/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanSupport;
import com.sun.jmx.mbeanserver.PerInterface;
import com.sun.jmx.mbeanserver.StandardMBeanIntrospector;
import com.sun.jmx.mbeanserver.StandardMBeanSupport;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DescriptorKey;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeData;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class Introspector {
    public static final boolean ALLOW_NONPUBLIC_MBEAN;

    private Introspector() {
    }

    public static final boolean isDynamic(Class<?> clazz) {
        return DynamicMBean.class.isAssignableFrom(clazz);
    }

    public static void testCreation(Class<?> clazz) throws NotCompliantMBeanException {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n)) {
            throw new NotCompliantMBeanException("MBean class must be concrete");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("MBean class must have public constructor");
        }
    }

    public static void checkCompliance(Class<?> clazz) throws NotCompliantMBeanException {
        if (DynamicMBean.class.isAssignableFrom(clazz)) {
            return;
        }
        try {
            Introspector.getStandardMBeanInterface(clazz);
            return;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            NotCompliantMBeanException notCompliantMBeanException2 = notCompliantMBeanException;
            try {
                Introspector.getMXBeanInterface(clazz);
                return;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException3) {
                NotCompliantMBeanException notCompliantMBeanException4 = notCompliantMBeanException3;
                String string = "MBean class " + clazz.getName() + " does not implement " + "DynamicMBean, and neither follows the Standard MBean conventions (" + notCompliantMBeanException2.toString() + ") nor the MXBean conventions (" + notCompliantMBeanException4.toString() + ")";
                throw new NotCompliantMBeanException(string);
            }
        }
    }

    public static <T> DynamicMBean makeDynamicMBean(T t) throws NotCompliantMBeanException {
        if (t instanceof DynamicMBean) {
            return (DynamicMBean)t;
        }
        Class<?> clazz = t.getClass();
        Class clazz2 = null;
        try {
            clazz2 = (Class)Util.cast(Introspector.getStandardMBeanInterface(clazz));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            return new StandardMBeanSupport(t, clazz2);
        }
        try {
            clazz2 = (Class)Util.cast(Introspector.getMXBeanInterface(clazz));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            // empty catch block
        }
        if (clazz2 != null) {
            return new MXBeanSupport(t, clazz2);
        }
        Introspector.checkCompliance(clazz);
        throw new NotCompliantMBeanException("Not compliant");
    }

    public static MBeanInfo testCompliance(Class<?> clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    public static void testComplianceMXBeanInterface(Class<?> clazz) throws NotCompliantMBeanException {
        MXBeanIntrospector.getInstance().getAnalyzer(clazz);
    }

    public static void testComplianceMBeanInterface(Class<?> clazz) throws NotCompliantMBeanException {
        StandardMBeanIntrospector.getInstance().getAnalyzer(clazz);
    }

    public static synchronized MBeanInfo testCompliance(Class<?> clazz, Class<?> clazz2) throws NotCompliantMBeanException {
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        }
        ReflectUtil.checkPackageAccess(clazz2);
        StandardMBeanIntrospector standardMBeanIntrospector = StandardMBeanIntrospector.getInstance();
        return Introspector.getClassMBeanInfo(standardMBeanIntrospector, clazz, clazz2);
    }

    private static <M> MBeanInfo getClassMBeanInfo(MBeanIntrospector<M> mBeanIntrospector, Class<?> clazz, Class<?> clazz2) throws NotCompliantMBeanException {
        PerInterface<M> perInterface = mBeanIntrospector.getPerInterface(clazz2);
        return mBeanIntrospector.getClassMBeanInfo(clazz, perInterface);
    }

    public static Class<?> getMBeanInterface(Class<?> clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        try {
            return Introspector.getStandardMBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            return null;
        }
    }

    public static <T> Class<? super T> getStandardMBeanInterface(Class<T> clazz) throws NotCompliantMBeanException {
        Class<T> clazz2 = null;
        for (Class<T> clazz3 = clazz; clazz3 != null && (clazz2 = Introspector.findMBeanInterface(clazz3, clazz3.getName())) == null; clazz3 = clazz3.getSuperclass()) {
        }
        if (clazz2 != null) {
            return clazz2;
        }
        String string = "Class " + clazz.getName() + " is not a JMX compliant Standard MBean";
        throw new NotCompliantMBeanException(string);
    }

    public static <T> Class<? super T> getMXBeanInterface(Class<T> clazz) throws NotCompliantMBeanException {
        try {
            return MXBeanSupport.findMXBeanInterface(clazz);
        }
        catch (Exception exception) {
            throw Introspector.throwException(clazz, exception);
        }
    }

    private static <T> Class<? super T> findMBeanInterface(Class<T> clazz, String string) {
        for (Class<T> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<T> clazz3 = (Class<T>)Util.cast(classArray[i]);
                if ((clazz3 = Introspector.implementsMBean(clazz3, string)) == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    public static Descriptor descriptorForElement(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        Annotation[] annotationArray = annotatedElement.getAnnotations();
        return Introspector.descriptorForAnnotations(annotationArray);
    }

    public static Descriptor descriptorForAnnotations(Annotation[] annotationArray) {
        if (annotationArray.length == 0) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            Method[] methodArray = clazz.getMethods();
            boolean bl = false;
            for (Method method : methodArray) {
                Object object;
                DescriptorKey descriptorKey = method.getAnnotation(DescriptorKey.class);
                if (descriptorKey == null) continue;
                String string = descriptorKey.value();
                try {
                    if (!bl) {
                        ReflectUtil.checkPackageAccess(clazz);
                        bl = true;
                    }
                    object = MethodUtil.invoke(method, annotation, null);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new UndeclaredThrowableException(exception);
                }
                object = Introspector.annotationToField(object);
                Object object2 = hashMap.put(string, object);
                if (object2 == null || Introspector.equals(object2, object)) continue;
                String string2 = "Inconsistent values for descriptor field " + string + " from annotations: " + object + " :: " + object2;
                throw new IllegalArgumentException(string2);
            }
        }
        if (hashMap.isEmpty()) {
            return ImmutableDescriptor.EMPTY_DESCRIPTOR;
        }
        return new ImmutableDescriptor(hashMap);
    }

    static NotCompliantMBeanException throwException(Class<?> clazz, Throwable throwable) throws NotCompliantMBeanException, SecurityException {
        if (throwable instanceof SecurityException) {
            throw (SecurityException)throwable;
        }
        if (throwable instanceof NotCompliantMBeanException) {
            throw (NotCompliantMBeanException)throwable;
        }
        String string = clazz == null ? "null class" : clazz.getName();
        String string2 = throwable == null ? "Not compliant" : throwable.getMessage();
        NotCompliantMBeanException notCompliantMBeanException = new NotCompliantMBeanException(string + ": " + string2);
        notCompliantMBeanException.initCause(throwable);
        throw notCompliantMBeanException;
    }

    private static Object annotationToField(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number || object instanceof String || object instanceof Character || object instanceof Boolean || object instanceof String[]) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (clazz.getComponentType().isPrimitive()) {
                return object;
            }
            Object[] objectArray = (Object[])object;
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)Introspector.annotationToField(objectArray[i]);
            }
            return stringArray;
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (Proxy.isProxyClass(clazz)) {
            clazz = clazz.getInterfaces()[0];
        }
        throw new IllegalArgumentException("Illegal type for annotation element using @DescriptorKey: " + clazz.getName());
    }

    private static boolean equals(Object object, Object object2) {
        return Arrays.deepEquals(new Object[]{object}, new Object[]{object2});
    }

    private static <T> Class<? super T> implementsMBean(Class<T> clazz, String string) {
        String string2 = string + "MBean";
        if (clazz.getName().equals(string2)) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(string2) || !Modifier.isPublic(classArray[i].getModifiers()) && !ALLOW_NONPUBLIC_MBEAN) continue;
            return (Class)Util.cast(classArray[i]);
        }
        return null;
    }

    public static Object elementFromComplex(Object object, String string) throws AttributeNotFoundException {
        try {
            if (object.getClass().isArray() && string.equals("length")) {
                return Array.getLength(object);
            }
            if (object instanceof CompositeData) {
                return ((CompositeData)object).get(string);
            }
            Class<?> clazz = object.getClass();
            Method method = null;
            if (BeansHelper.isAvailable()) {
                Object[] objectArray;
                Object object2 = BeansHelper.getBeanInfo(clazz);
                for (Object object3 : objectArray = BeansHelper.getPropertyDescriptors(object2)) {
                    if (!BeansHelper.getPropertyName(object3).equals(string)) continue;
                    method = BeansHelper.getReadMethod(object3);
                    break;
                }
            } else {
                method = SimpleIntrospector.getReadMethod(clazz, string);
            }
            if (method != null) {
                ReflectUtil.checkPackageAccess(method.getDeclaringClass());
                return MethodUtil.invoke(method, object, new Class[0]);
            }
            throw new AttributeNotFoundException("Could not find the getter method for the property " + string + " using the Java Beans introspector");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw attributeNotFoundException;
        }
        catch (Exception exception) {
            throw EnvHelp.initCause(new AttributeNotFoundException(exception.getMessage()), exception);
        }
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.jmx.mbeans.allowNonPublic"));
        ALLOW_NONPUBLIC_MBEAN = Boolean.parseBoolean(string);
    }

    private static class BeansHelper {
        private static final Class<?> introspectorClass = BeansHelper.getClass("java.beans.Introspector");
        private static final Class<?> beanInfoClass = introspectorClass == null ? null : BeansHelper.getClass("java.beans.BeanInfo");
        private static final Class<?> getPropertyDescriptorClass = beanInfoClass == null ? null : BeansHelper.getClass("java.beans.PropertyDescriptor");
        private static final Method getBeanInfo = BeansHelper.getMethod(introspectorClass, "getBeanInfo", Class.class);
        private static final Method getPropertyDescriptors = BeansHelper.getMethod(beanInfoClass, "getPropertyDescriptors", new Class[0]);
        private static final Method getPropertyName = BeansHelper.getMethod(getPropertyDescriptorClass, "getName", new Class[0]);
        private static final Method getReadMethod = BeansHelper.getMethod(getPropertyDescriptorClass, "getReadMethod", new Class[0]);

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            if (clazz != null) {
                try {
                    return clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)noSuchMethodException);
                }
            }
            return null;
        }

        private BeansHelper() {
        }

        static boolean isAvailable() {
            return introspectorClass != null;
        }

        static Object getBeanInfo(Class<?> clazz) throws Exception {
            try {
                return getBeanInfo.invoke(null, clazz);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        static Object[] getPropertyDescriptors(Object object) {
            try {
                return (Object[])getPropertyDescriptors.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        static String getPropertyName(Object object) {
            try {
                return (String)getPropertyName.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }

        static Method getReadMethod(Object object) {
            try {
                return (Method)getReadMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    }

    private static class SimpleIntrospector {
        private static final String GET_METHOD_PREFIX = "get";
        private static final String IS_METHOD_PREFIX = "is";
        private static final Map<Class<?>, SoftReference<List<Method>>> cache = Collections.synchronizedMap(new WeakHashMap());

        private SimpleIntrospector() {
        }

        private static List<Method> getCachedMethods(Class<?> clazz) {
            List<Method> list;
            SoftReference<List<Method>> softReference = cache.get(clazz);
            if (softReference != null && (list = softReference.get()) != null) {
                return list;
            }
            return null;
        }

        static boolean isReadMethod(Method method) {
            int n = method.getModifiers();
            if (Modifier.isStatic(n)) {
                return false;
            }
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            int n2 = classArray.length;
            if (n2 == 0 && string.length() > 2) {
                if (string.startsWith(IS_METHOD_PREFIX)) {
                    return method.getReturnType() == Boolean.TYPE;
                }
                if (string.length() > 3 && string.startsWith(GET_METHOD_PREFIX)) {
                    return method.getReturnType() != Void.TYPE;
                }
            }
            return false;
        }

        static List<Method> getReadMethods(Class<?> clazz) {
            List<Method> list = SimpleIntrospector.getCachedMethods(clazz);
            if (list != null) {
                return list;
            }
            List<Method> list2 = StandardMBeanIntrospector.getInstance().getMethods(clazz);
            list2 = MBeanAnalyzer.eliminateCovariantMethods(list2);
            LinkedList<Method> linkedList = new LinkedList<Method>();
            for (Method method : list2) {
                if (!SimpleIntrospector.isReadMethod(method)) continue;
                if (method.getName().startsWith(IS_METHOD_PREFIX)) {
                    linkedList.add(0, method);
                    continue;
                }
                linkedList.add(method);
            }
            cache.put(clazz, new SoftReference(linkedList));
            return linkedList;
        }

        static Method getReadMethod(Class<?> clazz, String string) {
            string = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
            String string2 = GET_METHOD_PREFIX + string;
            String string3 = IS_METHOD_PREFIX + string;
            for (Method method : SimpleIntrospector.getReadMethods(clazz)) {
                String string4 = method.getName();
                if (!string4.equals(string3) && !string4.equals(string2)) continue;
                return method;
            }
            return null;
        }
    }
}

