/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FullScreenWindow {
    private static GraphicsDevice defaultScreen;
    private GraphicsDevice screen;
    private JFrame jf;
    private boolean dead = false;
    private Flag flag = new Flag();
    private GraphicsDevice pickedDevice;

    public FullScreenWindow(JComponent part, boolean forcechoice) {
        this.init(part, forcechoice);
    }

    public FullScreenWindow(JComponent part) {
        this.init(part, false);
    }

    public void close() {
        this.dead = true;
        this.flag.set();
        this.screen.setFullScreenWindow(null);
        if (this.jf != null) {
            this.jf.dispose();
        }
    }

    private void init(JComponent part, boolean forcechoice) {
        if (forcechoice) {
            defaultScreen = null;
        }
        this.screen = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        if (defaultScreen != null) {
            for (int i = 0; i < screens.length; ++i) {
                if (screens[i] != defaultScreen) continue;
                this.screen = defaultScreen;
            }
        }
        if (screens.length == 1) {
            this.screen = screens[0];
        }
        if (this.screen == null) {
            this.screen = this.pickScreen(screens);
        }
        if (this.dead) {
            return;
        }
        defaultScreen = this.screen;
        DisplayMode dm = this.screen.getDisplayMode();
        GraphicsConfiguration gc = this.screen.getDefaultConfiguration();
        this.jf = new JFrame(gc);
        this.jf.setUndecorated(true);
        this.jf.setBounds(gc.getBounds());
        this.jf.getContentPane().add(part);
        this.jf.setVisible(true);
        this.screen.setFullScreenWindow(this.jf);
    }

    private void pickDevice(GraphicsDevice gd) {
        this.pickedDevice = gd;
        this.flag.set();
    }

    private GraphicsDevice pickScreen(GraphicsDevice[] scrns) {
        int i;
        this.flag.clear();
        int count = 0;
        PickMe[] pickers = new PickMe[scrns.length];
        for (i = 0; i < scrns.length; ++i) {
            if (scrns[i].isFullScreenSupported()) {
                ++count;
            }
            pickers[i] = new PickMe(scrns[i]);
        }
        this.flag.waitForFlag();
        for (i = 0; i < pickers.length; ++i) {
            if (pickers[i] == null) continue;
            pickers[i].dispose();
        }
        return this.pickedDevice;
    }

    class PickMe
    extends JFrame {
        GraphicsDevice mygd;

        public PickMe(GraphicsDevice gd) {
            super(gd.getDefaultConfiguration());
            this.setUndecorated(true);
            this.mygd = gd;
            JButton jb = new JButton("Click here to use this screen");
            jb.setBackground(Color.yellow);
            jb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    FullScreenWindow.this.pickDevice(PickMe.this.mygd);
                }
            });
            Dimension sz = jb.getPreferredSize();
            sz.width += 30;
            sz.height = 200;
            jb.setPreferredSize(sz);
            this.getContentPane().add(jb);
            this.pack();
            Rectangle bounds = gd.getDefaultConfiguration().getBounds();
            int x = bounds.width / 2 - sz.width / 2 + bounds.x;
            int y = bounds.height / 2 - sz.height / 2 + bounds.y;
            this.setLocation(x, y);
            this.setVisible(true);
        }
    }
}

