/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonExtractor;
import com.dropbox.client2.jsonextract.JsonThing;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonList
extends JsonBase<List<Object>>
implements Iterable<JsonThing> {
    public JsonList(List<Object> list, String string) {
        super(list, string);
    }

    public JsonList(List<Object> list) {
        super(list);
    }

    private static String pathConcatIndex(String string, int n) {
        return JsonThing.pathConcat(string, Integer.toString(n));
    }

    public JsonThing get(int n) throws JsonExtractionException {
        if (n >= ((List)this.internal).size()) {
            throw this.error("expecting array to have an element at index " + n + ", but it only has length " + ((List)this.internal).size());
        }
        return new JsonThing(((List)this.internal).get(n), JsonList.pathConcatIndex(this.path, n));
    }

    public void expectLength(int n) throws JsonExtractionException {
        if (((List)this.internal).size() != n) {
            throw this.error("expecting array to have length " + n + ", but it has length " + ((List)this.internal).size());
        }
    }

    public int length() {
        return ((List)this.internal).size();
    }

    @Override
    public Iterator<JsonThing> iterator() {
        return new WrapperIterator(this.path, ((List)this.internal).iterator());
    }

    public <T> ArrayList<T> extract(JsonExtractor<T> jsonExtractor) throws JsonExtractionException {
        ArrayList<T> arrayList = new ArrayList<T>(this.length());
        for (Object e : (List)this.internal) {
            arrayList.add(jsonExtractor.extract(new JsonThing(e)));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Extractor<T>
    extends JsonExtractor<List<T>> {
        public final JsonExtractor<T> elementExtractor;

        public Extractor(JsonExtractor<T> jsonExtractor) {
            this.elementExtractor = jsonExtractor;
        }

        @Override
        public List<T> extract(JsonThing jsonThing) throws JsonExtractionException {
            return jsonThing.expectList().extract(this.elementExtractor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WrapperIterator
    implements Iterator<JsonThing> {
        private int numReturned = 0;
        private final String path;
        private final Iterator<Object> internal;

        private WrapperIterator(String string, Iterator<Object> iterator) {
            this.path = string;
            this.internal = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }

        @Override
        public JsonThing next() {
            int n = this.numReturned++;
            return new JsonThing(this.internal.next(), JsonList.pathConcatIndex(this.path, n));
        }
    }
}

