/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.RESTUtility;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class RESTUtilityTest
extends TestCase {
    public RESTUtilityTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(RESTUtilityTest.class);
    }

    public void test_builUrlNoparams() throws Exception {
        RESTUtility.buildURL("foo", 0, "bar", null);
        String string = RESTUtility.buildURL("foo", 0, "/bar", null);
        assert (string.equals("https://foo:443/0/bar")) : "Error in no params: " + string;
    }

    public void test_buildUrlParams() throws Exception {
        String[] stringArray = new String[]{"hey", "there"};
        String string = RESTUtility.buildURL("foo", 0, "/bar", stringArray);
        assert (string.equals("https://foo:443/0/bar?hey=there")) : "Error in params: " + string;
    }

    public void test_buildLongUrl() throws Exception {
        String[] stringArray = new String[]{"hey", "there"};
        String string = RESTUtility.buildURL("foo", 0, "/bar/meta/data/is/fun/we/love/slashes", stringArray);
        assert (string.equals("https://foo:443/0/bar/meta/data/is/fun/we/love/slashes?hey=there")) : "Error in long url: " + string;
    }

    public void test_buildCrazyUrl() throws Exception {
        String[] stringArray = new String[]{"my file", "We have spaces, ? marks & ampersand # hashes"};
        String string = RESTUtility.buildURL("foo", 0, "/bar", stringArray);
        assert (string.equals("https://foo:443/0/bar?my%20file=We%20have%20spaces%2C%20%3F%20marks%20%26%20ampersand%20%23%20hashes")) : "Error in crazy params: " + string;
    }

    public void test_buildOddParams() throws Exception {
        try {
            String[] stringArray = new String[]{"hey", "there", "you"};
            RESTUtility.buildURL("foo", 0, "/bar", stringArray);
            assert (false) : "Didn't throw error with odd-numbered params";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

