/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.sun;

import org.jpedal.sun.JaiI18N;

public class TIFFLZWDecoder {
    int[] andTable = new int[]{511, 1023, 2047, 4095};
    int nextBits = 0;
    int nextData = 0;
    int w;
    int h;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int predictor;
    int samplesPerPixel;

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }

    public static byte[] composeString(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        return byArray2;
    }

    public TIFFLZWDecoder(int n, int n2, int n3) {
        this.w = n;
        this.predictor = n2;
        this.samplesPerPixel = n3;
    }

    public byte[] decode(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new UnsupportedOperationException(JaiI18N.getString("TIFFLZWDecoder0"));
        }
        this.initializeStringTable();
        this.data = byArray;
        this.h = n;
        this.uncompData = byArray2;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n3 = 0;
        while ((n2 = this.getNextCode()) != 257 && this.dstIndex < byArray2.length) {
            byte[] byArray3;
            if (n2 == 256) {
                this.initializeStringTable();
                n2 = this.getNextCode();
                if (n2 == 257) break;
                this.writeString(this.stringTable[n2]);
                n3 = n2;
                continue;
            }
            if (n2 < this.tableIndex) {
                byArray3 = this.stringTable[n2];
                this.writeString(byArray3);
                this.addStringToTable(this.stringTable[n3], byArray3[0]);
                n3 = n2;
                continue;
            }
            byArray3 = this.stringTable[n3];
            byArray3 = TIFFLZWDecoder.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n3 = n2;
        }
        return byArray2;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.uncompData[this.dstIndex++] = byArray[i];
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        byArray2[n] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }
}

