/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class PdfObjectCache {
    public static final int ColorspacesUsed = 1;
    public static final int Colorspaces = 2;
    private static final int initSize = 50;
    private final Map colorspacesUsed = new HashMap(50);
    public Map colorspacesObjects = new HashMap(50);
    private Map colorspaces = new HashMap(50);
    private Map globalXObjects = new Hashtable(50);
    private Map localXObjects = new Hashtable(50);
    public final Map XObjectColorspaces = new HashMap(50);
    public Map patterns = new HashMap(50);
    public Map globalShadings = new HashMap(50);
    public Map localShadings = new HashMap(50);
    Map imposedImages = new HashMap(50);
    PdfObject groupObj = null;
    PdfObject pageGroupingObj = null;
    public Map unresolvedFonts = new Hashtable(50);
    public Map directFonts = new Hashtable(50);
    public Map resolvedFonts = new Hashtable(50);
    Map GraphicsStates = new HashMap(50);

    public PdfObjectCache copy() {
        PdfObjectCache pdfObjectCache = new PdfObjectCache();
        pdfObjectCache.localShadings = this.localShadings;
        pdfObjectCache.unresolvedFonts = this.unresolvedFonts;
        pdfObjectCache.GraphicsStates = this.GraphicsStates;
        pdfObjectCache.directFonts = this.directFonts;
        pdfObjectCache.resolvedFonts = this.resolvedFonts;
        pdfObjectCache.colorspaces = this.colorspaces;
        pdfObjectCache.localXObjects = this.localXObjects;
        pdfObjectCache.globalXObjects = this.globalXObjects;
        pdfObjectCache.groupObj = this.groupObj;
        return pdfObjectCache;
    }

    public void put(int n, int n2, Object object) {
        switch (n) {
            case 1: {
                this.colorspacesUsed.put(new Integer(n2), object);
            }
        }
    }

    public Iterator iterator(int n) {
        Iterator iterator = null;
        switch (n) {
            case 1: {
                iterator = this.colorspacesUsed.keySet().iterator();
            }
        }
        return iterator;
    }

    public Object get(int n, Object object) {
        Object var3_3 = null;
        switch (n) {
            case 1: {
                var3_3 = this.colorspacesUsed.get(object);
                break;
            }
            case 2: {
                var3_3 = this.colorspaces.get(object);
            }
        }
        return var3_3;
    }

    public void resetFonts() {
        this.resolvedFonts.clear();
        this.unresolvedFonts.clear();
        this.directFonts.clear();
    }

    public PdfObject getXObjects(String string) {
        PdfObject pdfObject = (PdfObject)this.localXObjects.get(string);
        if (pdfObject == null) {
            pdfObject = (PdfObject)this.globalXObjects.get(string);
        }
        return pdfObject;
    }

    public void resetXObject(String string, String string2, byte[] byArray) {
        XObject xObject = new XObject(string2);
        if (byArray[byArray.length - 1] == 82) {
            xObject.setStatus(1);
        } else {
            xObject.setStatus(2);
        }
        xObject.setUnresolvedData(byArray, 540096309);
        if (this.localXObjects.containsKey(string)) {
            this.localXObjects.remove(string);
        } else {
            this.globalXObjects.remove(string);
        }
    }

    public void readResources(PdfObject pdfObject, boolean bl, PdfObjectReader pdfObjectReader) throws PdfException {
        pdfObjectReader.checkResolved(pdfObject);
        String[] stringArray = new String[]{"ColorSpace", "ExtGState", "Font", "Pattern", "Shading", "XObject"};
        int[] nArray = new int[]{2087749783, -1938465939, 373243460, 1146450818, 878474856, 979194486};
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] == 373243460 || nArray[i] == 979194486) {
                this.readArrayPairs(pdfObject, bl, nArray[i], pdfObjectReader);
                continue;
            }
            this.readArrayPairs(pdfObject, false, nArray[i], pdfObjectReader);
        }
    }

    private void readArrayPairs(PdfObject pdfObject, boolean bl, int n, PdfObjectReader pdfObjectReader) throws PdfException {
        PdfObject pdfObject2;
        if (pdfObject != null && (pdfObject2 = pdfObject.getDictionary(n)) != null) {
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                String string = pdfKeyPairsIterator.getNextKeyAsString();
                String string2 = pdfKeyPairsIterator.getNextValueAsString();
                PdfObject pdfObject3 = pdfKeyPairsIterator.getNextValueAsDictionary();
                if (pdfObject.isDataExternal()) {
                    ObjectDecoder objectDecoder = new ObjectDecoder(pdfObjectReader.getObjectReader());
                    if (pdfObject3 == null && string2 == null) {
                        pdfObject.setFullyResolved(false);
                        return;
                    }
                    if (pdfObject3 == null) {
                        PdfObject pdfObject4 = ObjectFactory.createObject(n, string2, n, -1);
                        pdfObject4.setStatus(2);
                        pdfObject4.setUnresolvedData(StringUtils.toBytes(string2), n);
                        if (!objectDecoder.resolveFully(pdfObject4)) {
                            pdfObject.setFullyResolved(false);
                            return;
                        }
                        if (n == 373243460) {
                            this.directFonts.put(string, pdfObject4);
                        }
                    } else if (!objectDecoder.resolveFully(pdfObject3)) {
                        pdfObject.setFullyResolved(false);
                        return;
                    }
                }
                switch (n) {
                    case 2087749783: {
                        this.colorspaces.put(string, pdfObject3);
                        break;
                    }
                    case -1938465939: {
                        this.GraphicsStates.put(string, pdfObject3);
                        break;
                    }
                    case 373243460: {
                        this.unresolvedFonts.put(string, string2);
                        break;
                    }
                    case 1146450818: {
                        this.patterns.put(string, pdfObject3);
                        break;
                    }
                    case 878474856: {
                        if (bl) {
                            this.globalShadings.put(string, pdfObject3);
                            break;
                        }
                        this.localShadings.put(string, pdfObject3);
                        break;
                    }
                    case 979194486: {
                        if (bl) {
                            this.globalXObjects.put(string, pdfObject3);
                            break;
                        }
                        this.localXObjects.put(string, pdfObject3);
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
        }
    }

    public void reset(PdfObjectCache pdfObjectCache) {
        this.localShadings = new HashMap(50);
        this.resolvedFonts = new HashMap(50);
        this.unresolvedFonts = new HashMap(50);
        this.directFonts = new HashMap(50);
        this.colorspaces = new HashMap(50);
        this.GraphicsStates = new HashMap(50);
        this.localXObjects = new HashMap(50);
        for (Object k : pdfObjectCache.GraphicsStates.keySet()) {
            this.GraphicsStates.put(k, pdfObjectCache.GraphicsStates.get(k));
        }
        for (Object k : pdfObjectCache.colorspaces.keySet()) {
            this.colorspaces.put(k, pdfObjectCache.colorspaces.get(k));
        }
        for (Object k : pdfObjectCache.localXObjects.keySet()) {
            this.localXObjects.put(k, pdfObjectCache.localXObjects.get(k));
        }
        for (Object k : pdfObjectCache.globalXObjects.keySet()) {
            this.globalXObjects.put(k, pdfObjectCache.globalXObjects.get(k));
        }
        if (this.unresolvedFonts.isEmpty()) {
            for (Object k : pdfObjectCache.unresolvedFonts.keySet()) {
                this.unresolvedFonts.put(k, pdfObjectCache.unresolvedFonts.get(k));
            }
        }
    }

    public void restore(PdfObjectCache pdfObjectCache) {
        this.directFonts = pdfObjectCache.directFonts;
        this.unresolvedFonts = pdfObjectCache.unresolvedFonts;
        this.resolvedFonts = pdfObjectCache.resolvedFonts;
        this.GraphicsStates = pdfObjectCache.GraphicsStates;
        this.colorspaces = pdfObjectCache.colorspaces;
        this.localShadings = pdfObjectCache.localShadings;
        this.localXObjects = pdfObjectCache.localXObjects;
        this.globalXObjects = pdfObjectCache.globalXObjects;
        this.groupObj = pdfObjectCache.groupObj;
    }

    public int getXObjectCount() {
        return this.localXObjects.keySet().size() + this.globalXObjects.keySet().size();
    }

    public Object getImposedKey(String string) {
        return this.imposedImages.get(string);
    }

    public void setImposedKey(String string, int n) {
        if (this.imposedImages != null) {
            this.imposedImages.put(string, new Integer(n));
        }
    }
}

