/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.GraphicsState;
import org.jpedal.utils.LogWriter;

public class ImageTransformer {
    private int image_type;
    private BufferedImage current_image;
    private float[][] Trm;
    private float[][] CTM;
    private int i_x = 0;
    private int i_y = 0;
    private int i_w = 0;
    private int i_h = 0;
    private float scale = 1.0f;

    public ImageTransformer(int n, GraphicsState graphicsState, BufferedImage bufferedImage, boolean bl) {
        this.scale = n / 72;
        this.current_image = bufferedImage;
        int n2 = this.current_image.getWidth();
        int n3 = this.current_image.getHeight();
        this.CTM = graphicsState.CTM;
        this.Trm = new float[3][3];
        this.Trm[0][0] = this.CTM[0][0] / (float)n2;
        this.Trm[0][1] = -(this.CTM[0][1] / (float)n2);
        this.Trm[0][2] = 0.0f;
        this.Trm[1][0] = -(this.CTM[1][0] / (float)n3);
        this.Trm[1][1] = this.CTM[1][1] / (float)n3;
        this.Trm[1][2] = 0.0f;
        this.Trm[2][0] = this.CTM[2][0];
        this.Trm[2][1] = this.CTM[2][1];
        this.Trm[2][2] = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!((double)this.Trm[j][i] > 0.99 & this.Trm[j][i] < 1.0f)) continue;
                this.Trm[j][i] = 1.0f;
            }
        }
        this.scale(bl, n2, n3, n);
        this.completeImage();
    }

    private void scale(boolean bl, int n, int n2, int n3) {
        if ((double)this.Trm[0][0] != 1.0 || (double)this.Trm[1][1] != 1.0 || (double)this.Trm[0][1] != 0.0 || (double)this.Trm[1][0] != 0.0 || n3 != 72) {
            boolean bl2;
            AffineTransformOp affineTransformOp;
            AffineTransform affineTransform = new AffineTransform(this.Trm[0][0] * this.scale, this.Trm[0][1] * this.scale, this.Trm[1][0] * this.scale, this.Trm[1][1] * this.scale, 0.0f, 0.0f);
            Area area = new Area(new Rectangle(0, 0, n, n2));
            area.transform(affineTransform);
            double d = area.getBounds2D().getY();
            double d2 = area.getBounds2D().getX();
            float f = this.Trm[0][0] * this.scale;
            float f2 = this.Trm[0][1] * this.scale;
            float f3 = this.Trm[1][0] * this.scale;
            float f4 = this.Trm[1][1] * this.scale;
            affineTransform = new AffineTransform((double)f, (double)f2, (double)f3, (double)f4, -d2, -d);
            if (f < 0.0f) {
                f = -f;
            }
            if (f2 < 0.0f) {
                f2 = -f2;
            }
            if (f3 < 0.0f) {
                f3 = -f3;
            }
            if (f4 < 0.0f) {
                f4 = -f4;
            }
            if (f > 5.0f || f2 > 5.0f || f3 > 5.0f || f4 > 5.0f) {
                return;
            }
            if (n > 1 && n2 > 1) {
                if (this.CTM[0][0] == 0.0f && this.CTM[1][1] == 0.0f && this.CTM[0][1] > 0.0f && this.CTM[1][0] < 0.0f) {
                    affineTransform.scale(-1.0, 1.0);
                    affineTransform.translate(-this.current_image.getWidth(), 0.0);
                }
                affineTransformOp = new AffineTransformOp(affineTransform, ColorSpaces.hints);
            } else {
                bl2 = true;
                if (n2 == 1) {
                    WritableRaster writableRaster = this.current_image.getRaster();
                    int n4 = writableRaster.getNumBands();
                    int n5 = writableRaster.getWidth();
                    int[] nArray = new int[n5 * n4 + 1];
                    writableRaster.getPixels(0, 0, n5, 1, nArray);
                    for (int i = 0; i < n4; ++i) {
                        int n6 = nArray[0];
                        for (int j = 1; j < n5; ++j) {
                            if (nArray[j * i] == n6) continue;
                            bl2 = false;
                            j = n5;
                            i = n4;
                        }
                    }
                }
                affineTransformOp = bl2 ? new AffineTransformOp(affineTransform, null) : new AffineTransformOp(affineTransform, ColorSpaces.hints);
            }
            if (this.CTM[1][0] != 0.0f || this.CTM[0][1] != 0.0f) {
                this.current_image = ColorSpaceConvertor.convertToARGB(this.current_image);
            }
            if (bl && n2 > 1 && !(bl2 = false)) {
                boolean bl3 = false;
                try {
                    this.current_image = affineTransformOp.filter(this.current_image, null);
                }
                catch (Exception exception) {
                    bl3 = true;
                }
                if (bl3) {
                    try {
                        affineTransformOp = new AffineTransformOp(affineTransform, null);
                        this.current_image = affineTransformOp.filter(this.current_image, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void completeImage() {
        this.calcCoordinates();
    }

    private final void calcCoordinates() {
        if (this.CTM[1][0] == 0.0f && this.CTM[0][1] == 0.0f) {
            this.i_x = (int)this.CTM[2][0];
            this.i_y = (int)this.CTM[2][1];
            this.i_w = (int)this.CTM[0][0];
            this.i_h = (int)this.CTM[1][1];
            if (this.i_w < 0) {
                this.i_w = -this.i_w;
            }
            if (this.i_h < 0) {
                this.i_h = -this.i_h;
            }
        } else {
            this.i_w = (int)Math.sqrt(this.CTM[0][0] * this.CTM[0][0] + this.CTM[0][1] * this.CTM[0][1]);
            this.i_h = (int)Math.sqrt(this.CTM[1][1] * this.CTM[1][1] + this.CTM[1][0] * this.CTM[1][0]);
            if (this.CTM[1][0] > 0.0f && this.CTM[0][1] < 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)(this.CTM[2][1] + this.CTM[0][1]);
            } else if (this.CTM[1][0] < 0.0f && this.CTM[0][1] > 0.0f) {
                this.i_x = (int)(this.CTM[2][0] + this.CTM[1][0]);
                this.i_y = (int)this.CTM[2][1];
            } else if (this.CTM[1][0] > 0.0f && this.CTM[0][1] > 0.0f) {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            } else {
                this.i_x = (int)this.CTM[2][0];
                this.i_y = (int)this.CTM[2][1];
            }
        }
        if (this.CTM[1][1] < 0.0f) {
            this.i_y -= this.i_h;
        }
        if (this.CTM[0][0] < 0.0f) {
            this.i_x -= this.i_w;
        }
    }

    public final int getImageY() {
        return this.i_y;
    }

    public final BufferedImage getImage() {
        return this.current_image;
    }

    public final int getImageW() {
        return this.i_w;
    }

    public final int getImageH() {
        return this.i_h;
    }

    public final int getImageX() {
        return this.i_x;
    }

    public final void clipImage(Area area) {
        Area area2 = (Area)area.clone();
        if (this.scale != 1.0f) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scale, this.scale);
            area2.transform(affineTransform);
        }
        int n = this.current_image.getWidth();
        int n2 = this.current_image.getHeight();
        double d = area2.getBounds2D().getX();
        double d2 = area2.getBounds2D().getY();
        double d3 = area2.getBounds2D().getHeight();
        double d4 = (double)n2 - d3;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(-d, -d2);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(d, -(d2 + d3));
        area2.transform(affineTransform);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate((float)(-this.i_x) * this.scale, (double)((float)this.i_y * this.scale) + d4);
        area2.transform(affineTransform2);
        double d5 = area2.getBounds2D().getX();
        double d6 = area2.getBounds2D().getY();
        double d7 = area2.getBounds2D().getWidth();
        double d8 = area2.getBounds2D().getHeight();
        this.image_type = this.current_image.getType();
        if (this.image_type == 0) {
            this.image_type = 2;
        } else if (this.image_type == 1) {
            this.image_type = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, this.image_type);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!bufferedImage.getColorModel().hasAlpha()) {
            graphics2D.setBackground(Color.white);
            graphics2D.fill(new Rectangle(0, 0, n, n2));
        }
        graphics2D.setClip(area2);
        try {
            graphics2D.drawImage((Image)this.current_image, 0, 0, null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " plotting clipping image");
        }
        if (d6 < 0.0) {
            d8 += d6;
            d6 = 0.0;
        }
        if (d5 < 0.0) {
            d7 += d5;
            d5 = 0.0;
        }
        if (d7 > (double)n) {
            d7 = n;
        }
        if (d8 > (double)n2) {
            d8 = n2;
        }
        if (d6 + d8 > (double)n2) {
            d8 = (double)n2 - d6;
        }
        if (d5 + d7 > (double)n) {
            d7 = (double)n - d5;
        }
        try {
            this.current_image = bufferedImage.getSubimage((int)d5, (int)d6, (int)d7, (int)d8);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " extracting clipped image with values x=" + d5 + " y=" + d6 + " w=" + d7 + " h=" + d8 + " from image ");
        }
        double d9 = (double)this.i_x > d ? (double)this.i_x : d;
        double d10 = (double)this.i_y > d2 ? (double)this.i_y : d2;
        this.i_x = (int)(d9 / (double)this.scale);
        this.i_y = (int)(d10 / (double)this.scale);
        this.i_w = (int)d7;
        this.i_h = (int)d8;
    }
}

