/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.StringUtils;

public class FontWriter
extends FontFile2 {
    String name;
    int glyphCount;
    int headCheckSumPos = -1;
    boolean debug = false;

    public FontWriter(byte[] byArray) {
        super(byArray);
    }

    public FontWriter() {
    }

    static int getUintFromByteArray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
            int n5 = byArray[n + n4];
            if (n5 < 0) {
                n5 += 256;
            }
            n3 |= n5 << i;
            ++n4;
        }
        return n3;
    }

    static int getUintFromIntArray(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = (n2 - 1) * 8; i >= 0; i -= 8) {
            n3 |= (nArray[n + n4] & 0xFF) << i;
            ++n4;
        }
        return n3;
    }

    static byte[] set1cNumber(int n) {
        byte[] byArray = n >= -107 && n <= 107 ? new byte[]{(byte)(n + 139)} : (n >= 108 && n <= 1131 ? new byte[]{(byte)(247 + (n -= 108) / 256), (byte)(n & 0xFF)} : (n >= -1131 && n <= -108 ? new byte[]{(byte)(251 + (n += 108) / -256), (byte)(-n & 0xFF)} : (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? new byte[]{28, (byte)(n / 256 & 0xFF), (byte)(n & 0xFF)} : new byte[]{29, (byte)(n / 256 / 256 / 256 & 0xFF), (byte)(n / 256 / 256 & 0xFF), (byte)(n / 256 & 0xFF), (byte)(n & 0xFF)})));
        return byArray;
    }

    public static byte[] setUintAsBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = n2; i > 0; --i) {
            int n3 = n;
            for (int j = 1; j < i; ++j) {
                n3 >>= 8;
            }
            byArray[n2 - i] = (byte)n3;
        }
        return byArray;
    }

    static int createChecksum(byte[] byArray) {
        int n = 0;
        FontFile2 fontFile2 = new FontFile2(byArray, true);
        int n2 = byArray.length + 3 >> 2;
        for (int i = 0; i < n2; ++i) {
            n += fontFile2.getNextUint32();
        }
        return n;
    }

    public static final byte[] setUFWord(int n) {
        short s = (short)n;
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setFWord(int n) {
        short s = (short)n;
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint16(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextInt16(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextSignedInt16(short s) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(s >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte setNextUint8(int n) {
        return (byte)(n & 0xFF);
    }

    public static final byte[] setNextUint32(int n) {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(n >> 8 * (3 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint64(int n) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(n >> 8 * (7 - i) & 0xFF);
        }
        return byArray;
    }

    public static final byte[] setNextUint64(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * (7 - i) & 0xFFL);
        }
        return byArray;
    }

    public final byte[] writeFontToStream() throws IOException {
        this.readTables();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.type == 1) {
            byteArrayOutputStream.write(FontWriter.setNextUint32(0x4F54544F));
        } else if (this.type == 3) {
            byteArrayOutputStream.write(FontWriter.setNextUint32(1953784678));
        } else {
            byteArrayOutputStream.write(FontWriter.setNextUint32(65536));
        }
        if (this.type == 3) {
            System.out.println("TTC write not implemented");
        } else {
            this.writeTablesForFont(byteArrayOutputStream);
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = FontWriter.setNextUint32((int)(Long.parseLong("B1B0AFBA", 16) - (long)FontWriter.createChecksum(byArray)));
        System.arraycopy(byArray2, 0, byArray, 0 + this.headCheckSumPos, 4);
        return byArray;
    }

    void readTables() {
    }

    private void writeTablesForFont(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        Object[] objectArray;
        int n2;
        String string;
        int n3;
        int[] nArray = new int[this.numTables];
        int[] nArray2 = new int[this.numTables];
        int[] nArray3 = new int[this.numTables];
        int[] nArray4 = new int[this.numTables];
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.numTables));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.searchRange));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.entrySelector));
        byteArrayOutputStream.write(FontWriter.setNextUint16(this.rangeShift));
        for (n3 = 0; n3 < this.numTables; ++n3) {
            string = (String)this.tableList.get(n3);
            n2 = FontWriter.getTableID(string);
            if (this.debug) {
                System.out.println("writing out " + string + " id=" + n2);
            }
            if (n2 == -1) continue;
            objectArray = this.getTableBytes(n2);
            if (n2 != 0) {
                nArray3[n3] = FontWriter.createChecksum((byte[])objectArray);
            }
            nArray4[n3] = objectArray.length;
            nArray[n3] = n3;
            nArray2[n3] = this.tables[n2][this.currentFontID];
        }
        nArray = Sorts.quicksort(nArray2, nArray);
        n3 = FontWriter.alignOnWordBoundary(byteArrayOutputStream.size() + 16 * this.numTables);
        objectArray = new int[this.numTables];
        for (n = 0; n < this.numTables; ++n) {
            int n4 = nArray[n];
            objectArray[n4] = n3;
            nArray2[n4] = n3;
            n3 = FontWriter.alignOnWordBoundary(n3 + nArray4[n4]);
        }
        for (n = 0; n < this.numTables; ++n) {
            int n5 = n;
            string = (String)this.tableList.get(n5);
            byteArrayOutputStream.write(StringUtils.toBytes(string));
            n2 = FontWriter.getTableID(string);
            if (n2 == -1) continue;
            if (n2 == 0) {
                this.headCheckSumPos = byteArrayOutputStream.size();
            }
            byteArrayOutputStream.write(FontWriter.setNextUint32(nArray3[n5]));
            byteArrayOutputStream.write(FontWriter.setNextUint32(objectArray[n5]));
            byteArrayOutputStream.write(FontWriter.setNextUint32(nArray4[n5]));
        }
        for (int i = 0; i < this.numTables; ++i) {
            n = nArray[i];
            string = (String)this.tableList.get(n);
            n2 = FontWriter.getTableID(string);
            byte[] byArray = this.getTableBytes(n2);
            while ((byteArrayOutputStream.size() & 3) != 0) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray);
        }
    }

    private static int alignOnWordBoundary(int n) {
        int n2 = n & 3;
        if (n2 != 0) {
            n += 4 - n2;
        }
        return n;
    }
}

