/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import javax.imageio.IIOException;

public class TIFFFaxDecompressor
extends TIFFDecompressor {
    protected int fillOrder;
    protected int compression;
    private int t4Options;
    private int t6Options;
    protected int uncompressedMode = 0;
    protected int fillBits = 0;
    protected int oneD;
    private byte[] data;
    private int bitPointer;
    private int bytePointer;
    private byte[] buffer;
    private int w;
    private int h;
    private int bitsPerScanline;
    private int lineBitNum;
    private int changingElemSize = 0;
    private int[] prevChangingElems;
    private int[] currChangingElems;
    private int lastChangingElement = 0;
    static int[] table1 = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    static int[] table2 = new int[]{0, 128, 192, 224, 240, 248, 252, 254, 255};
    static byte[] flipTable = new byte[]{0, -128, 64, -64, 32, -96, 96, -32, 16, -112, 80, -48, 48, -80, 112, -16, 8, -120, 72, -56, 40, -88, 104, -24, 24, -104, 88, -40, 56, -72, 120, -8, 4, -124, 68, -60, 36, -92, 100, -28, 20, -108, 84, -44, 52, -76, 116, -12, 12, -116, 76, -52, 44, -84, 108, -20, 28, -100, 92, -36, 60, -68, 124, -4, 2, -126, 66, -62, 34, -94, 98, -30, 18, -110, 82, -46, 50, -78, 114, -14, 10, -118, 74, -54, 42, -86, 106, -22, 26, -102, 90, -38, 58, -70, 122, -6, 6, -122, 70, -58, 38, -90, 102, -26, 22, -106, 86, -42, 54, -74, 118, -10, 14, -114, 78, -50, 46, -82, 110, -18, 30, -98, 94, -34, 62, -66, 126, -2, 1, -127, 65, -63, 33, -95, 97, -31, 17, -111, 81, -47, 49, -79, 113, -15, 9, -119, 73, -55, 41, -87, 105, -23, 25, -103, 89, -39, 57, -71, 121, -7, 5, -123, 69, -59, 37, -91, 101, -27, 21, -107, 85, -43, 53, -75, 117, -11, 13, -115, 77, -51, 45, -83, 109, -19, 29, -99, 93, -35, 61, -67, 125, -3, 3, -125, 67, -61, 35, -93, 99, -29, 19, -109, 83, -45, 51, -77, 115, -13, 11, -117, 75, -53, 43, -85, 107, -21, 27, -101, 91, -37, 59, -69, 123, -5, 7, -121, 71, -57, 39, -89, 103, -25, 23, -105, 87, -41, 55, -73, 119, -9, 15, -113, 79, -49, 47, -81, 111, -17, 31, -97, 95, -33, 63, -65, 127, -1};
    static short[] white = new short[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    static short[] additionalMakeup = new short[]{28679, 28679, 31752, -32759, -31735, -30711, -29687, -28663, 29703, 29703, 30727, 30727, -27639, -26615, -25591, -24567};
    static short[] initBlack = new short[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    static short[] twoBitBlack = new short[]{292, 260, 226, 226};
    static short[] black = new short[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    static byte[] twoDCodes = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};

    public void beginDecoding() {
        super.beginDecoding();
        if (this.metadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tIFFImageMetadata = (TIFFImageMetadata)this.metadata;
            TIFFField tIFFField = tIFFImageMetadata.getTIFFField(266);
            this.fillOrder = tIFFField == null ? 1 : tIFFField.getAsInt(0);
            tIFFField = tIFFImageMetadata.getTIFFField(259);
            this.compression = tIFFField == null ? 2 : tIFFField.getAsInt(0);
            tIFFField = tIFFImageMetadata.getTIFFField(292);
            this.t4Options = tIFFField == null ? 0 : tIFFField.getAsInt(0);
            this.oneD = this.t4Options & 1;
            this.uncompressedMode = (this.t4Options & 2) >> 1;
            this.fillBits = (this.t4Options & 4) >> 2;
            tIFFField = tIFFImageMetadata.getTIFFField(293);
            this.t6Options = tIFFField == null ? 0 : tIFFField.getAsInt(0);
        } else {
            this.fillOrder = 1;
            this.compression = 2;
            this.t4Options = 0;
            this.oneD = 0;
            this.uncompressedMode = 0;
            this.fillBits = 0;
            this.t6Options = 0;
        }
    }

    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        block5: {
            this.buffer = byArray;
            this.w = this.srcWidth;
            this.h = this.srcHeight;
            this.bitsPerScanline = n3 * 8;
            this.lineBitNum = 8 * n;
            this.data = new byte[this.byteCount];
            this.bitPointer = 0;
            this.bytePointer = 0;
            this.prevChangingElems = new int[this.w + 1];
            this.currChangingElems = new int[this.w + 1];
            this.stream.seek(this.offset);
            this.stream.readFully(this.data);
            try {
                if (this.compression == 2) {
                    this.decodeRLE();
                    break block5;
                }
                if (this.compression == 3) {
                    this.decodeT4();
                    break block5;
                }
                if (this.compression == 4) {
                    this.uncompressedMode = (this.t6Options & 2) >> 1;
                    this.decodeT6();
                    break block5;
                }
                throw new IIOException("Unknown compression type " + this.compression);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                arrayIndexOutOfBoundsException.printStackTrace(new PrintStream(byteArrayOutputStream));
                String string = new String(byteArrayOutputStream.toByteArray());
                this.warning("Ignoring exception:\n " + string);
            }
        }
    }

    public void decodeRLE() throws IIOException {
        for (int i = 0; i < this.h; ++i) {
            this.decodeNextScanline(this.srcMinY + i);
            if (this.bitPointer != 0) {
                ++this.bytePointer;
                this.bitPointer = 0;
            }
            this.lineBitNum += this.bitsPerScanline;
        }
    }

    public void decodeNextScanline(int n) throws IIOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = false;
        int n5 = 0;
        this.changingElemSize = 0;
        while (n5 < this.w) {
            short s;
            int n6;
            int n7 = n5;
            while (bl && n5 < this.w) {
                n6 = this.nextNBits(10);
                s = white[n6];
                n4 = s & 1;
                n2 = s >>> 1 & 0xF;
                if (n2 == 12) {
                    int n8 = this.nextLesserThan8Bits(2);
                    n6 = n6 << 2 & 0xC | n8;
                    s = additionalMakeup[n6];
                    n2 = s >>> 1 & 7;
                    n3 = s >>> 4 & 0xFFF;
                    n5 += n3;
                    this.updatePointer(4 - n2);
                    continue;
                }
                if (n2 == 0) {
                    this.warning("Error 0");
                    continue;
                }
                if (n2 == 15) {
                    this.warning("Premature EOL in white run of line " + n + ": read " + n5 + " of " + this.w + " expected pixels.");
                    return;
                }
                n3 = s >>> 5 & 0x7FF;
                n5 += n3;
                this.updatePointer(10 - n2);
                if (n4 != 0) continue;
                bl = false;
                this.currChangingElems[this.changingElemSize++] = n5;
            }
            if (n5 == this.w) {
                int n9 = n5 - n7;
                if (!bl || n9 == 0 || n9 % 64 != 0 || this.nextNBits(8) == 53) break;
                this.warning("Missing zero white run length terminating code!");
                this.updatePointer(8);
                break;
            }
            n7 = n5;
            while (!bl && n5 < this.w) {
                n6 = this.nextLesserThan8Bits(4);
                s = initBlack[n6];
                n4 = s & 1;
                n2 = s >>> 1 & 0xF;
                n3 = s >>> 5 & 0x7FF;
                if (n3 == 100) {
                    n6 = this.nextNBits(9);
                    s = black[n6];
                    n4 = s & 1;
                    n2 = s >>> 1 & 0xF;
                    n3 = s >>> 5 & 0x7FF;
                    if (n2 == 12) {
                        this.updatePointer(5);
                        n6 = this.nextLesserThan8Bits(4);
                        s = additionalMakeup[n6];
                        n2 = s >>> 1 & 7;
                        n3 = s >>> 4 & 0xFFF;
                        this.setToBlack(n5, n3);
                        n5 += n3;
                        this.updatePointer(4 - n2);
                        continue;
                    }
                    if (n2 == 15) {
                        this.warning("Premature EOL in black run of line " + n + ": read " + n5 + " of " + this.w + " expected pixels.");
                        return;
                    }
                    this.setToBlack(n5, n3);
                    n5 += n3;
                    this.updatePointer(9 - n2);
                    if (n4 != 0) continue;
                    bl = true;
                    this.currChangingElems[this.changingElemSize++] = n5;
                    continue;
                }
                if (n3 == 200) {
                    n6 = this.nextLesserThan8Bits(2);
                    s = twoBitBlack[n6];
                    n3 = s >>> 5 & 0x7FF;
                    n2 = s >>> 1 & 0xF;
                    this.setToBlack(n5, n3);
                    this.updatePointer(2 - n2);
                    bl = true;
                    this.currChangingElems[this.changingElemSize++] = n5 += n3;
                    continue;
                }
                this.setToBlack(n5, n3);
                this.updatePointer(4 - n2);
                bl = true;
                this.currChangingElems[this.changingElemSize++] = n5 += n3;
            }
            if (n5 != this.w) continue;
            int n10 = n5 - n7;
            if (bl || n10 == 0 || n10 % 64 != 0 || this.nextNBits(10) == 55) break;
            this.warning("Missing zero black run length terminating code!");
            this.updatePointer(10);
            break;
        }
        this.currChangingElems[this.changingElemSize++] = n5;
    }

    public void decodeT4() throws IIOException {
        int n = this.h;
        int[] nArray = new int[2];
        int n2 = 0;
        if (this.data.length < 2) {
            throw new IIOException("Insufficient data to read initial EOL.");
        }
        int n3 = this.nextNBits(12);
        if (n3 != 1) {
            this.warning("T.4 compressed data should begin with EOL.");
        }
        this.updatePointer(12);
        int n4 = 0;
        int n5 = -1;
        while (n4 != 1) {
            try {
                n4 = this.findNextLine();
                ++n5;
            }
            catch (EOFException eOFException) {
                throw new IIOException("No reference line present.");
            }
        }
        this.decodeNextScanline(this.srcMinY);
        ++n5;
        this.lineBitNum += this.bitsPerScanline;
        while (n5 < n) {
            try {
                n4 = this.findNextLine();
            }
            catch (EOFException eOFException) {
                this.warning("Input exhausted before EOL found at line " + (this.srcMinY + n5) + ": read 0 of " + this.w + " expected pixels.");
                break;
            }
            if (n4 == 0) {
                int[] nArray2 = this.prevChangingElems;
                this.prevChangingElems = this.currChangingElems;
                this.currChangingElems = nArray2;
                n2 = 0;
                int n6 = -1;
                boolean bl = true;
                int n7 = 0;
                this.lastChangingElement = 0;
                while (n7 < this.w) {
                    int n8;
                    this.getNextChangingElement(n6, bl, nArray);
                    int n9 = nArray[0];
                    int n10 = nArray[1];
                    int n11 = this.nextLesserThan8Bits(7);
                    n11 = twoDCodes[n11] & 0xFF;
                    int n12 = (n11 & 0x78) >>> 3;
                    int n13 = n11 & 7;
                    if (n12 == 0) {
                        if (!bl) {
                            this.setToBlack(n7, n10 - n7);
                        }
                        n7 = n6 = n10;
                        this.updatePointer(7 - n13);
                        continue;
                    }
                    if (n12 == 1) {
                        this.updatePointer(7 - n13);
                        if (bl) {
                            n8 = this.decodeWhiteCodeWord();
                            this.currChangingElems[n2++] = n7 += n8;
                            n8 = this.decodeBlackCodeWord();
                            this.setToBlack(n7, n8);
                            this.currChangingElems[n2++] = n7 += n8;
                        } else {
                            n8 = this.decodeBlackCodeWord();
                            this.setToBlack(n7, n8);
                            this.currChangingElems[n2++] = n7 += n8;
                            n8 = this.decodeWhiteCodeWord();
                            this.currChangingElems[n2++] = n7 += n8;
                        }
                        n6 = n7;
                        continue;
                    }
                    if (n12 <= 8) {
                        int n14 = n9 + (n12 - 5);
                        this.currChangingElems[n2++] = n14;
                        if (!bl) {
                            this.setToBlack(n7, n14 - n7);
                        }
                        n7 = n6 = n14;
                        bl = !bl;
                        this.updatePointer(7 - n13);
                        continue;
                    }
                    this.warning("Unknown coding mode encountered at line " + (this.srcMinY + n5) + ": read " + n7 + " of " + this.w + " expected pixels.");
                    n8 = 0;
                    while (n4 != 1) {
                        try {
                            n4 = this.findNextLine();
                            ++n8;
                        }
                        catch (EOFException eOFException) {
                            this.warning("Sync loss at line " + (this.srcMinY + n5) + ": read " + n5 + " of " + n + " lines.");
                            return;
                        }
                    }
                    n5 += n8 - 1;
                    this.updatePointer(13);
                    break;
                }
                this.currChangingElems[n2++] = n7;
                this.changingElemSize = n2;
            } else {
                this.decodeNextScanline(this.srcMinY + n5);
            }
            this.lineBitNum += this.bitsPerScanline;
            ++n5;
        }
    }

    public synchronized void decodeT6() throws IIOException {
        int n = this.h;
        boolean bl = false;
        int[] nArray = new int[2];
        int[] nArray2 = this.currChangingElems;
        this.changingElemSize = 0;
        nArray2[this.changingElemSize++] = this.w;
        nArray2[this.changingElemSize++] = this.w;
        for (int i = 0; i < n; ++i) {
            int n2 = -1;
            boolean bl2 = true;
            int[] nArray3 = this.prevChangingElems;
            this.prevChangingElems = this.currChangingElems;
            this.currChangingElems = nArray3;
            nArray2 = nArray3;
            int n3 = 0;
            int n4 = 0;
            this.lastChangingElement = 0;
            while (n4 < this.w) {
                this.getNextChangingElement(n2, bl2, nArray);
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = this.nextLesserThan8Bits(7);
                n7 = twoDCodes[n7] & 0xFF;
                int n8 = (n7 & 0x78) >>> 3;
                int n9 = n7 & 7;
                if (n8 == 0) {
                    if (!bl2) {
                        if (n6 > this.w) {
                            n6 = this.w;
                            this.warning("Decoded row " + (this.srcMinY + i) + " too long; ignoring extra samples.");
                        }
                        this.setToBlack(n4, n6 - n4);
                    }
                    n4 = n2 = n6;
                    this.updatePointer(7 - n9);
                    continue;
                }
                if (n8 == 1) {
                    int n10;
                    this.updatePointer(7 - n9);
                    if (bl2) {
                        n10 = this.decodeWhiteCodeWord();
                        nArray2[n3++] = n4 += n10;
                        n10 = this.decodeBlackCodeWord();
                        if (n10 > this.w - n4) {
                            n10 = this.w - n4;
                            this.warning("Decoded row " + (this.srcMinY + i) + " too long; ignoring extra samples.");
                        }
                        this.setToBlack(n4, n10);
                        nArray2[n3++] = n4 += n10;
                    } else {
                        n10 = this.decodeBlackCodeWord();
                        if (n10 > this.w - n4) {
                            n10 = this.w - n4;
                            this.warning("Decoded row " + (this.srcMinY + i) + " too long; ignoring extra samples.");
                        }
                        this.setToBlack(n4, n10);
                        nArray2[n3++] = n4 += n10;
                        n10 = this.decodeWhiteCodeWord();
                        nArray2[n3++] = n4 += n10;
                    }
                    n2 = n4;
                    continue;
                }
                if (n8 <= 8) {
                    int n11 = n5 + (n8 - 5);
                    nArray2[n3++] = n11;
                    if (!bl2) {
                        if (n11 > this.w) {
                            n11 = this.w;
                            this.warning("Decoded row " + (this.srcMinY + i) + " too long; ignoring extra samples.");
                        }
                        this.setToBlack(n4, n11 - n4);
                    }
                    n4 = n2 = n11;
                    bl2 = !bl2;
                    this.updatePointer(7 - n9);
                    continue;
                }
                if (n8 == 11) {
                    int n12 = this.nextLesserThan8Bits(3);
                    if (n12 != 7) {
                        String string = "Unsupported entrance code " + n12 + " for extension mode at line " + (this.srcMinY + i) + ".";
                        this.warning(string);
                    }
                    int n13 = 0;
                    boolean bl3 = false;
                    while (!bl3) {
                        while (this.nextLesserThan8Bits(1) != 1) {
                            ++n13;
                        }
                        if (n13 > 5) {
                            if (!bl2 && (n13 -= 6) > 0) {
                                nArray2[n3++] = n4;
                            }
                            n4 += n13;
                            if (n13 > 0) {
                                bl2 = true;
                            }
                            if (this.nextLesserThan8Bits(1) == 0) {
                                if (!bl2) {
                                    nArray2[n3++] = n4;
                                }
                                bl2 = true;
                            } else {
                                if (bl2) {
                                    nArray2[n3++] = n4;
                                }
                                bl2 = false;
                            }
                            bl3 = true;
                        }
                        if (n13 == 5) {
                            if (!bl2) {
                                nArray2[n3++] = n4;
                            }
                            n4 += n13;
                            bl2 = true;
                            continue;
                        }
                        nArray2[n3++] = n4 += n13;
                        this.setToBlack(n4, 1);
                        ++n4;
                        bl2 = false;
                    }
                    continue;
                }
                String string = "Unknown coding mode encountered at line " + (this.srcMinY + i) + ".";
                this.warning(string);
            }
            if (n3 <= this.w) {
                nArray2[n3++] = n4;
            }
            this.changingElemSize = n3;
            this.lineBitNum += this.bitsPerScanline;
        }
    }

    private void setToBlack(int n, int n2) {
        int n3 = (n += this.lineBitNum) + n2;
        int n4 = n >> 3;
        int n5 = n & 7;
        if (n5 > 0) {
            byte by = this.buffer[n4];
            for (int i = 1 << 7 - n5; i > 0 && n < n3; i >>= 1, ++n) {
                by = (byte)(by | i);
            }
            this.buffer[n4] = by;
        }
        n4 = n >> 3;
        while (n < n3 - 7) {
            this.buffer[n4++] = -1;
            n += 8;
        }
        while (n < n3) {
            int n6 = n4 = n >> 3;
            this.buffer[n6] = (byte)(this.buffer[n6] | 1 << 7 - (n & 7));
            ++n;
        }
    }

    private int decodeWhiteCodeWord() throws IIOException {
        int n = -1;
        int n2 = 0;
        boolean bl = true;
        while (bl) {
            int n3 = this.nextNBits(10);
            short s = white[n3];
            int n4 = s & 1;
            int n5 = s >>> 1 & 0xF;
            if (n5 == 12) {
                int n6 = this.nextLesserThan8Bits(2);
                n3 = n3 << 2 & 0xC | n6;
                s = additionalMakeup[n3];
                n5 = s >>> 1 & 7;
                n = s >>> 4 & 0xFFF;
                n2 += n;
                this.updatePointer(4 - n5);
                continue;
            }
            if (n5 == 0) {
                throw new IIOException("Error 0");
            }
            if (n5 == 15) {
                throw new IIOException("Error 1");
            }
            n = s >>> 5 & 0x7FF;
            n2 += n;
            this.updatePointer(10 - n5);
            if (n4 != 0) continue;
            bl = false;
        }
        return n2;
    }

    private int decodeBlackCodeWord() throws IIOException {
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            int n3 = this.nextLesserThan8Bits(4);
            short s = initBlack[n3];
            int n4 = s & 1;
            int n5 = s >>> 1 & 0xF;
            n = s >>> 5 & 0x7FF;
            if (n == 100) {
                n3 = this.nextNBits(9);
                s = black[n3];
                n4 = s & 1;
                n5 = s >>> 1 & 0xF;
                n = s >>> 5 & 0x7FF;
                if (n5 == 12) {
                    this.updatePointer(5);
                    n3 = this.nextLesserThan8Bits(4);
                    s = additionalMakeup[n3];
                    n5 = s >>> 1 & 7;
                    n = s >>> 4 & 0xFFF;
                    n2 += n;
                    this.updatePointer(4 - n5);
                    continue;
                }
                if (n5 == 15) {
                    throw new IIOException("Error 2");
                }
                n2 += n;
                this.updatePointer(9 - n5);
                if (n4 != 0) continue;
                bl = true;
                continue;
            }
            if (n == 200) {
                n3 = this.nextLesserThan8Bits(2);
                s = twoBitBlack[n3];
                n = s >>> 5 & 0x7FF;
                n2 += n;
                n5 = s >>> 1 & 0xF;
                this.updatePointer(2 - n5);
                bl = true;
                continue;
            }
            n2 += n;
            this.updatePointer(4 - n5);
            bl = true;
        }
        return n2;
    }

    private int findNextLine() throws IIOException, EOFException {
        int n = this.data.length * 8 - 1;
        int n2 = n - 12;
        int n3 = this.bytePointer * 8 + this.bitPointer;
        while (n3 <= n2) {
            int n4 = this.nextNBits(12);
            n3 += 12;
            while (n4 != 1 && n3 < n) {
                n4 = (n4 & 0x7FF) << 1 | this.nextLesserThan8Bits(1) & 1;
                ++n3;
            }
            if (n4 != 1) continue;
            if (this.oneD == 1) {
                if (n3 >= n) continue;
                return this.nextLesserThan8Bits(1);
            }
            return 1;
        }
        throw new EOFException();
    }

    private void getNextChangingElement(int n, boolean bl, int[] nArray) throws IIOException {
        int n2;
        int n3;
        int[] nArray2 = this.prevChangingElems;
        int n4 = this.changingElemSize;
        int n5 = n3 = this.lastChangingElement > 0 ? this.lastChangingElement - 1 : 0;
        n3 = bl ? (n3 &= 0xFFFFFFFE) : (n3 |= 1);
        for (n2 = n3; n2 < n4; n2 += 2) {
            int n6 = nArray2[n2];
            if (n6 <= n) continue;
            this.lastChangingElement = n2;
            nArray[0] = n6;
            break;
        }
        if (n2 + 1 < n4) {
            nArray[1] = nArray2[n2 + 1];
        }
    }

    private int nextNBits(int n) throws IIOException {
        byte by;
        byte by2;
        byte by3;
        int n2 = this.data.length - 1;
        int n3 = this.bytePointer;
        if (this.fillOrder == 1) {
            by3 = this.data[n3];
            if (n3 == n2) {
                by2 = 0;
                by = 0;
            } else if (n3 + 1 == n2) {
                by2 = this.data[n3 + 1];
                by = 0;
            } else {
                by2 = this.data[n3 + 1];
                by = this.data[n3 + 2];
            }
        } else if (this.fillOrder == 2) {
            by3 = flipTable[this.data[n3] & 0xFF];
            if (n3 == n2) {
                by2 = 0;
                by = 0;
            } else if (n3 + 1 == n2) {
                by2 = flipTable[this.data[n3 + 1] & 0xFF];
                by = 0;
            } else {
                by2 = flipTable[this.data[n3 + 1] & 0xFF];
                by = flipTable[this.data[n3 + 2] & 0xFF];
            }
        } else {
            throw new IIOException("Invalid FillOrder");
        }
        int n4 = 8 - this.bitPointer;
        int n5 = n - n4;
        int n6 = 0;
        if (n5 > 8) {
            n6 = n5 - 8;
            n5 = 8;
        }
        ++this.bytePointer;
        int n7 = (by3 & table1[n4]) << n - n4;
        int n8 = (by2 & table2[n5]) >>> 8 - n5;
        int n9 = 0;
        if (n6 != 0) {
            n8 <<= n6;
            n9 = (by & table2[n6]) >>> 8 - n6;
            n8 |= n9;
            ++this.bytePointer;
            this.bitPointer = n6;
        } else if (n5 == 8) {
            this.bitPointer = 0;
            ++this.bytePointer;
        } else {
            this.bitPointer = n5;
        }
        int n10 = n7 | n8;
        return n10;
    }

    private int nextLesserThan8Bits(int n) throws IIOException {
        int n2;
        byte by;
        byte by2;
        int n3 = this.data.length - 1;
        int n4 = this.bytePointer;
        if (this.fillOrder == 1) {
            by2 = this.data[n4];
            by = n4 == n3 ? (byte)0 : this.data[n4 + 1];
        } else if (this.fillOrder == 2) {
            by2 = flipTable[this.data[n4] & 0xFF];
            by = n4 == n3 ? (byte)0 : flipTable[this.data[n4 + 1] & 0xFF];
        } else {
            throw new IIOException("Invalid FillOrder");
        }
        int n5 = 8 - this.bitPointer;
        int n6 = n - n5;
        int n7 = n5 - n;
        if (n7 >= 0) {
            n2 = (by2 & table1[n5]) >>> n7;
            this.bitPointer += n;
            if (this.bitPointer == 8) {
                this.bitPointer = 0;
                ++this.bytePointer;
            }
        } else {
            n2 = (by2 & table1[n5]) << -n7;
            int n8 = (by & table2[n6]) >>> 8 - n6;
            n2 |= n8;
            ++this.bytePointer;
            this.bitPointer = n6;
        }
        return n2;
    }

    private void updatePointer(int n) {
        int n2;
        if (n > 8) {
            this.bytePointer -= n / 8;
            n %= 8;
        }
        if ((n2 = this.bitPointer - n) < 0) {
            --this.bytePointer;
            this.bitPointer = 8 + n2;
        } else {
            this.bitPointer = n2;
        }
    }

    private void warning(String string) {
        if (this.reader instanceof TIFFImageReader) {
            ((TIFFImageReader)this.reader).forwardWarningMessage(string);
        }
    }
}

