/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.IndexColorModel;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaletteBox
extends Box {
    private int numEntries;
    private int numComps;
    private byte[] bitDepth;
    private byte[][] lut;

    private static int computeLength(IndexColorModel indexColorModel) {
        int n = indexColorModel.getMapSize();
        int[] nArray = indexColorModel.getComponentSize();
        return 11 + nArray.length + n * nArray.length;
    }

    private static byte[] getCompSize(IndexColorModel indexColorModel) {
        int[] nArray = indexColorModel.getComponentSize();
        int n = nArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(nArray[i] - 1);
        }
        return byArray;
    }

    private static byte[][] getLUT(IndexColorModel indexColorModel) {
        int[] nArray = indexColorModel.getComponentSize();
        int n = indexColorModel.getMapSize();
        byte[][] byArray = new byte[nArray.length][n];
        indexColorModel.getReds(byArray[0]);
        indexColorModel.getGreens(byArray[1]);
        indexColorModel.getBlues(byArray[2]);
        if (nArray.length == 4) {
            indexColorModel.getAlphas(byArray[3]);
        }
        return byArray;
    }

    public PaletteBox(IndexColorModel indexColorModel) {
        this(PaletteBox.computeLength(indexColorModel), PaletteBox.getCompSize(indexColorModel), PaletteBox.getLUT(indexColorModel));
    }

    public PaletteBox(Node node) throws IIOInvalidTreeException {
        super(node);
        int n;
        Object object = null;
        int n2 = 0;
        NodeList nodeList = node.getChildNodes();
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if ("NumberEntries".equals(string)) {
                this.numEntries = Box.getIntElementValue(node2);
            }
            if ("NumberColors".equals(string)) {
                this.numComps = Box.getIntElementValue(node2);
            }
            if ("BitDepth".equals(string)) {
                this.bitDepth = Box.getByteArrayElementValue(node2);
            }
            if (!"LUT".equals(string)) continue;
            object = new byte[this.numEntries][];
            NodeList nodeList2 = node2.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node3 = nodeList2.item(i);
                string = node3.getNodeName();
                if (!"LUTRow".equals(string)) continue;
                object[n2++] = Box.getByteArrayElementValue(node3);
            }
        }
        this.lut = new byte[this.numComps][this.numEntries];
        for (n = 0; n < this.numComps; ++n) {
            for (int i = 0; i < this.numEntries; ++i) {
                this.lut[n][i] = object[i][n];
            }
        }
    }

    public PaletteBox(int n, byte[] byArray, byte[][] byArray2) {
        super(n, 1885564018, null);
        this.bitDepth = byArray;
        this.lut = byArray2;
        this.numEntries = byArray2[0].length;
        this.numComps = byArray2.length;
    }

    public PaletteBox(byte[] byArray) {
        super(8 + byArray.length, 1885564018, byArray);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getNumComp() {
        return this.numComps;
    }

    public byte[] getBitDepths() {
        return this.bitDepth;
    }

    public byte[][] getLUT() {
        return this.lut;
    }

    public IIOMetadataNode getNativeNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(Box.getName(this.getType()));
        this.setDefaultAttributes(iIOMetadataNode);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("NumberEntries");
        iIOMetadataNode2.setUserObject(new Integer(this.numEntries));
        iIOMetadataNode2.setNodeValue("" + this.numEntries);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumberColors");
        iIOMetadataNode2.setUserObject(new Integer(this.numComps));
        iIOMetadataNode2.setNodeValue("" + this.numComps);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("BitDepth");
        iIOMetadataNode2.setUserObject(this.bitDepth);
        iIOMetadataNode2.setNodeValue(ImageUtil.convertObjectToString(this.bitDepth));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("LUT");
        for (int i = 0; i < this.numEntries; ++i) {
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("LUTRow");
            byte[] byArray = new byte[this.numComps];
            for (int j = 0; j < this.numComps; ++j) {
                byArray[j] = this.lut[j][i];
            }
            iIOMetadataNode3.setUserObject(byArray);
            iIOMetadataNode3.setNodeValue(ImageUtil.convertObjectToString(byArray));
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
        }
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected void parse(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.numEntries = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.numComps = byArray[2];
        this.bitDepth = new byte[this.numComps];
        System.arraycopy(byArray, 3, this.bitDepth, 0, this.numComps);
        this.lut = new byte[this.numComps][this.numEntries];
        int n = 3 + this.numComps;
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < this.numComps; ++j) {
                this.lut[j][i] = byArray[n++];
            }
        }
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[3 + this.numComps + this.numEntries * this.numComps];
        this.data[0] = (byte)(this.numEntries >> 8);
        this.data[1] = (byte)(this.numEntries & 0xFF);
        this.data[2] = (byte)this.numComps;
        System.arraycopy(this.bitDepth, 0, this.data, 3, this.numComps);
        int n = 3 + this.numComps;
        for (int i = 0; i < this.numEntries; ++i) {
            for (int j = 0; j < this.numComps; ++j) {
                this.data[n++] = this.lut[j][i];
            }
        }
    }
}

