/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedCost;
import net.sf.mpxj.TimephasedItem;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.TimescaleUnits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimephasedUtility {
    public ArrayList<Duration> segmentWork(ProjectCalendar projectCalendar, List<TimephasedWork> list, TimescaleUnits timescaleUnits, ArrayList<DateRange> arrayList) {
        ArrayList<Duration> arrayList2 = new ArrayList<Duration>(arrayList.size());
        int n = 0;
        for (DateRange dateRange : arrayList) {
            int n2;
            int n3 = n2 = n == -1 ? -1 : this.getStartIndex(dateRange, list, n);
            if (n2 == -1) {
                arrayList2.add(Duration.getInstance(0, TimeUnit.HOURS));
                continue;
            }
            arrayList2.add(this.getRangeDuration(projectCalendar, timescaleUnits, dateRange, list, n2));
            n = n2;
        }
        return arrayList2;
    }

    public ArrayList<Duration> segmentBaselineWork(ProjectFile projectFile, List<TimephasedWork> list, TimescaleUnits timescaleUnits, ArrayList<DateRange> arrayList) {
        return this.segmentWork(projectFile.getBaselineCalendar(), list, timescaleUnits, arrayList);
    }

    public ArrayList<Double> segmentCost(ProjectCalendar projectCalendar, List<TimephasedCost> list, TimescaleUnits timescaleUnits, ArrayList<DateRange> arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>(arrayList.size());
        int n = 0;
        for (DateRange dateRange : arrayList) {
            int n2;
            int n3 = n2 = n == -1 ? -1 : this.getStartIndex(dateRange, list, n);
            if (n2 == -1) {
                arrayList2.add(NumberHelper.DOUBLE_ZERO);
                continue;
            }
            arrayList2.add(this.getRangeCost(projectCalendar, timescaleUnits, dateRange, list, n2));
            n = n2;
        }
        return arrayList2;
    }

    public ArrayList<Double> segmentBaselineCost(ProjectFile projectFile, List<TimephasedCost> list, TimescaleUnits timescaleUnits, ArrayList<DateRange> arrayList) {
        return this.segmentCost(projectFile.getBaselineCalendar(), list, timescaleUnits, arrayList);
    }

    private <T extends TimephasedItem<?>> int getStartIndex(DateRange dateRange, List<T> list, int n) {
        int n2 = -1;
        if (list != null) {
            long l = dateRange.getStart().getTime();
            long l2 = dateRange.getEnd().getTime();
            for (int i = n; i < list.size(); ++i) {
                TimephasedItem timephasedItem = (TimephasedItem)list.get(i);
                int n3 = DateHelper.compare(timephasedItem.getStart(), timephasedItem.getFinish(), l);
                if (n3 > 0) continue;
                if (n3 == 0) {
                    n2 = i;
                    break;
                }
                n3 = DateHelper.compare(timephasedItem.getStart(), timephasedItem.getFinish(), l2);
                if (n3 < 0) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    private Duration getRangeDuration(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedWork> list, int n) {
        Duration duration;
        switch (timescaleUnits) {
            case MINUTES: 
            case HOURS: {
                duration = this.getRangeDurationSubDay(projectCalendar, timescaleUnits, dateRange, list, n);
                break;
            }
            default: {
                duration = this.getRangeDurationWholeDay(projectCalendar, timescaleUnits, dateRange, list, n);
            }
        }
        return duration;
    }

    private Duration getRangeDurationSubDay(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedWork> list, int n) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }

    private Duration getRangeDurationWholeDay(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedWork> list, int n) {
        int n2 = 0;
        double d = 0.0;
        TimephasedWork timephasedWork = list.get(n);
        boolean bl = false;
        do {
            long l;
            long l2;
            if ((l2 = dateRange.getStart().getTime()) < (l = timephasedWork.getStart().getTime())) {
                l2 = l;
            }
            long l3 = dateRange.getEnd().getTime();
            long l4 = timephasedWork.getFinish().getTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l2);
            Date date = calendar.getTime();
            while (l2 < l3 && l2 < l4) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(date)) {
                    ++n2;
                }
                calendar.add(6, 1);
                l2 = calendar.getTimeInMillis();
                date = calendar.getTime();
            }
            bl = true;
            d += ((Duration)timephasedWork.getAmountPerDay()).getDuration() * (double)n2;
            if (l2 >= l3 || ++n >= list.size()) continue;
            timephasedWork = list.get(n);
            n2 = 0;
            bl = false;
        } while (!bl);
        return Duration.getInstance(d, ((Duration)timephasedWork.getAmountPerDay()).getUnits());
    }

    private Double getRangeCost(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedCost> list, int n) {
        Double d;
        switch (timescaleUnits) {
            case MINUTES: 
            case HOURS: {
                d = this.getRangeCostSubDay(projectCalendar, timescaleUnits, dateRange, list, n);
                break;
            }
            default: {
                d = this.getRangeCostWholeDay(projectCalendar, timescaleUnits, dateRange, list, n);
            }
        }
        return d;
    }

    private Double getRangeCostWholeDay(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedCost> list, int n) {
        int n2 = 0;
        double d = 0.0;
        TimephasedCost timephasedCost = list.get(n);
        boolean bl = false;
        do {
            long l;
            long l2;
            if ((l2 = dateRange.getStart().getTime()) < (l = timephasedCost.getStart().getTime())) {
                l2 = l;
            }
            long l3 = dateRange.getEnd().getTime();
            long l4 = timephasedCost.getFinish().getTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l2);
            Date date = calendar.getTime();
            while (l2 < l3 && l2 < l4) {
                if (projectCalendar == null || projectCalendar.isWorkingDate(date)) {
                    ++n2;
                }
                calendar.add(6, 1);
                l2 = calendar.getTimeInMillis();
                date = calendar.getTime();
            }
            bl = true;
            d += ((Number)timephasedCost.getAmountPerDay()).doubleValue() * (double)n2;
            if (l2 >= l3 || ++n >= list.size()) continue;
            timephasedCost = list.get(n);
            n2 = 0;
            bl = false;
        } while (!bl);
        return d;
    }

    private Double getRangeCostSubDay(ProjectCalendar projectCalendar, TimescaleUnits timescaleUnits, DateRange dateRange, List<TimephasedCost> list, int n) {
        throw new UnsupportedOperationException("Please request this functionality from the MPXJ maintainer");
    }
}

