/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarDateRanges;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.ReplaceOnceStream;
import net.sf.mpxj.primavera.schema.APIBusinessObjects;
import net.sf.mpxj.primavera.schema.ActivityType;
import net.sf.mpxj.primavera.schema.CalendarType;
import net.sf.mpxj.primavera.schema.CurrencyType;
import net.sf.mpxj.primavera.schema.GlobalPreferencesType;
import net.sf.mpxj.primavera.schema.ProjectType;
import net.sf.mpxj.primavera.schema.RelationshipType;
import net.sf.mpxj.primavera.schema.ResourceAssignmentType;
import net.sf.mpxj.primavera.schema.WBSType;
import net.sf.mpxj.primavera.schema.WorkTimeType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PrimaveraPMFileReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private Map<Integer, Integer> m_clashMap = new HashMap<Integer, Integer>();
    private Map<Integer, ProjectCalendar> m_calMap = new HashMap<Integer, ProjectCalendar>();
    private static final Charset UTF8;
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\".*\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://xmlns.oracle.com/Primavera/P6/V8.3/API/BusinessObjects\"";
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP;
    private static final Map<String, ConstraintType> CONSTRAINT_TYPE_MAP;
    private static final Map<String, Priority> PRIORITY_MAP;
    private static final Map<String, RelationType> RELATION_TYPE_MAP;
    private static final Map<String, Day> DAY_MAP;
    private static final Map<String, Boolean> MILESTONE_MAP;

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            ReplaceOnceStream replaceOnceStream = new ReplaceOnceStream(inputStream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, UTF8);
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoAssignmentUniqueID(false);
            CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
            customFieldContainer.getCustomField(TaskField.TEXT1).setAlias("WBS Code");
            customFieldContainer.getCustomField(TaskField.TEXT2).setAlias("Task ID");
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(replaceOnceStream));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            APIBusinessObjects aPIBusinessObjects = (APIBusinessObjects)unmarshaller.unmarshal((Source)sAXSource);
            List<ProjectType> list = aPIBusinessObjects.getProject();
            ProjectType projectType = null;
            for (ProjectType projectType2 : list) {
                if (BooleanHelper.getBoolean(projectType2.isExternal())) continue;
                projectType = projectType2;
                break;
            }
            if (projectType == null) {
                throw new MPXJException("Unable to locate any non-external projects in a list of " + list.size() + " projects");
            }
            this.processProjectProperties(aPIBusinessObjects, projectType);
            this.processCalendars(aPIBusinessObjects);
            this.processResources(aPIBusinessObjects);
            this.processTasks(projectType);
            this.processPredecessors(projectType);
            this.processAssignments(projectType);
            projectConfig.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", (Exception)((Object)jAXBException));
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
            this.m_clashMap.clear();
            this.m_calMap.clear();
        }
    }

    private void processProjectProperties(APIBusinessObjects aPIBusinessObjects, ProjectType projectType) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setCreationDate(projectType.getCreateDate());
        projectProperties.setFinishDate(projectType.getFinishDate());
        projectProperties.setName(projectType.getName());
        projectProperties.setStartDate(projectType.getPlannedStartDate());
        projectProperties.setStatusDate(projectType.getDataDate());
        projectProperties.setProjectTitle(projectType.getId());
        List<GlobalPreferencesType> list = aPIBusinessObjects.getGlobalPreferences();
        if (!list.isEmpty()) {
            GlobalPreferencesType globalPreferencesType = list.get(0);
            projectProperties.setCreationDate(globalPreferencesType.getCreateDate());
            projectProperties.setLastSaved(globalPreferencesType.getLastUpdateDate());
            projectProperties.setMinutesPerDay((int)(NumberHelper.getDouble(globalPreferencesType.getHoursPerDay()) * 60.0));
            projectProperties.setMinutesPerWeek((int)(NumberHelper.getDouble(globalPreferencesType.getHoursPerWeek()) * 60.0));
            projectProperties.setWeekStartDay(Day.getInstance(NumberHelper.getInt(globalPreferencesType.getStartDayOfWeek())));
            List<CurrencyType> list2 = aPIBusinessObjects.getCurrency();
            for (CurrencyType currencyType : list2) {
                if (!currencyType.getObjectId().equals(globalPreferencesType.getBaseCurrencyObjectId())) continue;
                projectProperties.setCurrencySymbol(currencyType.getSymbol());
                break;
            }
        }
    }

    private void processCalendars(APIBusinessObjects aPIBusinessObjects) {
        for (CalendarType calendarType : aPIBusinessObjects.getCalendar()) {
            Object object;
            List<WorkTimeType> list;
            Object object2;
            ProjectCalendar projectCalendar = this.m_projectFile.addCalendar();
            Integer n = calendarType.getObjectId();
            this.m_calMap.put(n, projectCalendar);
            projectCalendar.setName(calendarType.getName());
            projectCalendar.setUniqueID(n);
            CalendarType.StandardWorkWeek standardWorkWeek = calendarType.getStandardWorkWeek();
            if (standardWorkWeek != null) {
                object2 = standardWorkWeek.getStandardWorkHours().iterator();
                while (object2.hasNext()) {
                    CalendarType.StandardWorkWeek.StandardWorkHours standardWorkHours = (CalendarType.StandardWorkWeek.StandardWorkHours)object2.next();
                    Day day = DAY_MAP.get(standardWorkHours.getDayOfWeek());
                    list = standardWorkHours.getWorkTime();
                    if (list.isEmpty() || list.get(0) == null) {
                        projectCalendar.setWorkingDay(day, false);
                        continue;
                    }
                    projectCalendar.setWorkingDay(day, true);
                    object = projectCalendar.addCalendarHours(day);
                    for (WorkTimeType workTimeType : list) {
                        if (workTimeType == null) continue;
                        ((ProjectCalendarDateRanges)object).addRange(new DateRange(workTimeType.getStart(), workTimeType.getFinish()));
                    }
                }
            }
            if ((object2 = calendarType.getHolidayOrExceptions()) == null) continue;
            for (CalendarType.HolidayOrExceptions.HolidayOrException holidayOrException : ((CalendarType.HolidayOrExceptions)object2).getHolidayOrException()) {
                list = DateHelper.getDayStartDate(holidayOrException.getDate());
                object = DateHelper.getDayEndDate(holidayOrException.getDate());
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException((Date)((Object)list), (Date)object);
                List<WorkTimeType> list2 = holidayOrException.getWorkTime();
                for (WorkTimeType workTimeType : list2) {
                    if (workTimeType == null) continue;
                    projectCalendarException.addRange(new DateRange(workTimeType.getStart(), workTimeType.getFinish()));
                }
            }
        }
    }

    private void processResources(APIBusinessObjects aPIBusinessObjects) {
        List<net.sf.mpxj.primavera.schema.ResourceType> list = aPIBusinessObjects.getResource();
        for (net.sf.mpxj.primavera.schema.ResourceType resourceType : list) {
            ProjectCalendar projectCalendar;
            Resource resource = this.m_projectFile.addResource();
            resource.setUniqueID(resourceType.getObjectId());
            resource.setName(resourceType.getName());
            resource.setCode(resourceType.getEmployeeId());
            resource.setEmailAddress(resourceType.getEmailAddress());
            resource.setNotes(resourceType.getResourceNotes());
            resource.setCreationDate(resourceType.getCreateDate());
            resource.setType(RESOURCE_TYPE_MAP.get(resourceType.getResourceType()));
            Integer n = resourceType.getCalendarObjectId();
            if (n != null && (projectCalendar = this.m_calMap.get(n)) != null) {
                ProjectCalendar projectCalendar2;
                if (!projectCalendar.isDerived()) {
                    projectCalendar2 = this.m_projectFile.addCalendar();
                    projectCalendar2.setParent(projectCalendar);
                    projectCalendar2.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
                    projectCalendar2.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
                    resource.setResourceCalendar(projectCalendar2);
                } else if (projectCalendar.getResource() == null) {
                    resource.setResourceCalendar(projectCalendar);
                } else {
                    projectCalendar2 = this.m_projectFile.addCalendar();
                    projectCalendar2.copy(projectCalendar);
                    resource.setResourceCalendar(projectCalendar2);
                }
            }
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processTasks(ProjectType projectType) {
        Comparable<Integer> comparable;
        List<WBSType> list = projectType.getWBS();
        List<ActivityType> list2 = projectType.getActivity();
        HashSet<Comparable<Integer>> hashSet = new HashSet<Comparable<Integer>>();
        for (WBSType object2 : list) {
            Task task = this.m_projectFile.addTask();
            comparable = object2.getObjectId();
            hashSet.add(comparable);
            task.setUniqueID((Integer)comparable);
            task.setName(object2.getName());
            task.setBaselineCost(object2.getSummaryBaselineTotalCost());
            task.setRemainingCost(object2.getSummaryRemainingTotalCost());
            task.setRemainingDuration(this.getDuration(object2.getSummaryRemainingDuration()));
            task.setStart(object2.getAnticipatedStartDate());
            task.setFinish(object2.getAnticipatedFinishDate());
            task.setText(1, object2.getCode());
        }
        this.m_projectFile.getChildTasks().clear();
        for (WBSType wBSType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(wBSType.getObjectId());
            comparable = this.m_projectFile.getTaskByUniqueID(wBSType.getParentObjectId());
            if (comparable == null) {
                this.m_projectFile.getChildTasks().add(task);
                continue;
            }
            this.m_projectFile.getChildTasks().remove(task);
            ((Task)comparable).getChildTasks().add(task);
        }
        int n = 1;
        this.m_clashMap.clear();
        for (ActivityType activityType : list2) {
            Comparable<Integer> comparable2;
            comparable = activityType.getObjectId();
            if (hashSet.contains(comparable)) {
                while (hashSet.contains(n)) {
                    ++n;
                }
                comparable2 = n;
                this.m_clashMap.put((Integer)comparable, (Integer)comparable2);
                comparable = comparable2;
            }
            hashSet.add(comparable);
            Integer n2 = activityType.getWBSObjectId();
            Task task = this.m_projectFile.getTaskByUniqueID(n2);
            comparable2 = task == null ? this.m_projectFile.addTask() : task.addTask();
            ((Task)comparable2).setUniqueID((Integer)comparable);
            ((Task)comparable2).setPercentageComplete(NumberHelper.getDouble(activityType.getPercentComplete() * 100.0));
            ((Task)comparable2).setName(activityType.getName());
            ((Task)comparable2).setRemainingDuration(this.getDuration(activityType.getRemainingDuration()));
            ((Task)comparable2).setActualWork(this.getDuration(activityType.getActualDuration()));
            ((Task)comparable2).setRemainingWork(this.getDuration(activityType.getRemainingTotalUnits()));
            ((Task)comparable2).setBaselineDuration(this.getDuration(activityType.getPlannedDuration()));
            ((Task)comparable2).setActualDuration(this.getDuration(activityType.getActualDuration()));
            ((Task)comparable2).setDuration(this.getDuration(activityType.getAtCompletionDuration()));
            ((Task)comparable2).setActualCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setRemainingCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setBaselineCost(NumberHelper.DOUBLE_ZERO);
            ((Task)comparable2).setConstraintDate(activityType.getPrimaryConstraintDate());
            ((Task)comparable2).setConstraintType(CONSTRAINT_TYPE_MAP.get(activityType.getPrimaryConstraintType()));
            ((Task)comparable2).setActualStart(activityType.getActualStartDate());
            ((Task)comparable2).setActualFinish(activityType.getActualFinishDate());
            ((Task)comparable2).setLateStart(activityType.getRemainingLateStartDate());
            ((Task)comparable2).setLateFinish(activityType.getRemainingLateFinishDate());
            ((Task)comparable2).setEarlyStart(activityType.getRemainingEarlyStartDate());
            ((Task)comparable2).setEarlyFinish(activityType.getRemainingEarlyFinishDate());
            ((Task)comparable2).setBaselineStart(activityType.getPlannedStartDate());
            ((Task)comparable2).setBaselineFinish(activityType.getPlannedFinishDate());
            ((Task)comparable2).setPriority(PRIORITY_MAP.get(activityType.getLevelingPriority()));
            ((Task)comparable2).setCreateDate(activityType.getCreateDate());
            ((Task)comparable2).setText(1, activityType.getId());
            ((Task)comparable2).setMilestone(BooleanHelper.getBoolean(MILESTONE_MAP.get(activityType.getType())));
            ((Task)comparable2).setCritical(((Task)comparable2).getEarlyStart() != null && ((Task)comparable2).getLateStart() != null && ((Task)comparable2).getLateStart().compareTo(((Task)comparable2).getEarlyStart()) <= 0);
            Integer n3 = activityType.getCalendarObjectId();
            ProjectCalendar projectCalendar = this.m_calMap.get(n3);
            ((Task)comparable2).setCalendar(projectCalendar);
            ((Task)comparable2).setStart(activityType.getStartDate());
            ((Task)comparable2).setFinish(activityType.getFinishDate());
            this.populateField((FieldContainer)((Object)comparable2), TaskField.WORK, TaskField.BASELINE_WORK, TaskField.ACTUAL_WORK);
            this.m_eventManager.fireTaskReadEvent((Task)comparable2);
        }
        this.updateStructure();
    }

    private void populateField(FieldContainer fieldContainer, FieldType fieldType, FieldType fieldType2, FieldType fieldType3) {
        Object object = fieldContainer.getCachedValue(fieldType3);
        if (object == null) {
            object = fieldContainer.getCachedValue(fieldType2);
        }
        fieldContainer.set(fieldType, object);
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_projectFile.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    private void processPredecessors(ProjectType projectType) {
        for (RelationshipType relationshipType : projectType.getRelationship()) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getSuccessorActivityObjectId()));
            Task task2 = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(relationshipType.getPredecessorActivityObjectId()));
            if (task == null || task2 == null) continue;
            RelationType relationType = RELATION_TYPE_MAP.get(relationshipType.getType());
            Duration duration = this.getDuration(relationshipType.getLag());
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void processAssignments(ProjectType projectType) {
        List<ResourceAssignmentType> list = projectType.getResourceAssignment();
        for (ResourceAssignmentType resourceAssignmentType : list) {
            Task task = this.m_projectFile.getTaskByUniqueID(this.mapTaskID(resourceAssignmentType.getActivityObjectId()));
            Resource resource = this.m_projectFile.getResourceByUniqueID(resourceAssignmentType.getResourceObjectId());
            if (task == null || resource == null) continue;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(resourceAssignmentType.getObjectId());
            resourceAssignment.setRemainingWork(this.getDuration(resourceAssignmentType.getRemainingUnits()));
            resourceAssignment.setBaselineWork(this.getDuration(resourceAssignmentType.getPlannedUnits()));
            resourceAssignment.setActualWork(this.getDuration(resourceAssignmentType.getActualUnits()));
            resourceAssignment.setRemainingCost(resourceAssignmentType.getRemainingCost());
            resourceAssignment.setBaselineCost(resourceAssignmentType.getPlannedCost());
            resourceAssignment.setActualCost(resourceAssignmentType.getActualCost());
            resourceAssignment.setActualStart(resourceAssignmentType.getActualStartDate());
            resourceAssignment.setActualFinish(resourceAssignmentType.getActualFinishDate());
            resourceAssignment.setBaselineStart(resourceAssignmentType.getPlannedStartDate());
            resourceAssignment.setBaselineFinish(resourceAssignmentType.getPlannedFinishDate());
            task.setActualCost(task.getActualCost().doubleValue() + resourceAssignment.getActualCost().doubleValue());
            task.setRemainingCost(task.getRemainingCost().doubleValue() + resourceAssignment.getRemainingCost().doubleValue());
            task.setBaselineCost(task.getBaselineCost().doubleValue() + resourceAssignment.getBaselineCost().doubleValue());
            this.populateField(resourceAssignment, AssignmentField.WORK, AssignmentField.BASELINE_WORK, AssignmentField.ACTUAL_WORK);
            this.populateField(resourceAssignment, AssignmentField.COST, AssignmentField.BASELINE_COST, AssignmentField.ACTUAL_COST);
            this.populateField(resourceAssignment, AssignmentField.START, AssignmentField.BASELINE_START, AssignmentField.ACTUAL_START);
            this.populateField(resourceAssignment, AssignmentField.FINISH, AssignmentField.BASELINE_FINISH, AssignmentField.ACTUAL_FINISH);
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    private Duration getDuration(Double d) {
        Duration duration = null;
        if (d != null) {
            duration = Duration.getInstance(NumberHelper.getDouble(d), TimeUnit.HOURS);
        }
        return duration;
    }

    private Integer mapTaskID(Integer n) {
        Integer n2 = this.m_clashMap.get(n);
        if (n2 == null) {
            n2 = n;
        }
        return n2;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.primavera.schema", (ClassLoader)PrimaveraPMFileReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        UTF8 = Charset.forName("UTF8");
        RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
        RESOURCE_TYPE_MAP.put(null, ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        RESOURCE_TYPE_MAP.put("Material", ResourceType.MATERIAL);
        RESOURCE_TYPE_MAP.put("Nonlabor", ResourceType.MATERIAL);
        CONSTRAINT_TYPE_MAP = new HashMap<String, ConstraintType>();
        CONSTRAINT_TYPE_MAP.put("Start On", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Start On or Before", ConstraintType.START_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Start On or After", ConstraintType.START_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On", ConstraintType.MUST_FINISH_ON);
        CONSTRAINT_TYPE_MAP.put("Finish On or Before", ConstraintType.FINISH_NO_LATER_THAN);
        CONSTRAINT_TYPE_MAP.put("Finish On or After", ConstraintType.FINISH_NO_EARLIER_THAN);
        CONSTRAINT_TYPE_MAP.put("As Late As Possible", ConstraintType.AS_LATE_AS_POSSIBLE);
        CONSTRAINT_TYPE_MAP.put("Mandatory Start", ConstraintType.MUST_START_ON);
        CONSTRAINT_TYPE_MAP.put("Mandatory Finish", ConstraintType.MUST_FINISH_ON);
        PRIORITY_MAP = new HashMap<String, Priority>();
        PRIORITY_MAP.put("Top", Priority.getInstance(900));
        PRIORITY_MAP.put("High", Priority.getInstance(600));
        PRIORITY_MAP.put("Normal", Priority.getInstance(500));
        PRIORITY_MAP.put("Low", Priority.getInstance(400));
        PRIORITY_MAP.put("Lowest", Priority.getInstance(100));
        RELATION_TYPE_MAP = new HashMap<String, RelationType>();
        RELATION_TYPE_MAP.put("Finish to Start", RelationType.FINISH_START);
        RELATION_TYPE_MAP.put("Finish to Finish", RelationType.FINISH_FINISH);
        RELATION_TYPE_MAP.put("Start to Start", RelationType.START_START);
        RELATION_TYPE_MAP.put("Start to Finish", RelationType.START_FINISH);
        DAY_MAP = new HashMap<String, Day>();
        DAY_MAP.put("Monday", Day.MONDAY);
        DAY_MAP.put("Tuesday", Day.TUESDAY);
        DAY_MAP.put("Wednesday", Day.WEDNESDAY);
        DAY_MAP.put("Thursday", Day.THURSDAY);
        DAY_MAP.put("Friday", Day.FRIDAY);
        DAY_MAP.put("Saturday", Day.SATURDAY);
        DAY_MAP.put("Sunday", Day.SUNDAY);
        MILESTONE_MAP = new HashMap<String, Boolean>();
        MILESTONE_MAP.put("Task Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Resource Dependent", Boolean.FALSE);
        MILESTONE_MAP.put("Level of Effort", Boolean.FALSE);
        MILESTONE_MAP.put("Start Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("Finish Milestone", Boolean.TRUE);
        MILESTONE_MAP.put("WBS Summary", Boolean.FALSE);
    }
}

