/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXConstants;
import net.sf.mpxj.mpx.MPXJFormats;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.RecurrenceUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.writer.AbstractProjectWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MPXWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private OutputStreamWriter m_writer;
    private ResourceModel m_resourceModel;
    private TaskModel m_taskModel;
    private char m_delimiter;
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_useLocaleDefaults = true;
    private StringBuilder m_buffer;
    private MPXJFormats m_formats;

    @Override
    public void write(ProjectFile projectFile, OutputStream outputStream) throws IOException {
        this.m_projectFile = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        if (this.m_useLocaleDefaults) {
            LocaleUtility.setLocale(this.m_projectFile.getProjectProperties(), this.m_locale);
        }
        this.m_delimiter = projectFile.getProjectProperties().getMpxDelimiter();
        this.m_writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), projectFile.getProjectProperties().getMpxCodePage().getCharset());
        this.m_buffer = new StringBuilder();
        this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
        try {
            this.write();
        }
        finally {
            this.m_writer = null;
            this.m_projectFile = null;
            this.m_resourceModel = null;
            this.m_taskModel = null;
            this.m_buffer = null;
            this.m_locale = null;
            this.m_formats = null;
        }
    }

    private void write() throws IOException {
        this.m_projectFile.validateUniqueIDsForMicrosoftProject();
        this.writeFileCreationRecord();
        this.writeProjectHeader(this.m_projectFile.getProjectProperties());
        if (!this.m_projectFile.getAllResources().isEmpty()) {
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_resourceModel.toString());
            for (Resource resource : this.m_projectFile.getAllResources()) {
                this.writeResource(resource);
            }
        }
        if (!this.m_projectFile.getAllTasks().isEmpty()) {
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_writer.write(this.m_taskModel.toString());
            this.writeTasks(this.m_projectFile.getChildTasks());
        }
        this.m_writer.flush();
    }

    private void writeFileCreationRecord() throws IOException {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        this.m_buffer.setLength(0);
        this.m_buffer.append("MPX");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectProperties.getMpxProgramName());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectProperties.getMpxFileVersion());
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append((Object)projectProperties.getMpxCodePage());
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeProjectHeader(ProjectProperties projectProperties) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(10);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getCurrencySymbol()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getSymbolPosition()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getCurrencyDigits()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(projectProperties.getThousandsSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(projectProperties.getDecimalSeparator())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(11);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getDefaultDurationUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectProperties.getDefaultDurationIsFixed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getDefaultWorkUnits().getValue()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberHelper.getDouble(projectProperties.getMinutesPerDay()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDecimal(NumberHelper.getDouble(projectProperties.getMinutesPerWeek()) / 60.0)));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(projectProperties.getDefaultStandardRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatRate(projectProperties.getDefaultOvertimeRate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectProperties.getUpdatingTaskStatusUpdatesResourceStatus() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectProperties.getSplitInProgressTasks() ? "1" : "0");
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_buffer.append(12);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getDateOrder()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getTimeFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.getIntegerTimeInMinutes(projectProperties.getDefaultStartTime())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(projectProperties.getDateSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(Character.valueOf(projectProperties.getTimeSeparator())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getAMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getPMText()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getDateFormat()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getBarTextDateFormat()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        for (ProjectCalendar projectCalendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(projectCalendar);
        }
        this.m_buffer.setLength(0);
        this.m_buffer.append(30);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getProjectTitle()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getCompany()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getManager()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getDefaultCalendarName()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getStartDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getFinishDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getScheduleFrom()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getCurrentDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getComments()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(projectProperties.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(projectProperties.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(projectProperties.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(projectProperties.getWork2())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getBaselineDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getActualDuration())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatPercentage(projectProperties.getPercentageComplete())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getBaselineStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getBaselineFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getActualStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(projectProperties.getActualFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getStartVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(projectProperties.getFinishVariance())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getSubject()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getAuthor()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectProperties.getKeywords()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendar(ProjectCalendar projectCalendar) throws IOException {
        if (projectCalendar.getParent() == null || projectCalendar.getResource() != null) {
            this.m_buffer.setLength(0);
            if (projectCalendar.getParent() == null) {
                this.m_buffer.append(20);
                this.m_buffer.append(this.m_delimiter);
                if (projectCalendar.getName() != null) {
                    this.m_buffer.append(projectCalendar.getName());
                }
            } else {
                this.m_buffer.append(55);
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(projectCalendar.getParent().getName());
            }
            DayType[] dayTypeArray = projectCalendar.getDays();
            for (int i = 0; i < dayTypeArray.length; ++i) {
                this.m_buffer.append(this.m_delimiter);
                this.m_buffer.append(dayTypeArray[i].getValue());
            }
            this.m_buffer.append("\r\n");
            this.m_writer.write(this.m_buffer.toString());
            ProjectCalendarHours[] projectCalendarHoursArray = projectCalendar.getHours();
            for (int i = 0; i < projectCalendarHoursArray.length; ++i) {
                if (projectCalendarHoursArray[i] == null) continue;
                this.writeCalendarHours(projectCalendar, projectCalendarHoursArray[i]);
            }
            if (!projectCalendar.getCalendarExceptions().isEmpty()) {
                for (ProjectCalendarException projectCalendarException : projectCalendar.getCalendarExceptions()) {
                    this.writeCalendarException(projectCalendar, projectCalendarException);
                }
            }
            this.m_eventManager.fireCalendarWrittenEvent(projectCalendar);
        }
    }

    private void writeCalendarHours(ProjectCalendar projectCalendar, ProjectCalendarHours projectCalendarHours) throws IOException {
        DateRange dateRange;
        DateRange dateRange2;
        this.m_buffer.setLength(0);
        int n = !projectCalendar.isDerived() ? 25 : 56;
        DateRange dateRange3 = projectCalendarHours.getRange(0);
        if (dateRange3 == null) {
            dateRange3 = DateRange.EMPTY_RANGE;
        }
        if ((dateRange2 = projectCalendarHours.getRange(1)) == null) {
            dateRange2 = DateRange.EMPTY_RANGE;
        }
        if ((dateRange = projectCalendarHours.getRange(2)) == null) {
            dateRange = DateRange.EMPTY_RANGE;
        }
        this.m_buffer.append(n);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(projectCalendarHours.getDay()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange3.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange3.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange2.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange2.getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(dateRange.getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeCalendarException(ProjectCalendar projectCalendar, ProjectCalendarException projectCalendarException) throws IOException {
        this.m_buffer.setLength(0);
        if (!projectCalendar.isDerived()) {
            this.m_buffer.append(26);
        } else {
            this.m_buffer.append(57);
        }
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(projectCalendarException.getFromDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDate(projectCalendarException.getToDate())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(projectCalendarException.getWorking() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(0).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(0).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(1).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(1).getEnd())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(2).getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatTime(projectCalendarException.getRange(2).getEnd())));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResource(Resource resource) throws IOException {
        int n;
        this.m_buffer.setLength(0);
        int[] nArray = this.m_resourceModel.getModel();
        this.m_buffer.append(50);
        for (int i = 0; i < nArray.length && (n = nArray[i]) != -1; ++i) {
            ResourceField resourceField = MPXResourceField.getMpxjField(n);
            Object object = resource.getCachedValue(resourceField);
            object = this.formatType(resourceField.getDataType(), object);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(object));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String string = resource.getNotes();
        if (string.length() != 0) {
            this.writeNotes(51, string);
        }
        if (resource.getResourceCalendar() != null) {
            this.writeCalendar(resource.getResourceCalendar());
        }
        this.m_eventManager.fireResourceWrittenEvent(resource);
    }

    private void writeNotes(int n, String string) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(n);
        this.m_buffer.append(this.m_delimiter);
        if (string != null) {
            String string2 = this.stripLineBreaks(string, MPXConstants.EOL_PLACEHOLDER_STRING);
            boolean bl = string2.indexOf(this.m_delimiter) != -1 || string2.indexOf(34) != -1;
            int n2 = string2.length();
            if (bl) {
                this.m_buffer.append('\"');
            }
            block3: for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                switch (c) {
                    case '\"': {
                        this.m_buffer.append("\"\"");
                        continue block3;
                    }
                    default: {
                        this.m_buffer.append(c);
                    }
                }
            }
            if (bl) {
                this.m_buffer.append('\"');
            }
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTask(Task task) throws IOException {
        int n;
        this.m_buffer.setLength(0);
        int[] nArray = this.m_taskModel.getModel();
        this.m_buffer.append(70);
        for (int i = 0; i < nArray.length && (n = nArray[i]) != -1; ++i) {
            TaskField taskField = MPXTaskField.getMpxjField(n);
            Object object2 = task.getCachedValue(taskField);
            object2 = this.formatType(taskField.getDataType(), object2);
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(object2));
        }
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        String string = task.getNotes();
        if (string.length() != 0) {
            this.writeNotes(71, string);
        }
        if (task.getRecurringTask() != null) {
            this.writeRecurringTask(task.getRecurringTask());
        }
        if (!task.getResourceAssignments().isEmpty()) {
            for (ResourceAssignment resourceAssignment : task.getResourceAssignments()) {
                this.writeResourceAssignment(resourceAssignment);
            }
        }
        this.m_eventManager.fireTaskWrittenEvent(task);
    }

    private void writeRecurringTask(RecurringTask recurringTask) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(72);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append("1");
        if (recurringTask.getRecurrenceType() != null) {
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(recurringTask.getStartDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(recurringTask.getFinishDate())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationValue(this.m_projectFile.getProjectProperties(), recurringTask.getDuration())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDurationUnits(recurringTask)));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getOccurrences()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getRecurrenceValue(recurringTask.getRecurrenceType())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append("0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(recurringTask.getUseEndDate() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(recurringTask.getDailyWorkday() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDays(recurringTask.getWeeklyDays())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(recurringTask.getMonthlyRelative() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(recurringTask.getYearlyAbsolute() ? "1" : "0");
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getDailyFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getWeeklyFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getMonthlyRelativeOrdinal()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(recurringTask.getMonthlyRelativeDay())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getMonthlyRelativeFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getMonthlyAbsoluteDay()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getMonthlyAbsoluteFrequency()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getYearlyRelativeOrdinal()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(RecurrenceUtility.getDay(recurringTask.getYearlyRelativeDay())));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(recurringTask.getYearlyRelativeMonth()));
            this.m_buffer.append(this.m_delimiter);
            this.m_buffer.append(this.format(this.formatDateTime(recurringTask.getYearlyAbsoluteDate())));
            this.stripTrailingDelimiters(this.m_buffer);
        }
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeResourceAssignment(ResourceAssignment resourceAssignment) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(75);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.formatResource(resourceAssignment.getResource()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatUnits(resourceAssignment.getUnits())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(resourceAssignment.getWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(resourceAssignment.getBaselineWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(resourceAssignment.getActualWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(resourceAssignment.getOvertimeWork())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(resourceAssignment.getCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(resourceAssignment.getBaselineCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatCurrency(resourceAssignment.getActualCost())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(resourceAssignment.getStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTime(resourceAssignment.getFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDuration(resourceAssignment.getDelay())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(resourceAssignment.getResourceUniqueID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
        ResourceAssignmentWorkgroupFields resourceAssignmentWorkgroupFields = resourceAssignment.getWorkgroupAssignment();
        if (resourceAssignmentWorkgroupFields == null) {
            resourceAssignmentWorkgroupFields = ResourceAssignmentWorkgroupFields.EMPTY;
        }
        this.writeResourceAssignmentWorkgroupFields(resourceAssignmentWorkgroupFields);
        this.m_eventManager.fireAssignmentWrittenEvent(resourceAssignment);
    }

    private void writeResourceAssignmentWorkgroupFields(ResourceAssignmentWorkgroupFields resourceAssignmentWorkgroupFields) throws IOException {
        this.m_buffer.setLength(0);
        this.m_buffer.append(76);
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(resourceAssignmentWorkgroupFields.getMessageUniqueID()));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(resourceAssignmentWorkgroupFields.getConfirmed() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(resourceAssignmentWorkgroupFields.getResponsePending() ? "1" : "0");
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(resourceAssignmentWorkgroupFields.getUpdateStart())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(this.formatDateTimeNull(resourceAssignmentWorkgroupFields.getUpdateFinish())));
        this.m_buffer.append(this.m_delimiter);
        this.m_buffer.append(this.format(resourceAssignmentWorkgroupFields.getScheduleID()));
        this.stripTrailingDelimiters(this.m_buffer);
        this.m_buffer.append("\r\n");
        this.m_writer.write(this.m_buffer.toString());
    }

    private void writeTasks(List<Task> list) throws IOException {
        for (Task task : list) {
            this.writeTask(task);
            this.writeTasks(task.getChildTasks());
        }
    }

    private Integer getIntegerTimeInMinutes(Date date) {
        Integer n = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n2 = calendar.get(11) * 60;
            n = n2 += calendar.get(12);
        }
        return n;
    }

    private String escapeQuotes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        stringBuilder.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuilder.append(c);
            if (c != '\"') continue;
            stringBuilder.append('\"');
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    private String stripLineBreaks(String string, String string2) {
        if (string.indexOf(13) != -1 || string.indexOf(10) != -1) {
            int n;
            StringBuilder stringBuilder = new StringBuilder(string);
            while ((n = stringBuilder.indexOf("\r\n")) != -1) {
                stringBuilder.replace(n, n + 2, string2);
            }
            while ((n = stringBuilder.indexOf("\n\r")) != -1) {
                stringBuilder.replace(n, n + 2, string2);
            }
            while ((n = stringBuilder.indexOf("\r")) != -1) {
                stringBuilder.replace(n, n + 1, string2);
            }
            while ((n = stringBuilder.indexOf("\n")) != -1) {
                stringBuilder.replace(n, n + 1, string2);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private String format(Object object) {
        String string;
        if (object == null) {
            string = "";
        } else {
            string = object instanceof Boolean ? LocaleData.getString(this.m_locale, (Boolean)object == true ? "YES" : "NO") : (object instanceof Float || object instanceof Double ? this.m_formats.getDecimalFormat().format(((Number)object).doubleValue()) : (object instanceof Day ? Integer.toString(((Day)object).getValue()) : object.toString()));
            if ((string = this.stripLineBreaks(string, MPXConstants.EOL_PLACEHOLDER_STRING)).indexOf(34) != -1) {
                string = this.escapeQuotes(string);
            } else if (string.indexOf(this.m_delimiter) != -1) {
                string = '\"' + string + '\"';
            }
        }
        return string;
    }

    private void stripTrailingDelimiters(StringBuilder stringBuilder) {
        int n;
        for (n = stringBuilder.length() - 1; n > 0 && stringBuilder.charAt(n) == this.m_delimiter; --n) {
        }
        stringBuilder.setLength(n + 1);
    }

    private String formatTime(Date date) {
        return date == null ? null : this.m_formats.getTimeFormat().format(date);
    }

    private String formatCurrency(Number number) {
        return number == null ? null : this.m_formats.getCurrencyFormat().format(number);
    }

    private String formatUnits(Number number) {
        return number == null ? null : this.m_formats.getUnitsDecimalFormat().format(number.doubleValue() / 100.0);
    }

    private String formatDateTime(Object object) {
        String string = null;
        if (object instanceof Date) {
            string = this.m_formats.getDateTimeFormat().format(object);
        }
        return string;
    }

    private String formatDateTimeNull(Date date) {
        return date == null ? this.m_formats.getNullText() : this.m_formats.getDateTimeFormat().format(date);
    }

    private String formatDate(Date date) {
        return date == null ? null : this.m_formats.getDateFormat().format(date);
    }

    private String formatPercentage(Number number) {
        return number == null ? null : this.m_formats.getPercentageDecimalFormat().format(number) + "%";
    }

    private String formatAccrueType(AccrueType accrueType) {
        return accrueType == null ? null : LocaleData.getStringArray(this.m_locale, "ACCRUE_TYPES")[accrueType.getValue() - 1];
    }

    private String formatConstraintType(ConstraintType constraintType) {
        return constraintType == null ? null : LocaleData.getStringArray(this.m_locale, "CONSTRAINT_TYPES")[constraintType.getValue()];
    }

    private String formatDuration(Object object) {
        String string = null;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            string = this.m_formats.getDurationDecimalFormat().format(duration.getDuration()) + this.formatTimeUnit(duration.getUnits());
        }
        return string;
    }

    private String formatRate(Rate rate) {
        String string = null;
        if (rate != null) {
            StringBuilder stringBuilder = new StringBuilder(this.m_formats.getCurrencyFormat().format(rate.getAmount()));
            stringBuilder.append("/");
            stringBuilder.append(this.formatTimeUnit(rate.getUnits()));
            string = stringBuilder.toString();
        }
        return string;
    }

    private String formatPriority(Priority priority) {
        String string = null;
        if (priority != null) {
            String[] stringArray = LocaleData.getStringArray(this.m_locale, "PRIORITY_TYPES");
            int n = priority.getValue();
            if (n < 100) {
                n = 100;
            } else if (n > 1000) {
                n = 1000;
            }
            string = stringArray[(n /= 100) - 1];
        }
        return string;
    }

    private String formatTaskType(TaskType taskType) {
        return LocaleData.getString(this.m_locale, taskType == TaskType.FIXED_DURATION ? "YES" : "NO");
    }

    private String formatRelationList(List<Relation> list) {
        String string = null;
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Relation relation : list) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(this.m_delimiter);
                }
                stringBuilder.append(this.formatRelation(relation));
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private String formatRelation(Relation relation) {
        String string = null;
        if (relation != null) {
            StringBuilder stringBuilder = new StringBuilder(relation.getTargetTask().getID().toString());
            Duration duration = relation.getLag();
            RelationType relationType = relation.getType();
            double d = duration.getDuration();
            if (d != 0.0 || relationType != RelationType.FINISH_START) {
                String[] stringArray = LocaleData.getStringArray(this.m_locale, "RELATION_TYPES");
                stringBuilder.append(stringArray[relationType.getValue()]);
            }
            if (d != 0.0) {
                if (d > 0.0) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(this.formatDuration(duration));
            }
            string = stringBuilder.toString();
        }
        this.m_eventManager.fireRelationWrittenEvent(relation);
        return string;
    }

    private String formatTimeUnit(TimeUnit timeUnit) {
        int n = timeUnit.getValue();
        String[][] stringArray = LocaleData.getStringArrays(this.m_locale, "TIME_UNITS_ARRAY");
        String string = n < 0 || n >= stringArray.length ? "" : stringArray[n][0];
        return string;
    }

    private String formatDecimal(double d) {
        return this.m_formats.getDecimalFormat().format(d);
    }

    private Object formatType(DataType dataType, Object object) {
        switch (dataType) {
            case DATE: {
                object = this.formatDateTime(object);
                break;
            }
            case CURRENCY: {
                object = this.formatCurrency((Number)object);
                break;
            }
            case UNITS: {
                object = this.formatUnits((Number)object);
                break;
            }
            case PERCENTAGE: {
                object = this.formatPercentage((Number)object);
                break;
            }
            case ACCRUE: {
                object = this.formatAccrueType((AccrueType)object);
                break;
            }
            case CONSTRAINT: {
                object = this.formatConstraintType((ConstraintType)object);
                break;
            }
            case WORK: 
            case DURATION: {
                object = this.formatDuration(object);
                break;
            }
            case RATE: {
                object = this.formatRate((Rate)object);
                break;
            }
            case PRIORITY: {
                object = this.formatPriority((Priority)object);
                break;
            }
            case RELATION_LIST: {
                object = this.formatRelationList((List)object);
                break;
            }
            case TASK_TYPE: {
                object = this.formatTaskType((TaskType)object);
                break;
            }
        }
        return object;
    }

    private String formatResource(Resource resource) {
        return resource == null ? "-65535" : this.format(resource.getID());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public boolean getUseLocaleDefaults() {
        return this.m_useLocaleDefaults;
    }

    public void setUseLocaleDefaults(boolean bl) {
        this.m_useLocaleDefaults = bl;
    }

    public Locale[] getSupportedLocales() {
        return LocaleUtility.getSupportedLocales();
    }
}

