/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.CustomField;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.CustomFieldLookupTable;
import net.sf.mpxj.DataType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Props;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFieldValueReader9 {
    private final ProjectProperties m_properties;
    private final Props m_projectProps;
    private final CustomFieldContainer m_container;

    public CustomFieldValueReader9(ProjectProperties projectProperties, Props props, CustomFieldContainer customFieldContainer) {
        this.m_properties = projectProperties;
        this.m_projectProps = props;
        this.m_container = customFieldContainer;
    }

    public void process() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (byArray != null) {
            int n = 0;
            int n2 = MPPUtility.getInt(byArray, n);
            int n3 = MPPUtility.getInt(byArray, n += 4);
            n += 4;
            int n4 = 0;
            for (int i = 0; i < n3 && n < n2; ++i) {
                FieldType fieldType = FieldTypeHelper.getInstance(MPPUtility.getInt(byArray, n));
                n4 = MPPUtility.getInt(byArray, n += 4);
                n += 4;
                if (n4 >= byArray.length) continue;
                int n5 = n4;
                int n6 = MPPUtility.getInt(byArray, n5 += 8) + n4;
                int n7 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n8 = MPPUtility.getInt(byArray, n5 += 4) + n4;
                int n9 = n7 - n6;
                byte[] byArray2 = new byte[n9];
                MPPUtility.getByteArray(byArray, n6, n9, byArray2, 0);
                int n10 = n8 - n7;
                byte[] byArray3 = new byte[n10];
                MPPUtility.getByteArray(byArray, n7, n10, byArray3, 0);
                this.populateContainer(fieldType, byArray2, byArray3);
            }
        }
    }

    private void populateContainer(FieldType fieldType, byte[] byArray, byte[] byArray2) {
        CustomField customField = this.m_container.getCustomField(fieldType);
        CustomFieldLookupTable customFieldLookupTable = customField.getLookupTable();
        List<Object> list = this.convertType(DataType.STRING, byArray2);
        List<Object> list2 = this.convertType(fieldType.getDataType(), byArray);
        for (int i = 0; i < list.size(); ++i) {
            CustomFieldValueItem customFieldValueItem = new CustomFieldValueItem(0);
            customFieldValueItem.setDescription((String)list.get(i));
            if (i < list2.size()) {
                customFieldValueItem.setValue(list2.get(i));
            }
            customFieldLookupTable.add(customFieldValueItem);
        }
    }

    private List<Object> convertType(DataType dataType, byte[] byArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        block8: while (n < byArray.length) {
            switch (dataType) {
                case STRING: {
                    Object object = MPPUtility.getUnicodeString(byArray, n);
                    arrayList.add(object);
                    n += (((String)object).length() + 1) * 2;
                    continue block8;
                }
                case CURRENCY: {
                    Object object = MPPUtility.getDouble(byArray, n) / 100.0;
                    arrayList.add(object);
                    n += 8;
                    continue block8;
                }
                case NUMERIC: {
                    Object object = MPPUtility.getDouble(byArray, n);
                    arrayList.add(object);
                    n += 8;
                    continue block8;
                }
                case DATE: {
                    Object object = MPPUtility.getTimestamp(byArray, n);
                    arrayList.add(object);
                    n += 4;
                    continue block8;
                }
                case DURATION: {
                    Object object = MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, n + 4), this.m_properties.getDefaultDurationUnits());
                    Duration duration = MPPUtility.getAdjustedDuration(this.m_properties, MPPUtility.getInt(byArray, n), (TimeUnit)object);
                    arrayList.add(duration);
                    n += 6;
                    continue block8;
                }
                case BOOLEAN: {
                    Object object = MPPUtility.getShort(byArray, n) == 1;
                    arrayList.add(object);
                    n += 2;
                    continue block8;
                }
            }
            n = byArray.length;
        }
        return arrayList;
    }
}

