/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.print.ExtendedPageFormat;
import com.projity.print.PDFPrintService;
import com.projity.strings.Messages;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class PageSizes
extends MediaSizeName {
    public static final int BIG_PAGE = 1;
    public static final int CUSTOM = 2;
    protected static PageSizes instance;
    protected Format[] sizes;
    protected Format[] sizesSystemNames;

    protected PageSizes() {
        super(-1);
        String[] stringArray = this.getStringTable();
        EnumSyntax[] enumSyntaxArray = this.getEnumValueTable();
        ArrayList<Format> arrayList = new ArrayList<Format>(stringArray.length + 2);
        arrayList.add(new Format(Messages.getString("PageSetupDialog.PaperFormat.Custom"), 2));
        arrayList.add(new Format(Messages.getString("PageSetupDialog.PaperSizeSettings.SinglePage"), 1));
        ArrayList<Format> arrayList2 = new ArrayList<Format>(stringArray.length + 2);
        arrayList2.add(new Format(Messages.getString("PageSetupDialog.PaperFormat.Custom"), 2));
        arrayList2.add(new Format(Messages.getString("PageSetupDialog.PaperSizeSettings.SinglePage"), 1));
        for (int i = 0; i < stringArray.length; ++i) {
            MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)enumSyntaxArray[i]);
            if (mediaSize == null) continue;
            String string = stringArray[i];
            String string2 = string;
            if (string2.startsWith("iso-")) {
                string2 = string2.substring(4);
            } else if (string2.startsWith("na-")) {
                string2 = string2.substring(3);
            } else if (string2.startsWith("jis-") && string2.length() > 5) {
                string2 = string2.substring(0, 5).toUpperCase() + string2.substring(5);
            }
            if (string2.length() == 0) continue;
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            arrayList.add(new Format(string2, mediaSize));
            arrayList2.add(new Format(string, mediaSize));
        }
        this.sizes = new Format[arrayList.size()];
        this.sizes = arrayList.toArray(this.sizes);
        this.sizesSystemNames = new Format[arrayList2.size()];
        this.sizesSystemNames = arrayList2.toArray(this.sizesSystemNames);
    }

    public static PageSizes getInstance() {
        if (instance == null) {
            instance = new PageSizes();
        }
        return instance;
    }

    public Format[] getPageSizes() {
        return this.sizes;
    }

    public Dimension getPageDimension(Object object) {
        if (object == null || !(object instanceof Format)) {
            return null;
        }
        return ((Format)object).getDimension();
    }

    public boolean isCustomPageSize(Object object) {
        if (object == null || !(object instanceof Format)) {
            return false;
        }
        return ((Format)object).getType() == 2;
    }

    public boolean isBigPageSize(Object object) {
        if (object == null || !(object instanceof Format)) {
            return false;
        }
        return ((Format)object).getType() == 1;
    }

    public Format getPageSize(ExtendedPageFormat extendedPageFormat) {
        MediaSizeName mediaSizeName = extendedPageFormat.getSizeName();
        if (mediaSizeName == null) {
            int n = extendedPageFormat.getType();
            for (int i = 1; i < this.sizes.length; ++i) {
                if (this.sizesSystemNames[i].getType() != n) continue;
                return this.sizes[i];
            }
        } else {
            for (int i = 1; i < this.sizes.length; ++i) {
                if (!mediaSizeName.equals(this.sizesSystemNames[i].getValue())) continue;
                return this.sizes[i];
            }
        }
        return this.sizes[0];
    }

    public MediaSizeNameModel createComboBoxModel(PrintService printService) {
        return new MediaSizeNameModel(this.sizes, this.sizesSystemNames, printService);
    }

    public static class MediaSizeNameModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected Format[] sizes;
        protected Format[] sizesSystemNames;
        protected ArrayList<Format> currentSizes;
        protected Object selectedItem;

        protected MediaSizeNameModel(Format[] formatArray, Format[] formatArray2, PrintService printService) {
            this.sizes = formatArray;
            this.sizesSystemNames = formatArray2;
            this.currentSizes = new ArrayList(formatArray.length);
            this.update(printService);
        }

        public Format update(PrintService printService) {
            HashSet<MediaSizeName> hashSet = null;
            if (!(printService instanceof PDFPrintService)) {
                Media[] mediaArray = (Media[])printService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
                hashSet = new HashSet<MediaSizeName>();
                for (int i = 0; i < mediaArray.length; ++i) {
                    if (!(mediaArray[i] instanceof MediaSizeName)) continue;
                    hashSet.add((MediaSizeName)mediaArray[i]);
                }
            }
            this.currentSizes.clear();
            boolean bl = false;
            MediaSizeName mediaSizeName = this.selectedItem == null ? null : ((Format)this.selectedItem).getValue();
            for (int i = 0; i < this.sizes.length; ++i) {
                MediaSizeName mediaSizeName2 = this.sizesSystemNames[i].getValue();
                if (mediaSizeName2 == null && hashSet != null || hashSet != null && !hashSet.contains(mediaSizeName2)) continue;
                if (mediaSizeName2 != null && mediaSizeName2.equals(mediaSizeName)) {
                    bl = true;
                }
                this.currentSizes.add(this.sizes[i]);
            }
            Format format = null;
            if (!bl) {
                format = this.selectDefault(printService, true);
            }
            this.fireContentsChanged(this, 0, this.currentSizes.size());
            return format;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void setSelectedItem(Object object) {
            this.selectedItem = object;
        }

        public Format selectDefault(PrintService printService, boolean bl) {
            MediaSizeName mediaSizeName = ExtendedPageFormat.getDefaultMediaSizeName(printService);
            for (Format format : this.currentSizes) {
                if (format.getValue() == null || !format.getValue().equals(mediaSizeName)) continue;
                if (bl) {
                    this.setSelectedItem(format);
                }
                return format;
            }
            return null;
        }

        public Object getElementAt(int n) {
            return this.currentSizes.get(n);
        }

        public int getSize() {
            return this.currentSizes.size();
        }
    }

    public static class Format {
        protected String name;
        protected MediaSizeName value;
        protected Dimension dimension;
        protected int type;

        public Format(String string, int n) {
            this.name = string;
            this.value = null;
            this.type = n;
        }

        public Format(String string, MediaSize mediaSize) {
            this.name = string;
            this.value = mediaSize.getMediaSizeName();
            this.dimension = new Dimension();
            this.dimension.setSize(mediaSize.getX(1000), mediaSize.getY(1000));
        }

        public String toString() {
            return this.name;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public MediaSizeName getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }
}

