/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.graphic.configuration.CellFormat;
import com.projity.pm.graphic.ChangeAwareTextField;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.renderer.CellUtility;
import com.projity.pm.graphic.spreadsheet.renderer.FontManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class NameCellComponent
extends JPanel {
    protected JComponent textComponent = null;
    protected JLabel iconLabel = null;
    protected Box.Filler filler = null;
    protected ImageIcon collapsedIcon;
    protected ImageIcon expandedIcon;
    protected ImageIcon leafIcon;
    protected ImageIcon emptyLeafIcon;
    protected String text = null;
    protected ImageIcon icon = null;
    protected boolean lazy = false;
    protected boolean fetched = true;
    protected ImageIcon unfetchedLazyIcon = null;
    protected ImageIcon fetchedLazyExpandedIcon = null;
    protected ImageIcon fetchedLazyCollapsedIcon = null;
    protected boolean offline;
    int level = -1;
    protected static NameCellComponent rendererComponent;
    protected static NameCellComponent editorComponent;
    protected static Font savedRendererFont;
    protected static Font savedEditorFont;

    public NameCellComponent() {
        this(new JLabel(""));
    }

    public NameCellComponent(JComponent jComponent) {
        this.textComponent = jComponent;
        jComponent.setFont(this.getFont());
    }

    public void init() {
        this.setBackground(Color.WHITE);
        this.textComponent.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.setLayout(new BoxLayout(this, 0));
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        this.leafIcon = IconManager.getIcon("spreadsheet.leaf.icon");
        this.emptyLeafIcon = IconManager.getIcon("spreadsheet.emptyleaf.icon");
        this.collapsedIcon = IconManager.getIcon("spreadsheet.collapsed.icon");
        this.expandedIcon = IconManager.getIcon("spreadsheet.expanded.icon");
        this.unfetchedLazyIcon = IconManager.getIcon("spreadsheet.unfetchedLazy.icon");
        this.fetchedLazyExpandedIcon = IconManager.getIcon("spreadsheet.fetchedLazyExpanded.icon");
        this.fetchedLazyCollapsedIcon = IconManager.getIcon("spreadsheet.fetchedLazyCollapsed.icon");
        this.filler = (Box.Filler)Box.createHorizontalStrut(this.leafIcon.getIconWidth());
        this.add(this.filler);
        this.iconLabel = new JLabel(this.leafIcon);
        this.iconLabel.setAlignmentY(0.5f);
        this.iconLabel.setAlignmentX(0.0f);
        this.add(this.iconLabel);
        this.add(this.textComponent);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean bl) {
        this.offline = bl;
    }

    public JComponent getTextComponent() {
        return this.textComponent;
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public void setText(String string) {
        if (this.text == string) {
            return;
        }
        this.text = string;
        if (this.textComponent instanceof JLabel) {
            ((JLabel)this.textComponent).setText(string);
        } else if (this.textComponent instanceof JTextComponent) {
            ((JTextComponent)this.textComponent).setText(string);
        }
    }

    public String getText() {
        if (this.textComponent instanceof JLabel) {
            return ((JLabel)this.textComponent).getText();
        }
        if (this.textComponent instanceof JTextComponent) {
            return ((JTextComponent)this.textComponent).getText();
        }
        return null;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.textComponent != null) {
            this.textComponent.setFont(font);
        }
    }

    public void setLeaf(boolean bl) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2 = imageIcon = bl ? this.emptyLeafIcon : this.leafIcon;
        if (this.icon == imageIcon) {
            return;
        }
        this.icon = imageIcon;
        this.iconLabel.setIcon(this.icon);
    }

    public void setCollapsed(boolean bl) {
        ImageIcon imageIcon = null;
        if (this.isLazy()) {
            imageIcon = this.isFetched() ? (bl ? this.fetchedLazyCollapsedIcon : this.fetchedLazyExpandedIcon) : this.unfetchedLazyIcon;
        } else {
            ImageIcon imageIcon2 = imageIcon = bl ? this.collapsedIcon : this.expandedIcon;
        }
        if (this.icon == imageIcon) {
            return;
        }
        this.icon = imageIcon;
        this.iconLabel.setIcon(this.icon);
    }

    public boolean isLeaf() {
        return this.icon == this.leafIcon;
    }

    public boolean isCollapsed() {
        return this.icon == this.collapsedIcon || this.icon == this.unfetchedLazyIcon || this.icon == this.fetchedLazyCollapsedIcon;
    }

    public void setLevel(int n) {
        this.setLevel(n, false);
    }

    public void setLevel(int n, boolean bl) {
        if (this.level == n) {
            return;
        }
        this.level = n;
        if (n == 0) {
            return;
        }
        int n2 = this.leafIcon == null ? 0 : (n - 1) * this.leafIcon.getIconWidth();
        this.filler.changeShape(new Dimension(n2, 0), new Dimension(n2, 0), new Dimension(n2, Short.MAX_VALUE));
        if (bl) {
            this.invalidate();
        }
    }

    public static NameCellComponent getInstance() {
        NameCellComponent nameCellComponent = new NameCellComponent();
        nameCellComponent.init();
        return nameCellComponent;
    }

    public static boolean isOnIcon(Point point, Dimension dimension, int n) {
        NameCellComponent nameCellComponent = NameCellComponent.getInstance();
        nameCellComponent.setSize(dimension);
        nameCellComponent.setLevel(n);
        nameCellComponent.doLayout();
        Rectangle rectangle = nameCellComponent.getIconLabel().getBounds();
        rectangle.grow(4, 4);
        return rectangle.contains(point);
    }

    public static boolean isOnText(Point point, Dimension dimension, int n) {
        NameCellComponent nameCellComponent = NameCellComponent.getInstance();
        nameCellComponent.setSize(dimension);
        nameCellComponent.setLevel(n);
        nameCellComponent.doLayout();
        return nameCellComponent.getTextComponent().getBounds().contains(point);
    }

    protected static NameCellComponent getUninitializedComponent(boolean bl) {
        if (bl) {
            if (editorComponent == null) {
                JTextField jTextField = new JTextField();
                editorComponent = new NameCellComponent(jTextField);
                savedEditorFont = editorComponent.getFont();
                jTextField.setBorder(null);
                editorComponent.init();
            } else {
                editorComponent.setFont(savedEditorFont);
            }
            return editorComponent;
        }
        if (rendererComponent == null) {
            JLabel jLabel = new JLabel();
            rendererComponent = new NameCellComponent(jLabel);
            savedRendererFont = UIManager.getFont("Table.font");
            jLabel.setBorder(null);
            rendererComponent.init();
        } else {
            rendererComponent.setFont(savedRendererFont);
        }
        return rendererComponent;
    }

    public static NameCellComponent getComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        NameCellComponent nameCellComponent = NameCellComponent.getUninitializedComponent(bl2);
        nameCellComponent.setOffline(false);
        CellUtility.setAppearance(jTable, object, bl, bl2, n, n2, nameCellComponent);
        CommonSpreadSheetModel commonSpreadSheetModel = (CommonSpreadSheetModel)jTable.getModel();
        GraphicNode graphicNode = commonSpreadSheetModel.getNode(n);
        nameCellComponent.setText(object == null ? "" : object.toString());
        int n3 = commonSpreadSheetModel.getCache().getLevel(graphicNode);
        nameCellComponent.setLevel(graphicNode.isVoid() ? n3 + 1 : n3);
        nameCellComponent.setLazy(graphicNode.isLazyParent());
        nameCellComponent.setFetched(graphicNode.isFetched());
        if (commonSpreadSheetModel.getCellProperties(graphicNode).isCompositeIcon()) {
            nameCellComponent.setCollapsed(graphicNode.isCollapsed());
        } else {
            nameCellComponent.setLeaf(graphicNode.isVoid());
        }
        FontManager.setComponentFont(commonSpreadSheetModel.getCellProperties(graphicNode), nameCellComponent);
        nameCellComponent.doLayout();
        return nameCellComponent;
    }

    public static Component getComponent(Object object, GraphicNode graphicNode, SpreadSheetParams spreadSheetParams) {
        String string;
        NameCellComponent nameCellComponent = NameCellComponent.getUninitializedComponent(false);
        CellFormat cellFormat = spreadSheetParams.getFieldArray().getCellStyle().getCellFormat(graphicNode);
        nameCellComponent.getTextComponent().setBorder(null);
        nameCellComponent.setOffline(true);
        CellUtility.setAppearance(cellFormat, nameCellComponent);
        String string2 = string = object == null ? " " : object.toString();
        if (string.length() == 0) {
            string = " ";
        }
        nameCellComponent.setText(string);
        int n = spreadSheetParams.getCache().getLevel(graphicNode);
        nameCellComponent.setLevel(graphicNode.isVoid() ? n + 1 : n, true);
        nameCellComponent.setLazy(graphicNode.isLazyParent());
        nameCellComponent.setFetched(graphicNode.isFetched());
        if (cellFormat.isCompositeIcon()) {
            nameCellComponent.setCollapsed(graphicNode.isCollapsed());
        } else {
            nameCellComponent.setLeaf(graphicNode.isVoid());
        }
        FontManager.setComponentFont(cellFormat, nameCellComponent);
        return nameCellComponent;
    }

    public void doLayout() {
        super.doLayout();
        if (this.offline) {
            this.textComponent.setSize(this.getWidth() - this.textComponent.getX(), this.textComponent.getHeight());
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.textComponent != null) {
            this.textComponent.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.textComponent != null) {
            this.textComponent.setForeground(color);
        }
    }

    public void requestFocus() {
        if (this.textComponent instanceof ChangeAwareTextField) {
            this.textComponent.setVisible(true);
            this.textComponent.setEnabled(true);
            this.textComponent.setFocusable(true);
            this.textComponent.requestFocus();
            System.out.println("delegating focus request to text component");
        }
    }

    public final boolean isLazy() {
        return this.lazy;
    }

    public final void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public final boolean isFetched() {
        return this.fetched;
    }

    public final void setFetched(boolean bl) {
        this.fetched = bl;
    }
}

