/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFilePanel;

public class AttachFileDialog
extends JDialog {
    AttachFileDialog ths = this;
    FieldEditor editor;
    String fieldName;
    JPanel main;
    JButton browse = new JButton(Globals.lang("Browse"));
    JButton download = new JButton(Globals.lang("Download"));
    JButton auto = new JButton(Globals.lang("Auto"));
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    BibtexEntry entry;
    MetaData metaData;
    private boolean cancelled = true;

    public AttachFileDialog(Frame parent, MetaData metaData, BibtexEntry entry, String fieldName) {
        super(parent, true);
        this.metaData = metaData;
        this.entry = entry;
        this.fieldName = fieldName;
        this.editor = new FieldTextField(fieldName, entry.getField(fieldName), false);
        this.initGui();
    }

    public AttachFileDialog(Dialog parent, MetaData metaData, BibtexEntry entry, String fieldName) {
        super(parent, true);
        this.metaData = metaData;
        this.entry = entry;
        this.fieldName = fieldName;
        this.editor = new FieldTextField(fieldName, entry.getField(fieldName), false);
        this.initGui();
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public String getValue() {
        return this.editor.getText();
    }

    private void initGui() {
        final ExternalFilePanel extPan = new ExternalFilePanel(this.fieldName, this.metaData, this.entry, this.editor, Util.getFileFilterForField(this.fieldName));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                extPan.browseFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor);
            }
        });
        this.download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                extPan.downLoadFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor, AttachFileDialog.this.ths);
            }
        });
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                extPan.autoSetFile(AttachFileDialog.this.fieldName, AttachFileDialog.this.editor);
            }
        });
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AttachFileDialog.this.cancelled = false;
                AttachFileDialog.this.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        ((JTextField)this.editor.getTextComponent()).addActionListener(okListener);
        AbstractAction cancelListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AttachFileDialog.this.cancelled = true;
                AttachFileDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelListener);
        this.editor.getTextComponent().getInputMap().put(Globals.prefs.getKey("Close dialog"), "close");
        this.editor.getTextComponent().getActionMap().put("close", cancelListener);
        FormLayout layout = new FormLayout("fill:160dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.appendSeparator(Util.nCase(this.fieldName));
        builder.append(this.editor.getTextComponent());
        builder.append(this.browse);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addButton((JComponent)this.download);
        bb.addButton((JComponent)this.auto);
        builder.nextLine();
        builder.append(bb.getPanel());
        builder.nextLine();
        builder.appendSeparator();
        this.main = builder.getPanel();
        this.main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
    }
}

