/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRefPreferences;

public class IncrementalSearcher {
    JabRefPreferences prefs;
    private String hitInField;

    public IncrementalSearcher(JabRefPreferences prefs) {
        this.prefs = prefs;
    }

    public String getField() {
        return this.hitInField;
    }

    public boolean search(String pattern, BibtexEntry bibtexEntry) {
        this.hitInField = null;
        return this.searchFields(bibtexEntry.getAllFields(), bibtexEntry, pattern);
    }

    protected boolean searchFields(Set<String> fields, BibtexEntry bibtexEntry, String searchString) {
        boolean found = false;
        if (fields != null) {
            for (String field : fields) {
                try {
                    if (bibtexEntry.getField(field.toString()) == null) continue;
                    if (this.prefs.getBoolean("caseSensitiveSearch")) {
                        if (bibtexEntry.getField(field.toString()).toString().indexOf(searchString) > -1) {
                            found = true;
                        }
                    } else if (bibtexEntry.getField(field.toString()).toString().toLowerCase().indexOf(searchString.toLowerCase()) > -1) {
                        found = true;
                    }
                    if (!found) continue;
                    this.hitInField = field.toString();
                    return true;
                }
                catch (Throwable t) {
                    System.err.println("Searching error: " + t);
                }
            }
        }
        return false;
    }
}

