/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class IntOption
extends Option {
    private int value;

    public IntOption() {
        this(0);
    }

    public IntOption(IntOption op) {
        super(op);
        op.value = op.getValue();
    }

    public IntOption(int value) {
        this(value, null);
    }

    public IntOption(int value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public IntOption(int value, char shortOption) {
        this(value, null, shortOption);
    }

    public IntOption(int value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return new Integer(this.value);
    }

    @Override
    public void modify(String value) throws OptionModificationException {
        try {
            this.value = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new OptionModificationException("Error. An integer must be specified, not '" + value + "'.");
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return Integer.toString(this.value);
    }

    @Override
    public String getTypeName() {
        return "INTEGER";
    }

    public String toString() {
        return this.getStringValue();
    }
}

