/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.gradient;

import com.michaelbaranov.microba.common.AbstractBoundedTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class DefaultGradientModel
extends AbstractBoundedTableModel {
    protected static final int POSITION_COLUMN = 0;
    protected static final int COLOR_COLUMN = 1;
    protected List positionList = new ArrayList(32);
    protected List colorList = new ArrayList(32);

    public DefaultGradientModel() {
        this.positionList.add(new Integer(0));
        this.colorList.add(Color.YELLOW);
        this.positionList.add(new Integer(50));
        this.colorList.add(Color.RED);
        this.positionList.add(new Integer(100));
        this.colorList.add(Color.GREEN);
    }

    public int getLowerBound() {
        return 0;
    }

    public int getUpperBound() {
        return 100;
    }

    public int getRowCount() {
        return this.positionList.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Color.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.positionList.get(rowIndex);
            }
            case 1: {
                return this.colorList.get(rowIndex);
            }
        }
        return null;
    }

    public void add(Color color, int position) {
        this.colorList.add(color);
        this.positionList.add(new Integer(position));
        this.fireTableDataChanged();
    }

    public void remove(int index) {
        this.colorList.remove(index);
        this.positionList.remove(index);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.colorList.clear();
        this.positionList.clear();
        this.fireTableDataChanged();
    }
}

