/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.tracker;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TypeItem
extends CoreTableColumn
implements TableCellRefreshListener {
    private static final String[] js_resource_keys = new String[]{"SpeedView.stats.unknown", "MyTrackerView.tracker", "wizard.webseed.title", "tps.type.dht", "ConfigView.section.transfer.lan", "tps.type.pex", "tps.type.incoming", "tps.type.plugin"};
    private static String[] js_resources = new String[js_resource_keys.length];

    public TypeItem() {
        super("type", 1, -2, 75, "Trackers");
        this.setRefreshInterval(-3);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                for (int i = 0; i < js_resources.length; ++i) {
                    js_resources[i] = MessageText.getString(js_resource_keys[i]);
                }
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    public void refresh(TableCell cell) {
        int value;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        int n = value = ps == null ? 0 : ps.getType();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(js_resources[value]);
    }
}

