/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PeerIDItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PeerIDItem(String table_id) {
        super("peer_id", -1, 100, table_id);
        this.setRefreshInterval(-2);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"identification"});
    }

    public void refresh(TableCell cell) {
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            cell.setText("");
            return;
        }
        byte[] peer_id = peer.getId();
        if (peer_id == null) {
            cell.setText("");
            return;
        }
        try {
            String text = new String(peer_id, 0, peer_id.length, "ISO-8859-1");
            text = text.replace('\f', ' ');
            text = text.replace('\n', ' ');
            cell.setText(text);
        }
        catch (UnsupportedEncodingException uee) {
            cell.setText("");
        }
    }
}

