/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TimeSinceUploadItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "timesinceupload";

    public TimeSinceUploadItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int value = dm == null ? -2 : dm.getStats().getTimeSinceLastDataSentInSeconds();
        if (!cell.setSortValue(value == -1 ? Integer.MAX_VALUE : (long)value) && cell.isValid()) {
            return;
        }
        cell.setText(value == -2 ? "" : (value == -1 ? "\u221e" : TimeFormatter.format(value)));
    }
}

