/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class SeedsItem
extends CoreTableColumn
implements TableCellAddedListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    private static final String CFG_FC_SEEDSTART = "StartStopManager_iFakeFullCopySeedStart";
    private static final String CFG_FC_NUMPEERS = "StartStopManager_iNumPeersAsFullCopy";
    public static final String COLUMN_ID = "seeds";
    private static String textStarted;
    private static String textStartedOver;
    private static String textNotStarted;
    private static String textStartedNoScrape;
    private static String textNotStartedNoScrape;
    private int iFC_MinSeeds;
    private int iFC_NumPeers;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    public SeedsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
        COConfigurationManager.addParameterListener(CFG_FC_SEEDSTART, (ParameterListener)this);
        COConfigurationManager.addParameterListener(CFG_FC_NUMPEERS, (ParameterListener)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CFG_FC_SEEDSTART, this);
        COConfigurationManager.removeParameterListener(CFG_FC_NUMPEERS, this);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void parameterChanged(String parameterName) {
        this.iFC_MinSeeds = COConfigurationManager.getIntParameter(CFG_FC_SEEDSTART);
        this.iFC_NumPeers = COConfigurationManager.getIntParameter(CFG_FC_NUMPEERS);
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                textStarted = MessageText.getString("Column.seedspeers.started");
                textStartedOver = MessageText.getString("Column.seedspeers.started.over");
                textNotStarted = MessageText.getString("Column.seedspeers.notstarted");
                textStartedNoScrape = MessageText.getString("Column.seedspeers.started.noscrape");
                textNotStartedNoScrape = MessageText.getString("Column.seedspeers.notstarted.noscrape");
            }
        });
    }

    private class Cell
    extends AbstractTrackerCell {
        private long lTotalPeers;
        private long lTotalSeeds;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = 0L;
            this.lTotalSeeds = -1L;
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalSeeds = response.getSeeds();
                this.lTotalPeers = response.getPeers();
            }
        }

        public void refresh(TableCell cell) {
            boolean hasScrape;
            super.refresh(cell);
            long lConnectedSeeds = 0L;
            if (this.dm != null) {
                TRTrackerScraperResponse response;
                lConnectedSeeds = this.dm.getNbSeeds();
                if (this.lTotalSeeds == -1L && (response = this.dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalSeeds = response.getSeeds();
                    this.lTotalPeers = response.getPeers();
                }
            }
            long value = lConnectedSeeds << 42;
            if (this.lTotalSeeds > 0L) {
                value += this.lTotalSeeds << 21;
            }
            if (this.lTotalPeers > 0L) {
                value += this.lTotalPeers;
            }
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            boolean bCompleteTorrent = this.dm == null ? false : this.dm.getAssumedComplete();
            int state = this.dm.getState();
            boolean started = state == 60 || state == 50;
            boolean bl = hasScrape = this.lTotalSeeds >= 0L;
            String tmp = started ? (hasScrape ? (lConnectedSeeds > this.lTotalSeeds ? textStartedOver : textStarted) : textStartedNoScrape) : (hasScrape ? textNotStarted : textNotStartedNoScrape);
            tmp = tmp.replaceAll("%1", String.valueOf(lConnectedSeeds));
            String param2 = "?";
            if (this.lTotalSeeds != -1L) {
                long lSeedsToAdd;
                param2 = String.valueOf(this.lTotalSeeds);
                if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L && (lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers) > 0L) {
                    param2 = param2 + "+" + lSeedsToAdd;
                }
            }
            tmp = tmp.replaceAll("%2", param2);
            cell.setText(tmp);
        }

        public void cellHover(TableCell cell) {
            boolean bCompleteTorrent;
            super.cellHover(cell);
            long lConnectedSeeds = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                lConnectedSeeds = dm.getNbSeeds();
            }
            String sToolTip = lConnectedSeeds + " " + MessageText.getString("GeneralView.label.connected") + "\n";
            if (this.lTotalSeeds != -1L) {
                sToolTip = sToolTip + this.lTotalSeeds + " " + MessageText.getString("GeneralView.label.in_swarm");
            } else {
                TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                if (response != null) {
                    sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                }
            }
            boolean bl = bCompleteTorrent = dm == null ? false : dm.getAssumedComplete();
            if (bCompleteTorrent && SeedsItem.this.iFC_NumPeers > 0 && this.lTotalSeeds >= (long)SeedsItem.this.iFC_MinSeeds && this.lTotalPeers > 0L) {
                long lSeedsToAdd = this.lTotalPeers / (long)SeedsItem.this.iFC_NumPeers;
                sToolTip = sToolTip + "\n" + MessageText.getString("TableColumn.header.seeds.fullcopycalc", new String[]{"" + this.lTotalPeers, "" + lSeedsToAdd});
            }
            cell.setToolTip(sToolTip);
        }
    }
}

