/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellLightRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellLightRefreshListener,
ObfusticateCellText,
TableCellDisposeListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "name";
    private boolean showIcon;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    public NameItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 250, sTableID);
        this.setObfustication(true);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setMinWidth(100);
        TableContextMenuItem menuItem = this.addContextMenuItem("MyTorrentsView.menu.rename.displayed");
        menuItem.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                Object[] o;
                if (target == null) {
                    return;
                }
                for (Object object : o = (Object[])target) {
                    if (!(object instanceof DownloadManager)) continue;
                    final DownloadManager dm = (DownloadManager)object;
                    String msg_key_prefix = "MyTorrentsView.menu.rename.displayed.enter.";
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow(msg_key_prefix + "title", msg_key_prefix + "message");
                    entryWindow.setPreenteredText(dm.getDisplayName(), false);
                    entryWindow.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                            if (!entryWindow.hasSubmittedInput()) {
                                return;
                            }
                            String value = entryWindow.getSubmittedInput();
                            if (value != null && value.length() > 0) {
                                dm.getDownloadState().setDisplayName(value);
                            }
                        }
                    });
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NameItem.this.setShowIcon(COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon"));
            }
        });
    }

    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter("NameColumn.showProgramIcon");
    }

    public void refresh(TableCell cell) {
        this.refresh(cell, false);
    }

    public void refresh(TableCell cell, boolean sortOnlyRefresh) {
        String path;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && dm != null && this.isShowIcon() && !sortOnlyRefresh && cell instanceof TableCellSWT && (path = dm.getDownloadState().getPrimaryFile()) != null) {
            TOTorrent torrent = dm.getTorrent();
            Image icon = ImageRepository.getPathIcon(path, false, torrent != null && !torrent.isSimpleTorrent());
            ((TableCellSWT)cell).setIcon(icon);
        }
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void dispose(TableCell cell) {
    }

    private void disposeCellIcon(TableCell cell) {
        if (!(cell instanceof TableCellSWT)) {
            return;
        }
        Image img = ((TableCellSWT)cell).getIcon();
        if (img != null) {
            ((TableCellSWT)cell).setIcon(null);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }
}

