/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnFileCount
extends CoreTableColumn
implements TableCellMouseListener,
TableCellSWTPaintListener,
TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "filecount";

    public ColumnFileCount(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setRefreshInterval(-3);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public void cellAdded(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int sortVal = dm.getNumFileInfos();
        cell.setSortValue(sortVal);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (Utils.getUserMode() >= 2) {
            // empty if block
        }
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        int sortVal = dm.getNumFileInfos();
        Rectangle bounds = cell.getBounds();
        Rectangle printArea = new Rectangle(bounds.x, bounds.y, bounds.width - 6, bounds.height);
        GCStringPrinter.printString(gc, "" + sortVal, printArea, true, true, 131072);
    }

    private void openFilesMiniView(DownloadManager dm, TableCell cell) {
        Shell shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        shell.setLayout(new FillLayout());
        Rectangle bounds = ((TableCellSWT)cell).getBoundsOnDisplay();
        bounds.y += bounds.height;
        bounds.width = 630;
        bounds.height = 16 * dm.getNumFileInfos() + 60;
        Rectangle realBounds = shell.computeTrim(0, 0, bounds.width, bounds.height);
        realBounds.width -= realBounds.x;
        realBounds.height -= realBounds.y;
        realBounds.x = bounds.x;
        realBounds.y = bounds.y;
        if (bounds.height > 500) {
            bounds.height = 500;
        }
        shell.setBounds(realBounds);
        shell.setAlpha(230);
        Utils.verifyShellRect(shell, true);
        final FilesView view = new FilesView(false);
        view.dataSourceChanged(dm);
        view.initialize(shell);
        Composite composite = view.getComposite();
        shell.setLayout(new FillLayout());
        view.viewActivated();
        view.refresh();
        final UIUpdatable viewUpdater = new UIUpdatable(){

            public void updateUI() {
                view.refresh();
            }

            public String getUpdateUIName() {
                return view.getFullTitle();
            }
        };
        UIUpdaterSWT.getInstance().addUpdater(viewUpdater);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIUpdaterSWT.getInstance().removeUpdater(viewUpdater);
            }
        });
        shell.layout(true, true);
        shell.setText(dm.getDisplayName());
        shell.open();
    }

    static /* synthetic */ void access$000(ColumnFileCount x0, DownloadManager x1, TableCell x2) {
        x0.openFilesMiniView(x1, x2);
    }
}

