/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.util.Map;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;

public class TreeItemDelegate
implements TableItemOrTreeItem {
    TreeItem item;
    Map data = new LightHashMap(2);
    int index = -1;
    private Boolean settingExpandTo = null;

    protected TreeItemDelegate(TreeItem treeItem) {
        this.item = treeItem;
    }

    protected TreeItemDelegate(TableOrTreeSWT tree, int style) {
        this.item = new TreeItem((Tree)tree.getComposite(), style);
    }

    public void addListener(int eventType, Listener listener) {
        this.item.addListener(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.item.addDisposeListener(listener);
    }

    public void clear(int index, boolean all) {
        this.item.clear(index, all);
    }

    public void clearAll(boolean all) {
        this.item.clearAll(all);
    }

    public void dispose() {
        this.item.dispose();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableItemOrTreeItem) {
            return this.item.equals(((TableItemOrTreeItem)obj).getItem());
        }
        return this.item.equals(obj);
    }

    public Color getBackground() {
        return this.item.getBackground();
    }

    public Color getBackground(int index) {
        return this.item.getBackground(index);
    }

    public Rectangle getBounds() {
        return this.item.getBounds();
    }

    public Rectangle getBounds(int index) {
        return this.item.getBounds(index);
    }

    public Object getData() {
        return this.getData(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String key) {
        Map map = this.data;
        synchronized (map) {
            return this.data.get(key);
        }
    }

    public Display getDisplay() {
        return this.item.getDisplay();
    }

    public boolean getChecked() {
        return this.item.getChecked();
    }

    public Listener[] getListeners(int eventType) {
        return this.item.getListeners(eventType);
    }

    public boolean getExpanded() {
        return this.item.getExpanded();
    }

    public int getStyle() {
        return this.item.getStyle();
    }

    public Font getFont() {
        return this.item.getFont();
    }

    public Font getFont(int index) {
        return this.item.getFont(index);
    }

    public Color getForeground() {
        return this.item.getForeground();
    }

    public Color getForeground(int index) {
        return this.item.getForeground(index);
    }

    public boolean getGrayed() {
        return this.item.getGrayed();
    }

    public void notifyListeners(int eventType, Event event2) {
        this.item.notifyListeners(eventType, event2);
    }

    public TableItemOrTreeItem getItem(int index) {
        TreeItem treeItem = this.item.getItem(index);
        return TableOrTreeUtils.getEventItem(treeItem);
    }

    public int getItemCount() {
        return this.item.getItemCount();
    }

    public TableItemOrTreeItem[] getItems() {
        TreeItem[] items = this.item.getItems();
        TableItemOrTreeItem[] returnItems = new TableItemOrTreeItem[items.length];
        for (int i = 0; i < returnItems.length; ++i) {
            returnItems[i] = TableOrTreeUtils.getEventItem(items[i]);
        }
        return returnItems;
    }

    public Image getImage() {
        return this.item.getImage();
    }

    public Image getImage(int index) {
        return this.item.getImage(index);
    }

    public Rectangle getImageBounds(int index) {
        return this.item.getImageBounds(index);
    }

    public void removeListener(int eventType, Listener listener) {
        this.item.removeListener(eventType, listener);
    }

    public TableOrTreeSWT getParent() {
        return TableOrTreeUtils.getTableOrTreeSWT(this.item.getParent());
    }

    public TableItemOrTreeItem getParentItem() {
        TreeItem treeItem = this.item.getParentItem();
        return TableOrTreeUtils.getEventItem(treeItem);
    }

    public String getText() {
        return this.item.getText();
    }

    public String getText(int index) {
        return this.item.getText(index);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.item.removeDisposeListener(listener);
    }

    public Rectangle getTextBounds(int index) {
        return this.item.getTextBounds(index);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean isDisposed() {
        return this.item.isDisposed();
    }

    public boolean isListening(int eventType) {
        return this.item.isListening(eventType);
    }

    public int indexOf(TableItemOrTreeItem item2) {
        return this.item.indexOf((TreeItem)item2.getItem());
    }

    public void removeAll() {
        this.item.removeAll();
    }

    public void setBackground(Color color) {
        this.item.setBackground(color);
    }

    public void setBackground(int index, Color color) {
        this.item.setBackground(index, color);
    }

    public void setData(Object data) {
        this.setData(null, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String key, Object value) {
        Map map = this.data;
        synchronized (map) {
            this.data.put(key, value);
        }
    }

    public void setChecked(boolean checked) {
        this.item.setChecked(checked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpanded(boolean expanded) {
        boolean wasExpanded = this.item.getExpanded();
        this.item.setExpanded(expanded);
        if (expanded != wasExpanded && (this.settingExpandTo == null || this.settingExpandTo != expanded)) {
            try {
                this.settingExpandTo = expanded;
                Event event2 = new Event();
                event2.widget = this.item.getParent();
                event2.item = this.item;
                event2.type = expanded ? 17 : 18;
                this.item.getParent().notifyListeners(event2.type, event2);
                Object var5_4 = null;
                this.settingExpandTo = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.settingExpandTo = null;
                throw throwable;
            }
        }
    }

    public void setFont(Font font) {
        this.item.setFont(font);
    }

    public String toString() {
        return this.item.toString();
    }

    public void setFont(int index, Font font) {
        this.item.setFont(index, font);
    }

    public void setForeground(Color color) {
        this.item.setForeground(color);
    }

    public void setForeground(int index, Color color) {
        this.item.setForeground(index, color);
    }

    public void setGrayed(boolean grayed) {
        this.item.setGrayed(grayed);
    }

    public void setImage(Image[] images) {
        this.item.setImage(images);
    }

    public void setImage(int index, Image image) {
        this.item.setImage(index, image);
    }

    public void setImage(Image image) {
        this.item.setImage(image);
    }

    public void setItemCount(int count) {
        this.item.setItemCount(count);
    }

    public void setText(String[] strings) {
        this.item.setText(strings);
    }

    public void setText(int index, String string) {
        this.item.setText(index, string);
    }

    public void setText(String string) {
        this.item.setText(string);
    }

    public Item getItem() {
        return this.item;
    }

    protected int getStoredIndex() {
        return this.index;
    }

    protected void setStoredIndex(int i) {
        this.index = i;
    }
}

