/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableGroupRowVisibilityRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectedRowsListener;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.LightHashSet;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableRowRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.columnsetup.TableColumnSetupWindow;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableColumnOrTreeColumn;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewFilterCheck;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTPanelCreator;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableTooltips;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_EraseItem;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_PaintItem;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWTImpl<DATASOURCETYPE>
extends TableViewImpl<DATASOURCETYPE>
implements ParameterListener,
TableViewSWT<DATASOURCETYPE>,
TableStructureModificationListener<DATASOURCETYPE>,
ObfusticateImage,
KeyListener,
MessageText.MessageTextListener {
    protected static final boolean DRAW_VERTICAL_LINES = Constants.isWindows;
    protected static final boolean DRAW_FULL_ROW = Constants.isWindows;
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean DEBUG_SORTER = false;
    private static final ConfigurationManager configMan = ConfigurationManager.getInstance();
    private static final String CFG_SORTDIRECTION = "config.style.table.defaultSortOrder";
    private static final int ASYOUTYPE_MODE_FIND = 0;
    private static final int ASYOUTYPE_MODE_FILTER = 1;
    private static final int ASYOUTYPE_MODE = 1;
    private static final int ASYOUTYPE_UPDATEDELAY = 300;
    private static final Color COLOR_FILTER_REGEX = Colors.fadedYellow;
    protected static final boolean DEBUG_CELL_CHANGES = false;
    private static final boolean DEBUG_SELECTION = false;
    private static final boolean DEBUG_ROWCHANGE = false;
    private static final boolean OBEY_COLUMN_MINWIDTH = false;
    protected String sTableID;
    protected String sPropertiesPrefix;
    protected String sDefaultSortOn;
    protected boolean bSkipFirstColumn = true;
    private Point ptIconSize = null;
    private TableColumnCore[] basicItems;
    private TableColumnCore[] tableColumns;
    private Composite mainComposite;
    private Composite tableComposite;
    private TableOrTreeSWT table;
    private ControlEditor editor;
    protected int iTableStyle;
    private Menu menu;
    private Map<DATASOURCETYPE, TableRowCore> mapDataSourceToRow;
    private AEMonitor listUnfilteredDatasources_mon = new AEMonitor("TableView:uds");
    private Set<DATASOURCETYPE> listUnfilteredDataSources;
    private AEMonitor dataSourceToRow_mon = new AEMonitor("TableView:OTSI");
    private List<TableRowSWT> sortedRows;
    private AEMonitor sortedRows_mon = new AEMonitor("TableView:sR");
    private AEMonitor sortColumn_mon = new AEMonitor("TableView:sC");
    protected TableColumnCore sortColumn;
    private long lLastSortedOn;
    protected int loopFactor;
    protected int graphicsUpdate = configMan.getIntParameter("Graphics Update");
    protected int reOrderDelay = configMan.getIntParameter("ReOrder Delay");
    private TableColumnCore[] columnsOrdered;
    private boolean[] columnsVisible;
    private ColumnMoveListener columnMoveListener = new ColumnMoveListener();
    private LightHashSet dataSourcesToAdd = new LightHashSet(4);
    private LightHashSet dataSourcesToRemove = new LightHashSet(4);
    private boolean bReallyAddingDataSources = false;
    public boolean bEnableTabViews = false;
    private CTabFolder tabFolder;
    private ArrayList<IView> tabViews = new ArrayList(1);
    TableRowSWT[] visibleRows;
    protected IView[] coreTabViews = null;
    private long lCancelSelectionTriggeredOn = -1L;
    private long lastSelectionTriggeredOn = -1L;
    private List<TableViewSWTMenuFillListener> listenersMenuFill = new ArrayList<TableViewSWTMenuFillListener>(1);
    private ArrayList<TableRowSWTPaintListener> rowPaintListeners;
    private static AEMonitor mon_RowPaintListener = new AEMonitor("rpl");
    private ArrayList<TableRowMouseListener> rowMouseListeners;
    private static AEMonitor mon_RowMouseListener = new AEMonitor("rml");
    private TableViewSWTPanelCreator mainPanelCreator;
    private List<KeyListener> listenersKey = new ArrayList<KeyListener>(1);
    private boolean columnPaddingAdjusted = false;
    private boolean columnVisibilitiesChanged = true;
    private final Class<?> classPluginDataSourceType;
    private AEMonitor listeners_mon = new AEMonitor("tablelisteners");
    private ArrayList<TableRowRefreshListener> refreshListeners;
    protected Rectangle clientArea;
    private boolean isVisible;
    private boolean menuEnabled = true;
    private boolean headerVisible = true;
    private List<TableRowCore> selectedRows = new ArrayList<TableRowCore>(1);
    private List<Object> listSelectedCoreDataSources;
    private Utils.addDataSourceCallback processDataSourceQueueCallback = new Utils.addDataSourceCallback(){

        public void process() {
            TableViewSWTImpl.this.processDataSourceQueue();
        }

        public void debug(String str) {
            TableViewSWTImpl.this.debug(str);
        }
    };
    private int lastHorizontalPos;
    filter filter;
    private boolean useTree;
    protected int headerHeight;
    private Shell shell;
    private SourceReplaceListener cellEditNotifier;
    private Control sliderArea;
    private boolean isDragging;

    public TableViewSWTImpl(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn, int _iTableStyle) {
        boolean wantTree = (_iTableStyle & 0x40) != 0;
        _iTableStyle &= 0xFFFFFFBF;
        if (wantTree) {
            this.useTree = COConfigurationManager.getBooleanParameter("Table.useTree") && !Utils.isCarbon;
        }
        this.classPluginDataSourceType = pluginDataSourceType;
        this.sTableID = _sTableID;
        this.basicItems = _basicItems;
        this.sPropertiesPrefix = _sPropertiesPrefix;
        this.sDefaultSortOn = _sDefaultSortOn;
        this.iTableStyle = _iTableStyle | 0x200 | 0x20000000;
        this.mapDataSourceToRow = new LightHashMap<DATASOURCETYPE, TableRowCore>();
        this.sortedRows = new ArrayList<TableRowSWT>();
        this.listUnfilteredDataSources = new HashSet<DATASOURCETYPE>();
    }

    public TableViewSWTImpl(Class<?> pluginDataSourceType, String _sTableID, String _sPropertiesPrefix, TableColumnCore[] _basicItems, String _sDefaultSortOn) {
        this(pluginDataSourceType, _sTableID, _sPropertiesPrefix, _basicItems, _sDefaultSortOn, 0x10010004);
    }

    private void initializeColumnDefs() {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (this.basicItems != null) {
            if (tcManager.getTableColumnCount(this.sTableID) != this.basicItems.length) {
                tcManager.addColumns(this.basicItems);
            }
            this.basicItems = null;
        }
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.classPluginDataSourceType, this.sTableID);
        tcManager.ensureIntegrety(this.sTableID);
    }

    @Override
    public void setColumnList(TableColumnCore[] columns, String defaultSortColumnID, boolean defaultSortOrder, boolean titleIsMinWidth) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager.getTableColumnCount(this.sTableID) != columns.length) {
            tcManager.addColumns(this.basicItems);
        }
        this.tableColumns = tcManager.getAllTableColumnCoreAsArray(this.classPluginDataSourceType, this.sTableID);
        tcManager.ensureIntegrety(this.sTableID);
    }

    @Override
    public void initialize(Composite composite) {
        composite.setRedraw(false);
        this.shell = composite.getShell();
        this.mainComposite = this.createSashForm(composite);
        this.mainComposite.setData("TableView.TableID", this.sTableID);
        this.table = this.createTable(this.tableComposite);
        this.menu = this.createMenu(this.table);
        this.clientArea = this.table.getClientArea();
        this.editor = TableOrTreeUtils.createTableOrTreeEditor(this.table);
        this.editor.minimumWidth = 80;
        this.editor.grabHorizontal = true;
        this.initializeTable(this.table);
        this.triggerLifeCycleListener(0);
        configMan.addParameterListener("Graphics Update", this);
        configMan.addParameterListener("ReOrder Delay", this);
        Colors.getInstance().addColorsChangedListener(this);
        TableStructureEventDispatcher.getInstance(this.sTableID).addListener(this);
        composite.setRedraw(true);
    }

    private Composite createSashForm(Composite composite) {
        double pct;
        Composite cFixLayout;
        UISWTInstanceImpl pluginUI;
        if (!this.bEnableTabViews) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        int iNumViews = this.coreTabViews == null ? 0 : this.coreTabViews.length;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        Map<String, UISWTViewEventListenerHolder> pluginViews = null;
        if (uiFunctions != null && (pluginUI = uiFunctions.getSWTPluginInstanceImpl()) != null && (pluginViews = pluginUI.getViewListeners(this.sTableID)) != null) {
            iNumViews += pluginViews.size();
        }
        if (iNumViews == 0) {
            this.tableComposite = this.createMainPanel(composite);
            return this.tableComposite;
        }
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout(flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData(gridData);
        int TABHEIGHT = 20;
        this.tabFolder = new CTabFolder(form, 2176);
        this.tabFolder.setMinimizeVisible(true);
        this.tabFolder.setTabHeight(20);
        final int iFolderHeightAdj = this.tabFolder.computeSize((int)-1, (int)0).y;
        final Sash sash = new Sash(form, 256);
        for (cFixLayout = this.tableComposite = this.createMainPanel(form); cFixLayout != null && cFixLayout.getParent() != form; cFixLayout = cFixLayout.getParent()) {
        }
        if (cFixLayout == null) {
            cFixLayout = this.tableComposite;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cFixLayout.setLayout(layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(this.sPropertiesPrefix + ".SplitAt", 3000);
        if (iSplitAt < 100) {
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 10000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        sash.setData("PCT", new Double(pct));
        this.tabFolder.setLayoutData(formData);
        final FormData tabFolderData = formData;
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(this.tabFolder);
        formData.height = 5;
        sash.setLayoutData(formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(sash);
        cFixLayout.setLayoutData(formData);
        sash.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    TableViewSWTImpl.this.tabFolder.setMinimized(false);
                    TableViewSWTImpl.this.refreshSelectedSubView();
                    configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", false);
                }
                Rectangle area = form.getClientArea();
                tabFolderData.height = area.height - e.y - e.height - iFolderHeightAdj;
                form.layout();
                Double l = new Double((double)((TableViewSWTImpl)TableViewSWTImpl.this).tabFolder.getBounds().height / (double)form.getBounds().height);
                sash.setData("PCT", l);
                if (e.detail != 1) {
                    configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".SplitAt", (int)(l * 10000.0));
                }
            }
        });
        final CTabFolder2Adapter folderListener = new CTabFolder2Adapter(){

            public void minimize(CTabFolderEvent event2) {
                TableViewSWTImpl.this.tabFolder.setMinimized(true);
                tabFolderData.height = iFolderHeightAdj;
                CTabItem[] items = TableViewSWTImpl.this.tabFolder.getItems();
                for (int i = 0; i < items.length; ++i) {
                    CTabItem tabItem = items[i];
                    tabItem.getControl().setVisible(false);
                }
                form.layout();
                IView view = TableViewSWTImpl.this.getActiveSubView();
                if (view instanceof IViewExtension) {
                    ((IViewExtension)((Object)view)).viewDeactivated();
                }
                configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", true);
            }

            public void restore(CTabFolderEvent event2) {
                TableViewSWTImpl.this.tabFolder.setMinimized(false);
                CTabItem selection = TableViewSWTImpl.this.tabFolder.getSelection();
                if (selection != null) {
                    selection.getControl().setVisible(true);
                }
                form.notifyListeners(11, null);
                IView view = TableViewSWTImpl.this.getActiveSubView();
                if (view instanceof IViewExtension) {
                    ((IViewExtension)((Object)view)).viewActivated();
                }
                TableViewSWTImpl.this.refreshSelectedSubView();
                configMan.setParameter(TableViewSWTImpl.this.sPropertiesPrefix + ".subViews.minimized", false);
            }
        };
        this.tabFolder.addCTabFolder2Listener(folderListener);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ((CTabItem)e.item).getControl().setVisible(true);
                    ((CTabItem)e.item).getControl().moveAbove(null);
                    IView view = TableViewSWTImpl.this.getActiveSubView();
                    if (view instanceof IViewExtension) {
                        ((IViewExtension)((Object)view)).viewActivated();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolder.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    folderListener.restore(null);
                    e.button = 0;
                    TableViewSWTImpl.this.tabFolder.notifyListeners(7, null);
                }
            }
        });
        form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    return;
                }
                Double l = (Double)sash.getData("PCT");
                if (l != null) {
                    tabFolderData.height = (int)((double)form.getBounds().height * l) - iFolderHeightAdj;
                    form.layout();
                }
            }
        });
        if (this.coreTabViews != null) {
            for (int i = 0; i < this.coreTabViews.length; ++i) {
                this.addTabView(this.coreTabViews[i]);
            }
        }
        if (pluginViews != null) {
            String[] sNames = pluginViews.keySet().toArray(new String[0]);
            for (int i = 0; i < sNames.length; ++i) {
                UISWTViewEventListener l = pluginViews.get(sNames[i]);
                if (l == null) continue;
                try {
                    UISWTViewImpl view = new UISWTViewImpl(this.sTableID, sNames[i], l);
                    this.addTabView(view);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (configMan.getBooleanParameter(this.sPropertiesPrefix + ".subViews.minimized", false)) {
            this.tabFolder.setMinimized(true);
            tabFolderData.height = iFolderHeightAdj;
        } else {
            this.tabFolder.setMinimized(false);
        }
        this.tabFolder.setSelection(0);
        return form;
    }

    public Composite createMainPanel(Composite composite) {
        TableViewSWTPanelCreator mainPanelCreator = this.getMainPanelCreator();
        if (mainPanelCreator != null) {
            return mainPanelCreator.createTableViewPanel(composite);
        }
        Composite panel = new Composite(composite, 524288);
        composite.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout(layout);
        Layout parentLayout = composite.getLayout();
        if (parentLayout == null || parentLayout instanceof GridLayout) {
            panel.setLayoutData(new GridData(1808));
        }
        return panel;
    }

    public TableOrTreeSWT createTable(Composite panel) {
        this.table = TableOrTreeUtils.createGrid(panel, this.iTableStyle, this.useTree);
        this.table.setLayoutData(new GridData(1808));
        return this.table;
    }

    public void initializeTable(final TableOrTreeSWT table) {
        ScrollBar horizontalBar;
        this.initializeColumnDefs();
        this.iTableStyle = table.getStyle();
        if ((this.iTableStyle & 0x10000000) == 0) {
            throw new Error("Virtual Table Required");
        }
        table.setLinesVisible(Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR);
        table.setMenu(this.menu);
        table.setData("Name", this.sTableID);
        table.setData("TableView", this);
        table.setFont(table.getFont());
        table.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event2) {
                TableViewSWTImpl.this.changeColumnIndicator();
                table.setRedraw(false);
                table.setRedraw(true);
                table.removePaintListener(this);
            }
        });
        table.addListener(42, new TableViewSWT_PaintItem(this, table));
        if (Constants.isWindows) {
            TableViewSWT_EraseItem eraseItemListener = new TableViewSWT_EraseItem(this, table);
            table.addListener(40, eraseItemListener);
            table.addListener(9, eraseItemListener);
        }
        if ((horizontalBar = table.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                        }
                    });
                }

                public void widgetSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                        }
                    });
                }
            });
        }
        table.addListener(41, new Listener(){

            public void handleEvent(Event event2) {
                int defaultHeight;
                int iColumnNo = event2.index;
                if (TableViewSWTImpl.this.bSkipFirstColumn) {
                    --iColumnNo;
                }
                if (iColumnNo >= 0 && iColumnNo < TableViewSWTImpl.this.columnsOrdered.length) {
                    int preferredWidth;
                    TableColumnCore tc = TableViewSWTImpl.this.columnsOrdered[iColumnNo];
                    event2.width = preferredWidth = tc.getPreferredWidth();
                }
                if (event2.height < (defaultHeight = TableViewSWTImpl.this.getRowDefaultHeight())) {
                    event2.height = defaultHeight;
                }
            }
        });
        table.addMouseListener(new MouseAdapter(){
            long lastMouseDblClkEventTime = 0L;
            long lastMouseUpEventTime = 0L;
            Point lastMouseUpPos = new Point(0, 0);
            boolean mouseDown = false;
            TableRowCore lastClickRow;

            public void mouseDoubleClick(MouseEvent e) {
                TableCellMouseEvent event2;
                long time = (long)e.time & 0xFFFFFFFFL;
                long diff = time - this.lastMouseDblClkEventTime;
                if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L) {
                    return;
                }
                this.lastMouseDblClkEventTime = time;
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 2, false)) != null) {
                    tc.invokeCellMouseListeners(event2);
                    cell.invokeMouseListeners(event2);
                    if (event2.skipCoreFunctionality) {
                        TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                TableCellMouseEvent event2;
                if (!this.mouseDown) {
                    return;
                }
                this.mouseDown = false;
                if (e.button == 1) {
                    long time = (long)e.time & 0xFFFFFFFFL;
                    long diff = time - this.lastMouseUpEventTime;
                    if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L && this.lastMouseUpPos.x == e.x && this.lastMouseUpPos.y == e.y) {
                        TableViewSWTImpl.this.runDefaultAction(e.stateMask);
                        return;
                    }
                    this.lastMouseUpEventTime = time;
                    this.lastMouseUpPos = new Point(e.x, e.y);
                }
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                if (cell != null && tc != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 1, false)) != null) {
                    tc.invokeCellMouseListeners(event2);
                    cell.invokeMouseListeners(event2);
                    if (event2.skipCoreFunctionality) {
                        TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                TableRowMouseEvent event2;
                this.mouseDown = true;
                TableRowSWT row = TableViewSWTImpl.this.getTableRow(e.x, e.y, false);
                if (row == null) {
                    TableViewSWTImpl.this.setSelectedRows(new TableRowCore[0]);
                } else if (!row.isRowDisposed()) {
                    TableViewSWTImpl.this.selectRow(row, true);
                }
                TableColumnCore tc = TableViewSWTImpl.this.getTableColumnByOffset(e.x);
                TableCellCore cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                TableViewSWTImpl.this.editCell(-1, -1);
                if (cell != null && tc != null) {
                    TableCellMouseEvent event3;
                    if (e.button == 2 && e.stateMask == 262144) {
                        ((TableCellImpl)cell).bDebug = !((TableCellImpl)cell).bDebug;
                        System.out.println("Set debug for " + cell + " to " + ((TableCellImpl)cell).bDebug);
                    }
                    if ((event3 = TableViewSWTImpl.this.createMouseEvent(cell, e, 0, false)) != null) {
                        tc.invokeCellMouseListeners(event3);
                        cell.invokeMouseListeners(event3);
                        TableViewSWTImpl.this.invokeRowMouseListener(event3);
                        if (event3.skipCoreFunctionality) {
                            TableViewSWTImpl.this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                        }
                    }
                    if (tc.isInplaceEdit() && e.button == 1 && this.lastClickRow == cell.getTableRowCore()) {
                        TableViewSWTImpl.this.editCell(TableViewSWTImpl.this.getColumnNo(e.x), cell.getTableRowCore().getIndex());
                    }
                    if (e.button == 1) {
                        this.lastClickRow = cell.getTableRowCore();
                    }
                } else if (row != null && (event2 = TableViewSWTImpl.this.createMouseEvent(row, e, 0, false)) != null) {
                    TableViewSWTImpl.this.invokeRowMouseListener(event2);
                }
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){
            TableCellCore lastCell = null;
            int lastCursorID = 0;

            public void mouseMove(MouseEvent e) {
                TableViewSWTImpl.this.lCancelSelectionTriggeredOn = -1L;
                if (TableViewSWTImpl.this.isDragging) {
                    return;
                }
                try {
                    TableCellMouseEvent event2;
                    TableCellMouseEvent event3;
                    TableCellCore cell = TableViewSWTImpl.this.getTableCell(e.x, e.y);
                    if (this.lastCell != null && cell != this.lastCell && !this.lastCell.isDisposed() && (event3 = TableViewSWTImpl.this.createMouseEvent(this.lastCell, e, 5, true)) != null) {
                        TableColumnCore tc = (TableColumnCore)this.lastCell.getTableColumn();
                        if (tc != null) {
                            tc.invokeCellMouseListeners(event3);
                        }
                        this.lastCell.invokeMouseListeners(event3);
                    }
                    int iCursorID = 0;
                    if (cell == null) {
                        this.lastCell = null;
                    } else if (cell == this.lastCell) {
                        iCursorID = this.lastCursorID;
                    } else {
                        iCursorID = cell.getCursorID();
                        this.lastCell = cell;
                    }
                    if (iCursorID < 0) {
                        iCursorID = 0;
                    }
                    if (iCursorID != this.lastCursorID) {
                        this.lastCursorID = iCursorID;
                        if (iCursorID >= 0) {
                            table.setCursor(table.getDisplay().getSystemCursor(iCursorID));
                        } else {
                            table.setCursor(null);
                        }
                    }
                    if (cell != null && (event2 = TableViewSWTImpl.this.createMouseEvent(cell, e, 3, false)) != null) {
                        TableColumnCore tc = (TableColumnCore)cell.getTableColumn();
                        if (tc.hasCellMouseMoveListener()) {
                            ((TableColumnCore)cell.getTableColumn()).invokeCellMouseListeners(event2);
                        }
                        cell.invokeMouseListeners(event2);
                        int cellCursorID = cell.getCursorID();
                        if (cellCursorID != -1) {
                            this.lastCursorID = cellCursorID;
                        }
                    }
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event2) {
                TableViewSWTImpl.this.updateSelectedRows(table.getSelection(), true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TableViewSWTImpl.this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - TableViewSWTImpl.this.lCancelSelectionTriggeredOn < 200L) {
                    e.doit = false;
                } else {
                    TableViewSWTImpl.this.runDefaultAction(e.stateMask);
                }
            }
        });
        table.addListener(39, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWTImpl.this.tableInvalidate();
            }
        });
        if (this.useTree) {
            Listener listenerExpandCollapse = new Listener(){

                public void handleEvent(Event event2) {
                    TableItemOrTreeItem item = TableOrTreeUtils.getEventItem(event2.item);
                    if (item == null) {
                        return;
                    }
                    TableRowCore row = TableViewSWTImpl.this.getRow(item);
                    if (row == null || row.isRowDisposed()) {
                        return;
                    }
                    row.setExpanded(event2.type == 17);
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.visibleRowsChanged();
                        }
                    });
                }
            };
            table.addListener(17, listenerExpandCollapse);
            table.addListener(18, listenerExpandCollapse);
        }
        new TableTooltips(this, table.getComposite());
        table.addKeyListener(this);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TableViewSWTImpl.this.filter != null && TableViewSWTImpl.this.filter.widget != null && !TableViewSWTImpl.this.filter.widget.isDisposed()) {
                    TableViewSWTImpl.this.filter.widget.removeKeyListener(TableViewSWTImpl.this);
                    TableViewSWTImpl.this.filter.widget.removeModifyListener(TableViewSWTImpl.this.filter.widgetModifyListener);
                }
                Utils.disposeSWTObjects(new Object[]{TableViewSWTImpl.this.sliderArea});
            }
        });
        ScrollBar bar = table.getVerticalBar();
        if (bar != null) {
            bar.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            TableViewSWTImpl.this.swt_calculateClientArea();
                            TableViewSWTImpl.this.visibleRowsChanged();
                        }
                    });
                    if (!table.isFocusControl()) {
                        table.setFocus();
                    }
                }
            });
        }
        table.setHeaderVisible(this.getHeaderVisible());
        this.headerHeight = table.getHeaderHeight();
        this.clientArea = table.getClientArea();
        table.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                TableViewSWTImpl.this.swt_calculateClientArea();
            }
        });
        this.initializeTableColumns(table);
        MessageText.addListener(this);
    }

    @Override
    public void localeChanged(Locale old_locale, Locale new_locale) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.tabViews != null && TableViewSWTImpl.this.tabViews.size() > 0) {
                    for (int i = 0; i < TableViewSWTImpl.this.tabViews.size(); ++i) {
                        IView view = (IView)TableViewSWTImpl.this.tabViews.get(i);
                        if (view == null) continue;
                        view.updateLanguage();
                    }
                }
                TableViewSWTImpl.this.tableInvalidate();
                TableViewSWTImpl.this.refreshTable(true);
                TableColumnOrTreeColumn[] tableColumnsSWT = TableViewSWTImpl.this.table.getColumns();
                for (int i = 0; i < tableColumnsSWT.length; ++i) {
                    TableColumnCore column = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                    if (column == null) continue;
                    Messages.setLanguageText(tableColumnsSWT[i].getColumn(), column.getTitleLanguageKey());
                }
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent event2) {
        Object[] listeners = this.listenersKey.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener l = (KeyListener)listeners[i];
            l.keyPressed(event2);
            if (event2.doit) continue;
            this.lCancelSelectionTriggeredOn = SystemTime.getCurrentTime();
            return;
        }
        if (event2.keyCode == 0x100000E) {
            if ((event2.stateMask & 0x20000) > 0) {
                this.runForSelectedRows(new TableGroupRowRunner(){

                    public void run(TableRowCore row) {
                        row.invalidate();
                        row.refresh(true);
                    }
                });
            } else if ((event2.stateMask & 0x40000) > 0) {
                this.runForAllRows(new TableGroupRowRunner(){

                    public void run(TableRowCore row) {
                        row.invalidate();
                        row.refresh(true);
                    }
                });
            } else {
                this.sortColumn(true);
            }
            event2.doit = false;
            return;
        }
        int key = event2.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (event2.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (this.filter == null || event2.widget != this.filter.widget) {
                        if ((this.table.getStyle() & 2) <= 0) break;
                        this.selectAll();
                        event2.doit = false;
                        break;
                    }
                    this.filter.widget.selectAll();
                    event2.doit = false;
                    break;
                }
                case 43: {
                    if (!Constants.isUnix) break;
                    TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
                    for (int i = 0; i < tableColumnsSWT.length; ++i) {
                        TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                        if (tc == null) continue;
                        int w = tc.getPreferredWidth();
                        if (w <= 0 && (w = tc.getMinWidth()) <= 0) {
                            w = 100;
                        }
                        tc.setWidth(w);
                    }
                    event2.doit = false;
                    break;
                }
                case 102: {
                    this.openFilterDialog();
                    event2.doit = false;
                    break;
                }
                case 120: {
                    if (this.filter == null || event2.widget != this.filter.widget) break;
                    this.filter.regex = !this.filter.regex;
                    this.filter.widget.setBackground(this.filter.regex ? COLOR_FILTER_REGEX : null);
                    this.refilter();
                    return;
                }
            }
        }
        if (event2.stateMask == 0 && this.filter != null && this.filter.widget == event2.widget) {
            if (event2.keyCode == 0x1000002) {
                this.setFocus();
                event2.doit = false;
            } else if (event2.character == '\r') {
                this.refilter();
            }
        }
        if (!event2.doit) {
            return;
        }
        this.handleSearchKeyPress(event2);
    }

    @Override
    public void keyReleased(KeyEvent event2) {
        this.swt_calculateClientArea();
        this.visibleRowsChanged();
        Object[] listeners = this.listenersKey.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            KeyListener l = (KeyListener)listeners[i];
            l.keyReleased(event2);
            if (event2.doit) continue;
            return;
        }
    }

    public boolean getHeaderVisible() {
        return this.headerVisible;
    }

    public void setHeaderVisible(boolean visible) {
        this.headerVisible = visible;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.setHeaderVisible(TableViewSWTImpl.this.headerVisible);
                    TableViewSWTImpl.this.headerHeight = TableViewSWTImpl.this.table.getHeaderHeight();
                }
            }
        });
    }

    protected void swt_calculateClientArea() {
        int pos;
        Rectangle oldClientArea = this.clientArea;
        this.clientArea = this.table.getClientArea();
        ScrollBar horizontalBar = this.table.getHorizontalBar();
        boolean clientAreaCausedVisibilityChanged = false;
        if (horizontalBar != null && (pos = horizontalBar.getSelection()) != this.lastHorizontalPos) {
            this.lastHorizontalPos = pos;
            clientAreaCausedVisibilityChanged = true;
        }
        if (oldClientArea != null && (oldClientArea.x != this.clientArea.x || oldClientArea.width != this.clientArea.width)) {
            clientAreaCausedVisibilityChanged = true;
        }
        if (oldClientArea != null && (oldClientArea.y != this.clientArea.y || oldClientArea.height != this.clientArea.height)) {
            this.visibleRowsChanged();
        }
        if (oldClientArea != null && oldClientArea.height < this.table.getHeaderHeight()) {
            clientAreaCausedVisibilityChanged = true;
        }
        if (clientAreaCausedVisibilityChanged) {
            this.columnVisibilitiesChanged = true;
            Utils.execSWTThreadLater(50, new AERunnable(){

                public void runSupport() {
                    if (TableViewSWTImpl.this.columnVisibilitiesChanged) {
                        TableViewSWTImpl.this.refreshTable(false);
                    }
                }
            });
        }
    }

    protected void triggerTabViewsDataSourceChanged() {
        if (this.tabViews == null || this.tabViews.size() == 0) {
            return;
        }
        Object[] dataSourcesCore = this.getSelectedDataSources(true);
        Object[] dataSourcesPlugin = null;
        for (int i = 0; i < this.tabViews.size(); ++i) {
            IView view = this.tabViews.get(i);
            if (view == null) continue;
            if (view instanceof UISWTViewImpl) {
                if (dataSourcesPlugin == null) {
                    dataSourcesPlugin = this.getSelectedDataSources(false);
                }
                ((UISWTViewImpl)view).dataSourceChanged(dataSourcesPlugin.length == 0 ? null : dataSourcesPlugin);
                continue;
            }
            view.dataSourceChanged(dataSourcesCore.length == 0 ? null : dataSourcesCore);
        }
    }

    private void editCell(final int column, final int row) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_editCell(column, row);
            }
        });
    }

    private void swt_editCell(final int column, final int row) {
        Text oldInput = (Text)this.editor.getEditor();
        if (column >= this.table.getColumnCount() || row < 0 || row >= this.table.getItemCount()) {
            this.cellEditNotifier = null;
            if (oldInput != null && !oldInput.isDisposed()) {
                this.editor.getEditor().dispose();
            }
            return;
        }
        TableColumnOrTreeColumn tcColumn = this.table.getColumn(column);
        final TableItemOrTreeItem item = this.table.getItem(row);
        String cellName = (String)tcColumn.getData("Name");
        final TableRowSWT rowSWT = (TableRowSWT)this.getRow(row);
        final TableCellSWT cell = rowSWT.getTableCellSWT(cellName);
        final Text newInput = oldInput == null || oldInput.isDisposed() ? new Text(this.table.getComposite(), Constants.isOSX ? 0 : 2048) : oldInput;
        final Object datasource = cell.getDataSource();
        if (this.cellEditNotifier != null) {
            this.cellEditNotifier.cleanup(newInput);
        }
        this.table.showItem(item);
        this.table.showColumn(tcColumn);
        newInput.setText(cell.getText());
        newInput.setSelection(0);
        newInput.selectAll();
        newInput.setFocus();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class QuickEditListener
        implements ModifyListener,
        SelectionListener,
        KeyListener,
        TraverseListener,
        SourceReplaceListener,
        ControlListener {
            boolean resizing = true;

            public QuickEditListener(Text toAttach) {
                toAttach.addModifyListener(this);
                toAttach.addSelectionListener(this);
                toAttach.addKeyListener(this);
                toAttach.addTraverseListener(this);
                toAttach.addControlListener(this);
                TableViewSWTImpl.this.cellEditNotifier = this;
            }

            @Override
            public void modifyText(ModifyEvent e) {
                if (item.isDisposed()) {
                    this.sourcesChanged();
                    return;
                }
                if (((TableColumnCore)cell.getTableColumn()).inplaceValueSet(cell, newInput.getText(), false)) {
                    newInput.setBackground(null);
                } else {
                    newInput.setBackground(Colors.colorErrorBG);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                if (item.isDisposed()) {
                    this.sourcesChanged();
                    newInput.traverse(4);
                    return;
                }
                ((TableColumnCore)cell.getTableColumn()).inplaceValueSet(cell, newInput.getText(), true);
                rowSWT.invalidate();
                TableViewSWTImpl.this.editCell(column, row + 1);
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(column, row + (e.keyCode == 0x1000002 ? 1 : -1));
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    TableViewSWTImpl.this.editCell(column, -1);
                }
            }

            @Override
            public void sourcesChanged() {
                if (TableViewSWTImpl.this.getRow(datasource) == rowSWT || TableViewSWTImpl.this.getRow(datasource) == null || newInput.isDisposed()) {
                    return;
                }
                String newVal = newInput.getText();
                Point sel = newInput.getSelection();
                TableViewSWTImpl.this.editCell(column, TableViewSWTImpl.this.getRow(datasource).getIndex());
                if (newInput.isDisposed()) {
                    return;
                }
                newInput.setText(newVal);
                newInput.setSelection(sel);
            }

            @Override
            public void cleanup(Text oldText) {
                if (!oldText.isDisposed()) {
                    oldText.removeModifyListener(this);
                    oldText.removeSelectionListener(this);
                    oldText.removeKeyListener(this);
                    oldText.removeTraverseListener(this);
                    oldText.removeControlListener(this);
                }
            }

            @Override
            public void controlMoved(ControlEvent e) {
                TableViewSWTImpl.this.table.showItem(item);
                if (this.resizing) {
                    return;
                }
                this.resizing = true;
                Point sel = newInput.getSelection();
                TableOrTreeUtils.setEditorItem(TableViewSWTImpl.this.editor, newInput, column, item);
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = newInput.computeSize((int)-1, (int)-1).x;
                Rectangle leftAlignedBounds = item.getBounds(column);
                leftAlignedBounds.width = ((TableViewSWTImpl)TableViewSWTImpl.this).editor.minimumWidth = newInput.computeSize((int)-1, (int)-1).x;
                ((TableViewSWTImpl)TableViewSWTImpl.this).editor.horizontalAlignment = leftAlignedBounds.intersection(TableViewSWTImpl.this.clientArea).equals(leftAlignedBounds) ? 16384 : 131072;
                TableViewSWTImpl.this.editor.layout();
                newInput.setSelection(0);
                newInput.setSelection(sel);
                this.resizing = false;
            }

            @Override
            public void controlResized(ControlEvent e) {
            }
        }
        QuickEditListener l = new QuickEditListener(newInput);
        l.modifyText(null);
        TableOrTreeUtils.setEditorItem(this.editor, newInput, column, item);
        this.table.deselectAll();
        this.table.select(this.table.getItem(row));
        this.updateSelectedRows(new TableRowCore[]{this.sortedRows.get(row)}, true);
        l.resizing = false;
        l.controlMoved(null);
    }

    private TableCellMouseEvent createMouseEvent(TableCellCore cell, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.cell = cell;
        if (cell != null) {
            event2.row = cell.getTableRow();
        }
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (cell instanceof TableCellSWT) {
            Rectangle r = ((TableCellSWT)cell).getBounds();
            if (r == null) {
                return event2;
            }
            event2.x = e.x - r.x;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    private TableRowMouseEvent createMouseEvent(TableRowSWT row, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.row = row;
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (row != null) {
            Rectangle r = row.getBounds();
            event2.x = e.x - r.x;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    public void runDefaultAction(int stateMask) {
        if (this.lastSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lastSelectionTriggeredOn < 200L) {
            return;
        }
        if (System.currentTimeMillis() - this.lCancelSelectionTriggeredOn > 200L) {
            this.lastSelectionTriggeredOn = System.currentTimeMillis();
            TableRowCore[] selectedRows = this.getSelectedRows();
            this.triggerDefaultSelectedListeners(selectedRows, stateMask);
        }
    }

    private void swt_updateColumnVisibilities(boolean doInvalidate) {
        TableColumnOrTreeColumn[] columns = this.table.getColumns();
        if (this.table.getItemCount() < 1 || columns.length == 0 || !this.table.isVisible()) {
            return;
        }
        this.columnVisibilitiesChanged = false;
        TableItemOrTreeItem topRow = this.table.getTopItem();
        if (topRow == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            boolean nowVisible;
            int position;
            final TableColumnCore tc = (TableColumnCore)columns[i].getData("TableColumnCore");
            if (tc == null || (position = tc.getPosition()) < 0 || position >= this.columnsVisible.length) continue;
            Rectangle size = topRow.getBounds(i);
            size.intersect(this.clientArea);
            boolean bl = nowVisible = !size.isEmpty();
            if (this.columnsVisible[position] == nowVisible) continue;
            this.columnsVisible[position] = nowVisible;
            if (!nowVisible || !doInvalidate) continue;
            this.swt_runForVisibleRows(new TableGroupRowRunner(){

                public void run(TableRowCore row) {
                    TableCellCore cell = row.getTableCellCore(tc.getName());
                    if (cell != null) {
                        cell.invalidate();
                        cell.redraw();
                    }
                }
            });
        }
    }

    @Override
    public boolean isColumnVisible(TableColumn column) {
        int position = column.getPosition();
        if (position < 0 || position >= this.columnsVisible.length) {
            return false;
        }
        return this.columnsVisible[position];
    }

    @Override
    public boolean isUnfilteredDataSourceAdded(Object ds) {
        return this.listUnfilteredDataSources.contains(ds);
    }

    protected void initializeTableColumns(final TableOrTreeSWT table) {
        TableColumnCore tc;
        int i;
        TableColumnOrTreeColumn[] oldColumns = table.getColumns();
        for (i = 0; i < oldColumns.length; ++i) {
            oldColumns[i].removeListener(10, this.columnMoveListener);
        }
        for (i = oldColumns.length - 1; i >= 0; --i) {
            oldColumns[i].dispose();
        }
        this.columnPaddingAdjusted = false;
        ControlAdapter resizeListener = new ControlAdapter(){
            private boolean bInFunction = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void controlResized(ControlEvent e) {
                TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(e.widget);
                if (column == null || column.isDisposed() || this.bInFunction) {
                    return;
                }
                try {
                    this.bInFunction = true;
                    TableColumnCore tc = (TableColumnCore)column.getData("TableColumnCore");
                    if (tc != null) {
                        Long lPadding = (Long)column.getData("widthOffset");
                        int padding = lPadding == null ? 0 : lPadding.intValue();
                        int newWidth = column.getWidth();
                        tc.setWidth(newWidth - padding);
                    }
                    int columnNumber = table.indexOf(column);
                    TableViewSWTImpl.this.locationChanged(columnNumber);
                    Object var8_8 = null;
                    this.bInFunction = false;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.bInFunction = false;
                    throw throwable;
                }
            }
        };
        if (this.bSkipFirstColumn) {
            TableColumnOrTreeColumn tc2 = table.createNewColumn(0);
            tc2.setWidth(0);
            tc2.setResizable(false);
            tc2.setMoveable(false);
        }
        TableColumnCore[] tmpColumnsOrdered = new TableColumnCore[this.tableColumns.length];
        int columnOrderPos = 0;
        Arrays.sort(this.tableColumns, TableColumnManager.getTableColumnOrderComparator());
        for (int i2 = 0; i2 < this.tableColumns.length; ++i2) {
            int position = this.tableColumns[i2].getPosition();
            if (position == -1 || !this.tableColumns[i2].isVisible()) continue;
            table.createNewColumn(0);
            tmpColumnsOrdered[columnOrderPos++] = this.tableColumns[i2];
        }
        int numSWTColumns = table.getColumnCount();
        int iNewLength = numSWTColumns - (this.bSkipFirstColumn ? 1 : 0);
        this.columnsOrdered = new TableColumnCore[iNewLength];
        System.arraycopy(tmpColumnsOrdered, 0, this.columnsOrdered, 0, iNewLength);
        this.columnsVisible = new boolean[this.tableColumns.length];
        ColumnSelectionListener columnSelectionListener = new ColumnSelectionListener();
        int swtColumnPos = this.bSkipFirstColumn ? 1 : 0;
        for (int i3 = 0; i3 < this.tableColumns.length; ++i3) {
            TableColumnCore columnCore = this.tableColumns[i3];
            int position = columnCore.getPosition();
            if (position == -1 || !columnCore.isVisible()) continue;
            this.columnsVisible[i3] = false;
            String sName = columnCore.getName();
            if (swtColumnPos >= numSWTColumns) {
                Debug.out("Incorrect table column setup, skipping column '" + sName + "', position=" + swtColumnPos + ";numCols=" + numSWTColumns);
                continue;
            }
            TableColumnOrTreeColumn column = table.getColumn(swtColumnPos);
            try {
                column.setMoveable(true);
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
            column.setAlignment(TableColumnSWTUtils.convertColumnAlignmentToSWT(columnCore.getAlignment()));
            String iconReference = columnCore.getIconReference();
            if (iconReference != null) {
                Image image = ImageLoader.getInstance().getImage(iconReference);
                column.setImage(image);
            } else {
                Messages.setLanguageText(column.getColumn(), columnCore.getTitleLanguageKey());
            }
            if (!Constants.isUnix && !Utils.isCarbon) {
                column.setWidth(columnCore.getWidth());
            } else {
                column.setData("widthOffset", new Long(1L));
                column.setWidth(columnCore.getWidth() + 1);
            }
            if (columnCore.getMinWidth() == columnCore.getMaxWidth() && columnCore.getMinWidth() > 0) {
                column.setResizable(false);
            }
            column.setData("TableColumnCore", columnCore);
            column.setData("configName", "Table." + this.sTableID + "." + sName);
            column.setData("Name", sName);
            column.addControlListener(resizeListener);
            column.addListener(13, columnSelectionListener);
            ++swtColumnPos;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String sSortColumn = tcManager.getDefaultSortColumnName(this.sTableID);
        if (sSortColumn == null || sSortColumn.length() == 0) {
            sSortColumn = this.sDefaultSortOn;
        }
        if ((tc = tcManager.getTableColumnCore(this.sTableID, sSortColumn)) == null && this.tableColumns.length > 0) {
            tc = this.tableColumns[0];
        }
        this.sortColumn = tc;
        this.fixAlignment(tc, true);
        this.changeColumnIndicator();
        TableColumnOrTreeColumn[] columns = table.getColumns();
        for (int i4 = 0; i4 < columns.length; ++i4) {
            TableColumnOrTreeColumn column = columns[i4];
            column.addListener(10, this.columnMoveListener);
        }
        this.columnVisibilitiesChanged = true;
    }

    public void fixAlignment(TableColumnCore tc, boolean sorted) {
        if (Constants.isOSX) {
            if (this.table.isDisposed() || tc == null) {
                return;
            }
            int[] columnOrder = this.table.getColumnOrder();
            int i = tc.getPosition() - (this.bSkipFirstColumn ? 1 : 0);
            if (i < 0 || i >= columnOrder.length) {
                return;
            }
            TableColumnOrTreeColumn swtColumn = this.table.getColumn(columnOrder[i]);
            if (swtColumn != null) {
                if (swtColumn.getAlignment() == 131072 && sorted) {
                    swtColumn.setText("   " + swtColumn.getText() + "   ");
                } else {
                    swtColumn.setText(swtColumn.getText().trim());
                }
            }
        }
    }

    private Menu createMenu(final TableOrTreeSWT table) {
        if (!this.isMenuEnabled()) {
            return null;
        }
        final Menu menu = new Menu(this.shell, 8);
        table.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                boolean inHeader;
                Point pt = event2.display.map(null, (Control)table.getComposite(), new Point(event2.x, event2.y));
                boolean noRow = table.getItem(pt) == null;
                Rectangle clientArea = table.getClientArea();
                boolean bl = inHeader = clientArea.y <= pt.y && pt.y < clientArea.y + TableViewSWTImpl.this.headerHeight;
                if (!noRow) {
                    noRow = inHeader;
                }
                menu.setData("inBlankArea", !inHeader && noRow);
                menu.setData("isHeader", new Boolean(noRow));
                int columnNo = TableViewSWTImpl.this.getColumnNo(pt.x);
                menu.setData("column", columnNo < 0 || columnNo >= table.getColumnCount() ? null : table.getColumn(columnNo));
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                Object oIsHeader = menu.getData("isHeader");
                boolean isHeader = oIsHeader instanceof Boolean ? (Boolean)oIsHeader : false;
                Object oInBlankArea = menu.getData("inBlankArea");
                boolean inBlankArea = oInBlankArea instanceof Boolean ? (Boolean)oInBlankArea : false;
                TableColumnOrTreeColumn tcColumn = (TableColumnOrTreeColumn)menu.getData("column");
                if (isHeader) {
                    TableViewSWTImpl.this.fillColumnMenu(tcColumn, inBlankArea);
                } else {
                    TableViewSWTImpl.this.fillMenu(menu, tcColumn);
                }
            }
        });
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMenu(Menu menu, final TableColumnOrTreeColumn tcColumn) {
        String columnName = tcColumn == null ? null : (String)tcColumn.getData("Name");
        Object[] listeners = this.listenersMenuFill.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
            l.fillMenu(columnName, menu);
        }
        boolean hasLevel1 = false;
        boolean hasLevel2 = false;
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            for (TableRowCore row : this.selectedRows) {
                if (row.getParentRowCore() != null) {
                    hasLevel2 = true;
                    continue;
                }
                hasLevel1 = true;
            }
        }
        String sMenuID = hasLevel1 ? this.sTableID : "Files";
        boolean enable_items = this.table != null && this.table.getSelection().length > 0;
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(sMenuID);
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = null;
        menu_items = "MySeeders".equals(this.sTableID) || "MyTorrents".equals(this.sTableID) ? MenuItemManager.getInstance().getAllAsArray("download_context") : MenuItemManager.getInstance().getAllAsArray((String)null);
        if (columnName == null) {
            MenuItem itemChangeTable = new MenuItem(menu, 8);
            Messages.setLanguageText(itemChangeTable, "MyTorrentsView.menu.editTableColumns");
            Utils.setMenuItemImage(itemChangeTable, "columns");
            itemChangeTable.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWTImpl.this.showColumnEditor();
                }
            });
        } else {
            MenuItem item = new MenuItem(menu, 8);
            Messages.setLanguageText(item, "MyTorrentsView.menu.thisColumn.toClipboard");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableRowCore[] rows;
                    String sToClipboard = "";
                    if (tcColumn == null) {
                        return;
                    }
                    String columnName = (String)tcColumn.getData("Name");
                    if (columnName == null) {
                        return;
                    }
                    for (TableRowCore row : rows = TableViewSWTImpl.this.getSelectedRows()) {
                        TableCellCore cell;
                        if (row != rows[0]) {
                            sToClipboard = sToClipboard + "\n";
                        }
                        if ((cell = row.getTableCellCore(columnName)) == null) continue;
                        sToClipboard = sToClipboard + cell.getClipboardText();
                    }
                    if (sToClipboard.length() == 0) {
                        return;
                    }
                    new Clipboard(TableViewSWTImpl.this.mainComposite.getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
                }
            });
        }
        if (items.length > 0 || menu_items.length > 0) {
            new MenuItem(menu, 2);
            if (menu_items != null) {
                MenuBuildUtils.addPluginMenuItems(this.getComposite(), menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.getSelectedDataSources(false)));
            }
            if (items.length > 0) {
                MenuBuildUtils.addPluginMenuItems(this.getComposite(), items, menu, true, enable_items, new MenuBuildUtils.PluginMenuController(){

                    public Listener makeSelectionListener(final org.gudy.azureus2.plugins.ui.menus.MenuItem plugin_menu_item) {
                        return new TableSelectedRowsListener(TableViewSWTImpl.this, false){

                            public boolean run(TableRowCore[] rows) {
                                if (rows.length != 0) {
                                    ((TableContextMenuItemImpl)plugin_menu_item).invokeListenersMulti(rows);
                                }
                                return true;
                            }
                        };
                    }

                    public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
                        ((TableContextMenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TableViewSWTImpl.this.getSelectedRows());
                    }
                });
            }
        }
        if (hasLevel1) {
            TableColumnCore tc;
            org.gudy.azureus2.plugins.ui.menus.MenuItem[] columnItems;
            if (tcColumn != null && (columnItems = (tc = (TableColumnCore)tcColumn.getData("TableColumnCore")).getContextMenuItems(2)).length > 0) {
                new MenuItem(menu, 2);
                MenuBuildUtils.addPluginMenuItems(this.getComposite(), columnItems, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.getSelectedDataSources(true)));
            }
            if (this.filter != null) {
                MenuItem itemFilter = new MenuItem(menu, 8);
                Messages.setLanguageText(itemFilter, "MyTorrentsView.menu.filter");
                itemFilter.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TableViewSWTImpl.this.openFilterDialog();
                    }
                });
            }
        }
    }

    void showColumnEditor() {
        TableRowCore focusedRow = this.getFocusedRow();
        if (focusedRow == null || focusedRow.isRowDisposed()) {
            focusedRow = this.getRow(0);
        }
        new TableColumnSetupWindow(this.classPluginDataSourceType, this.sTableID, focusedRow, TableStructureEventDispatcher.getInstance(this.sTableID)).open();
    }

    private void fillColumnMenu(TableColumnOrTreeColumn tcColumn, boolean isBlankArea) {
        if (!isBlankArea) {
            TableColumnManager tcm = TableColumnManager.getInstance();
            TableColumnCore[] allTableColumns = tcm.getAllTableColumnCoreAsArray(this.classPluginDataSourceType, this.sTableID);
            Arrays.sort(allTableColumns, TableColumnManager.getTableColumnOrderComparator());
            for (final TableColumnCore tc : allTableColumns) {
                TableColumnInfo columnInfo;
                boolean visible = tc.isVisible();
                if (!visible && (columnInfo = tcm.getColumnInfo(this.classPluginDataSourceType, this.sTableID, tc.getName())).getProficiency() != 0) continue;
                MenuItem menuItem = new MenuItem(this.menu, 32);
                Messages.setLanguageText(menuItem, tc.getTitleLanguageKey());
                if (visible) {
                    menuItem.setSelection(true);
                }
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        tc.setVisible(!tc.isVisible());
                        TableViewSWTImpl.this.tableStructureChanged(true, null);
                    }
                });
            }
        }
        if (this.menu.getItemCount() > 0) {
            new MenuItem(this.menu, 2);
        }
        MenuItem itemResetColumns = new MenuItem(this.menu, 8);
        Messages.setLanguageText(itemResetColumns, "table.columns.reset");
        itemResetColumns.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnManager tcm = TableColumnManager.getInstance();
                String[] defaultColumnNames = tcm.getDefaultColumnNames(TableViewSWTImpl.this.sTableID);
                if (defaultColumnNames != null) {
                    for (TableColumnCore column : TableViewSWTImpl.this.tableColumns) {
                        column.setVisible(false);
                    }
                    int i = 0;
                    for (String name : defaultColumnNames) {
                        TableColumnCore column = tcm.getTableColumnCore(TableViewSWTImpl.this.sTableID, name);
                        if (column == null) continue;
                        column.reset();
                        column.setVisible(true);
                        column.setPositionNoShift(i++);
                    }
                    tcm.saveTableColumns(TableViewSWTImpl.this.classPluginDataSourceType, TableViewSWTImpl.this.sTableID);
                    TableStructureEventDispatcher.getInstance(TableViewSWTImpl.this.sTableID).tableStructureChanged(true, TableViewSWTImpl.this.classPluginDataSourceType);
                }
            }
        });
        MenuItem itemChangeTable = new MenuItem(this.menu, 8);
        Messages.setLanguageText(itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        Utils.setMenuItemImage(itemChangeTable, "columns");
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWTImpl.this.showColumnEditor();
            }
        });
        if (this.menu != null) {
            this.menu.setData("column", tcColumn);
        }
        if (tcColumn == null) {
            return;
        }
        String sColumnName = (String)tcColumn.getData("Name");
        if (sColumnName != null) {
            Object[] listeners = this.listenersMenuFill.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
                l.addThisColumnSubMenu(sColumnName, this.menu);
            }
        }
        final MenuItem at_item = new MenuItem(this.menu, 32);
        Messages.setLanguageText(at_item, "MyTorrentsView.menu.thisColumn.autoTooltip");
        at_item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnOrTreeColumn tc = (TableColumnOrTreeColumn)TableViewSWTImpl.this.menu.getData("column");
                TableColumnCore tcc = (TableColumnCore)tc.getData("TableColumnCore");
                tcc.setAutoTooltip(at_item.getSelection());
                tcc.invalidateCells();
            }
        });
        at_item.setSelection(((TableColumnCore)tcColumn.getData("TableColumnCore")).doesAutoTooltip());
        TableColumnCore tc = (TableColumnCore)tcColumn.getData("TableColumnCore");
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = tc.getContextMenuItems(1);
        if (items.length > 0) {
            new MenuItem(this.menu, 2);
            MenuBuildUtils.addPluginMenuItems(this.getComposite(), items, this.menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.getSelectedDataSources(true)));
        }
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public Composite getTableComposite() {
        return this.tableComposite;
    }

    @Override
    public TableOrTreeSWT getTableOrTreeSWT() {
        return this.table;
    }

    public IView getActiveSubView() {
        if (!this.bEnableTabViews || this.tabFolder == null || this.tabFolder.isDisposed() || this.tabFolder.getMinimized()) {
            return null;
        }
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            return (IView)item.getData("IView");
        }
        return null;
    }

    public void refreshSelectedSubView() {
        IView view = this.getActiveSubView();
        if (view != null && view.getComposite().isVisible()) {
            view.refresh();
        }
    }

    @Override
    public void refreshTable(final boolean bForceSort) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_refreshTable(bForceSort);
                if (TableViewSWTImpl.this.bEnableTabViews && TableViewSWTImpl.this.tabFolder != null && !TableViewSWTImpl.this.tabFolder.isDisposed() && !TableViewSWTImpl.this.tabFolder.getMinimized()) {
                    TableViewSWTImpl.this.refreshSelectedSubView();
                }
            }
        });
        this.triggerTableRefreshListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_refreshTable(boolean bForceSort) {
        if (this.table == null) {
            return;
        }
        this.isVisible();
        try {
            long lTimeDiff;
            boolean bWillSort;
            block11: {
                block10: {
                    if (this.getComposite() == null) break block10;
                    if (!this.getComposite().isDisposed()) break block11;
                }
                Object var9_2 = null;
                return;
            }
            if (this.columnVisibilitiesChanged) {
                this.swt_updateColumnVisibilities(true);
            }
            final boolean bDoGraphics = this.loopFactor % this.graphicsUpdate == 0;
            boolean bl = bWillSort = bForceSort || this.reOrderDelay != 0 && this.loopFactor % this.reOrderDelay == 0;
            if (bWillSort) {
                if (bForceSort && this.sortColumn != null) {
                    this.lLastSortedOn = 0L;
                    this.sortColumn.setLastSortValueChange(SystemTime.getCurrentTime());
                }
                this._sortColumn(true, false, false);
            }
            long lTimeStart = SystemTime.getMonotonousTime();
            this.runForAllRows(new TableGroupRowVisibilityRunner(){

                public void run(TableRowCore row, boolean bVisible) {
                    row.refresh(bDoGraphics, bVisible);
                }
            });
            if (DEBUGADDREMOVE && (lTimeDiff = SystemTime.getMonotonousTime() - lTimeStart) > 500L) {
                this.debug(lTimeDiff + "ms to refresh rows");
            }
            ++this.loopFactor;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            throw throwable;
        }
        Object var9_3 = null;
    }

    private void swt_refreshVisibleRows() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.swt_runForVisibleRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.refresh(false, true);
            }
        });
    }

    @Override
    public void processDataSourceQueue() {
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this._processDataSourceQueue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processDataSourceQueue() {
        Object[] dataSourcesAdd = null;
        Object[] dataSourcesRemove = null;
        try {
            this.dataSourceToRow_mon.enter();
            if (this.dataSourcesToAdd.size() > 0) {
                if (this.dataSourcesToAdd.removeAll(this.dataSourcesToRemove) && DEBUGADDREMOVE) {
                    this.debug("Saved time by not adding a row that was removed");
                }
                dataSourcesAdd = this.dataSourcesToAdd.toArray();
                this.dataSourcesToAdd.clear();
            }
            if (this.dataSourcesToRemove.size() > 0) {
                dataSourcesRemove = this.dataSourcesToRemove.toArray();
                if (DEBUGADDREMOVE && dataSourcesRemove.length > 1) {
                    this.debug("Streamlining removing " + dataSourcesRemove.length + " rows");
                }
                this.dataSourcesToRemove.clear();
            }
            Object var4_3 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        if (dataSourcesAdd != null && dataSourcesAdd.length > 0) {
            this.reallyAddDataSources(dataSourcesAdd);
            if (DEBUGADDREMOVE && dataSourcesAdd.length > 1) {
                this.debug("Streamlined adding " + dataSourcesAdd.length + " rows");
            }
        }
        if (dataSourcesRemove != null && dataSourcesRemove.length > 0) {
            this.reallyRemoveDataSources(dataSourcesRemove);
        }
    }

    private void locationChanged(final int iStartColumn) {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        this.columnVisibilitiesChanged = true;
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                row.locationChanged(iStartColumn);
            }
        });
    }

    @Override
    public void delete() {
        this.triggerLifeCycleListener(1);
        if (this.tabViews != null && this.tabViews.size() > 0) {
            for (int i = 0; i < this.tabViews.size(); ++i) {
                IView view = this.tabViews.get(i);
                if (view == null) continue;
                view.delete();
            }
        }
        TableStructureEventDispatcher.getInstance(this.sTableID).removeListener(this);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        if (tcManager != null) {
            tcManager.saveTableColumns(this.classPluginDataSourceType, this.sTableID);
        }
        if (this.table != null && !this.table.isDisposed()) {
            this.table.dispose();
        }
        this.removeAllTableRows();
        configMan.removeParameterListener("ReOrder Delay", this);
        configMan.removeParameterListener("Graphics Update", this);
        Colors.getInstance().removeColorsChangedListener(this);
        this.processDataSourceQueueCallback = null;
        Composite comp2 = this.getComposite();
        if (comp2 != null && !comp2.isDisposed()) {
            comp2.dispose();
        }
        MessageText.removeListener(this);
    }

    @Override
    public void addDataSource(DATASOURCETYPE dataSource) {
        this.addDataSource(dataSource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDataSource(DATASOURCETYPE dataSource, boolean skipFilterCheck) {
        if (dataSource == null) {
            return;
        }
        this.listUnfilteredDatasources_mon.enter();
        try {
            this.listUnfilteredDataSources.add(dataSource);
            Object var4_3 = null;
            this.listUnfilteredDatasources_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listUnfilteredDatasources_mon.exit();
            throw throwable;
        }
        if (!skipFilterCheck && this.filter != null && !this.filter.checker.filterCheck(dataSource, this.filter.text, this.filter.regex)) {
            return;
        }
        try {
            this.dataSourceToRow_mon.enter();
            if (this.dataSourcesToRemove.remove(dataSource) && DEBUGADDREMOVE) {
                this.debug("AddDS: Removed from toRemove.  Total Removals Queued: " + this.dataSourcesToRemove.size());
            }
            if (this.dataSourcesToAdd.contains(dataSource)) {
                if (DEBUGADDREMOVE) {
                    this.debug("AddDS: Already There.  Total Additions Queued: " + this.dataSourcesToAdd.size());
                }
            } else {
                this.dataSourcesToAdd.add(dataSource);
                if (DEBUGADDREMOVE) {
                    this.debug("Queued 1 dataSource to add.  Total Additions Queued: " + this.dataSourcesToAdd.size() + "; already=" + this.sortedRows.size());
                }
                this.refreshenProcessDataSourcesTimer();
            }
            Object var6_6 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void addDataSources(DATASOURCETYPE[] dataSources) {
        this.addDataSources(dataSources, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSources(DATASOURCETYPE[] dataSources, boolean skipFilterCheck) {
        if (dataSources == null) {
            return;
        }
        this.listUnfilteredDatasources_mon.enter();
        try {
            this.listUnfilteredDataSources.addAll(Arrays.asList(dataSources));
            Object var4_3 = null;
            this.listUnfilteredDatasources_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listUnfilteredDatasources_mon.exit();
            throw throwable;
        }
        try {
            this.dataSourceToRow_mon.enter();
            int count = 0;
            for (int i = 0; i < dataSources.length; ++i) {
                DATASOURCETYPE dataSource = dataSources[i];
                if (dataSource == null || !skipFilterCheck && this.filter != null && !this.filter.checker.filterCheck(dataSource, this.filter.text, this.filter.regex)) continue;
                this.dataSourcesToRemove.remove(dataSource);
                if (this.dataSourcesToAdd.contains(dataSource)) continue;
                ++count;
                this.dataSourcesToAdd.add(dataSource);
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + count + " of " + dataSources.length + " dataSources to add.  Total Queued: " + this.dataSourcesToAdd.size());
            }
            Object var7_9 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void refreshenProcessDataSourcesTimer() {
        boolean processQueueImmediately;
        if (this.bReallyAddingDataSources || this.processDataSourceQueueCallback == null) {
            return;
        }
        if (this.cellEditNotifier != null) {
            this.cellEditNotifier.sourcesChanged();
        }
        if (processQueueImmediately = Utils.addDataSourceAggregated(this.processDataSourceQueueCallback)) {
            this.processDataSourceQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reallyAddDataSources(Object[] dataSources) {
        if (this.mainComposite == null || this.table == null || this.mainComposite.isDisposed() || this.table.isDisposed()) {
            return;
        }
        this.bReallyAddingDataSources = true;
        if (DEBUGADDREMOVE) {
            this.debug(">> Add " + dataSources.length + " rows;");
        }
        try {
            try {
                this.dataSourceToRow_mon.enter();
                long lStartTime = SystemTime.getCurrentTime();
                for (int i = 0; i < dataSources.length; ++i) {
                    if (dataSources[i] == null) continue;
                    if (this.mapDataSourceToRow.containsKey(dataSources[i])) {
                        dataSources[i] = null;
                        continue;
                    }
                    TableRowImpl row = new TableRowImpl(this, this.table, this.columnsOrdered, dataSources[i], this.bSkipFirstColumn);
                    this.mapDataSourceToRow.put(dataSources[i], row);
                }
                Object var7_6 = null;
                this.dataSourceToRow_mon.exit();
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Error while added row to Table " + this.sTableID, e));
                Object var7_7 = null;
                this.dataSourceToRow_mon.exit();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        if (DEBUGADDREMOVE) {
            this.debug("-- Add " + dataSources.length + " rows;");
        }
        this.addDataSourcesToSWT(dataSources, true);
    }

    private void addDataSourcesToSWT(final Object[] dataSources, boolean async) {
        try {
            if (this.isDisposed()) {
                return;
            }
            if (DEBUGADDREMOVE) {
                this.debug("-- Add " + dataSources.length + " rows to SWT " + (async ? " async " : " NOW"));
            }
            if (async) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                });
            } else {
                Utils.execSWTThread((Runnable)new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this._addDataSourcesToSWT(dataSources);
                    }
                }, false);
            }
        }
        catch (Exception e) {
            this.bReallyAddingDataSources = false;
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addDataSourcesToSWT(Object[] dataSources) {
        if (this.table == null || this.table.isDisposed()) {
            this.bReallyAddingDataSources = false;
            return;
        }
        this.mainComposite.getParent().setCursor(this.table.getDisplay().getSystemCursor(1));
        TableRowCore[] selectedRows = this.getSelectedRows();
        boolean bReplacedVisible = false;
        boolean bWas0Rows = this.table.getItemCount() == 0;
        try {
            Object var15_22;
            block34: {
                try {
                    this.dataSourceToRow_mon.enter();
                    this.sortedRows_mon.enter();
                    if (DEBUGADDREMOVE) {
                        this.debug("-- Add " + dataSources.length + " rows to SWT");
                    }
                    if (!Constants.isWindows) {
                        this.table.setItemCount(this.sortedRows.size() + dataSources.length);
                    }
                    long lStartTime = SystemTime.getCurrentTime();
                    int iTopIndex = this.table.getTopIndex();
                    int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
                    for (int i = 0; i < dataSources.length; ++i) {
                        TableCellCore cell;
                        TableRowImpl row;
                        Object dataSource = dataSources[i];
                        if (dataSource == null || (row = (TableRowImpl)this.mapDataSourceToRow.get(dataSource)) == null || row.isRowDisposed() || this.sortedRows.indexOf(row) >= 0) continue;
                        if (this.sortColumn != null && (cell = row.getTableCellCore(this.sortColumn.getName())) != null) {
                            try {
                                cell.invalidate();
                                cell.refresh(true);
                            }
                            catch (Exception e) {
                                Logger.log(new LogEvent(LOGID, "Minor error adding a row to table " + this.sTableID, e));
                            }
                        }
                        try {
                            int index = 0;
                            if (this.sortedRows.size() > 0) {
                                TableRowSWT lastRow = this.sortedRows.get(this.sortedRows.size() - 1);
                                if (this.sortColumn == null || this.sortColumn.compare(row, lastRow) >= 0) {
                                    index = this.sortedRows.size();
                                    this.sortedRows.add(row);
                                    if (DEBUGADDREMOVE) {
                                        this.debug("Adding new row to bottom");
                                    }
                                } else {
                                    index = Collections.binarySearch(this.sortedRows, row, this.sortColumn);
                                    if (index < 0) {
                                        index = -1 * index - 1;
                                    }
                                    if (index > this.sortedRows.size()) {
                                        index = this.sortedRows.size();
                                    }
                                    if (DEBUGADDREMOVE) {
                                        this.debug("Adding new row at position " + index + " of " + (this.sortedRows.size() - 1));
                                    }
                                    this.sortedRows.add(index, row);
                                }
                            } else {
                                if (DEBUGADDREMOVE) {
                                    this.debug("Adding new row to bottom (1st Entry)");
                                }
                                index = this.sortedRows.size();
                                this.sortedRows.add(row);
                            }
                            this.triggerListenerRowAdded(row);
                            if (!bReplacedVisible && (index >= iTopIndex && index <= iBottomIndex || index == this.sortedRows.size() - 1)) {
                                bReplacedVisible = true;
                            }
                            row.setIconSize(this.ptIconSize);
                            continue;
                        }
                        catch (Exception e) {
                            Logger.log(new LogEvent(LOGID, "Error adding a row to table " + this.sTableID, e));
                            try {
                                if (this.sortedRows.contains(row)) continue;
                                this.sortedRows.add(row);
                                continue;
                            }
                            catch (Exception e2) {
                                Debug.out(e2);
                            }
                        }
                    }
                    if (DEBUGADDREMOVE) {
                        this.debug("Adding took " + (SystemTime.getCurrentTime() - lStartTime) + "ms");
                    }
                    if (this.table.getItemCount() != this.sortedRows.size()) {
                        this.table.setItemCount(this.sortedRows.size());
                    }
                    if (this.sortedRows.size() != 1) break block34;
                    this.columnVisibilitiesChanged = true;
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Error while adding row to Table " + this.sTableID, e));
                    var15_22 = null;
                    this.sortedRows_mon.exit();
                    this.dataSourceToRow_mon.exit();
                    this.bReallyAddingDataSources = false;
                    this.refreshenProcessDataSourcesTimer();
                }
            }
            var15_22 = null;
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
            this.bReallyAddingDataSources = false;
            this.refreshenProcessDataSourcesTimer();
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
            this.bReallyAddingDataSources = false;
            this.refreshenProcessDataSourcesTimer();
            throw throwable;
        }
        this.fillRowGaps(false);
        if (bReplacedVisible) {
            this.visibleRowsChanged();
        }
        if (!this.columnPaddingAdjusted && this.table.getItemCount() > 0 && bWas0Rows) {
            TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
            TableItemOrTreeItem item = this.table.getItem(0);
            int len = Constants.isUnix ? tableColumnsSWT.length - 1 : tableColumnsSWT.length;
            for (int i = 0; i < len; ++i) {
                TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                if (tc == null) continue;
                boolean foundOne = false;
                Rectangle bounds = item.getBounds(i);
                int tcWidth = tc.getWidth();
                if (tcWidth != 0 && bounds.width != 0) {
                    Object oOldOfs = tableColumnsSWT[i].getData("widthOffset");
                    int oldOfs = oOldOfs instanceof Number ? ((Number)oOldOfs).intValue() : 0;
                    int ofs = tc.getWidth() - bounds.width + oldOfs;
                    if (ofs > 0 && ofs != oldOfs) {
                        foundOne = true;
                        tableColumnsSWT[i].setResizable(true);
                        tableColumnsSWT[i].setData("widthOffset", new Long(ofs + oldOfs));
                    }
                }
                if (!foundOne) continue;
                tc.triggerColumnSizeChange();
            }
            this.columnPaddingAdjusted = true;
        }
        if (bWas0Rows) {
            this.swt_updateColumnVisibilities(false);
        }
        this.setSelectedRows(selectedRows);
        if (DEBUGADDREMOVE) {
            this.debug("<< " + this.sortedRows.size());
        }
        this.mainComposite.getParent().setCursor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSource(DATASOURCETYPE dataSource) {
        if (dataSource == null) {
            return;
        }
        this.listUnfilteredDatasources_mon.enter();
        try {
            this.listUnfilteredDataSources.remove(dataSource);
            Object var3_2 = null;
            this.listUnfilteredDatasources_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listUnfilteredDatasources_mon.exit();
            throw throwable;
        }
        try {
            this.dataSourceToRow_mon.enter();
            this.dataSourcesToAdd.remove(dataSource);
            this.dataSourcesToRemove.add(dataSource);
            if (DEBUGADDREMOVE) {
                this.debug("Queued 1 dataSource to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
            Object var5_5 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        this.refreshenProcessDataSourcesTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataSources(DATASOURCETYPE[] dataSources) {
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        this.listUnfilteredDatasources_mon.enter();
        try {
            this.listUnfilteredDataSources.removeAll(Arrays.asList(dataSources));
            Object var3_2 = null;
            this.listUnfilteredDatasources_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listUnfilteredDatasources_mon.exit();
            throw throwable;
        }
        try {
            this.dataSourceToRow_mon.enter();
            for (int i = 0; i < dataSources.length; ++i) {
                DATASOURCETYPE dataSource = dataSources[i];
                this.dataSourcesToAdd.remove(dataSource);
                this.dataSourcesToRemove.add(dataSource);
            }
            if (DEBUGADDREMOVE) {
                this.debug("Queued " + dataSources.length + " dataSources to remove.  Total Queued: " + this.dataSourcesToRemove.size());
            }
            Object var5_6 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        this.refreshenProcessDataSourcesTimer();
    }

    private void reallyRemoveDataSources(final Object[] dataSources) {
        long lStart;
        boolean ok;
        if (DEBUGADDREMOVE) {
            this.debug(">> Remove rows");
        }
        if (!(ok = Utils.execSWTThread(new AERunnable(lStart = SystemTime.getCurrentTime()){
            final /* synthetic */ long val$lStart;
            {
                this.val$lStart = l;
            }

            public void runSupport() {
                TableViewSWTImpl.this.swt_reallyRemoveDataSources(dataSources, this.val$lStart);
            }
        }))) {
            for (int i = 0; i < dataSources.length; ++i) {
                if (dataSources[i] == null) continue;
                TableRowSWT item = (TableRowSWT)this.mapDataSourceToRow.get(dataSources[i]);
                this.mapDataSourceToRow.remove(dataSources[i]);
                if (item == null) continue;
                this.sortedRows.remove(item);
            }
            if (DEBUGADDREMOVE) {
                this.debug("<< Remove row(s), noswt");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swt_reallyRemoveDataSources(Object[] dataSources, long lStart) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableRowCore[] oldSelectedRows = this.getSelectedRows();
        this.mainComposite.getParent().setCursor(this.table.getDisplay().getSystemCursor(1));
        try {
            StringBuffer sbWillRemove = null;
            if (DEBUGADDREMOVE) {
                this.debug(">>> Remove rows.  Start w/" + this.mapDataSourceToRow.size() + "ds; tc=" + this.table.getItemCount() + ";" + (SystemTime.getCurrentTime() - lStart) + "ms wait");
                sbWillRemove = new StringBuffer("Will soon remove row #");
            }
            ArrayList<TableRowSWT> itemsToRemove = new ArrayList<TableRowSWT>();
            ArrayList<Long> swtItemsToRemove = new ArrayList<Long>();
            int iTopIndex = this.table.getTopIndex();
            int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            boolean bRefresh = false;
            if (DEBUGADDREMOVE) {
                this.debug("--- Remove: vis rows " + iTopIndex + " to " + iBottomIndex);
            }
            for (int i = 0; i < dataSources.length; ++i) {
                TableRowSWT item;
                if (dataSources[i] == null || (item = (TableRowSWT)this.mapDataSourceToRow.get(dataSources[i])) == null) continue;
                int n = this.sortedRows.indexOf(item);
                if (!bRefresh) {
                    boolean bl = bRefresh = n >= iTopIndex && n <= iBottomIndex;
                }
                if (DEBUGADDREMOVE) {
                    if (i != 0) {
                        sbWillRemove.append(", ");
                    }
                    sbWillRemove.append(n);
                }
                if (n < 0) continue;
                swtItemsToRemove.add(new Long(n));
            }
            if (DEBUGADDREMOVE) {
                this.debug(sbWillRemove.toString());
                this.debug("#swtItemsToRemove=" + swtItemsToRemove.size());
            }
            int numRemovedHavingSelection = 0;
            for (int i = 0; i < dataSources.length; ++i) {
                TableRowSWT tableRowSWT;
                if (dataSources[i] == null || (tableRowSWT = (TableRowSWT)this.mapDataSourceToRow.remove(dataSources[i])) == null) continue;
                if (tableRowSWT.isSelected()) {
                    ++numRemovedHavingSelection;
                }
                itemsToRemove.add(tableRowSWT);
                this.sortedRows.remove(tableRowSWT);
                this.triggerListenerRowRemoved(tableRowSWT);
            }
            if (DEBUGADDREMOVE) {
                this.debug("-- Removed from map and list");
            }
            if (swtItemsToRemove.size() > 0) {
                this.table.setItemCount(this.mapDataSourceToRow.size());
                if (Utils.isCocoa && this.mapDataSourceToRow.size() == 0) {
                    this.table.redraw();
                }
            }
            if (DEBUGADDREMOVE) {
                this.debug("-- Removed from SWT");
            }
            for (TableRowCore tableRowCore : itemsToRemove) {
                tableRowCore.delete();
            }
            if (bRefresh) {
                this.visibleRowsChanged();
                this.fillRowGaps(false);
                this.swt_refreshVisibleRows();
                if (DEBUGADDREMOVE) {
                    this.debug("-- Fill row gaps and refresh after remove");
                }
            }
            if (DEBUGADDREMOVE) {
                this.debug("<< Remove " + itemsToRemove.size() + " rows. now " + this.mapDataSourceToRow.size() + "ds; tc=" + this.table.getItemCount());
            }
            if (oldSelectedRows.length > 0) {
                this.setSelectedRows(oldSelectedRows);
            }
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.mainComposite.getParent().setCursor(null);
            throw throwable;
        }
        this.mainComposite.getParent().setCursor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllTableRows() {
        long lTimeDiff;
        long lTimeStart = System.currentTimeMillis();
        final TableRowCore[] rows = this.getRows();
        try {
            this.dataSourceToRow_mon.enter();
            this.sortedRows_mon.enter();
            this.mapDataSourceToRow.clear();
            this.sortedRows.clear();
            this.dataSourcesToAdd.clear();
            this.dataSourcesToRemove.clear();
            if (DEBUGADDREMOVE) {
                this.debug("removeAll");
            }
            Object var5_3 = null;
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.sortedRows_mon.exit();
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableViewSWT.DEBUGADDREMOVE) {
                    TableViewSWTImpl.this.debug("removeAll (SWT)");
                }
                if (TableViewSWTImpl.this.table != null && !TableViewSWTImpl.this.table.isDisposed()) {
                    TableViewSWTImpl.this.table.removeAll();
                }
                for (int i = 0; i < rows.length; ++i) {
                    rows[i].delete();
                }
            }
        });
        if (DEBUGADDREMOVE && (lTimeDiff = System.currentTimeMillis() - lTimeStart) > 10L) {
            this.debug("RemovaAll took " + lTimeDiff + "ms");
        }
    }

    @Override
    public String getTableID() {
        return this.sTableID;
    }

    @Override
    public void parameterChanged(String parameterName) {
        if (parameterName == null || parameterName.equals("Graphics Update")) {
            this.graphicsUpdate = configMan.getIntParameter("Graphics Update");
        }
        if (parameterName == null || parameterName.equals("ReOrder Delay")) {
            this.reOrderDelay = configMan.getIntParameter("ReOrder Delay");
        }
        if (parameterName == null || parameterName.startsWith("Color")) {
            this.tableInvalidate();
        }
    }

    @Override
    public void tableStructureChanged(final boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        if (forPluginDataSourceType == null || forPluginDataSourceType.equals(this.classPluginDataSourceType)) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (TableViewSWTImpl.this.table.isDisposed()) {
                        return;
                    }
                    TableViewSWTImpl.this._tableStructureChanged(columnAddedOrRemoved);
                }
            });
        }
    }

    private void _tableStructureChanged(boolean columnAddedOrRemoved) {
        this.triggerLifeCycleListener(1);
        this.removeAllTableRows();
        if (columnAddedOrRemoved) {
            this.tableColumns = TableColumnManager.getInstance().getAllTableColumnCoreAsArray(this.classPluginDataSourceType, this.sTableID);
        }
        this.initializeTableColumns(this.table);
        this.refreshTable(false);
        this.triggerLifeCycleListener(0);
    }

    @Override
    public void columnOrderChanged(final int[] positions) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    TableViewSWTImpl.this.table.setColumnOrder(positions);
                    TableViewSWTImpl.this.swt_updateColumnVisibilities(true);
                }
                catch (NoSuchMethodError e) {
                    TableViewSWTImpl.this.tableStructureChanged(false, null);
                }
            }
        });
    }

    @Override
    public void columnSizeChanged(final TableColumnCore tableColumn) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableViewSWTImpl.this.swt_columnSizeChanged(tableColumn);
            }
        });
    }

    public void swt_columnSizeChanged(TableColumnCore tableColumn) {
        int newWidth = tableColumn.getWidth();
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableColumnOrTreeColumn column = null;
        TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            if (tableColumnsSWT[i].getData("TableColumnCore") != tableColumn) continue;
            column = tableColumnsSWT[i];
            break;
        }
        if (column == null) {
            return;
        }
        Long lOfs = (Long)column.getData("widthOffset");
        if (lOfs != null) {
            newWidth += lOfs.intValue();
        }
        this.swt_refreshVisibleRows();
        if (column.isDisposed() || column.getWidth() == newWidth) {
            return;
        }
        if (Constants.isUnix) {
            final int fNewWidth = newWidth;
            final TableColumnOrTreeColumn fTableColumn = column;
            column.getDisplay().asyncExec(new AERunnable(){

                public void runSupport() {
                    if (!fTableColumn.isDisposed()) {
                        fTableColumn.setWidth(fNewWidth);
                    }
                }
            });
        } else {
            column.setWidth(newWidth);
        }
    }

    @Override
    public void columnInvalidate(TableColumnCore tableColumn) {
        this.columnInvalidate(tableColumn, true);
    }

    @Override
    public void cellInvalidate(TableColumnCore tableColumn, DATASOURCETYPE data_source) {
        this.cellInvalidate(tableColumn, data_source, true);
    }

    public void columnRefresh(TableColumnCore tableColumn) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.refresh(true, bVisible);
                }
            }
        });
    }

    public void tableInvalidate() {
        this.runForAllRows(new TableGroupRowVisibilityRunner(){

            public void run(TableRowCore row, boolean bVisible) {
                row.invalidate();
                row.refresh(true, bVisible);
            }
        });
    }

    @Override
    public void columnInvalidate(String sColumnName) {
        TableColumnCore tc = TableColumnManager.getInstance().getTableColumnCore(this.sTableID, sColumnName);
        if (tc != null) {
            this.columnInvalidate(tc, tc.getType() == 3);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
        this.lLastSortedOn = 0L;
        tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
    }

    public void cellInvalidate(TableColumnCore tableColumn, final DATASOURCETYPE data_source, final boolean bMustRefresh) {
        final String sColumnName = tableColumn.getName();
        this.runForAllRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                TableCellCore cell = row.getTableCellCore(sColumnName);
                if (cell != null && cell.getDataSource() != null && cell.getDataSource().equals(data_source)) {
                    cell.invalidate(bMustRefresh);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore[] getColumnCells(String sColumnName) {
        TableCellCore[] cells = new TableCellCore[this.sortedRows.size()];
        try {
            this.sortedRows_mon.enter();
            int i = 0;
            for (TableRowCore tableRowCore : this.sortedRows) {
                cells[i++] = tableRowCore.getTableCellCore(sColumnName);
            }
            Object var7_6 = null;
            this.sortedRows_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.sortedRows_mon.exit();
            throw throwable;
        }
        return cells;
    }

    @Override
    public TableColumn getTableColumn(String sColumnName) {
        for (int i = 0; i < this.tableColumns.length; ++i) {
            TableColumnCore tc = this.tableColumns[i];
            if (!tc.getName().equals(sColumnName)) continue;
            return tc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getRows() {
        try {
            this.sortedRows_mon.enter();
            TableRowCore[] tableRowCoreArray = this.sortedRows.toArray(new TableRowCore[0]);
            Object var3_2 = null;
            this.sortedRows_mon.exit();
            return tableRowCoreArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.sortedRows_mon.exit();
            throw throwable;
        }
    }

    @Override
    public TableRowCore getRow(DATASOURCETYPE dataSource) {
        return this.mapDataSourceToRow.get(dataSource);
    }

    @Override
    public TableRowSWT getRowSWT(DATASOURCETYPE dataSource) {
        return (TableRowSWT)this.mapDataSourceToRow.get(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getRow(int iPos) {
        block4: {
            try {
                this.sortedRows_mon.enter();
                if (iPos < 0 || iPos >= this.sortedRows.size()) break block4;
                TableRowCore row = this.sortedRows.get(iPos);
                if (row.getIndex() != iPos && Utils.isThisThreadSWT()) {
                    row.setTableItem(iPos);
                }
                TableRowCore tableRowCore = row;
                Object var5_4 = null;
                this.sortedRows_mon.exit();
                return tableRowCore;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.sortedRows_mon.exit();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.sortedRows_mon.exit();
        return null;
    }

    protected TableRowCore getRowQuick(int iPos) {
        try {
            return this.sortedRows.get(iPos);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int indexOf(TableRowCore row) {
        if (!Utils.isThisThreadSWT()) {
            return this.sortedRows.indexOf(row);
        }
        int i = ((TableRowImpl)row).getRealIndex();
        if (i == -1 && (i = this.sortedRows.indexOf(row)) >= 0) {
            row.setTableItem(i);
        }
        return i;
    }

    @Override
    protected TableRowCore getRow(TableItemOrTreeItem item) {
        if (item == null) {
            return null;
        }
        try {
            Object o = item.getData("TableRow");
            if (o instanceof TableRowCore && !((TableRowCore)o).isRowDisposed()) {
                return (TableRowCore)o;
            }
            if (item.getParentItem() != null) {
                TableRowCore row = this.getRow(item.getParentItem());
                return row.linkSubItem(item.getParentItem().indexOf(item));
            }
            int iPos = this.table.indexOf(item);
            if (iPos >= 0 && iPos < this.sortedRows.size()) {
                TableRowSWT row = this.sortedRows.get(iPos);
                if (row != null && !row.isRowDisposed()) {
                    row.setTableItem(iPos);
                    return row;
                }
                return null;
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    public int getRowCount() {
        return this.mapDataSourceToRow.size();
    }

    @Override
    public ArrayList<DATASOURCETYPE> getDataSources() {
        return new ArrayList<DATASOURCETYPE>(this.mapDataSourceToRow.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedDataSourcesList() {
        if (this.listSelectedCoreDataSources != null) {
            return this.listSelectedCoreDataSources;
        }
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            if (this.table == null || this.table.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(true)) == null) continue;
                l.add(ds);
            }
            this.listSelectedCoreDataSources = l;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getSelectedPluginDataSourcesList() {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            if (this.table == null || this.table.isDisposed() || this.selectedRows.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> l = new ArrayList<Object>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                Object ds;
                if (row == null || row.isRowDisposed() || (ds = row.getDataSource(false)) == null) continue;
                l.add(ds);
            }
            return l;
        }
    }

    @Override
    public List<Object> getSelectedDataSources() {
        return new ArrayList<Object>(this.getSelectedDataSourcesList());
    }

    @Override
    public Object[] getSelectedDataSources(boolean bCoreDataSource) {
        if (bCoreDataSource) {
            return this.getSelectedDataSourcesList().toArray();
        }
        return this.getSelectedPluginDataSourcesList().toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSelectedRows() {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            return this.selectedRows.toArray(new TableRowCore[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSelectedRowsSize() {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            return this.selectedRows.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableRowCore> getSelectedRowsList() {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            ArrayList<TableRowCore> l = new ArrayList<TableRowCore>(this.selectedRows.size());
            for (TableRowCore row : this.selectedRows) {
                if (row == null || row.isRowDisposed()) continue;
                l.add(row);
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelected(TableRow row) {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            return this.selectedRows.contains(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getFocusedRow() {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            if (this.selectedRows.size() == 0) {
                return null;
            }
            return this.selectedRows.get(0);
        }
    }

    @Override
    public Object getFirstSelectedDataSource() {
        return this.getFirstSelectedDataSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableRowSWT[] swt_getVisibleRows() {
        if (!this.isVisible()) {
            return new TableRowSWT[0];
        }
        TableViewSWTImpl tableViewSWTImpl = this;
        synchronized (tableViewSWTImpl) {
            if (this.visibleRows == null) {
                this.visibleRowsChanged();
            }
            return this.visibleRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFirstSelectedDataSource(boolean bCoreObject) {
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            if (this.selectedRows.size() > 0) {
                return this.selectedRows.get(0).getDataSource(bCoreObject);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runForSelectedRows(TableGroupRowRunner runner) {
        TableRowCore[] rows;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            rows = this.selectedRows.toArray(new TableRowCore[0]);
        }
        boolean ran = runner.run(rows);
        if (!ran) {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                runner.run(row);
            }
        }
    }

    public void swt_runForVisibleRows(TableGroupRowRunner runner) {
        TableRowCore[] rows = this.swt_getVisibleRows();
        if (runner.run(rows)) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            runner.run(rows[i]);
        }
    }

    @Override
    public void runForAllRows(TableGroupRowVisibilityRunner runner) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        TableRowCore[] rows = this.getRows();
        for (int i = 0; i < rows.length; ++i) {
            TableRowCore[] subRows;
            boolean isRowVisible = this.isRowVisible(rows[i]);
            runner.run(rows[i], isRowVisible);
            int numSubRows = rows[i].getSubItemCount();
            if (numSubRows <= 0) continue;
            for (TableRowCore subRow : subRows = rows[i].getSubRowsWithNull()) {
                if (subRow == null) continue;
                runner.run(subRow, isRowVisible && this.isRowVisible(subRow));
            }
        }
    }

    public void runForTableItems(List<TableItemOrTreeItem> items, TableGroupRowRunner runner) {
        TableRowCore[] rows;
        boolean ran;
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        Iterator<TableItemOrTreeItem> iter = items.iterator();
        ArrayList<TableRowSWT> rows_to_use = new ArrayList<TableRowSWT>(items.size());
        while (iter.hasNext()) {
            TableRowSWT row;
            TableItemOrTreeItem tableItem = iter.next();
            if (tableItem.isDisposed() || (row = (TableRowSWT)this.getRow(tableItem)) == null || row.isRowDisposed()) continue;
            rows_to_use.add(row);
        }
        if (rows_to_use.size() > 0 && !(ran = runner.run(rows = rows_to_use.toArray(new TableRowCore[rows_to_use.size()])))) {
            for (int i = 0; i < rows.length; ++i) {
                TableRowCore row = rows[i];
                runner.run(row);
            }
        }
    }

    @Override
    public void clipboardSelected() {
        TableRowCore[] rows;
        String sToClipboard = "";
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            if (j != 0) {
                sToClipboard = sToClipboard + "\t";
            }
            sToClipboard = sToClipboard + this.table.getColumn(j).getText();
        }
        for (TableRowCore row : rows = this.getSelectedRows()) {
            sToClipboard = sToClipboard + "\n";
            TableColumnCore[] visibleColumns = this.getVisibleColumns();
            for (int j = 0; j < visibleColumns.length; ++j) {
                TableCellCore cell;
                TableColumnCore column = visibleColumns[j];
                if (!column.isVisible()) continue;
                if (j != 0) {
                    sToClipboard = sToClipboard + "\t";
                }
                if ((cell = row.getTableCellCore(column.getName())) == null) continue;
                sToClipboard = sToClipboard + cell.getClipboardText();
            }
        }
        new Clipboard(this.getComposite().getDisplay()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
    }

    private int getColumnNo(int iMouseX) {
        int iColumn = -1;
        int itemCount = this.table.getItemCount();
        if (this.table.getItemCount() > 0) {
            int i;
            TableItemOrTreeItem ti;
            int topIndex = this.table.getTopIndex();
            if (topIndex >= itemCount || topIndex < 0) {
                topIndex = itemCount - 1;
            }
            if ((ti = this.table.getItem(topIndex)).isDisposed()) {
                return -1;
            }
            int n = i = this.bSkipFirstColumn ? 1 : 0;
            while (i < this.table.getColumnCount()) {
                Rectangle cellBounds = ti.getBounds(i);
                if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                    iColumn = i;
                    break;
                }
                ++i;
            }
        }
        return iColumn;
    }

    @Override
    public TableRowCore getRow(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItemOrTreeItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            return null;
        }
        return this.getRow(item);
    }

    @Override
    public TableCellCore getTableCell(int x, int y) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableItemOrTreeItem item = this.table.getItem(new Point(2, y));
        if (item == null) {
            item = this.table.getItem(new Point(x, y));
        }
        if (item == null) {
            return null;
        }
        TableRowSWT row = (TableRowSWT)this.getRow(item);
        if (row == null || row.isRowDisposed()) {
            return null;
        }
        TableColumnOrTreeColumn tcColumn = this.table.getColumn(iColumn);
        String sCellName = (String)tcColumn.getData("Name");
        if (sCellName == null) {
            return null;
        }
        return row.getTableCellCore(sCellName);
    }

    public TableRowSWT getTableRow(int x, int y, boolean anyX) {
        TableItemOrTreeItem item = this.table.getItem(new Point(anyX ? 2 : x, y));
        if (item == null) {
            return null;
        }
        return (TableRowSWT)this.getRow(item);
    }

    private TableColumnCore getTableColumnByOffset(int x) {
        int iColumn = this.getColumnNo(x);
        if (iColumn < 0) {
            return null;
        }
        TableColumnOrTreeColumn column = this.table.getColumn(iColumn);
        return (TableColumnCore)column.getData("TableColumnCore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Diagnostics for " + this + " (" + this.sTableID + ")");
        try {
            this.dataSourceToRow_mon.enter();
            writer.println("DataSources scheduled to Add/Remove: " + this.dataSourcesToAdd.size() + "/" + this.dataSourcesToRemove.size());
            writer.println("TableView: " + this.mapDataSourceToRow.size() + " datasources");
            for (DATASOURCETYPE key : this.mapDataSourceToRow.keySet()) {
                writer.println("  " + key + " -> " + this.mapDataSourceToRow.get(key));
            }
            writer.println("# of SubViews: " + this.tabViews.size());
            writer.indent();
            try {
                for (IView view : this.tabViews) {
                    view.generateDiagnostics(writer);
                }
                Object var6_7 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                writer.exdent();
                throw throwable;
            }
            writer.println("Columns:");
            writer.indent();
            try {
                try {
                    TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
                    for (int i = 0; i < tableColumnsSWT.length; ++i) {
                        TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
                        if (tc == null) continue;
                        writer.println(tc.getName() + ";w=" + tc.getWidth() + ";w-offset=" + tableColumnsSWT[i].getData("widthOffset"));
                    }
                    Object var8_11 = null;
                    writer.exdent();
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    writer.exdent();
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                writer.exdent();
                throw throwable;
            }
            Object var10_15 = null;
            this.dataSourceToRow_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            this.dataSourceToRow_mon.exit();
            throw throwable;
        }
    }

    public boolean getSkipFirstColumn() {
        return this.bSkipFirstColumn;
    }

    @Override
    public void setRowDefaultHeight(int iHeight) {
        if (this.ptIconSize == null) {
            this.ptIconSize = new Point(1, iHeight);
        } else {
            this.ptIconSize.y = iHeight;
        }
        if (!Constants.isOSX) {
            this.bSkipFirstColumn = true;
        }
    }

    @Override
    public int getRowDefaultHeight() {
        if (this.ptIconSize == null) {
            return 0;
        }
        return this.ptIconSize.y;
    }

    @Override
    public void setRowDefaultIconSize(Point size) {
        this.ptIconSize = size;
        if (!Constants.isOSX) {
            this.bSkipFirstColumn = true;
        }
    }

    public void addTabView(IView view) {
        if (view == null || this.tabFolder == null) {
            return;
        }
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setData("IView", view);
        Messages.setLanguageText(item, view.getData());
        view.initialize(this.tabFolder);
        item.setControl(view.getComposite());
        this.tabViews.add(view);
    }

    private void fillRowGaps(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, true, false);
    }

    private void sortColumn(boolean bForceDataRefresh) {
        this._sortColumn(bForceDataRefresh, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sortColumn(boolean bForceDataRefresh, boolean bFillGapsOnly, boolean bFollowSelected) {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            this.sortColumn_mon.enter();
            int iNumMoves = 0;
            int iTopIndex = this.table.getTopIndex();
            int iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex);
            boolean needsUpdate = false;
            try {
                int count;
                this.sortedRows_mon.enter();
                if (bForceDataRefresh && this.sortColumn != null) {
                    int i = 0;
                    String sColumnID = this.sortColumn.getName();
                    for (TableRowSWT row : this.sortedRows) {
                        TableCellSWT cell = row.getTableCellSWT(sColumnID);
                        if (cell != null) {
                            cell.refresh(true, i >= iTopIndex && i <= iBottomIndex);
                        }
                        ++i;
                    }
                }
                if (!bFillGapsOnly && this.sortColumn != null && this.sortColumn.getLastSortValueChange() > this.lLastSortedOn) {
                    this.lLastSortedOn = SystemTime.getCurrentTime();
                    Collections.sort(this.sortedRows, this.sortColumn);
                }
                if (iBottomIndex >= (count = this.sortedRows.size())) {
                    iBottomIndex = count - 1;
                }
                for (int i = 0; i < this.sortedRows.size(); ++i) {
                    boolean visible;
                    TableRowSWT row = this.sortedRows.get(i);
                    boolean bl = visible = i >= iTopIndex && i <= iBottomIndex;
                    if (!row.setTableItem(i, visible)) continue;
                    if (visible) {
                        needsUpdate = true;
                    }
                    ++iNumMoves;
                }
                Object var16_15 = null;
                this.sortedRows_mon.exit();
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                this.sortedRows_mon.exit();
                throw throwable;
            }
            if (needsUpdate) {
                this.visibleRowsChanged();
            }
            Object var18_18 = null;
            this.sortColumn_mon.exit();
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            this.sortColumn_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectRow(TableRowCore row, boolean trigger) {
        if (row == null || row.isRowDisposed()) {
            return;
        }
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            if (this.selectedRows.contains(row)) {
                return;
            }
            this.selectedRows.add(row);
            this.listSelectedCoreDataSources = null;
        }
        if (trigger) {
            this.triggerSelectionListeners(new TableRowCore[]{row});
            this.triggerTabViewsDataSourceChanged();
        }
        ((TableRowSWT)row).setWidgetSelected(true);
    }

    protected void updateSelectedRows(TableItemOrTreeItem[] newSelectionArray, boolean trigger) {
        ArrayList<TableRowCore> newSelectionList = new ArrayList<TableRowCore>(1);
        for (TableItemOrTreeItem item : newSelectionArray) {
            TableRowCore row = this.getRow(item);
            if (row == null || row.isRowDisposed()) continue;
            newSelectionList.add(row);
        }
        this.updateSelectedRows(newSelectionList.toArray(new TableRowCore[0]), trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSelectedRows(final TableRowCore[] newSelectionArray, final boolean trigger) {
        if (this.table.isDisposed()) {
            return;
        }
        final ArrayList<TableRowCore> oldSelectionList = new ArrayList<TableRowCore>();
        List<TableRowCore> list = this.selectedRows;
        synchronized (list) {
            oldSelectionList.addAll(this.selectedRows);
            final TableItemOrTreeItem[] newSelectionItems = new TableItemOrTreeItem[newSelectionArray.length];
            int i = 0;
            this.listSelectedCoreDataSources = null;
            this.selectedRows.clear();
            if (newSelectionArray.length > 0) {
                for (TableRowCore row : newSelectionArray) {
                    if (row == null || row.isRowDisposed()) continue;
                    newSelectionItems[i] = ((TableRowImpl)row).getItem();
                    if (newSelectionItems[i] != null && !newSelectionItems[i].isDisposed()) {
                        ++i;
                    }
                    this.selectedRows.add(row);
                }
                final int numItems = i;
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableItemOrTreeItem[] selection = TableViewSWTImpl.this.table.getSelection();
                        for (int i = 0; i < numItems; ++i) {
                            boolean alreadySelected = false;
                            for (int j = 0; j < selection.length; ++j) {
                                if (selection[j] != newSelectionItems[i]) continue;
                                alreadySelected = true;
                                selection[j] = null;
                                break;
                            }
                            if (alreadySelected) continue;
                            TableViewSWTImpl.this.table.select(newSelectionItems[i]);
                        }
                        for (int j = 0; j < selection.length; ++j) {
                            if (selection[j] == null) continue;
                            TableViewSWTImpl.this.table.deselect(selection[j]);
                        }
                    }
                });
            } else {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableViewSWTImpl.this.table.deselectAll();
                    }
                });
            }
        }
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                boolean somethingChanged;
                ArrayList<TableRowCore> listNewlySelected;
                List list = TableViewSWTImpl.this.selectedRows;
                synchronized (list) {
                    ArrayList<TableRowCore> newSelectionList = new ArrayList<TableRowCore>(1);
                    listNewlySelected = new ArrayList<TableRowCore>(1);
                    for (TableRowCore row : newSelectionArray) {
                        if (row == null || row.isRowDisposed()) continue;
                        boolean existed = false;
                        for (TableRowCore oldRow : oldSelectionList) {
                            if (oldRow != row) continue;
                            existed = true;
                            newSelectionList.add(row);
                            oldSelectionList.remove(row);
                            break;
                        }
                        if (existed) continue;
                        newSelectionList.add(row);
                        listNewlySelected.add(row);
                    }
                    somethingChanged = listNewlySelected.size() > 0 || oldSelectionList.size() > 0;
                }
                if (trigger && somethingChanged) {
                    if (listNewlySelected.size() > 0) {
                        TableViewSWTImpl.this.triggerSelectionListeners(listNewlySelected.toArray(new TableRowCore[0]));
                    }
                    if (oldSelectionList.size() > 0) {
                        TableViewSWTImpl.this.triggerDeselectionListeners(oldSelectionList.toArray(new TableRowCore[0]));
                    }
                    TableViewSWTImpl.this.triggerTabViewsDataSourceChanged();
                }
            }
        });
    }

    public void sortColumnReverse(TableColumnCore sorter) {
        if (this.sortColumn == null) {
            return;
        }
        boolean bSameColumn = this.sortColumn.equals(sorter);
        if (!bSameColumn) {
            this.fixAlignment(this.sortColumn, false);
            this.sortColumn = sorter;
            this.fixAlignment(sorter, true);
            int iSortDirection = configMan.getIntParameter(CFG_SORTDIRECTION);
            if (iSortDirection == 0) {
                this.sortColumn.setSortAscending(true);
            } else if (iSortDirection == 1) {
                this.sortColumn.setSortAscending(false);
            } else {
                this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
            }
            TableColumnManager.getInstance().setDefaultSortColumnName(this.sTableID, this.sortColumn.getName());
        } else {
            this.sortColumn.setSortAscending(!this.sortColumn.isSortAscending());
        }
        this.changeColumnIndicator();
        this.sortColumn(!bSameColumn);
    }

    private void changeColumnIndicator() {
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        try {
            TableColumnOrTreeColumn[] tcs = this.table.getColumns();
            for (int i = 0; i < tcs.length; ++i) {
                String sName = (String)tcs[i].getData("Name");
                if (sName == null || this.sortColumn == null || !sName.equals(this.sortColumn.getName())) continue;
                this.table.setSortDirection(this.sortColumn.isSortAscending() ? 128 : 1024);
                this.table.setSortColumn(tcs[i]);
                return;
            }
            this.table.setSortColumn(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public boolean isRowVisible(TableRowCore row) {
        if (row.isInPaintItem()) {
            return true;
        }
        if (this.visibleRows == null) {
            return false;
        }
        for (TableRowSWT visibleRow : this.visibleRows) {
            if (row != visibleRow) continue;
            return !Utils.isThisThreadSWT() || this.isVisible();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visibleRowsChanged() {
        ArrayList<TableRowSWT> nowInVisibleRows;
        ArrayList<TableRowSWT> newlyVisibleRows = new ArrayList<TableRowSWT>();
        TableViewSWTImpl tableViewSWTImpl = this;
        synchronized (tableViewSWTImpl) {
            List<Object> visibleTableItems = this.isVisible() ? Utils.getVisibleTableItems(this.table) : Collections.emptyList();
            nowInVisibleRows = new ArrayList<TableRowSWT>(0);
            if (this.visibleRows != null) {
                nowInVisibleRows.addAll(Arrays.asList(this.visibleRows));
            }
            TableRowSWT[] rows = new TableRowSWT[visibleTableItems.size()];
            int pos = 0;
            for (TableItemOrTreeItem tableItemOrTreeItem : visibleTableItems) {
                TableRowCore row = this.getRow(tableItemOrTreeItem);
                if (!(row instanceof TableRowSWT)) continue;
                rows[pos++] = (TableRowSWT)row;
                boolean removed = nowInVisibleRows.remove(row);
                if (removed) continue;
                newlyVisibleRows.add((TableRowSWT)row);
            }
            if (pos < rows.length) {
                TableRowSWT[] temp = new TableRowSWT[pos];
                System.arraycopy(rows, 0, temp, 0, pos);
                this.visibleRows = temp;
            } else {
                this.visibleRows = rows;
            }
        }
        boolean bTableUpdate = false;
        for (TableRowSWT row : newlyVisibleRows) {
            row.refresh(true, true);
            if (row instanceof TableRowImpl) {
                ((TableRowImpl)row).setShown(true, false);
            }
            if (!Constants.isOSX) continue;
            bTableUpdate = true;
        }
        for (TableRowSWT row : nowInVisibleRows) {
            if (!(row instanceof TableRowImpl)) continue;
            ((TableRowImpl)row).setShown(false, false);
        }
        if (bTableUpdate) {
            this.table.update();
        }
    }

    @Override
    public Image obfusticatedImage(Image image) {
        if (this.table.getItemCount() == 0 || !this.isVisible()) {
            return image;
        }
        TableColumnOrTreeColumn[] tableColumnsSWT = this.table.getColumns();
        for (int i = 0; i < tableColumnsSWT.length; ++i) {
            int iTopIndex;
            int iBottomIndex;
            int size;
            TableColumnCore tc = (TableColumnCore)tableColumnsSWT[i].getData("TableColumnCore");
            if (tc == null || !tc.isObfusticated() || (size = (iBottomIndex = Utils.getTableBottomIndex(this.table, iTopIndex = this.table.getTopIndex())) - iTopIndex + 1) <= 0 || iTopIndex < 0) continue;
            for (int j = iTopIndex; j <= iBottomIndex; ++j) {
                TableCellSWT cell;
                String text;
                TableItemOrTreeItem rowSWT = this.table.getItem(j);
                TableRowSWT row = (TableRowSWT)this.table.getItem(j).getData("TableRow");
                if (row == null || row.isRowDisposed() || (text = (cell = row.getTableCellSWT(tc.getName())).getObfusticatedText()) == null) continue;
                Rectangle columnBounds = rowSWT.getBounds(i);
                if (columnBounds.y + columnBounds.height > this.clientArea.y + this.clientArea.height) {
                    columnBounds.height -= columnBounds.y + columnBounds.height - (this.clientArea.y + this.clientArea.height);
                }
                if (columnBounds.x + columnBounds.width > this.clientArea.x + this.clientArea.width) {
                    columnBounds.width -= columnBounds.x + columnBounds.width - (this.clientArea.x + this.clientArea.width);
                }
                Point location = Utils.getLocationRelativeToShell(this.table.getComposite());
                columnBounds.x += location.x;
                columnBounds.y += location.y;
                UIDebugGenerator.obfusticateArea(this.table.getDisplay(), image, columnBounds, text);
            }
        }
        IView view = this.getActiveSubView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + view, e);
            }
        }
        return image;
    }

    void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        diag_logger.log(SystemTime.getCurrentTime() + ":" + this.sTableID + ": " + s);
        System.out.println(SystemTime.getCurrentTime() + ": " + this.sTableID + ": " + s);
    }

    public boolean isEnableTabViews() {
        return this.bEnableTabViews;
    }

    @Override
    public void setEnableTabViews(boolean enableTabViews) {
        this.bEnableTabViews = enableTabViews;
    }

    @Override
    public IView[] getCoreTabViews() {
        return this.coreTabViews;
    }

    @Override
    public void setCoreTabViews(IView[] coreTabViews) {
        this.coreTabViews = coreTabViews;
    }

    @Override
    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.listenersMenuFill.add(l);
    }

    @Override
    public boolean isDisposed() {
        return this.mainComposite == null || this.mainComposite.isDisposed() || this.table == null || this.table.isDisposed();
    }

    @Override
    public int size(boolean bIncludeQueue) {
        int size = this.sortedRows.size();
        if (bIncludeQueue) {
            if (this.dataSourcesToAdd != null) {
                size += this.dataSourcesToAdd.size();
            }
            if (this.dataSourcesToRemove != null) {
                size -= this.dataSourcesToRemove.size();
            }
        }
        return size;
    }

    @Override
    public String getPropertiesPrefix() {
        return this.sPropertiesPrefix;
    }

    @Override
    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.listenersKey.contains(listener)) {
            return;
        }
        this.listenersKey.add(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.listenersKey.remove(listener);
    }

    @Override
    public TableColumnCore getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void selectAll() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.selectAll();
            this.updateSelectedRows(this.getRows(), true);
        }
    }

    @Override
    public boolean isTableFocus() {
        return this.table.isFocusControl();
    }

    @Override
    public DragSource createDragSource(int style) {
        final DragSource dragSource = new DragSource(this.table.getComposite(), style);
        dragSource.addDragListener(new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event2) {
                TableViewSWTImpl.this.table.setCursor(null);
                TableViewSWTImpl.this.isDragging = true;
            }

            public void dragFinished(DragSourceEvent event2) {
                TableViewSWTImpl.this.isDragging = false;
            }
        });
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dragSource.isDisposed()) {
                    dragSource.dispose();
                }
            }
        });
        return dragSource;
    }

    @Override
    public DropTarget createDropTarget(int style) {
        final DropTarget dropTarget = new DropTarget(this.table.getComposite(), style);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!dropTarget.isDisposed()) {
                    dropTarget.dispose();
                }
            }
        });
        return dropTarget;
    }

    @Override
    public TableRowCore getRow(DropTargetEvent event2) {
        TableItemOrTreeItem ti = TableOrTreeUtils.getEventItem(event2.item);
        if (ti != null) {
            return (TableRowCore)ti.getData("TableRow");
        }
        return null;
    }

    @Override
    public boolean dataSourceExists(DATASOURCETYPE dataSource) {
        return this.mapDataSourceToRow.containsKey(dataSource) || this.dataSourcesToAdd.contains(dataSource);
    }

    @Override
    public TableColumnCore[] getVisibleColumns() {
        return this.tableColumns;
    }

    protected TableViewSWTPanelCreator getMainPanelCreator() {
        return this.mainPanelCreator;
    }

    @Override
    public void setMainPanelCreator(TableViewSWTPanelCreator mainPanelCreator) {
        this.mainPanelCreator = mainPanelCreator;
    }

    @Override
    public TableCellCore getTableCellWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableCell(pt.x, pt.y);
    }

    @Override
    public TableRowCore getTableRowWithCursor() {
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        return this.getTableRow(pt.x, pt.y, true);
    }

    @Override
    public Point getTableCellMouseOffset(TableCellSWT tableCell) {
        if (tableCell == null) {
            return null;
        }
        Point pt = this.table.getDisplay().getCursorLocation();
        pt = this.table.toControl(pt);
        Rectangle bounds = tableCell.getBounds();
        int x = pt.x - bounds.x;
        if (x < 0 || x > bounds.width) {
            return null;
        }
        int y = pt.y - bounds.y;
        if (y < 0 || y > bounds.height) {
            return null;
        }
        return new Point(x, y);
    }

    @Override
    public Class<?> getDataSourceType() {
        return this.classPluginDataSourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            this.refreshListeners.add(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRefreshListener(TableRowRefreshListener listener) {
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                Object var3_2 = null;
                this.listeners_mon.exit();
                return;
            }
            this.refreshListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Object var3_3 = null;
        this.listeners_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeRefreshListeners(TableRowCore row) {
        Object[] listeners;
        try {
            this.listeners_mon.enter();
            if (this.refreshListeners == null) {
                Object var4_2 = null;
                this.listeners_mon.exit();
                return;
            }
            listeners = this.refreshListeners.toArray();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        Object var4_3 = null;
        this.listeners_mon.exit();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                TableRowRefreshListener l = (TableRowRefreshListener)listeners[i];
                l.rowRefresh(row);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean isVisible() {
        boolean wasVisible = this.isVisible;
        boolean bl = this.isVisible = this.table != null && !this.table.isDisposed() && this.table.isVisible() && !this.shell.getMinimized();
        if (this.isVisible != wasVisible) {
            this.visibleRowsChanged();
            if (this.isVisible) {
                this.loopFactor = 0;
                IView view = this.getActiveSubView();
                if (view instanceof IViewExtension) {
                    ((IViewExtension)((Object)view)).viewActivated();
                }
            } else {
                IView view = this.getActiveSubView();
                if (view instanceof IViewExtension) {
                    ((IViewExtension)((Object)view)).viewDeactivated();
                }
            }
        }
        return this.isVisible;
    }

    public void showRow(final TableRowCore row) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                int index = row.getIndex();
                if (index >= 0 && index < TableViewSWTImpl.this.table.getItemCount()) {
                    TableViewSWTImpl.this.table.showItem(TableViewSWTImpl.this.table.getItem(index));
                }
            }
        });
    }

    public boolean isMenuEnabled() {
        return this.menuEnabled;
    }

    public void setMenuEnabled(boolean menuEnabled) {
        this.menuEnabled = menuEnabled;
    }

    private void openFilterDialog() {
        if (this.filter == null) {
            return;
        }
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow();
        entryWindow.initTexts("MyTorrentsView.dialog.setFilter.title", null, "MyTorrentsView.dialog.setFilter.text", new String[]{MessageText.getString(this.getTableID() + "View" + ".header")});
        entryWindow.setPreenteredText(this.filter.text, false);
        entryWindow.prompt();
        if (!entryWindow.hasSubmittedInput()) {
            return;
        }
        String message = entryWindow.getSubmittedInput();
        if (message == null) {
            message = "";
        }
        this.setFilterText(message);
    }

    private void handleSearchKeyPress(KeyEvent e) {
        if (this.filter == null || e.widget == this.filter.widget) {
            return;
        }
        String newText = null;
        if (e.keyCode == 8) {
            if (e.stateMask == 262144) {
                newText = "";
            } else if (this.filter.nextText.length() > 0) {
                newText = this.filter.nextText.substring(0, this.filter.nextText.length() - 1);
            }
        } else if ((e.stateMask & 0xFFFDFFFF) == 0 && e.character > ' ') {
            newText = this.filter.nextText + String.valueOf(e.character);
        }
        if (newText == null) {
            return;
        }
        if (this.filter != null && this.filter.widget != null && !this.filter.widget.isDisposed()) {
            this.filter.widget.setFocus();
        }
        this.setFilterText(newText);
        e.doit = false;
    }

    @Override
    public void setFilterText(String s) {
        if (this.filter == null) {
            return;
        }
        this.filter.nextText = s;
        if (this.filter != null && this.filter.widget != null && !this.filter.widget.isDisposed()) {
            if (!this.filter.nextText.equals(this.filter.widget.getText())) {
                this.filter.widget.setText(this.filter.nextText);
                this.filter.widget.setSelection(this.filter.nextText.length());
            }
            if (this.filter.regex) {
                try {
                    Pattern.compile(this.filter.nextText, 2);
                    this.filter.widget.setBackground(COLOR_FILTER_REGEX);
                    Messages.setLanguageTooltip(this.filter.widget, "MyTorrentsView.filter.tooltip");
                }
                catch (Exception e) {
                    this.filter.widget.setBackground(Colors.colorErrorBG);
                    this.filter.widget.setToolTipText(e.getMessage());
                }
            } else {
                this.filter.widget.setBackground(null);
                Messages.setLanguageTooltip(this.filter.widget, "MyTorrentsView.filter.tooltip");
            }
        }
        if (this.filter.eventUpdate != null) {
            this.filter.eventUpdate.cancel();
        }
        this.filter.eventUpdate = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(300L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (TableViewSWTImpl.this.filter == null) {
                    return;
                }
                if (TableViewSWTImpl.this.filter.eventUpdate == null || TableViewSWTImpl.this.filter.eventUpdate.isCancelled()) {
                    TableViewSWTImpl.this.filter.eventUpdate = null;
                    return;
                }
                TableViewSWTImpl.this.filter.eventUpdate = null;
                if (TableViewSWTImpl.this.filter.nextText != null && !TableViewSWTImpl.this.filter.nextText.equals(TableViewSWTImpl.this.filter.text)) {
                    TableViewSWTImpl.this.filter.text = TableViewSWTImpl.this.filter.nextText;
                    TableViewSWTImpl.this.filter.checker.filterSet(TableViewSWTImpl.this.filter.text);
                    TableViewSWTImpl.this.refilter();
                }
            }
        });
    }

    @Override
    public String getFilterText() {
        return this.filter == null ? "" : this.filter.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refilter() {
        if (this.filter == null) {
            return;
        }
        if (this.filter.eventUpdate != null) {
            this.filter.eventUpdate.cancel();
        }
        this.filter.eventUpdate = null;
        this.listUnfilteredDatasources_mon.enter();
        try {
            Object[] unfilteredArray = this.listUnfilteredDataSources.toArray();
            HashSet existing = new HashSet(this.getDataSources());
            ArrayList<Object> listRemoves = new ArrayList<Object>();
            ArrayList<Object> listAdds = new ArrayList<Object>();
            for (int i = 0; i < unfilteredArray.length; ++i) {
                boolean bHave = existing.contains(unfilteredArray[i]);
                boolean isOurs = this.filter.checker.filterCheck(unfilteredArray[i], this.filter.text, this.filter.regex);
                if (!isOurs) {
                    if (!bHave) continue;
                    listRemoves.add(unfilteredArray[i]);
                    continue;
                }
                if (bHave) continue;
                listAdds.add(unfilteredArray[i]);
            }
            this.removeDataSources(listRemoves.toArray());
            this.addDataSources(listAdds.toArray(), true);
            this.listUnfilteredDataSources.addAll(listRemoves);
            Object var9_8 = null;
            this.listUnfilteredDatasources_mon.exit();
            this.processDataSourceQueue();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.listUnfilteredDatasources_mon.exit();
            this.processDataSourceQueue();
            throw throwable;
        }
    }

    @Override
    public void enableFilterCheck(Text txtFilter, TableViewFilterCheck<DATASOURCETYPE> filterCheck) {
        if (this.filter != null) {
            if (this.filter.widget != null && !this.filter.widget.isDisposed()) {
                this.filter.widget.removeKeyListener(this);
                this.filter.widget.removeModifyListener(this.filter.widgetModifyListener);
            }
        } else {
            this.filter = new filter();
        }
        this.filter.widget = txtFilter;
        if (txtFilter != null) {
            txtFilter.setMessage("Filter");
            txtFilter.addKeyListener(this);
            this.filter.widgetModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TableViewSWTImpl.this.setFilterText(((Text)e.widget).getText());
                }
            };
            txtFilter.addModifyListener(this.filter.widgetModifyListener);
            if (txtFilter.getText().length() == 0) {
                txtFilter.setText(this.filter.text);
            } else {
                this.filter.text = this.filter.nextText = txtFilter.getText();
            }
        } else {
            this.filter.nextText = "";
            this.filter.text = "";
        }
        this.filter.checker = filterCheck;
        this.filter.checker.filterSet(this.filter.text);
        this.refilter();
    }

    @Override
    public boolean enableSizeSlider(Composite composite, final int min, final int max) {
        try {
            if (this.sliderArea != null && !this.sliderArea.isDisposed()) {
                this.sliderArea.dispose();
            }
            Class<?> claTable = Class.forName("org.eclipse.swt.widgets." + (this.useTree ? "Tree" : "Table"));
            final Method method = claTable.getDeclaredMethod("setItemHeight", Integer.TYPE);
            method.setAccessible(true);
            composite.setLayout(new FormLayout());
            this.sliderArea = new Label(composite, 0);
            ((Label)this.sliderArea).setImage(ImageLoader.getInstance().getImage("zoom"));
            this.sliderArea.addListener(4, new Listener(){

                public void handleEvent(Event event2) {
                    final Shell shell = new Shell(TableViewSWTImpl.this.sliderArea.getShell(), 2048);
                    Listener l = new Listener(){

                        public void handleEvent(Event event2) {
                            if (event2.type == 7) {
                                Control curControl = event2.display.getCursorControl();
                                Point curPos = event2.display.getCursorLocation();
                                Point curPosRelShell = shell.toControl(curPos);
                                Rectangle bounds = shell.getBounds();
                                bounds.y = 0;
                                bounds.x = 0;
                                if (!bounds.contains(curPosRelShell)) {
                                    shell.dispose();
                                    return;
                                }
                                if (curControl != null && (curControl == shell || curControl.getParent() == shell)) {
                                    return;
                                }
                            }
                            shell.dispose();
                        }
                    };
                    shell.setBackgroundMode(2);
                    shell.setBackground(shell.getDisplay().getSystemColor(29));
                    shell.addListener(7, l);
                    shell.addListener(27, l);
                    FillLayout fillLayout = new FillLayout();
                    fillLayout.marginHeight = 4;
                    shell.setLayout(fillLayout);
                    final Scale slider = new Scale(shell, 512);
                    slider.addListener(7, l);
                    slider.addListener(27, l);
                    slider.setMinimum(min);
                    slider.setMaximum(max);
                    slider.setSelection(TableViewSWTImpl.this.getRowDefaultHeight());
                    try {
                        method.invoke((Object)TableViewSWTImpl.this.table.getComposite(), slider.getSelection());
                    }
                    catch (Throwable e1) {
                        // empty catch block
                    }
                    slider.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            TableViewSWTImpl.this.setRowDefaultHeight(slider.getSelection());
                            try {
                                method.invoke((Object)TableViewSWTImpl.this.table.getComposite(), slider.getSelection());
                            }
                            catch (Throwable e1) {
                                e1.printStackTrace();
                            }
                            TableViewSWTImpl.this.tableInvalidate();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    Point pt = TableViewSWTImpl.this.sliderArea.toDisplay(event2.x - 2, event2.y - 5);
                    int width = Constants.isOSX ? 20 : 50;
                    shell.setBounds(pt.x - width / 2, pt.y, width, 120);
                    shell.open();
                }
            });
            this.sliderArea.setLayoutData(Utils.getFilledFormData());
            composite.layout();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Override
    public void disableSizeSlider() {
        Utils.disposeSWTObjects(new Object[]{this.sliderArea});
    }

    @Override
    public void setEnabled(final boolean enable) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!TableViewSWTImpl.this.isDisposed()) {
                    TableViewSWTImpl.this.table.setEnabled(enable);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                this.rowMouseListeners = new ArrayList(1);
            }
            this.rowMouseListeners.add(listener);
            Object var3_2 = null;
            mon_RowMouseListener.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_RowMouseListener.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                Object var3_2 = null;
                mon_RowMouseListener.exit();
                return;
            }
            this.rowMouseListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mon_RowMouseListener.exit();
            throw throwable;
        }
        Object var3_3 = null;
        mon_RowMouseListener.exit();
    }

    private void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.rowPaintListeners == null) {
            return;
        }
        ArrayList<TableRowMouseListener> listeners = new ArrayList<TableRowMouseListener>(this.rowMouseListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                this.rowPaintListeners = new ArrayList(1);
            }
            this.rowPaintListeners.add(listener);
            Object var3_2 = null;
            mon_RowPaintListener.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_RowPaintListener.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                Object var3_2 = null;
                mon_RowPaintListener.exit();
                return;
            }
            this.rowPaintListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mon_RowPaintListener.exit();
            throw throwable;
        }
        Object var3_3 = null;
        mon_RowPaintListener.exit();
    }

    protected void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.rowPaintListeners == null) {
            return;
        }
        ArrayList<TableRowSWTPaintListener> listeners = new ArrayList<TableRowSWTPaintListener>(this.rowPaintListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowSWTPaintListener l = listeners.get(i);
                l.rowPaint(gc, row, column, cellArea);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public boolean canHaveSubItems() {
        return this.useTree;
    }

    protected TableColumnCore[] getColumnsOrdered() {
        return this.columnsOrdered;
    }

    @Override
    public void setSelectedRows(TableRowCore[] rows) {
        this.updateSelectedRows(rows, true);
    }

    private class ColumnMoveListener
    implements Listener {
        private ColumnMoveListener() {
        }

        public void handleEvent(Event event2) {
            int[] iColumnOrder;
            int iAddedPosition;
            TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(event2.widget);
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore == null) {
                return;
            }
            TableOrTreeSWT table = column.getParent();
            TableColumnOrTreeColumn[] tableColumns = table.getColumns();
            for (iAddedPosition = 0; iAddedPosition < tableColumns.length && column.getColumn() != tableColumns[iAddedPosition].getColumn(); ++iAddedPosition) {
            }
            if (iAddedPosition >= tableColumns.length) {
                return;
            }
            try {
                iColumnOrder = table.getColumnOrder();
            }
            catch (NoSuchMethodError e) {
                return;
            }
            for (int i = 0; i < iColumnOrder.length; ++i) {
                if (iColumnOrder[i] != iAddedPosition) continue;
                int iNewPosition = i - (TableViewSWTImpl.this.bSkipFirstColumn ? 1 : 0);
                if (tableColumnCore.getPosition() == iNewPosition) break;
                if (iNewPosition == -1) {
                    iColumnOrder[0] = 0;
                    iColumnOrder[1] = iAddedPosition;
                    table.setColumnOrder(iColumnOrder);
                    iNewPosition = 0;
                }
                tableColumnCore.setPositionNoShift(iNewPosition);
                tableColumnCore.saveSettings(null);
                TableStructureEventDispatcher.getInstance(TableViewSWTImpl.this.sTableID).columnOrderChanged(iColumnOrder);
                break;
            }
        }
    }

    private class ColumnSelectionListener
    implements Listener {
        private ColumnSelectionListener() {
        }

        public void handleEvent(Event event2) {
            int maskNoButton = event2.stateMask & ~SWT.BUTTON_MASK;
            if (maskNoButton != 0) {
                return;
            }
            TableColumnOrTreeColumn column = TableOrTreeUtils.getTableColumnEventItem(event2.widget);
            if (column == null) {
                return;
            }
            TableColumnCore tableColumnCore = (TableColumnCore)column.getData("TableColumnCore");
            if (tableColumnCore != null) {
                TableViewSWTImpl.this.sortColumnReverse(tableColumnCore);
                TableViewSWTImpl.this.columnVisibilitiesChanged = true;
                TableViewSWTImpl.this.refreshTable(true);
            }
        }
    }

    private static interface SourceReplaceListener {
        public void sourcesChanged();

        public void cleanup(Text var1);
    }

    class filter {
        Text widget = null;
        TimerEvent eventUpdate;
        String text = "";
        long lastFilterTime;
        boolean regex = false;
        TableViewFilterCheck<DATASOURCETYPE> checker;
        String nextText = "";
        ModifyListener widgetModifyListener;

        filter() {
        }
    }
}

