/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.dht.control.DHTControlContact;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.VivaldiPosition;
import com.aelitis.azureus.core.dht.netcoords.vivaldi.ver1.impl.HeightCoordinatesImpl;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;

public class VivaldiPanel {
    private static final int ALPHA_FOCUS = 255;
    private static final int ALPHA_NOFOCUS = 150;
    Display display;
    Composite parent;
    Canvas canvas;
    Scale scale;
    private boolean mouseLeftDown = false;
    private boolean mouseRightDown = false;
    private int xDown;
    private int yDown;
    private boolean antiAliasingAvailable = true;
    private List lastContacts;
    private DHTTransportContact lastSelf;
    private Image img;
    private int alpha = 255;
    private boolean autoAlpha = false;

    public VivaldiPanel(Composite parent) {
        this.parent = parent;
        this.display = parent.getDisplay();
        this.canvas = new Canvas(parent, 262144);
        this.scale = new Scale();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (VivaldiPanel.this.img != null && !VivaldiPanel.this.img.isDisposed()) {
                    Rectangle bounds = VivaldiPanel.this.img.getBounds();
                    if (bounds.width >= e.width && bounds.height >= e.height) {
                        if (VivaldiPanel.this.alpha != 255) {
                            try {
                                e.gc.setAlpha(VivaldiPanel.this.alpha);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        e.gc.drawImage(VivaldiPanel.this.img, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                } else {
                    e.gc.setBackground(VivaldiPanel.this.display.getSystemColor(22));
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                    e.gc.drawText(MessageText.getString("VivaldiView.notAvailable"), 10, 10, true);
                }
            }
        });
        this.canvas.addMouseListener(new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                if (event2.button == 1) {
                    VivaldiPanel.this.mouseLeftDown = true;
                }
                if (event2.button == 3) {
                    VivaldiPanel.this.mouseRightDown = true;
                }
                VivaldiPanel.this.xDown = event2.x;
                VivaldiPanel.this.yDown = event2.y;
                VivaldiPanel.this.scale.saveMinX = VivaldiPanel.this.scale.minX;
                VivaldiPanel.this.scale.saveMaxX = VivaldiPanel.this.scale.maxX;
                VivaldiPanel.this.scale.saveMinY = VivaldiPanel.this.scale.minY;
                VivaldiPanel.this.scale.saveMaxY = VivaldiPanel.this.scale.maxY;
                VivaldiPanel.this.scale.saveRotation = VivaldiPanel.this.scale.rotation;
            }

            public void mouseUp(MouseEvent event2) {
                if (event2.button == 1) {
                    VivaldiPanel.this.mouseLeftDown = false;
                }
                if (event2.button == 3) {
                    VivaldiPanel.this.mouseRightDown = false;
                }
                VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
            }
        });
        this.canvas.addListener(1, new Listener(){

            public void handleEvent(Event event2) {
            }
        });
        this.canvas.addListener(37, new Listener(){

            public void handleEvent(Event event2) {
                VivaldiPanel.this.scale.saveMinX = VivaldiPanel.this.scale.minX;
                VivaldiPanel.this.scale.saveMaxX = VivaldiPanel.this.scale.maxX;
                VivaldiPanel.this.scale.saveMinY = VivaldiPanel.this.scale.minY;
                VivaldiPanel.this.scale.saveMaxY = VivaldiPanel.this.scale.maxY;
                int deltaY = event2.count * 5;
                float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                if (scaleFactor <= 0.0f) {
                    scaleFactor = 0.01f;
                }
                float moveFactor = 1.0f - 1.0f / scaleFactor;
                float centerX = (VivaldiPanel.this.scale.saveMinX + VivaldiPanel.this.scale.saveMaxX) / 2.0f;
                VivaldiPanel.this.scale.minX = VivaldiPanel.this.scale.saveMinX + moveFactor * (centerX - VivaldiPanel.this.scale.saveMinX);
                VivaldiPanel.this.scale.maxX = VivaldiPanel.this.scale.saveMaxX - moveFactor * (VivaldiPanel.this.scale.saveMaxX - centerX);
                float centerY = (VivaldiPanel.this.scale.saveMinY + VivaldiPanel.this.scale.saveMaxY) / 2.0f;
                VivaldiPanel.this.scale.minY = VivaldiPanel.this.scale.saveMinY + moveFactor * (centerY - VivaldiPanel.this.scale.saveMinY);
                VivaldiPanel.this.scale.maxY = VivaldiPanel.this.scale.saveMaxY - moveFactor * (VivaldiPanel.this.scale.saveMaxY - centerY);
                VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event2) {
                int deltaY;
                int deltaX;
                if (VivaldiPanel.this.mouseLeftDown) {
                    deltaX = event2.x - VivaldiPanel.this.xDown;
                    deltaY = event2.y - VivaldiPanel.this.yDown;
                    int width = VivaldiPanel.this.scale.width;
                    int height = VivaldiPanel.this.scale.height;
                    float ratioX = (VivaldiPanel.this.scale.saveMaxX - VivaldiPanel.this.scale.saveMinX) / (float)width;
                    float ratioY = (VivaldiPanel.this.scale.saveMaxY - VivaldiPanel.this.scale.saveMinY) / (float)height;
                    float realDeltaX = (float)deltaX * ratioX;
                    float realDeltaY = (float)deltaY * ratioY;
                    VivaldiPanel.this.scale.minX = VivaldiPanel.this.scale.saveMinX - realDeltaX;
                    VivaldiPanel.this.scale.maxX = VivaldiPanel.this.scale.saveMaxX - realDeltaX;
                    VivaldiPanel.this.scale.minY = VivaldiPanel.this.scale.saveMinY - realDeltaY;
                    VivaldiPanel.this.scale.maxY = VivaldiPanel.this.scale.saveMaxY - realDeltaY;
                    VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
                }
                if (VivaldiPanel.this.mouseRightDown) {
                    deltaX = event2.x - VivaldiPanel.this.xDown;
                    VivaldiPanel.this.scale.rotation = VivaldiPanel.this.scale.saveRotation - (double)((float)deltaX / 100.0f);
                    deltaY = event2.y - VivaldiPanel.this.yDown;
                    float scaleFactor = 1.0f - (float)deltaY / 300.0f;
                    if (scaleFactor <= 0.0f) {
                        scaleFactor = 0.01f;
                    }
                    float moveFactor = 1.0f - 1.0f / scaleFactor;
                    float centerX = (VivaldiPanel.this.scale.saveMinX + VivaldiPanel.this.scale.saveMaxX) / 2.0f;
                    VivaldiPanel.this.scale.minX = VivaldiPanel.this.scale.saveMinX + moveFactor * (centerX - VivaldiPanel.this.scale.saveMinX);
                    VivaldiPanel.this.scale.maxX = VivaldiPanel.this.scale.saveMaxX - moveFactor * (VivaldiPanel.this.scale.saveMaxX - centerX);
                    float centerY = (VivaldiPanel.this.scale.saveMinY + VivaldiPanel.this.scale.saveMaxY) / 2.0f;
                    VivaldiPanel.this.scale.minY = VivaldiPanel.this.scale.saveMinY + moveFactor * (centerY - VivaldiPanel.this.scale.saveMinY);
                    VivaldiPanel.this.scale.maxY = VivaldiPanel.this.scale.saveMaxY - moveFactor * (VivaldiPanel.this.scale.saveMaxY - centerY);
                    VivaldiPanel.this.refreshContacts(VivaldiPanel.this.lastContacts, VivaldiPanel.this.lastSelf);
                }
            }
        });
        this.canvas.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                if (VivaldiPanel.this.autoAlpha) {
                    VivaldiPanel.this.setAlpha(150);
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (VivaldiPanel.this.autoAlpha) {
                    VivaldiPanel.this.setAlpha(255);
                }
            }
        });
    }

    public void setLayoutData(Object data) {
        this.canvas.setLayoutData(data);
    }

    public void refreshContacts(List contacts, DHTTransportContact self) {
        if (contacts == null || self == null) {
            return;
        }
        this.lastContacts = contacts;
        this.lastSelf = self;
        if (this.canvas.isDisposed()) {
            return;
        }
        Rectangle size = this.canvas.getBounds();
        if (size.isEmpty()) {
            return;
        }
        this.scale.width = size.width;
        this.scale.height = size.height;
        Color white = ColorCache.getColor(this.display, 255, 255, 255);
        Color blue = ColorCache.getColor(this.display, 66, 87, 104);
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        this.img = new Image((Device)this.display, size);
        GC gc = new GC(this.img);
        gc.setForeground(white);
        gc.setBackground(white);
        gc.fillRectangle(size);
        if (SWT.getVersion() < 3138 || this.antiAliasingAvailable) {
            // empty if block
        }
        gc.setForeground(blue);
        gc.setBackground(white);
        DHTNetworkPosition _ownPosition = self.getNetworkPosition((byte)1);
        if (_ownPosition == null) {
            return;
        }
        VivaldiPosition ownPosition = (VivaldiPosition)_ownPosition;
        float ownErrorEstimate = ownPosition.getErrorEstimate();
        HeightCoordinatesImpl ownCoords = (HeightCoordinatesImpl)ownPosition.getCoordinates();
        gc.drawText("Our error: " + ownErrorEstimate, 10, 10);
        Color black = ColorCache.getColor(this.display, 0, 0, 0);
        gc.setBackground(black);
        for (DHTControlContact contact : contacts) {
            VivaldiPosition position;
            HeightCoordinatesImpl coord;
            DHTNetworkPosition _position = contact.getTransportContact().getNetworkPosition((byte)1);
            if (_position == null || !(coord = (HeightCoordinatesImpl)(position = (VivaldiPosition)_position).getCoordinates()).isValid()) continue;
            this.draw(gc, coord.getX(), coord.getY(), coord.getH(), contact, (int)ownCoords.distance(coord), position.getErrorEstimate());
        }
        Color red = ColorCache.getColor(this.display, 255, 0, 0);
        gc.setForeground(red);
        this.drawSelf(gc, ownCoords.getX(), ownCoords.getY(), ownCoords.getH(), ownErrorEstimate);
        gc.dispose();
        this.canvas.redraw();
    }

    public void refresh(List vivaldiPositions) {
        if (this.canvas.isDisposed()) {
            return;
        }
        Rectangle size = this.canvas.getBounds();
        this.scale.width = size.width;
        this.scale.height = size.height;
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
        this.img = new Image((Device)this.display, size);
        GC gc = new GC(this.img);
        Color white = ColorCache.getColor(this.display, 255, 255, 255);
        gc.setForeground(white);
        gc.setBackground(white);
        gc.fillRectangle(size);
        Color blue = ColorCache.getColor(this.display, 66, 87, 104);
        gc.setForeground(blue);
        gc.setBackground(blue);
        for (VivaldiPosition position : vivaldiPositions) {
            HeightCoordinatesImpl coord = (HeightCoordinatesImpl)position.getCoordinates();
            float error = position.getErrorEstimate() - 0.1f;
            if (error < 0.0f) {
                error = 0.0f;
            }
            if (error > 1.0f) {
                error = 1.0f;
            }
            int blueComponent = (int)(255.0f - error * 255.0f);
            int redComponent = (int)(255.0f * error);
            Color drawColor = new Color(this.display, redComponent, 50, blueComponent);
            gc.setForeground(drawColor);
            this.draw(gc, coord.getX(), coord.getY(), coord.getH());
            drawColor.dispose();
        }
        gc.dispose();
        this.canvas.redraw();
    }

    private void draw(GC gc, float x, float y, float h) {
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.fillRectangle(x0 - 1, y0 - 1, 3, 3);
        gc.drawLine(x0, y0, x0, (int)((float)y0 - 200.0f * h / (this.scale.maxY - this.scale.minY)));
    }

    private void draw(GC gc, float x, float y, float h, DHTControlContact contact, int distance, float error) {
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        if (error > 1.0f) {
            error = 1.0f;
        }
        int errDisplay = (int)(100.0f * error);
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.fillRectangle(x0 - 1, y0 - 1, 3, 3);
        String text = distance + " ms \nerr:" + errDisplay + "%";
        int lineReturn = text.indexOf("\n");
        int xOffset = gc.getFontMetrics().getAverageCharWidth() * (lineReturn != -1 ? lineReturn : text.length()) / 2;
        gc.drawText(text, x0 - xOffset, y0, true);
    }

    private void drawSelf(GC gc, float x, float y, float h, float errorEstimate) {
        int x0 = this.scale.getX(x, y);
        int y0 = this.scale.getY(x, y);
        gc.drawLine(x0 - 15, y0, x0 + 15, y0);
        gc.drawLine(x0, y0 - 15, x0, y0 + 15);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw();
        }
    }

    public void setAutoAlpha(boolean autoAlpha) {
        this.autoAlpha = autoAlpha;
        if (autoAlpha) {
            this.setAlpha(this.canvas.getDisplay().getCursorControl() == this.canvas ? 255 : 150);
        }
    }

    public void delete() {
        if (this.img != null && !this.img.isDisposed()) {
            this.img.dispose();
        }
    }

    private class Scale {
        int width;
        int height;
        float minX = -1000.0f;
        float maxX = 1000.0f;
        float minY = -1000.0f;
        float maxY = 1000.0f;
        double rotation = 0.0;
        float saveMinX;
        float saveMaxX;
        float saveMinY;
        float saveMaxY;
        double saveRotation;

        private Scale() {
        }

        public int getX(float x, float y) {
            return (int)(((double)x * Math.cos(this.rotation) + (double)y * Math.sin(this.rotation) - (double)this.minX) / (double)(this.maxX - this.minX) * (double)this.width);
        }

        public int getY(float x, float y) {
            return (int)(((double)y * Math.cos(this.rotation) - (double)x * Math.sin(this.rotation) - (double)this.minY) / (double)(this.maxY - this.minY) * (double)this.height);
        }
    }
}

