/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;
import org.gudy.azureus2.ui.swt.views.stats.ActivityView;
import org.gudy.azureus2.ui.swt.views.stats.CacheView;
import org.gudy.azureus2.ui.swt.views.stats.DHTView;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiView;

public class StatsView
extends AbstractIView
implements IViewAlwaysInitialize {
    TabFolder folder;
    TabItem itemActivity;
    TabItem itemStats;
    TabItem itemCache;
    TabItem[] itemDHTs;
    TabItem[] itemVivaldis;
    ActivityView viewActivity;
    TransferStatsView viewStats;
    CacheView viewCache;
    DHTView[] viewDHTs;
    IView[] viewVivaldis;
    UpdateThread updateThread;
    private Object dataSource;

    public void initialize(Composite composite) {
        int i;
        int i2;
        this.folder = new TabFolder(composite, 16384);
        this.folder.setBackground(Colors.background);
        ArrayList<DHTView> dhts = new ArrayList<DHTView>();
        ArrayList<VivaldiView> vivaldis = new ArrayList<VivaldiView>();
        dhts.add(new DHTView(0));
        vivaldis.add(new VivaldiView(0));
        if (NetworkAdmin.getSingleton().hasDHTIPV6()) {
            dhts.add(new DHTView(3));
            vivaldis.add(new VivaldiView(3));
        }
        if (Constants.isCVSVersion()) {
            dhts.add(new DHTView(1));
            vivaldis.add(new VivaldiView(1));
        }
        this.viewDHTs = new DHTView[dhts.size()];
        this.viewVivaldis = new IView[vivaldis.size()];
        dhts.toArray(this.viewDHTs);
        vivaldis.toArray(this.viewVivaldis);
        this.itemActivity = new TabItem(this.folder, 0);
        this.itemStats = new TabItem(this.folder, 0);
        this.itemCache = new TabItem(this.folder, 0);
        this.itemDHTs = new TabItem[this.viewDHTs.length];
        for (i2 = 0; i2 < this.itemDHTs.length; ++i2) {
            this.itemDHTs[i2] = new TabItem(this.folder, 0);
        }
        this.itemVivaldis = new TabItem[this.viewVivaldis.length];
        for (i2 = 0; i2 < this.itemVivaldis.length; ++i2) {
            this.itemVivaldis[i2] = new TabItem(this.folder, 0);
        }
        this.viewActivity = new ActivityView();
        this.viewStats = new TransferStatsView();
        this.viewCache = new CacheView();
        Messages.setLanguageText(this.itemActivity, this.viewActivity.getData());
        Messages.setLanguageText(this.itemStats, this.viewStats.getData());
        Messages.setLanguageText(this.itemCache, this.viewCache.getData());
        for (i2 = 0; i2 < this.viewDHTs.length; ++i2) {
            Messages.setLanguageText(this.itemDHTs[i2], this.viewDHTs[i2].getData());
            Messages.setLanguageText(this.itemVivaldis[i2], this.viewVivaldis[i2].getData());
        }
        TabItem[] items = new TabItem[]{this.itemActivity};
        this.folder.setSelection(items);
        this.viewActivity.initialize(this.folder);
        this.itemActivity.setControl(this.viewActivity.getComposite());
        this.viewStats.initialize(this.folder);
        this.itemStats.setControl(this.viewStats.getComposite());
        this.viewCache.initialize(this.folder);
        this.itemCache.setControl(this.viewCache.getComposite());
        for (i = 0; i < this.viewDHTs.length; ++i) {
            this.viewDHTs[i].initialize(this.folder);
            this.itemDHTs[i].setControl(this.viewDHTs[i].getComposite());
        }
        for (i = 0; i < this.viewVivaldis.length; ++i) {
            this.viewVivaldis[i].initialize(this.folder);
            this.itemVivaldis[i].setControl(this.viewVivaldis[i].getComposite());
        }
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatsView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        this.viewActivity.getComposite().layout(true);
        for (i = 0; i < this.viewVivaldis.length; ++i) {
            this.viewVivaldis[i].getComposite().layout(true);
        }
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
        this.dataSourceChanged(this.dataSource);
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        try {
            int index = this.folder.getSelectionIndex();
            if (index == 0) {
                if (this.viewActivity != null && !this.itemActivity.isDisposed()) {
                    this.viewActivity.refresh();
                }
                return;
            }
            if (index == 1) {
                if (this.viewStats != null && !this.itemStats.isDisposed()) {
                    this.viewStats.refresh();
                }
                return;
            }
            if (index == 2) {
                if (this.viewCache != null && !this.itemCache.isDisposed()) {
                    this.viewCache.refresh();
                }
                return;
            }
            if (index - 3 < this.viewDHTs.length) {
                if (!this.itemDHTs[index - 3].isDisposed()) {
                    this.viewDHTs[index - 3].refresh();
                }
                return;
            }
            if (index - 3 - this.viewDHTs.length < this.viewVivaldis.length) {
                if (!this.itemVivaldis[index - 3 - this.viewDHTs.length].isDisposed()) {
                    this.viewVivaldis[index - 3 - this.viewDHTs.length].refresh();
                }
                return;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void showTransfers() {
        this.folder.setSelection(new TabItem[]{this.itemStats});
    }

    public void showDHT() {
        this.folder.setSelection(new TabItem[]{this.itemDHTs[0]});
    }

    public Composite getComposite() {
        return this.folder;
    }

    public String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    public void delete() {
        this.updateThread.stopIt();
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            TabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDisposed()) continue;
                items[i].dispose();
            }
        }
        this.viewActivity.delete();
        this.viewStats.delete();
        this.viewCache.delete();
        for (int i = 0; i < this.viewDHTs.length; ++i) {
            this.viewDHTs[i].delete();
        }
        if (!this.folder.isDisposed()) {
            Utils.disposeComposite(this.folder);
        }
    }

    public void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        if (this.folder == null) {
            return;
        }
        if (newDataSource instanceof String) {
            if ("dht".equals(newDataSource)) {
                this.showDHT();
            } else if ("transfers".equals(newDataSource)) {
                this.showTransfers();
            }
        }
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        public UpdateThread() {
            super("StatsView Update Thread");
        }

        public void run() {
            this.bContinue = true;
            while (this.bContinue) {
                try {
                    StatsView.this.viewActivity.periodicUpdate();
                    StatsView.this.viewCache.periodicUpdate();
                    StatsView.this.viewStats.periodicUpdate();
                    for (int i = 0; i < StatsView.this.viewDHTs.length; ++i) {
                        StatsView.this.viewDHTs[i].periodicUpdate();
                    }
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    break;
                }
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

