/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMemoryMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ConfigSectionStartShutdown
implements UISWTConfigSection {
    private static final String LBLKEY_PREFIX = "ConfigView.label.";

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "startstop";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 1;
    }

    public Composite configSectionCreate(Composite parent) {
        Label label;
        final Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData(gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cDisplay.setLayout(layout);
        final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean can_ral = platform.hasCapability(PlatformManagerCapabilities.RunAtLogin);
        if (can_ral) {
            Group gStartStop = new Group(cDisplay, 0);
            Messages.setLanguageText(gStartStop, "ConfigView.label.start");
            layout = new GridLayout(2, false);
            gStartStop.setLayout(layout);
            gStartStop.setLayoutData(new GridData(768));
            if (can_ral) {
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                BooleanParameter start_on_login = new BooleanParameter((Composite)gStartStop, "Start On Login", "ConfigView.label.start.onlogin");
                try {
                    start_on_login.setSelected(platform.getRunAtLogin());
                    start_on_login.addChangeListener(new ParameterChangeAdapter(){

                        public void booleanParameterChanging(Parameter p, boolean toValue) {
                            try {
                                platform.setRunAtLogin(toValue);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    start_on_login.setEnabled(false);
                    Debug.out(e);
                }
                start_on_login.setLayoutData(gridData);
            }
        }
        if (userMode > 0) {
            Group gPR = new Group(cDisplay, 0);
            Messages.setLanguageText(gPR, "ConfigView.label.pauseresume");
            layout = new GridLayout(2, false);
            gPR.setLayout(layout);
            gPR.setLayoutData(new GridData(768));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter pauseOnExit = new BooleanParameter((Composite)gPR, "Pause Downloads On Exit", "ConfigView.label.pause.downloads.on.exit");
            pauseOnExit.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter resumeOnStart = new BooleanParameter((Composite)gPR, "Resume Downloads On Start", "ConfigView.label.resume.downloads.on.start");
            resumeOnStart.setLayoutData(gridData);
        }
        if (userMode >= 0) {
            String[] action_values;
            Group gStop = new Group(cDisplay, 0);
            Messages.setLanguageText(gStop, "ConfigView.label.stop");
            layout = new GridLayout(2, false);
            gStop.setLayout(layout);
            gStop.setLayoutData(new GridData(768));
            gridData = new GridData();
            label = new Label(gStop, 0);
            Messages.setLanguageText(label, "ConfigView.label.stop.downcomp");
            label.setLayoutData(gridData);
            int shutdown_types = platform.getShutdownTypes();
            ArrayList<String> l_action_values = new ArrayList<String>();
            ArrayList<String> l_action_descs = new ArrayList<String>();
            l_action_values.add("Nothing");
            l_action_values.add("QuitVuze");
            if ((shutdown_types & 4) != 0) {
                l_action_values.add("Sleep");
            }
            if ((shutdown_types & 2) != 0) {
                l_action_values.add("Hibernate");
            }
            if ((shutdown_types & 1) != 0) {
                l_action_values.add("Shutdown");
            }
            for (String s : action_values = l_action_values.toArray(new String[l_action_values.size()])) {
                l_action_descs.add(MessageText.getString("ConfigView.label.stop." + s));
            }
            String[] action_descs = l_action_descs.toArray(new String[l_action_descs.size()]);
            new StringListParameter((Composite)gStop, "On Downloading Complete Do", "Nothing", action_descs, action_values);
            gridData = new GridData();
            label = new Label(gStop, 0);
            Messages.setLanguageText(label, "ConfigView.label.stop.seedcomp");
            label.setLayoutData(gridData);
            new StringListParameter((Composite)gStop, "On Seeding Complete Do", "Nothing", action_descs, action_values);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter resetOnTrigger = new BooleanParameter((Composite)gStop, "Stop Triggers Auto Reset", "!" + MessageText.getString("ConfigView.label.stop.autoreset", new String[]{MessageText.getString("ConfigView.label.stop.Nothing")}) + "!");
            resetOnTrigger.setLayoutData(gridData);
        }
        if (userMode > 0 && platform.hasCapability(PlatformManagerCapabilities.AccessExplicitVMOptions)) {
            Group gJVM = new Group(cDisplay, 0);
            Messages.setLanguageText(gJVM, "ConfigView.label.jvm");
            layout = new GridLayout(2, false);
            gJVM.setLayout(layout);
            gJVM.setLayoutData(new GridData(768));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            LinkLabel link = new LinkLabel(gJVM, gridData, "ConfigView.label.please.visit.here", "http://wiki.vuze.com/w/Java_VM_memory_usage");
            label = new Label(gJVM, 0);
            Messages.setLanguageText(label, "jvm.info");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData(gridData);
            try {
                final File option_file = platform.getVMOptionFile();
                final Group gJVMOptions = new Group(gJVM, 0);
                layout = new GridLayout(3, false);
                gJVMOptions.setLayout(layout);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gJVMOptions.setLayoutData(gridData);
                this.buildOptions(cDisplay, platform, gJVMOptions, false);
                label = new Label(gJVM, 0);
                Messages.setLanguageText((Widget)label, "jvm.show.file", new String[]{option_file.getAbsolutePath()});
                Button show_folder_button = new Button(gJVM, 8);
                Messages.setLanguageText(show_folder_button, "MyTorrentsView.menu.explore");
                show_folder_button.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ManagerUtils.open(option_file);
                    }
                });
                label = new Label(gJVM, 0);
                Messages.setLanguageText(label, "jvm.reset");
                Button reset_button = new Button(gJVM, 8);
                Messages.setLanguageText(reset_button, "Button.reset");
                reset_button.addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            platform.setExplicitVMOptions(new String[0]);
                            ConfigSectionStartShutdown.this.buildOptions(cDisplay, platform, gJVMOptions, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
                label = new Label(gJVM, 0);
                Messages.setLanguageText((Widget)label, "jvm.error", new String[]{Debug.getNestedExceptionMessage(e)});
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                label.setLayoutData(gridData);
            }
        }
        return cDisplay;
    }

    private void buildOptions(final Composite parent, final PlatformManager platform, final Composite area, boolean rebuild) throws PlatformManagerException {
        if (rebuild) {
            Control[] kids;
            for (Control k : kids = area.getChildren()) {
                k.dispose();
            }
        }
        String[] options = platform.getExplicitVMOptions();
        long max_mem = AEMemoryMonitor.getJVMLongOption(options, "-Xmx");
        int MIN_MAX_JVM = 0x2000000;
        GridData gridData = new GridData();
        Label label = new Label(area, 0);
        label.setLayoutData(gridData);
        Messages.setLanguageText((Widget)label, "jvm.max.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)});
        gridData = new GridData();
        gridData.widthHint = 125;
        final StringParameter max_vm = new StringParameter(area, "jvm.max.mem", "", false);
        max_vm.setLayoutData(gridData);
        max_vm.setValue(max_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_mem));
        max_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_vm.isDisposed()) {
                    max_vm.removeChangeListener(this);
                    return;
                }
                String val = max_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long max_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (max_mem < 0x2000000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    long min_mem = AEMemoryMonitor.getJVMLongOption(options = AEMemoryMonitor.setJVMLongOption(options, "-Xmx", max_mem), "-Xms");
                    if (min_mem == -1L || min_mem > max_mem) {
                        options = AEMemoryMonitor.setJVMLongOption(options, "-Xms", max_mem);
                    }
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.max.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label = new Label(area, 0);
        gridData = new GridData(768);
        label.setLayoutData(gridData);
        Long max_heap_mb = AEMemoryMonitor.getMaxHeapMB();
        if (max_heap_mb > 0L) {
            Messages.setLanguageText((Widget)label, "jvm.max.mem.current", new String[]{DisplayFormatters.formatByteCountToKiBEtc(max_heap_mb * 1024L * 1024L, true)});
        }
        int MIN_MIN_JVM = 0x800000;
        long min_mem = AEMemoryMonitor.getJVMLongOption(options, "-Xms");
        gridData = new GridData();
        label = new Label(area, 0);
        label.setLayoutData(gridData);
        Messages.setLanguageText((Widget)label, "jvm.min.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x800000L)});
        gridData = new GridData();
        gridData.widthHint = 125;
        final StringParameter min_vm = new StringParameter(area, "jvm.min.mem", "", false);
        min_vm.setLayoutData(gridData);
        min_vm.setValue(min_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(min_mem));
        min_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (min_vm.isDisposed()) {
                    min_vm.removeChangeListener(this);
                    return;
                }
                String val = min_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long min_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (min_mem < 0x800000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x800000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    long max_mem = AEMemoryMonitor.getJVMLongOption(options = AEMemoryMonitor.setJVMLongOption(options, "-Xms", min_mem), "-Xmx");
                    if (max_mem == -1L || max_mem < min_mem) {
                        options = AEMemoryMonitor.setJVMLongOption(options, "-Xmx", min_mem);
                    }
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.min.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label = new Label(area, 0);
        gridData = new GridData(768);
        label.setLayoutData(gridData);
        int MIN_DIRECT_JVM = 0x2000000;
        String OPTION_KEY = "-XX:MaxDirectMemorySize=";
        long max_direct = AEMemoryMonitor.getJVMLongOption(options, "-XX:MaxDirectMemorySize=");
        GridData gridData2 = new GridData();
        Label label2 = new Label(area, 0);
        label2.setLayoutData(gridData2);
        Messages.setLanguageText((Widget)label2, "jvm.max.direct.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)});
        gridData2 = new GridData();
        gridData2.widthHint = 125;
        final StringParameter max_direct_vm = new StringParameter(area, "jvm.max.direct.mem", "", false);
        max_direct_vm.setLayoutData(gridData2);
        max_direct_vm.setValue(max_direct == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_direct));
        max_direct_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_direct_vm.isDisposed()) {
                    max_direct_vm.removeChangeListener(this);
                    return;
                }
                String val = max_direct_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long max_direct = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (max_direct < 0x2000000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    options = AEMemoryMonitor.setJVMLongOption(options, "-XX:MaxDirectMemorySize=", max_direct);
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.max.direct.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label2 = new Label(area, 0);
        gridData2 = new GridData(768);
        label2.setLayoutData(gridData2);
        Messages.setLanguageText(label2, "jvm.max.direct.mem.info");
        Label label3 = new Label(area, 0);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        label3.setLayoutData(gridData3);
        Messages.setLanguageText(label3, "jvm.options.summary");
        for (String option : options) {
            label3 = new Label(area, 0);
            label3.setText(option);
            gridData3 = new GridData();
            gridData3.horizontalSpan = 3;
            gridData3.horizontalIndent = 20;
            label3.setLayoutData(gridData3);
        }
        if (rebuild) {
            parent.layout(true, true);
        }
    }

    private static String encodeDisplayLong(long val) {
        if (val < 1024L) {
            return String.valueOf(val);
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " KB";
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " MB";
        }
        return String.valueOf(val /= 1024L) + " GB";
    }

    private static long decodeDisplayLong(String val) throws Exception {
        char[] chars = val.trim().toCharArray();
        String digits = "";
        String units = "";
        for (char c : chars) {
            if (Character.isDigit(c)) {
                if (units.length() > 0) {
                    throw new Exception("Invalid unit");
                }
                digits = digits + c;
                continue;
            }
            if (digits.length() == 0) {
                throw new Exception("Missing digits");
            }
            if (units.length() == 0 && Character.isWhitespace(c)) continue;
            units = units + c;
        }
        long value = Long.parseLong(digits);
        if (units.length() == 0) {
            units = "m";
        }
        if (units.length() > 0) {
            char c = Character.toLowerCase(units.charAt(0));
            if (c == 'k') {
                value *= 1024L;
            } else if (c == 'm') {
                value = value * 1024L * 1024L;
            } else if (c == 'g') {
                value = value * 1024L * 1024L * 1024L;
            } else {
                throw new Exception("Invalid size unit '" + units + "'");
            }
        }
        return value;
    }
}

