/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceTables
implements UISWTConfigSection {
    private static final String MSG_PREFIX = "ConfigView.section.style.";

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "tables";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean isAZ3 = COConfigurationManager.getStringParameter("ui").equals("az3");
        Composite cSection = new Composite(parent, 0);
        cSection.setLayoutData(new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cSection.setLayout(layout);
        Label label = new Label(cSection, 0);
        Messages.setLanguageText(label, "ConfigView.section.style.defaultSortOrder");
        int[] sortOrderValues = new int[]{0, 1, 2};
        String[] sortOrderLabels = new String[]{MessageText.getString("ConfigView.section.style.defaultSortOrder.asc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.desc"), MessageText.getString("ConfigView.section.style.defaultSortOrder.flip")};
        new IntListParameter(cSection, "config.style.table.defaultSortOrder", sortOrderLabels, sortOrderValues);
        if (userMode > 0) {
            label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.guiUpdate");
            int[] values = new int[]{100, 250, 500, 1000, 2000, 5000, 10000, 15000};
            String[] labels = new String[]{"100 ms", "250 ms", "500 ms", "1 s", "2 s", "5 s", "10 s", "15 s"};
            new IntListParameter(cSection, "GUI Refresh", 1000, labels, values);
            label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.graphicsUpdate");
            GridData gridData = new GridData();
            IntParameter graphicUpdate = new IntParameter(cSection, "Graphics Update", 1, -1);
            graphicUpdate.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.reOrderDelay");
            gridData = new GridData();
            IntParameter reorderDelay = new IntParameter(cSection, "ReOrder Delay");
            reorderDelay.setLayoutData(gridData);
            new BooleanParameter(cSection, "NameColumn.showProgramIcon", "ConfigView.section.style.showProgramIcon").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        if (Constants.isWindows) {
            new BooleanParameter(cSection, "Table.extendedErase", "ConfigView.section.style.extendedErase").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        Group cLibrary = new Group(cSection, 0);
        Messages.setLanguageText(cLibrary, "ConfigView.section.style.library");
        layout = new GridLayout();
        layout.numColumns = 2;
        cLibrary.setLayout(layout);
        cLibrary.setLayoutData(new GridData(16384, 128, false, false, 2, 1));
        label = new Label(cLibrary, 0);
        Messages.setLanguageText(label, "ConfigView.label.dm.dblclick");
        String[] dblclickOptions = new String[]{"ConfigView.option.dm.dblclick.play", "ConfigView.option.dm.dblclick.details", "ConfigView.option.dm.dblclick.show"};
        String[] dblclickLabels = new String[dblclickOptions.length];
        String[] dblclickValues = new String[dblclickOptions.length];
        for (int i = 0; i < dblclickOptions.length; ++i) {
            dblclickLabels[i] = MessageText.getString(dblclickOptions[i]);
            dblclickValues[i] = "" + i;
        }
        new StringListParameter(cLibrary, "list.dm.dblclick", dblclickLabels, dblclickValues);
        new BooleanParameter((Composite)cLibrary, "Table.useTree", "ConfigView.section.style.useTree").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        if (userMode > 1) {
            new BooleanParameter((Composite)cLibrary, "DND Always In Incomplete", "ConfigView.section.style.DNDalwaysInIncomplete").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        new BooleanParameter((Composite)cLibrary, "MyTorrentsView.alwaysShowHeader", "ConfigView.label.alwaysShowLibraryHeader").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        if (isAZ3) {
            new BooleanParameter((Composite)cLibrary, "Library.CatInSideBar", "ConfigView.section.style.CatInSidebar").setLayoutData(new GridData(4, 16384, true, false, 2, 1));
        }
        return cSection;
    }
}

