/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.clientstats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.util.MapUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsDataSource;
import org.gudy.azureus2.ui.swt.views.clientstats.ClientStatsOverall;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Count;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Name;
import org.gudy.azureus2.ui.swt.views.clientstats.ColumnCS_Pct;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientStatsView
extends TableViewTab<ClientStatsDataSource>
implements TableLifeCycleListener,
GlobalManagerListener,
DownloadManagerPeerListener {
    private static final String CONFIG_FILE = "ClientStats.dat";
    private static final String CONFIG_FILE_ARCHIVE = "ClientStats_%1.dat";
    private static final int BLOOMFILTER_SIZE = 100000;
    private static final int BLOOMFILTER_PEERID_SIZE = 50000;
    private static final String TABLEID = "ClientStats";
    private AzureusCore core;
    private TableViewSWTImpl<ClientStatsDataSource> tv;
    private boolean columnsAdded;
    private Map<String, ClientStatsDataSource> mapData;
    private Composite parent;
    private BloomFilter bloomFilter;
    private BloomFilter bloomFilterPeerId;
    private ClientStatsOverall overall;
    private long startedListeningOn;
    private long totalTime;
    private long lastAdd;
    private GregorianCalendar calendar = new GregorianCalendar();
    private int lastAddMonth;

    public ClientStatsView() {
        super(TABLEID);
        this.initAndLoad();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                ClientStatsView.this.initColumns(core);
            }
        });
    }

    @Override
    public Composite initComposite(Composite composite) {
        this.parent = new Composite(composite, 2048);
        this.parent.setLayout(new FormLayout());
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            this.parent.setLayoutData(new GridData(4, 4, true, true));
        } else if (layout instanceof FormLayout) {
            this.parent.setLayoutData(Utils.getFilledFormData());
        }
        return this.parent;
    }

    @Override
    public void tableViewTabInitComplete() {
        Composite cTV = (Composite)this.parent.getChildren()[0];
        Composite cBottom = new Composite(this.parent, 0);
        FormData fd = Utils.getFilledFormData();
        fd.bottom = new FormAttachment(cBottom);
        cTV.setLayoutData(fd);
        fd = Utils.getFilledFormData();
        fd.top = null;
        cBottom.setLayoutData(fd);
        cBottom.setLayout(new FormLayout());
        Button btnCopy = new Button(cBottom, 8);
        btnCopy.setLayoutData(new FormData());
        btnCopy.setText("Copy");
        btnCopy.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore[] rows = ClientStatsView.this.tv.getRows();
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM yyyy").format(new Date()));
                sb.append("\n");
                sb.append("Hits,Client,Bytes Sent,Bytes Received,Bad Bytes\n");
                for (TableRowCore row : rows) {
                    ClientStatsDataSource stat = (ClientStatsDataSource)row.getDataSource();
                    if (stat == null) continue;
                    sb.append(stat.count);
                    sb.append(",");
                    sb.append(stat.client.replaceAll(",", ""));
                    sb.append(",");
                    sb.append(stat.bytesSent);
                    sb.append(",");
                    sb.append(stat.bytesReceived);
                    sb.append(",");
                    sb.append(stat.bytesDiscarded);
                    sb.append("\n");
                }
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        Button btnCopyShort = new Button(cBottom, 8);
        btnCopyShort.setLayoutData(new FormData());
        btnCopyShort.setText("Copy > 1%");
        btnCopyShort.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                StringBuilder sb = new StringBuilder();
                sb.append(new SimpleDateFormat("MMM ''yy").format(new Date()));
                sb.append("] ");
                sb.append(((ClientStatsView)ClientStatsView.this).overall.count);
                sb.append(": ");
                ClientStatsDataSource[] stats2 = ClientStatsView.this.mapData.values().toArray(new ClientStatsDataSource[0]);
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        if (o1.count == o2.count) {
                            return 0;
                        }
                        return o1.count > o2.count ? -1 : 1;
                    }
                });
                boolean first = true;
                for (ClientStatsDataSource stat : stats2) {
                    int pct = (int)((long)(stat.count * 1000) / ((ClientStatsView)ClientStatsView.this).overall.count);
                    if (pct < 10) continue;
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(DisplayFormatters.formatPercentFromThousands(pct));
                    sb.append(" ");
                    sb.append(stat.client);
                }
                Arrays.sort(stats2, new Comparator<ClientStatsDataSource>(){

                    @Override
                    public int compare(ClientStatsDataSource o1, ClientStatsDataSource o2) {
                        float v1 = (float)o1.bytesReceived / (float)o1.count;
                        float v2 = (float)o2.bytesReceived / (float)o2.count;
                        if (v1 == v2) {
                            return 0;
                        }
                        return v1 > v2 ? -1 : 1;
                    }
                });
                ClipboardCopy.copyToClipBoard(sb.toString());
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(btnCopy, 5);
        btnCopyShort.setLayoutData(fd);
    }

    @Override
    public TableViewSWT<ClientStatsDataSource> initYourTableView() {
        this.tv = new TableViewSWTImpl(ClientStatsDataSource.class, TABLEID, this.getPropertiesPrefix(), new TableColumnCore[0], "count", 0x10010002);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(AzureusCore core) {
        Class<ClientStatsView> clazz = ClientStatsView.class;
        synchronized (ClientStatsView.class) {
            if (this.columnsAdded) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.columnsAdded = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            UIManager uiManager = PluginInitializer.getDefaultInterface().getUIManager();
            TableManager tableManager = uiManager.getTableManager();
            tableManager.registerColumn(ClientStatsDataSource.class, "name", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Name(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "count", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Count(column);
                }
            });
            tableManager.registerColumn(ClientStatsDataSource.class, "percent", new TableColumnCreationListener(){

                public void tableColumnCreated(TableColumn column) {
                    new ColumnCS_Pct(column);
                }
            });
            TableColumnManager tcManager = TableColumnManager.getInstance();
            tcManager.setDefaultColumnNames(TABLEID, new String[]{"name", "percent", "count"});
            return;
        }
    }

    @Override
    public void tableViewDestroyed() {
        if (this.core == null) {
            return;
        }
        this.core.getGlobalManager().removeListener(this);
        List downloadManagers = this.core.getGlobalManager().getDownloadManagers();
        for (Object object : downloadManagers) {
            ((DownloadManager)object).removePeerListener(this);
        }
        this.save(CONFIG_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAndLoad() {
        Map<String, ClientStatsDataSource> map = this.mapData = new HashMap<String, ClientStatsDataSource>();
        synchronized (map) {
            Map map2 = FileUtil.readResilientConfigFile(CONFIG_FILE);
            this.totalTime = MapUtils.getMapLong(map2, "time", 0L);
            this.lastAdd = MapUtils.getMapLong(map2, "lastadd", 0L);
            if (this.lastAdd != 0L) {
                this.calendar.setTimeInMillis(this.lastAdd);
                this.lastAddMonth = this.calendar.get(2);
                Map mapBloom = MapUtils.getMapMap(map2, "bloomfilter", null);
                if (mapBloom != null) {
                    this.bloomFilter = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
                if ((mapBloom = MapUtils.getMapMap(map2, "bloomfilterPeerId", null)) != null) {
                    this.bloomFilterPeerId = BloomFilterFactory.deserialiseFromMap(mapBloom);
                }
            }
            if (this.bloomFilter == null) {
                this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
            }
            if (this.bloomFilterPeerId == null) {
                this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
            }
            this.overall = new ClientStatsOverall();
            List listSavedData = MapUtils.getMapList(map2, "data", null);
            if (listSavedData != null) {
                for (Object val : listSavedData) {
                    try {
                        Map mapVal = (Map)val;
                        if (mapVal == null) continue;
                        ClientStatsDataSource ds = new ClientStatsDataSource(mapVal);
                        ds.overall = this.overall;
                        if (this.mapData.containsKey(ds.client)) continue;
                        this.mapData.put(ds.client, ds);
                        this.overall.count += (long)ds.count;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, ClientStatsDataSource> map2 = this.mapData;
        synchronized (map2) {
            map.put("data", new ArrayList<ClientStatsDataSource>(this.mapData.values()));
            map.put("bloomfilter", this.bloomFilter.serialiseToMap());
            map.put("bloomfilterPeerId", this.bloomFilterPeerId.serialiseToMap());
            map.put("lastadd", SystemTime.getCurrentTime());
            if (this.startedListeningOn > 0L) {
                map.put("time", this.totalTime + (SystemTime.getCurrentTime() - this.startedListeningOn));
            } else {
                map.put("time", this.totalTime);
            }
        }
        FileUtil.writeResilientConfigFile(filename, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableViewInitialized() {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            if (this.mapData.values().size() > 0) {
                this.tv.addDataSources((ClientStatsDataSource[])this.mapData.values().toArray(new ClientStatsDataSource[0]));
            }
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                ClientStatsView.this.register(core);
            }
        });
    }

    protected void register(AzureusCore core) {
        this.core = core;
        core.getGlobalManager().addListener(this);
        this.startedListeningOn = SystemTime.getCurrentTime();
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        if (!dm.getDownloadState().getFlag(16L)) {
            dm.addPeerListener(this, true);
        }
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePeerListener(this);
    }

    @Override
    public void seedingStatusChanged(boolean seedingOnlyMode, boolean potentiallySeedingOnlyMode) {
    }

    @Override
    public void peerAdded(PEPeer peer) {
        peer.addListener(new PEPeerListener(){

            public void stateChanged(PEPeer peer, int newState) {
                if (newState == 30) {
                    ClientStatsView.this.addPeer(peer);
                } else if (newState == 40 || newState == 50) {
                    peer.removeListener(this);
                }
            }

            public void sentBadChunk(PEPeer peer, int pieceNum, int totalBadChunks) {
            }

            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }

            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer(PEPeer peer) {
        byte[] bloomId;
        long now = SystemTime.getCurrentTime();
        byte[] peerId = peer.getId();
        InetAddress ip = peer.getAlternativeIPv6();
        if (ip == null) {
            try {
                ip = InetAddress.getByName(peer.getIp());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (ip == null) {
            bloomId = peerId;
        } else {
            byte[] address = ip.getAddress();
            bloomId = new byte[8 + address.length];
            System.arraycopy(peerId, 0, bloomId, 0, 8);
            System.arraycopy(address, 0, bloomId, 8, address.length);
        }
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            boolean needNew;
            this.calendar.setTimeInMillis(now);
            int thisMonth = this.calendar.get(2);
            if (thisMonth != this.lastAddMonth) {
                if (this.lastAddMonth == 0) {
                    this.lastAddMonth = thisMonth;
                } else {
                    String s = new SimpleDateFormat("yyyy-MM").format(new Date(this.lastAdd));
                    String filename = CONFIG_FILE_ARCHIVE.replace("%1", s);
                    this.save(filename);
                    this.lastAddMonth = thisMonth;
                    this.lastAdd = 0L;
                    this.bloomFilter = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(100000), 2);
                    this.bloomFilterPeerId = BloomFilterFactory.createRotating(BloomFilterFactory.createAddOnly(50000), 2);
                    this.overall = new ClientStatsOverall();
                    this.mapData.clear();
                    this.tv.removeAllTableRows();
                    this.totalTime = 0L;
                    this.startedListeningOn = 0L;
                }
            }
            if (this.bloomFilter.contains(bloomId) || this.bloomFilterPeerId.contains(peerId)) {
                return;
            }
            this.bloomFilter.add(bloomId);
            this.bloomFilterPeerId.add(peerId);
            this.lastAdd = now;
            String id = this.getID(peer);
            ClientStatsDataSource stat = this.mapData.get(id);
            boolean bl = needNew = stat == null;
            if (needNew) {
                stat = new ClientStatsDataSource();
                stat.overall = this.overall;
                this.mapData.put(id, stat);
            }
            ++this.overall.count;
            stat.client = this.getID(peer);
            ++stat.count;
            ++stat.current;
            if (needNew) {
                this.tv.addDataSource(stat);
            } else {
                TableRowCore row = this.tv.getRow(stat);
                if (row != null) {
                    row.invalidate();
                }
            }
        }
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerRemoved(PEPeer peer) {
        Map<String, ClientStatsDataSource> map = this.mapData;
        synchronized (map) {
            ClientStatsDataSource stat = this.mapData.get(this.getID(peer));
            if (stat != null) {
                --stat.current;
                stat.bytesReceived += peer.getStats().getTotalDataBytesReceived();
                stat.bytesSent += peer.getStats().getTotalDataBytesSent();
                stat.bytesDiscarded += peer.getStats().getTotalBytesDiscarded();
                TableRowCore row = this.tv.getRow(stat);
                if (row != null) {
                    row.invalidate();
                }
            }
        }
    }

    private String getID(PEPeer peer) {
        String s = peer.getClient();
        return s.replaceAll(" v?[0-9._]+", "");
    }
}

