/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreOperationTask;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class FilesViewMenuUtil {
    public static final Object PRIORITY_HIGH = 0;
    public static final Object PRIORITY_NORMAL = 1;
    public static final Object PRIORITY_NUMERIC = 99;
    public static final Object PRIORITY_SKIPPED = 2;
    public static final Object PRIORITY_DELETE = 3;

    public static void fillMenu(final TableView tv, Menu menu, final DownloadManager manager, final Object[] data_sources) {
        Shell shell = menu.getShell();
        boolean hasSelection = data_sources.length > 0;
        MenuItem itemOpen = new MenuItem(menu, 8);
        Messages.setLanguageText(itemOpen, "FilesView.menu.open");
        Utils.setMenuItemImage(itemOpen, "run");
        menu.setDefaultItem(itemOpen);
        final boolean use_open_containing_folder = COConfigurationManager.getBooleanParameter("MyTorrentsView.menu.show_parent_folder_enabled");
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText(itemExplore, "MyTorrentsView.menu." + (use_open_containing_folder ? "open_parent_folder" : "explore"));
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = data_sources.length - 1; i >= 0; --i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null) continue;
                    ManagerUtils.open(info, use_open_containing_folder);
                }
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemRenameOrRetarget = null;
        MenuItem itemRename = null;
        MenuItem itemRetarget = null;
        itemRenameOrRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRenameOrRetarget, "FilesView.menu.rename");
        itemRenameOrRetarget.setData("rename", true);
        itemRenameOrRetarget.setData("retarget", true);
        itemRename = new MenuItem(menu, 8);
        itemRetarget = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRename, "FilesView.menu.rename_only");
        Messages.setLanguageText(itemRetarget, "FilesView.menu.retarget");
        itemRename.setData("rename", true);
        itemRename.setData("retarget", false);
        itemRetarget.setData("rename", false);
        itemRetarget.setData("retarget", true);
        MenuItem itemPriority = new MenuItem(menu, 64);
        Messages.setLanguageText(itemPriority, "FilesView.menu.setpriority");
        Menu menuPriority = new Menu(shell, 4);
        itemPriority.setMenu(menuPriority);
        MenuItem itemHigh = new MenuItem(menuPriority, 64);
        itemHigh.setData("Priority", PRIORITY_HIGH);
        Messages.setLanguageText(itemHigh, "FilesView.menu.setpriority.high");
        MenuItem itemLow = new MenuItem(menuPriority, 64);
        itemLow.setData("Priority", PRIORITY_NORMAL);
        Messages.setLanguageText(itemLow, "FilesView.menu.setpriority.normal");
        MenuItem itemNumeric = new MenuItem(menuPriority, 64);
        itemNumeric.setData("Priority", PRIORITY_NUMERIC);
        Messages.setLanguageText(itemNumeric, "FilesView.menu.setpriority.numeric");
        MenuItem itemSkipped = new MenuItem(menuPriority, 64);
        itemSkipped.setData("Priority", PRIORITY_SKIPPED);
        Messages.setLanguageText(itemSkipped, "FilesView.menu.setpriority.skipped");
        MenuItem itemDelete = new MenuItem(menuPriority, 64);
        itemDelete.setData("Priority", PRIORITY_DELETE);
        Messages.setLanguageText(itemDelete, "wizard.multitracker.delete");
        new MenuItem(menu, 2);
        if (!hasSelection) {
            itemOpen.setEnabled(false);
            itemPriority.setEnabled(false);
            itemRenameOrRetarget.setEnabled(false);
            itemRename.setEnabled(false);
            itemRetarget.setEnabled(false);
            return;
        }
        boolean open = true;
        boolean all_compact = true;
        boolean all_skipped = true;
        boolean all_priority = true;
        boolean all_not_priority = true;
        DiskManagerFileInfo[] dmi_array = new DiskManagerFileInfo[data_sources.length];
        System.arraycopy(data_sources, 0, dmi_array, 0, data_sources.length);
        int[] storage_types = manager.getStorageType(dmi_array);
        for (int i = 0; i < dmi_array.length; ++i) {
            DiskManagerFileInfo file_info = dmi_array[i];
            if (open && file_info.getAccessMode() != 1) {
                open = false;
            }
            if (all_compact && storage_types[i] != 2 && storage_types[i] != 4) {
                all_compact = false;
            }
            if (!all_skipped && !all_priority && !all_not_priority) continue;
            if (file_info.isSkipped()) {
                all_priority = false;
                all_not_priority = false;
                continue;
            }
            all_skipped = false;
            if (!all_not_priority && !all_priority) continue;
            if (file_info.getPriority() > 0) {
                all_not_priority = false;
                continue;
            }
            all_priority = false;
        }
        itemOpen.setEnabled(open);
        itemRenameOrRetarget.setEnabled(manager.isPersistent());
        itemRename.setEnabled(manager.isPersistent());
        itemRetarget.setEnabled(manager.isPersistent());
        itemSkipped.setEnabled(!all_skipped);
        itemHigh.setEnabled(!all_priority);
        itemLow.setEnabled(!all_not_priority);
        itemDelete.setEnabled(!all_compact);
        itemOpen.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                for (int i = 0; i < data_sources.length; ++i) {
                    DiskManagerFileInfo info = (DiskManagerFileInfo)data_sources[i];
                    if (info == null || info.getAccessMode() != 1) continue;
                    Utils.launch(info);
                }
            }
        });
        Listener rename_listener = new Listener(){

            public void handleEvent(Event event2) {
                boolean rename_it = (Boolean)event2.widget.getData("rename");
                boolean retarget_it = (Boolean)event2.widget.getData("retarget");
                FilesViewMenuUtil.rename(tv, manager, data_sources, rename_it, retarget_it);
            }
        };
        itemRenameOrRetarget.addListener(13, rename_listener);
        itemRename.addListener(13, rename_listener);
        itemRetarget.addListener(13, rename_listener);
        Listener priorityListener = new Listener(){

            public void handleEvent(Event event2) {
                final int priority = (Integer)event2.widget.getData("Priority");
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        FilesViewMenuUtil.changePriority(priority, data_sources);
                    }
                });
            }
        };
        itemNumeric.addListener(13, priorityListener);
        itemHigh.addListener(13, priorityListener);
        itemLow.addListener(13, priorityListener);
        itemSkipped.addListener(13, priorityListener);
        itemDelete.addListener(13, priorityListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rename(TableView tv, final DownloadManager manager, Object[] datasources, boolean rename_it, boolean retarget_it) {
        if (manager == null) {
            return;
        }
        if (datasources.length == 0) {
            return;
        }
        String save_dir = null;
        if (!rename_it && retarget_it && (save_dir = FilesViewMenuUtil.askForSaveDirectory((DiskManagerFileInfo)datasources[0])) == null) {
            return;
        }
        boolean paused = false;
        try {
            for (int i = 0; i < datasources.length; ++i) {
                String s_target;
                final DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)datasources[i];
                File existing_file = fileInfo2.getFile(true);
                File f_target = null;
                if (rename_it && retarget_it) {
                    s_target = FilesViewMenuUtil.askForRetargetedFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(s_target);
                    }
                } else if (rename_it) {
                    s_target = FilesViewMenuUtil.askForRenameFilename(fileInfo2);
                    if (s_target != null) {
                        f_target = new File(existing_file.getParentFile(), s_target);
                    }
                } else {
                    f_target = new File(save_dir, existing_file.getName());
                }
                if (f_target == null) {
                    Object var14_13 = null;
                    if (paused) {
                        manager.resume();
                    }
                    return;
                }
                if (!paused) {
                    paused = manager.pause();
                }
                if (f_target.exists() && (f_target.equals(existing_file) || existing_file.exists() && !FilesViewMenuUtil.askCanOverwrite(existing_file))) continue;
                final File ff_target = f_target;
                final TableRowCore row = tv == null ? null : tv.getRow(datasources[i]);
                Utils.getOffOfSWTThread(new AERunnable(){

                    public void runSupport() {
                        FilesViewMenuUtil.moveFile(manager, fileInfo2, ff_target);
                        if (row != null) {
                            row.invalidate();
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (paused) {
                manager.resume();
            }
            throw throwable;
        }
        Object var14_14 = null;
        if (paused) {
            manager.resume();
        }
    }

    public static void changePriority(Object type, Object[] datasources) {
        if (datasources == null || datasources.length == 0) {
            return;
        }
        if (type == PRIORITY_NUMERIC) {
            FilesViewMenuUtil.changePriorityManual(datasources);
            return;
        }
        HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
        DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[datasources.length];
        for (int i = 0; i < datasources.length; ++i) {
            file_infos[i] = (DiskManagerFileInfo)datasources[i];
            DownloadManager dm = file_infos[i].getDownloadManager();
            ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
            if (listFileInfos == null) {
                listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                mapDMtoDMFI.put(dm, listFileInfos);
            }
            listFileInfos.add(file_infos[i]);
            if (type != PRIORITY_NORMAL && type != PRIORITY_HIGH) continue;
            file_infos[i].setPriority(type == PRIORITY_HIGH ? 1 : 0);
        }
        boolean skipped = type == PRIORITY_SKIPPED || type == PRIORITY_DELETE;
        boolean delete_action = type == PRIORITY_DELETE;
        for (DownloadManager dm : mapDMtoDMFI.keySet()) {
            ArrayList list;
            DiskManagerFileInfo[] fileInfos;
            boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), skipped, delete_action);
            if (!paused) continue;
            dm.resume();
        }
    }

    private static void changePriorityManual(final Object[] datasources) {
        SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("FilesView.dialog.priority.title", "FilesView.dialog.priority.text");
        entryWindow.prompt(new UIInputReceiverListener(){

            public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                if (!entryWindow.hasSubmittedInput()) {
                    return;
                }
                String sReturn = entryWindow.getSubmittedInput();
                if (sReturn == null) {
                    return;
                }
                int priority = -1;
                try {
                    priority = Integer.valueOf(sReturn);
                }
                catch (NumberFormatException er) {
                    // empty catch block
                }
                if (priority >= 0) {
                    HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>> mapDMtoDMFI = new HashMap<DownloadManager, ArrayList<DiskManagerFileInfo>>();
                    DiskManagerFileInfo[] file_infos = new DiskManagerFileInfo[datasources.length];
                    for (int i = 0; i < datasources.length; ++i) {
                        file_infos[i] = (DiskManagerFileInfo)datasources[i];
                        DownloadManager dm = file_infos[i].getDownloadManager();
                        ArrayList<DiskManagerFileInfo> listFileInfos = (ArrayList<DiskManagerFileInfo>)mapDMtoDMFI.get(dm);
                        if (listFileInfos == null) {
                            listFileInfos = new ArrayList<DiskManagerFileInfo>(1);
                            mapDMtoDMFI.put(dm, listFileInfos);
                        }
                        listFileInfos.add(file_infos[i]);
                        file_infos[i].setPriority(priority);
                    }
                    for (DownloadManager dm : mapDMtoDMFI.keySet()) {
                        ArrayList list;
                        DiskManagerFileInfo[] fileInfos;
                        boolean paused = FilesViewMenuUtil.setSkipped(dm, fileInfos = (list = (ArrayList)mapDMtoDMFI.get(dm)).toArray(new DiskManagerFileInfo[0]), false, false);
                        if (!paused) continue;
                        dm.resume();
                    }
                }
            }
        });
    }

    private static String askForRenameFilename(DiskManagerFileInfo fileInfo2) {
        SimpleTextEntryWindow dialog = new SimpleTextEntryWindow("FilesView.rename.filename.title", "FilesView.rename.filename.text");
        dialog.setPreenteredText(fileInfo2.getFile(true).getName(), false);
        dialog.allowEmptyInput(false);
        dialog.prompt();
        if (!dialog.hasSubmittedInput()) {
            return null;
        }
        return dialog.getSubmittedInput();
    }

    private static String askForRetargetedFilename(DiskManagerFileInfo fileInfo2) {
        FileDialog fDialog = new FileDialog(Utils.findAnyShell(), 139264);
        File existing_file = fileInfo2.getFile(true);
        fDialog.setFilterPath(existing_file.getParent());
        fDialog.setFileName(existing_file.getName());
        fDialog.setText(MessageText.getString("FilesView.rename.choose.path"));
        return fDialog.open();
    }

    private static String askForSaveDirectory(DiskManagerFileInfo fileInfo2) {
        DirectoryDialog dDialog = new DirectoryDialog(Utils.findAnyShell(), 139264);
        File current_dir = fileInfo2.getFile(true).getParentFile();
        dDialog.setFilterPath(current_dir.getPath());
        dDialog.setText(MessageText.getString("FilesView.rename.choose.path.dir"));
        return dDialog.open();
    }

    private static boolean askCanOverwrite(File file) {
        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{file.toString()}));
        mb.setDefaultButtonUsingStyle(32);
        mb.setRememberOnlyIfButton(0);
        mb.setRemember("FilesView.messagebox.rename.id", true, null);
        mb.setLeftImage(8);
        mb.open(null);
        return mb.waitUntilClosed() == 32;
    }

    private static void moveFile(final DownloadManager manager, final DiskManagerFileInfo fileInfo2, final File target) {
        manager.setUserData("is_changing_links", true);
        try {
            final boolean[] result = new boolean[]{false};
            FileUtil.runAsTask(new AzureusCoreOperationTask(){

                public void run(AzureusCoreOperation operation) {
                    result[0] = fileInfo2.setLink(target);
                    manager.setUserData("is_changing_links", false);
                    if (!result[0]) {
                        new MessageBoxShell(33, MessageText.getString("FilesView.rename.failed.title"), MessageText.getString("FilesView.rename.failed.text")).open(null);
                    }
                }
            });
        }
        catch (Exception e) {
            manager.setUserData("is_changing_links", false);
        }
    }

    private static boolean setSkipped(DownloadManager manager, DiskManagerFileInfo[] infos, boolean skipped, boolean delete_action) {
        File save_location;
        if (!manager.isPersistent()) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
            return false;
        }
        int[] existing_storage_types = manager.getStorageType(infos);
        int nbFiles = manager.getDiskManagerFileInfoSet().nbFiles();
        boolean[] setLinear = new boolean[nbFiles];
        boolean[] setCompact = new boolean[nbFiles];
        boolean[] setReorder = new boolean[nbFiles];
        boolean[] setReorderCompact = new boolean[nbFiles];
        int compactCount = 0;
        int linearCount = 0;
        int reorderCount = 0;
        int reorderCompactCount = 0;
        if (infos.length > 1) {
            // empty if block
        }
        boolean root_exists = (save_location = manager.getAbsoluteSaveLocation()).isDirectory() || infos.length <= 1 && save_location.exists();
        boolean type_has_been_changed = false;
        boolean requires_pausing = false;
        for (int i = 0; i < infos.length; ++i) {
            int new_storage_type;
            int non_compact_target;
            int compact_target;
            int existing_storage_type = existing_storage_types[i];
            if (existing_storage_type == 2 || existing_storage_type == 1) {
                compact_target = 2;
                non_compact_target = 1;
            } else {
                compact_target = 4;
                non_compact_target = 3;
            }
            if (skipped) {
                File existing_file = infos[i].getFile(true);
                boolean perform_check = root_exists ? true : !FileUtil.isAncestorOf(save_location, existing_file);
                if (perform_check && existing_file.exists()) {
                    if (delete_action) {
                        boolean wants_to_delete;
                        MessageBoxShell mb = new MessageBoxShell(288, MessageText.getString("FilesView.rename.confirm.delete.title"), MessageText.getString("FilesView.rename.confirm.delete.text", new String[]{existing_file.toString()}));
                        mb.setDefaultButtonUsingStyle(32);
                        mb.setRememberOnlyIfButton(0);
                        mb.setRemember("FilesView.messagebox.delete.id", false, null);
                        mb.setLeftImage(8);
                        mb.open(null);
                        boolean bl = wants_to_delete = mb.waitUntilClosed() == 32;
                        new_storage_type = wants_to_delete ? compact_target : non_compact_target;
                    } else {
                        new_storage_type = non_compact_target;
                    }
                } else {
                    new_storage_type = compact_target;
                }
            } else {
                new_storage_type = non_compact_target;
            }
            boolean has_changed = existing_storage_type != new_storage_type;
            type_has_been_changed |= has_changed;
            requires_pausing |= has_changed && (new_storage_type == 2 || new_storage_type == 4);
            boolean bl = type_has_been_changed = existing_storage_type != new_storage_type;
            if (new_storage_type == 2) {
                setCompact[infos[i].getIndex()] = true;
                ++compactCount;
                continue;
            }
            if (new_storage_type == 1) {
                setLinear[infos[i].getIndex()] = true;
                ++linearCount;
                continue;
            }
            if (new_storage_type == 3) {
                setReorder[infos[i].getIndex()] = true;
                ++reorderCount;
                continue;
            }
            if (new_storage_type != 4) continue;
            setReorderCompact[infos[i].getIndex()] = true;
            ++reorderCompactCount;
        }
        boolean ok = true;
        boolean paused = false;
        if (type_has_been_changed) {
            if (requires_pausing) {
                paused = manager.pause();
            }
            if (linearCount > 0) {
                ok &= Arrays.equals(setLinear, manager.getDiskManagerFileInfoSet().setStorageTypes(setLinear, 1));
            }
            if (compactCount > 0) {
                ok &= Arrays.equals(setCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setCompact, 2));
            }
            if (reorderCount > 0) {
                ok &= Arrays.equals(setReorder, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorder, 3));
            }
            if (reorderCompactCount > 0) {
                ok &= Arrays.equals(setReorderCompact, manager.getDiskManagerFileInfoSet().setStorageTypes(setReorderCompact, 4));
            }
        }
        if (ok) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i].setSkipped(skipped);
            }
        }
        return paused;
    }
}

