/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.shells.IWizardPage;
import org.gudy.azureus2.ui.swt.shells.MultipageWizard;

public abstract class AbstractWizardPage
implements IWizardPage {
    public static final String BUTTON_OK = "button.ok";
    public static final String BUTTON_CANCEL = "button.cancel";
    public static final String BUTTON_NEXT = "button.next";
    public static final String BUTTON_BACK = "button.back";
    private MultipageWizard wizard;
    private Composite pageControl;
    private Composite contentPanel;
    private Composite toolbarPanel;
    private Map buttons = new LinkedHashMap();
    protected SelectionListener defaultButtonListener;
    private int buttonExtraMargin = 50;

    public AbstractWizardPage(MultipageWizard wizard) {
        this.wizard = wizard;
    }

    public Composite createControls(Composite parent) {
        this.pageControl = new Composite(parent, 0);
        this.pageControl.setBackground(Colors.red);
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        this.pageControl.setLayout(gLayout);
        this.contentPanel = new Composite(this.pageControl, 0);
        this.contentPanel.setLayoutData(new GridData(4, 4, true, true));
        Label separator2 = new Label(this.pageControl, 258);
        separator2.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.toolbarPanel = new Composite(this.pageControl, 0);
        this.toolbarPanel.setLayoutData(new GridData(4, 1024, true, false));
        GridLayout gLayout2 = new GridLayout(3, false);
        gLayout2.marginHeight = 16;
        gLayout2.marginWidth = 16;
        this.toolbarPanel.setLayout(gLayout2);
        this.defaultButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractWizardPage.BUTTON_OK.equals(e.widget.getData("button.id"))) {
                    AbstractWizardPage.this.performOK();
                } else if (AbstractWizardPage.BUTTON_CANCEL.equals(e.widget.getData("button.id"))) {
                    AbstractWizardPage.this.performCancel();
                } else if (AbstractWizardPage.BUTTON_NEXT.equals(e.widget.getData("button.id"))) {
                    AbstractWizardPage.this.performNext();
                } else if (AbstractWizardPage.BUTTON_BACK.equals(e.widget.getData("button.id"))) {
                    AbstractWizardPage.this.performBack();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        Label dummy = new Label(this.toolbarPanel, 0);
        dummy.setLayoutData(new GridData(4, 4, true, false));
        this.createButtons(this.toolbarPanel);
        return this.contentPanel;
    }

    public void fullScreen(boolean isFullScreen) {
        this.toolbarPanel.setVisible(false == isFullScreen);
        ((GridData)this.toolbarPanel.getLayoutData()).exclude = isFullScreen;
        this.pageControl.layout(true, true);
        this.getWizard().fullScreen(isFullScreen);
    }

    protected void createButtons(Composite buttonPanel) {
        this.createButton(BUTTON_CANCEL, MessageText.getString("Button.cancel"), this.defaultButtonListener);
        this.createButton(BUTTON_BACK, MessageText.getString("wizard.previous"), this.defaultButtonListener);
        this.createButton(BUTTON_NEXT, MessageText.getString("wizard.next"), this.defaultButtonListener);
        this.createButton(BUTTON_OK, MessageText.getString("wizard.finish"), this.defaultButtonListener);
    }

    protected Button createButton(String buttonID, String buttonText, SelectionListener listener) {
        if (null == buttonID) {
            throw new IllegalArgumentException("A button requires a non-null ID");
        }
        if (this.buttons.containsKey(buttonID)) {
            Debug.out("AbstractWizardPage:: a button with this same ID already exists ID:" + buttonID);
            return (Button)this.buttons.get(buttonID);
        }
        Button button = new Button(this.toolbarPanel, 8);
        GridData gData = new GridData(0x1000008, 1024, false, false);
        gData.widthHint = button.computeSize((int)-1, (int)-1).y + this.buttonExtraMargin;
        button.setLayoutData(gData);
        if (null != listener) {
            button.addSelectionListener(listener);
        }
        button.setText(buttonText);
        button.setData("button.id", buttonID);
        this.buttons.put(buttonID, button);
        this.adjustToolbar();
        return button;
    }

    protected void enableButton(String buttonID, boolean value) {
        if (!this.buttons.containsKey(buttonID)) {
            Debug.out("AbstractWizardPage:: a button with this ID is not found ID:" + buttonID);
            return;
        }
        ((Button)this.buttons.get(buttonID)).setEnabled(value);
        this.toolbarPanel.layout(true);
    }

    protected void showButton(String buttonID, boolean value) {
        if (!this.buttons.containsKey(buttonID)) {
            Debug.out("AbstractWizardPage:: a button with this ID is not found ID:" + buttonID);
            return;
        }
        Button button = (Button)this.buttons.get(buttonID);
        button.setVisible(value);
        if (value) {
            GridData gData = (GridData)button.getLayoutData();
            gData.exclude = false;
            gData.widthHint = button.computeSize((int)-1, (int)-1).y + this.buttonExtraMargin;
        } else {
            GridData gData = (GridData)button.getLayoutData();
            gData.exclude = true;
            gData.widthHint = 0;
        }
        this.toolbarPanel.layout(true);
    }

    protected Button getButton(String buttonID) {
        if (!this.buttons.containsKey(buttonID)) {
            return null;
        }
        return (Button)this.buttons.get(buttonID);
    }

    public void performOK() {
    }

    public void performCancel() {
        this.getWizard().performCancel();
    }

    public void performNext() {
        this.getWizard().performNext();
    }

    public void performBack() {
        this.getWizard().performBack();
    }

    private void adjustToolbar() {
        ((GridLayout)this.toolbarPanel.getLayout()).numColumns = this.buttons.size() + 1;
        this.toolbarPanel.layout(true);
    }

    public Control getControl() {
        return this.pageControl;
    }

    public MultipageWizard getWizard() {
        return this.wizard;
    }

    public String getDesciption() {
        return null;
    }

    public String getTitle() {
        return null;
    }

    public String getWindowTitle() {
        return null;
    }

    public boolean isComplete() {
        return false;
    }

    public void performDispose() {
    }

    public void performFinish() {
    }

    public boolean setComplete() {
        return true;
    }

    public void performAboutToBeHidden() {
    }

    public void performAboutToBeShown() {
        if (null != this.getButton(BUTTON_NEXT)) {
            this.enableButton(BUTTON_NEXT, false == this.getWizard().isLastPage(this.getPageID()));
        }
        if (null != this.getButton(BUTTON_BACK)) {
            this.enableButton(BUTTON_BACK, false == this.getWizard().isFirstPage(this.getPageID()));
        }
    }

    public boolean isInitOnStartup() {
        return false;
    }
}

