/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.maketorrent.DirectoryPanel;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.SingleFilePanel;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedPanel;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

public class MultiTrackerPanel
extends AbstractWizardPanel
implements TrackerEditorListener {
    private Combo configList;
    private Tree configDetails;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;

    public MultiTrackerPanel(NewTorrentWizard wizard, AbstractWizardPanel previous) {
        super(wizard, previous);
    }

    public void show() {
        this.wizard.setTitle(MessageText.getString("wizard.multitracker.title"));
        this.wizard.setCurrentInfo("");
        Composite rootPanel = this.wizard.getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout(layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData(gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        Label labelTitle = new Label(panel, 0);
        Messages.setLanguageText(labelTitle, "wizard.multitracker.configuration");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        labelTitle.setLayoutData(gridData);
        this.configList = new Combo(panel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.configList.setLayoutData(gridData);
        this.configList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MultiTrackerPanel.this.updateTrackers();
                MultiTrackerPanel.this.refreshDetails();
            }
        });
        this.btnNew = new Button(panel, 8);
        Messages.setLanguageText(this.btnNew, "wizard.multitracker.new");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnNew.setLayoutData(gridData);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ArrayList group = new ArrayList();
                ArrayList<String> tracker = new ArrayList<String>();
                tracker.add(((NewTorrentWizard)((MultiTrackerPanel)MultiTrackerPanel.this).wizard).trackerURL);
                group.add(tracker);
                new MultiTrackerEditor(null, group, MultiTrackerPanel.this);
            }
        });
        this.btnEdit = new Button(panel, 8);
        Messages.setLanguageText(this.btnEdit, "wizard.multitracker.edit");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnEdit.setLayoutData(gridData);
        this.btnEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = MultiTrackerPanel.this.configList.getSelectionIndex();
                String selected = MultiTrackerPanel.this.configList.getItem(selection);
                Map multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
                new MultiTrackerEditor(selected, (List)multiTrackers.get(selected), MultiTrackerPanel.this);
            }
        });
        this.btnDelete = new Button(panel, 8);
        Messages.setLanguageText(this.btnDelete, "wizard.multitracker.delete");
        gridData = new GridData(128);
        gridData.widthHint = 100;
        this.btnDelete.setLayoutData(gridData);
        this.btnDelete.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = MultiTrackerPanel.this.configList.getSelectionIndex();
                String selected = MultiTrackerPanel.this.configList.getItem(selection);
                TrackersUtil.getInstance().removeMultiTracker(selected);
                MultiTrackerPanel.this.refreshList("");
                MultiTrackerPanel.this.refreshDetails();
                MultiTrackerPanel.this.setEditDeleteEnable();
            }
        });
        Label labelSeparator = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData(gridData);
        this.configDetails = new Tree(panel, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.horizontalSpan = 3;
        this.configDetails.setLayoutData(gridData);
        this.refreshList(((NewTorrentWizard)this.wizard).multiTrackerConfig);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    public IWizardPanel getNextPanel() {
        if (((NewTorrentWizard)this.wizard).useWebSeed) {
            return new WebSeedPanel((NewTorrentWizard)this.wizard, this);
        }
        if (((NewTorrentWizard)this.wizard).create_from_dir) {
            return new DirectoryPanel((NewTorrentWizard)this.wizard, (IWizardPanel)this);
        }
        return new SingleFilePanel((NewTorrentWizard)this.wizard, this);
    }

    public boolean isNextEnabled() {
        return true;
    }

    void refreshDetails() {
        this.configDetails.removeAll();
        List trackers = ((NewTorrentWizard)this.wizard).trackers;
        for (List trackerGroup : trackers) {
            TreeItem itemRoot = new TreeItem(this.configDetails, 0);
            Messages.setLanguageText(itemRoot, "wizard.multitracker.group");
            for (String url : trackerGroup) {
                new TreeItem(itemRoot, 0).setText(url);
            }
            itemRoot.setExpanded(true);
        }
    }

    void setEditDeleteEnable() {
        if (this.configList.getItemCount() > 0) {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    public void trackersChanged(String oldName, String newName, List trackers) {
        TrackersUtil util = TrackersUtil.getInstance();
        if (oldName != null && !oldName.equals(newName)) {
            util.removeMultiTracker(oldName);
        }
        util.addMultiTracker(newName, trackers);
        this.refreshList(newName);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    private void refreshList(String toBeSelected) {
        Map multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
        this.configList.removeAll();
        Iterator iter = multiTrackers.keySet().iterator();
        while (iter.hasNext()) {
            this.configList.add((String)iter.next());
        }
        int selection = this.configList.indexOf(toBeSelected);
        if (selection != -1) {
            this.configList.select(selection);
        } else if (this.configList.getItemCount() > 0) {
            this.configList.select(0);
        }
        this.updateTrackers();
    }

    private void updateTrackers() {
        String selected;
        int selection = this.configList.getSelectionIndex();
        if (selection == -1) {
            ArrayList group = new ArrayList();
            ArrayList<String> tracker = new ArrayList<String>();
            tracker.add(((NewTorrentWizard)this.wizard).trackerURL);
            group.add(tracker);
            ((NewTorrentWizard)this.wizard).trackers = group;
            ((NewTorrentWizard)this.wizard).multiTrackerConfig = "";
            this.setNext();
            return;
        }
        ((NewTorrentWizard)this.wizard).multiTrackerConfig = selected = this.configList.getItem(selection);
        Map multiTrackers = TrackersUtil.getInstance().getMultiTrackers();
        ((NewTorrentWizard)this.wizard).trackers = (List)multiTrackers.get(selected);
        this.setNext();
    }

    private void setNext() {
        String trackerUrl = ((NewTorrentWizard)this.wizard).trackerURL;
        List groups = ((NewTorrentWizard)this.wizard).trackers;
        for (List trackers : groups) {
            for (String tracker : trackers) {
                if (!trackerUrl.equals(tracker)) continue;
                this.wizard.setNextEnabled(true);
                this.wizard.setErrorMessage("");
                return;
            }
        }
        this.wizard.setNextEnabled(false);
        this.wizard.setErrorMessage(MessageText.getString("wizard.multitracker.noannounce"));
    }
}

