/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class InfoParameter
extends Parameter {
    private String name;
    private BufferedLabel label;

    public InfoParameter(Composite composite, String name) {
        this(composite, name, COConfigurationManager.getStringParameter(name));
    }

    public InfoParameter(Composite composite, String name, String defaultValue) {
        super(name);
        this.name = name;
        this.label = new BufferedLabel(composite, 0);
        String value = COConfigurationManager.getStringParameter(name, defaultValue);
        this.label.setText(value);
    }

    public void setValue(final String value) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (InfoParameter.this.label == null || InfoParameter.this.label.isDisposed() || InfoParameter.this.label.getText().equals(value)) {
                    return;
                }
                InfoParameter.this.label.setText(value);
            }
        });
        if (!COConfigurationManager.getStringParameter(this.name).equals(value)) {
            COConfigurationManager.setParameter(this.name, value);
        }
    }

    public void setLayoutData(Object layoutData) {
        this.label.setLayoutData(layoutData);
    }

    public String getValue() {
        return this.label.getText();
    }

    public Control getControl() {
        return this.label.getControl();
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.setValue((String)value);
        }
    }

    public Object getValueObject() {
        return COConfigurationManager.getStringParameter(this.name);
    }
}

