/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

public class Scale {
    private int pixelsPerLevel = 50;
    private int max = 1;
    private int nbLevels;
    private int displayedMax;
    private int nbPixels = 1;
    int scaleFactor;
    int powFactor;

    public void setMax(int max) {
        this.max = max;
        if (max < 1) {
            max = 1;
        }
        this.computeValues();
    }

    public int getMax() {
        return this.max;
    }

    public void setNbPixels(int nbPixels) {
        this.nbPixels = nbPixels;
        if (nbPixels < 1) {
            nbPixels = 1;
        }
        this.computeValues();
    }

    private void computeValues() {
        int targetNbLevels = this.nbPixels / this.pixelsPerLevel;
        if (targetNbLevels < 1) {
            targetNbLevels = 1;
        }
        this.scaleFactor = this.max / targetNbLevels;
        this.powFactor = 1;
        while (this.scaleFactor >= 10) {
            this.powFactor = 10 * this.powFactor;
            this.scaleFactor /= 10;
        }
        this.scaleFactor = this.scaleFactor >= 5 ? 5 : (this.scaleFactor >= 2 ? 2 : 1);
        this.nbLevels = this.max / (this.scaleFactor * this.powFactor) + 1;
        this.displayedMax = this.scaleFactor * this.powFactor * this.nbLevels;
    }

    public int[] getScaleValues() {
        int[] result = new int[this.nbLevels + 1];
        for (int i = 0; i < this.nbLevels + 1; ++i) {
            result[i] = i * this.scaleFactor * this.powFactor;
        }
        return result;
    }

    public int getScaledValue(int value) {
        return (int)((long)value * (long)this.nbPixels / (long)this.displayedMax);
    }
}

