/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class StringListChooser {
    private Display display;
    private Shell shell;
    private Label label;
    private Combo combo;
    private String result = null;

    public StringListChooser(final Shell parentShell) {
        this.display = parentShell.getDisplay();
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec(new Runnable(){

            public void run() {
                StringListChooser.this.createShell(parentShell);
            }
        });
    }

    private void createShell(Shell parentShell) {
        this.shell = ShellFactory.createShell(this.display, 67680);
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout(layout);
        this.label = new Label(this.shell, 64);
        this.combo = new Combo(this.shell, 8);
        Button ok = new Button(this.shell, 8);
        ok.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                StringListChooser.this.result = StringListChooser.this.combo.getText();
                StringListChooser.this.shell.dispose();
            }
        });
        ok.setText(MessageText.getString("Button.ok"));
        Button cancel = new Button(this.shell, 8);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                StringListChooser.this.result = null;
                StringListChooser.this.shell.dispose();
            }
        });
        cancel.setText(MessageText.getString("Button.cancel"));
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event arg0) {
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.heightHint = 30;
        this.label.setLayoutData(data);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.combo.setLayoutData(data);
        data = new GridData();
        data.widthHint = 80;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 0x1000008;
        data.horizontalAlignment = 0x1000008;
        ok.setLayoutData(data);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 0x1000008;
        data.widthHint = 80;
        cancel.setLayoutData(data);
        this.shell.setSize(300, 150);
        this.shell.layout();
        Utils.centerWindowRelativeTo(this.shell, parentShell);
    }

    public void setTitle(final String title) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringListChooser.this.display == null || StringListChooser.this.display.isDisposed()) {
                    return;
                }
                StringListChooser.this.shell.setText(title);
            }
        });
    }

    public void setText(final String text) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringListChooser.this.display == null || StringListChooser.this.display.isDisposed()) {
                    return;
                }
                StringListChooser.this.label.setText(text.replaceAll("&", "&&"));
            }
        });
    }

    public void addOption(final String option) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringListChooser.this.display == null || StringListChooser.this.display.isDisposed()) {
                    return;
                }
                StringListChooser.this.combo.add(option);
                if (StringListChooser.this.combo.getItemCount() == 1) {
                    StringListChooser.this.combo.setText(option);
                }
            }
        });
    }

    public String open() {
        if (this.display == null || this.display.isDisposed()) {
            return null;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (StringListChooser.this.display == null || StringListChooser.this.display.isDisposed()) {
                    return;
                }
                try {
                    StringListChooser.this.shell.open();
                    while (!StringListChooser.this.shell.isDisposed()) {
                        if (StringListChooser.this.display.readAndDispatch()) continue;
                        StringListChooser.this.display.sleep();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        return this.result;
    }
}

