/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItemImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;

public abstract class BufferedGraphicTableItem1
extends BufferedTableItemImpl
implements BufferedGraphicTableItem {
    private int marginHeight = 1;
    private int marginWidth = 1;
    private int orientation = 0x1000000;
    private Image image;
    private boolean neverDrawn = true;

    public BufferedGraphicTableItem1(BufferedTableRow row, int position) {
        super(row, position);
    }

    public Image getGraphic() {
        return this.image;
    }

    public boolean setGraphic(Image img) {
        boolean bDoRedraw;
        boolean bImageSet = this.image != img;
        boolean bl = bDoRedraw = img == null;
        if (bImageSet) {
            if (!(bDoRedraw || this.image == null || this.image.isDisposed() || img.isDisposed() || this.image.getBounds().equals(img.getBounds()))) {
                bDoRedraw = true;
            }
            this.image = img;
        }
        return bImageSet;
    }

    public boolean needsPainting() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.image = null;
    }

    public Rectangle getBoundsForCanvas() {
        Rectangle bounds = super.getBounds();
        if (bounds == null) {
            return null;
        }
        bounds.y += this.marginHeight;
        bounds.height -= this.marginHeight * 2;
        bounds.x += this.marginWidth;
        bounds.width -= this.marginWidth * 2;
        return bounds;
    }

    public Rectangle getBounds() {
        return this.getBoundsForCanvas();
    }

    public Rectangle getBoundsRaw() {
        return super.getBounds();
    }

    public Point getSize() {
        Rectangle bounds = super.getBounds();
        if (bounds == null) {
            return new Point(0, 0);
        }
        return new Point(bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
    }

    public void invalidate() {
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public void setMargin(int width, int height) {
        if (width >= 0) {
            this.marginWidth = width;
        }
        if (height >= 0) {
            this.marginHeight = height;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Image getBackgroundImage() {
        Image imageRowBG = this.row.getBackgroundImage();
        if (imageRowBG != null) {
            Rectangle bounds = super.getBounds();
            int wInside = bounds.width - this.marginWidth * 2;
            int hInside = bounds.height - this.marginHeight * 2;
            Image imageCellBG = new Image((Device)Display.getDefault(), wInside, hInside);
            GC gc = new GC(imageCellBG);
            gc.drawImage(imageRowBG, bounds.x + this.marginWidth, 0 + this.marginHeight, wInside, hInside, 0, 0, wInside, hInside);
            gc.dispose();
            return imageCellBG;
        }
        TableOrTreeSWT table = this.row.getTable();
        Rectangle bounds = super.getBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), bounds.width - this.marginWidth * 2, bounds.height - this.marginHeight * 2);
        GC gc = new GC(image);
        gc.setForeground(this.getBackground());
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.dispose();
        return image;
    }
}

