/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console;

import com.aelitis.azureus.core.AzureusCoreException;
import org.gudy.azureus2.ui.console.util.StringEncrypter;

public class UserProfile {
    private String username;
    private String userType;
    private String encryptedPassword;
    private String defaultSaveDirectory;
    public static final String ADMIN = "admin";
    public static final String USER = "user";
    public static final String GUEST = "guest";
    public static final String DEFAULT_USER_TYPE = "admin";
    public static final UserProfile DEFAULT_USER_PROFILE = new UserProfile("admin", "admin");

    public static boolean isValidUserType(String userType) {
        return "admin".equals(userType) || USER.equals(userType) || GUEST.equals(userType);
    }

    public UserProfile() {
        this.userType = "admin";
    }

    public UserProfile(String name, String userType) {
        this.username = name;
        this.setUserType(userType);
    }

    public boolean authenticate(String password) {
        try {
            StringEncrypter encrypter = new StringEncrypter("DES");
            return encrypter.decrypt(this.encryptedPassword).equals(password);
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new AzureusCoreException("Unable to decrypt password", e);
        }
    }

    public void setPassword(String password) {
        try {
            StringEncrypter encrypter = new StringEncrypter("DES");
            this.setEncryptedPassword(encrypter.encrypt(password));
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new AzureusCoreException("Unable to encrypt password", e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        userType = userType.equalsIgnoreCase("admin") ? "admin" : (userType.equalsIgnoreCase(USER) ? USER : (userType.equalsIgnoreCase(GUEST) ? GUEST : "admin"));
        this.userType = userType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UserProfile)) {
            return false;
        }
        UserProfile other = (UserProfile)obj;
        if (this.getUsername() != null) {
            return this.getUsername().equals(other.getUsername());
        }
        if (other.getUsername() != null) {
            return false;
        }
        if (this.getEncryptedPassword() != null) {
            return this.getEncryptedPassword().equals(other.getEncryptedPassword());
        }
        return other.getEncryptedPassword() == null;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getDefaultSaveDirectory() {
        return this.defaultSaveDirectory;
    }

    public void setDefaultSaveDirectory(String newValue) {
        this.defaultSaveDirectory = newValue;
    }
}

