/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.io.Serializable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPPluginInterface;

public class RPRequest
implements Serializable {
    public RPObject object;
    public String method;
    public Object[] params;
    protected transient PluginInterface plugin_interface;
    protected transient LoggerChannel channel;
    public long connection_id;
    public long request_id;
    protected transient String client_ip;

    public RPRequest() {
    }

    public RPRequest(RPObject _object, String _method, Object[] _params) {
        this.object = _object;
        this.method = _method;
        this.params = _params;
        if (this.object != null) {
            RPPluginInterface pi = this.object.getDispatcher().getPlugin();
            this.connection_id = pi._getConectionId();
            this.request_id = pi._getNextRequestId();
            this.plugin_interface = (PluginInterface)pi._getDelegate();
        }
    }

    public void setClientIP(String str) {
        this.client_ip = str;
    }

    public String getClientIP() {
        return this.client_ip;
    }

    public long getConnectionId() {
        return this.connection_id;
    }

    public long getRequestId() {
        return this.request_id;
    }

    public String getString() {
        return "object=" + this.object + ", method=" + this.method + ", params=" + this.params;
    }

    public RPObject getObject() {
        return this.object;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    public PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    public void setPluginInterface(PluginInterface pi) {
        this.plugin_interface = pi;
    }

    public LoggerChannel getRPLoggerChannel() {
        return this.channel;
    }

    public void setRPLoggerChannel(LoggerChannel channel2) {
        this.channel = channel2;
    }

    public RPPluginInterface createRemotePluginInterface(PluginInterface pi) {
        return RPPluginInterface.create(pi);
    }
}

