/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.simpleparser.SimpleXMLParserDocumentNodeImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleXMLParserDocumentImpl
implements SimpleXMLParserDocument {
    private static DocumentBuilderFactory dbf_singleton;
    protected Document document;
    protected SimpleXMLParserDocumentNodeImpl root_node;

    public SimpleXMLParserDocumentImpl(File file) throws SimpleXMLParserDocumentException {
        try {
            this.create(new FileInputStream(file));
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocumentImpl(String data) throws SimpleXMLParserDocumentException {
        try {
            this.create(new ByteArrayInputStream(data.getBytes("UTF8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SimpleXMLParserDocumentImpl(InputStream input_stream) throws SimpleXMLParserDocumentException {
        this.create(input_stream);
    }

    protected static synchronized DocumentBuilderFactory getDBF() {
        if (dbf_singleton == null) {
            dbf_singleton = DocumentBuilderFactory.newInstance();
            dbf_singleton.setNamespaceAware(true);
            dbf_singleton.setValidating(false);
            dbf_singleton.setIgnoringComments(true);
            dbf_singleton.setIgnoringElementContentWhitespace(true);
            dbf_singleton.setCoalescing(true);
            dbf_singleton.setExpandEntityReferences(true);
        }
        return dbf_singleton;
    }

    protected void create(InputStream input_stream) throws SimpleXMLParserDocumentException {
        try {
            DocumentBuilderFactory dbf = SimpleXMLParserDocumentImpl.getDBF();
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter(System.err);
            MyErrorHandler error_handler = new MyErrorHandler(new PrintWriter((Writer)errorWriter, true));
            db.setErrorHandler(error_handler);
            this.document = db.parse(input_stream);
            SimpleXMLParserDocumentNodeImpl[] root_nodes = this.parseNode(this.document, false);
            int root_node_count = 0;
            for (int i = 0; i < root_nodes.length; ++i) {
                SimpleXMLParserDocumentNodeImpl node = root_nodes[i];
                if (node.getNode().getNodeType() == 7) continue;
                this.root_node = node;
                ++root_node_count;
            }
            if (root_node_count != 1) {
                throw new SimpleXMLParserDocumentException("invalid document - " + root_nodes.length + " root elements");
            }
        }
        catch (Throwable e) {
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public String getName() {
        return this.root_node.getName();
    }

    public String getFullName() {
        return this.root_node.getFullName();
    }

    public String getNameSpaceURI() {
        return this.root_node.getNameSpaceURI();
    }

    public String getValue() {
        return this.root_node.getValue();
    }

    public SimpleXMLParserDocumentNode[] getChildren() {
        return this.root_node.getChildren();
    }

    public SimpleXMLParserDocumentNode getChild(String name) {
        return this.root_node.getChild(name);
    }

    public SimpleXMLParserDocumentAttribute[] getAttributes() {
        return this.root_node.getAttributes();
    }

    public SimpleXMLParserDocumentAttribute getAttribute(String name) {
        return this.root_node.getAttribute(name);
    }

    public void print() {
        PrintWriter pw = new PrintWriter(System.out);
        this.print(pw);
        pw.flush();
    }

    public void print(PrintWriter pw) {
        this.root_node.print(pw, "");
    }

    protected SimpleXMLParserDocumentNodeImpl[] parseNode(Node node, boolean skip_this_node) {
        short type = node.getNodeType();
        if (!(type != 1 && type != 7 || skip_this_node)) {
            return new SimpleXMLParserDocumentNodeImpl[]{new SimpleXMLParserDocumentNodeImpl(this, node)};
        }
        Vector<SimpleXMLParserDocumentNodeImpl> v = new Vector<SimpleXMLParserDocumentNodeImpl>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            SimpleXMLParserDocumentNodeImpl[] kids = this.parseNode(child, false);
            for (int i = 0; i < kids.length; ++i) {
                v.addElement(kids[i]);
            }
        }
        Object[] res = new SimpleXMLParserDocumentNodeImpl[v.size()];
        v.copyInto(res);
        return res;
    }

    public static void main(String[] args) {
        try {
            String line;
            StringBuffer data = new StringBuffer(1024);
            FileInputStream is = new FileInputStream("C:\\temp\\upnp_trace3.log");
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((line = lnr.readLine()) != null) {
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c < ' ') {
                        data.append(' ');
                        continue;
                    }
                    data.append(c);
                }
                data.append("\n");
            }
            String data_str = data.toString();
            new SimpleXMLParserDocumentImpl(data_str).print();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        MyErrorHandler(PrintWriter out) {
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

