/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.util.DeleteFileOnCloseInputStream;
import com.aelitis.azureus.core.util.Java15Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;
    protected boolean force_no_proxy = false;
    private final String post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        this(_parent, _url, null, _auth_supplied, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _data, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.post_data = _data;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected void setForceNoProxy(boolean force_no_proxy) {
        this.force_no_proxy = force_no_proxy;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
                this.setProperties(c);
                Object var3_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String protocol = this.original_url.getProtocol().toLowerCase();
            if (protocol.equals("magnet")) return -1L;
            if (protocol.equals("dht")) return -1L;
            if (protocol.equals("vuze")) return -1L;
            if (protocol.equals("ftp")) {
                return -1L;
            }
            if (protocol.equals("file")) {
                return new File(this.original_url.toURI()).length();
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    int i = 0;
                    while (i < 2) {
                        long l;
                        try {
                            HttpURLConnection con;
                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                HttpsURLConnection ssl_con = (HttpsURLConnection)this.openConnection(url);
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                con = ssl_con;
                            } else {
                                con = (HttpURLConnection)this.openConnection(url);
                            }
                            con.setRequestMethod("HEAD");
                            con.setRequestProperty("User-Agent", "Azureus 4.6.0.4");
                            this.setRequestProperties(con, false);
                            con.connect();
                            int response = con.getResponseCode();
                            this.setProperty("URL_HTTP_Response", new Long(response));
                            if (response != 202 && response != 200) {
                                throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay(url) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                            }
                            this.getRequestProperties(con);
                            l = UrlUtils.getContentLength(con);
                        }
                        catch (SSLException e) {
                            if (i != 0) throw e;
                            if (SESecurityManager.installServerCertificates(url) == null) throw e;
                        }
                        catch (IOException e) {
                            if (i != 0) throw e;
                            URL retry_url = UrlUtils.getIPV4Fallback(url);
                            if (retry_url == null) throw e;
                            url = retry_url;
                        }
                        Object var9_15 = null;
                        if (!this.auth_supplied) return l;
                        SESecurityManager.setPasswordHandler(url, null);
                        return l;
                        ++i;
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    if (!this.auth_supplied) throw throwable;
                    SESecurityManager.setPasswordHandler(url, null);
                    throw throwable;
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
                throw rde;
            }
            Debug.out(e);
            rde = new ResourceDownloaderException(this, "Unexpected error", e);
            throw rde;
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        c.setProperties(this);
        c.setForceNoProxy(this.force_no_proxy);
        return c;
    }

    public void asyncDownload() {
        final Object parent_tls = TorrentUtils.getTLS();
        AEThread2 t = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object child_tls = TorrentUtils.getTLS();
                TorrentUtils.setTLS(parent_tls);
                try {
                    try {
                        ResourceDownloaderURLImpl.this.download();
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        Object var4_3 = null;
                        TorrentUtils.setTLS(child_tls);
                        return;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    TorrentUtils.setTLS(child_tls);
                    throw throwable;
                }
                TorrentUtils.setTLS(child_tls);
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.trimForDisplay(this.original_url));
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException(this, "Download already initiated");
                }
                this.download_initiated = true;
                Object var2_1 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this_mon.exit();
                throw throwable;
            }
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                String protocol = url.getProtocol().toLowerCase();
                if (protocol.equals("vuze")) {
                    url = this.original_url;
                } else {
                    if (protocol.equals("file")) {
                        File file = new File(this.original_url.toURI());
                        FileInputStream fis = new FileInputStream(file);
                        this.informAmountComplete(file.length());
                        this.informPercentDone(100);
                        this.informComplete(fis);
                        return fis;
                    }
                    if (url.getPort() == -1 && (protocol.equals("http") || protocol.equals("https"))) {
                        int target_port = protocol.equals("http") ? 80 : 443;
                        try {
                            String str = this.original_url.toString().replaceAll(" ", "%20");
                            int pos = str.indexOf("://");
                            pos = str.indexOf("/", pos + 4);
                            url = pos == -1 ? new URL(str + ":" + target_port + "/") : new URL(str.substring(0, pos) + ":" + target_port + str.substring(pos));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    boolean use_compression = true;
                    boolean follow_redirect = true;
                    int redirect_loop = 0;
                    while (redirect_loop < 2) {
                        if (!follow_redirect) throw new ResourceDownloaderException(this, "Should never get here");
                        follow_redirect = false;
                        for (int connect_loop = 0; connect_loop < 2; ++connect_loop) {
                            Object var27_46;
                            File temp_file = null;
                            try {
                                boolean handed_over;
                                InputStream res;
                                block78: {
                                    InputStream inputStream;
                                    block79: {
                                        Object var23_45;
                                        Object var21_44;
                                        int response;
                                        URLConnection con;
                                        block77: {
                                            String move_to;
                                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                                HttpsURLConnection ssl_con = (HttpsURLConnection)this.openConnection(url);
                                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                                    public boolean verify(String host, SSLSession session) {
                                                        return true;
                                                    }
                                                });
                                                con = ssl_con;
                                            } else {
                                                con = this.openConnection(url);
                                            }
                                            con.setRequestProperty("User-Agent", "Azureus 4.6.0.4");
                                            String connection = this.getStringProperty("URL_Connection");
                                            if (connection == null || !connection.equals("skip")) {
                                                con.setRequestProperty("Connection", "close");
                                            }
                                            if (use_compression) {
                                                con.addRequestProperty("Accept-Encoding", "gzip");
                                            }
                                            this.setRequestProperties(con, use_compression);
                                            if (this.post_data != null && con instanceof HttpURLConnection) {
                                                con.setDoOutput(true);
                                                String verb = this.getStringProperty("URL_HTTP_VERB");
                                                if (verb == null) {
                                                    verb = "POST";
                                                }
                                                ((HttpURLConnection)con).setRequestMethod(verb);
                                                if (this.post_data.length() > 0) {
                                                    OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream());
                                                    wr.write(this.post_data);
                                                    wr.flush();
                                                }
                                            }
                                            con.connect();
                                            int n = response = con instanceof HttpURLConnection ? ((HttpURLConnection)con).getResponseCode() : 200;
                                            if ((response == 302 || response == 301) && (move_to = con.getHeaderField("location")) != null && url.getProtocol().equalsIgnoreCase("http")) {
                                                try {
                                                    URL move_to_url = new URL(move_to);
                                                    if (!move_to_url.getProtocol().equalsIgnoreCase("https")) break block77;
                                                    url = move_to_url;
                                                    try {
                                                        List<String> cookies_list = con.getHeaderFields().get("Set-cookie");
                                                        ArrayList<String> cookies_set = new ArrayList<String>();
                                                        if (cookies_list != null) {
                                                            for (int i = 0; i < cookies_list.size(); ++i) {
                                                                String[] cookie_bits = cookies_list.get(i).split(";");
                                                                if (cookie_bits.length <= 0) continue;
                                                                cookies_set.add(cookie_bits[0]);
                                                            }
                                                        }
                                                        if (cookies_set.size() > 0) {
                                                            String new_cookies = "";
                                                            Map properties = this.getLCKeyProperties();
                                                            Object obj = properties.get("url_cookie");
                                                            if (obj instanceof String) {
                                                                new_cookies = (String)obj;
                                                            }
                                                            for (String s : cookies_set) {
                                                                new_cookies = new_cookies + (new_cookies.length() == 0 ? "" : "; ") + s;
                                                            }
                                                            this.setProperty("URL_Cookie", new_cookies);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.out(e);
                                                    }
                                                    follow_redirect = true;
                                                }
                                                catch (Throwable e) {
                                                    // empty catch block
                                                }
                                                var27_46 = null;
                                                if (temp_file != null) {
                                                    temp_file.delete();
                                                }
                                                break;
                                            }
                                        }
                                        this.setProperty("URL_HTTP_Response", new Long(response));
                                        if (response != 201 && response != 202 && response != 204 && response != 200) {
                                            String string;
                                            HttpURLConnection http_con = (HttpURLConnection)con;
                                            InputStream error_stream = http_con.getErrorStream();
                                            String error_str = null;
                                            if (error_stream != null) {
                                                String encoding = con.getHeaderField("content-encoding");
                                                if (encoding != null) {
                                                    if (encoding.equalsIgnoreCase("gzip")) {
                                                        error_stream = new GZIPInputStream(error_stream);
                                                    } else if (encoding.equalsIgnoreCase("deflate")) {
                                                        error_stream = new InflaterInputStream(error_stream);
                                                    }
                                                }
                                                error_str = FileUtil.readInputStreamAsString(error_stream, 256);
                                            }
                                            StringBuilder stringBuilder = new StringBuilder().append("Error on connect for '").append(this.trimForDisplay(url)).append("': ").append(Integer.toString(response)).append(" ").append(http_con.getResponseMessage());
                                            if (error_str == null) {
                                                string = "";
                                                throw new ResourceDownloaderException(this, stringBuilder.append(string).toString());
                                            }
                                            string = ": error=" + error_str;
                                            throw new ResourceDownloaderException(this, stringBuilder.append(string).toString());
                                        }
                                        this.getRequestProperties(con);
                                        boolean compressed = false;
                                        try {
                                            this.this_mon.enter();
                                            this.input_stream = con.getInputStream();
                                            String encoding = con.getHeaderField("content-encoding");
                                            if (encoding != null) {
                                                if (encoding.equalsIgnoreCase("gzip")) {
                                                    compressed = true;
                                                    this.input_stream = new GZIPInputStream(this.input_stream);
                                                } else if (encoding.equalsIgnoreCase("deflate")) {
                                                    compressed = true;
                                                    this.input_stream = new InflaterInputStream(this.input_stream);
                                                }
                                            }
                                            var21_44 = null;
                                            this.this_mon.exit();
                                        }
                                        catch (Throwable throwable) {
                                            var21_44 = null;
                                            this.this_mon.exit();
                                            throw throwable;
                                        }
                                        ByteArrayOutputStream baos = null;
                                        FileOutputStream fos = null;
                                        try {
                                            int read;
                                            long size;
                                            byte[] buf = new byte[32768];
                                            long total_read = 0L;
                                            long l = size = compressed ? -1L : UrlUtils.getContentLength(con);
                                            ByteArrayOutputStream byteArrayOutputStream = size > 0L ? new ByteArrayOutputStream(size > 262144L ? 262144 : (int)size) : (baos = new ByteArrayOutputStream());
                                            while (!this.cancel_download && (read = this.input_stream.read(buf)) > 0) {
                                                if (total_read > 262144L) {
                                                    if (fos == null) {
                                                        temp_file = AETemporaryFileHandler.createTempFile();
                                                        fos = new FileOutputStream(temp_file);
                                                        fos.write(baos.toByteArray());
                                                        baos = null;
                                                    }
                                                    fos.write(buf, 0, read);
                                                } else {
                                                    baos.write(buf, 0, read);
                                                }
                                                this.informAmountComplete(total_read += (long)read);
                                                if (size <= 0L) continue;
                                                this.informPercentDone((int)(100L * total_read / size));
                                            }
                                            if (size > 0L && total_read != size) {
                                                if (total_read <= size) throw new IOException("Premature end of stream");
                                                Debug.outNoStack("Inconsistent stream length for '" + this.trimForDisplay(this.original_url) + "': expected = " + size + ", actual = " + total_read);
                                            }
                                            var23_45 = null;
                                            if (fos != null) {
                                                fos.close();
                                            }
                                            this.input_stream.close();
                                        }
                                        catch (Throwable throwable) {
                                            var23_45 = null;
                                            if (fos != null) {
                                                fos.close();
                                            }
                                            this.input_stream.close();
                                            throw throwable;
                                        }
                                        if (temp_file != null) {
                                            res = new DeleteFileOnCloseInputStream(temp_file);
                                            temp_file = null;
                                        } else {
                                            res = new ByteArrayInputStream(baos.toByteArray());
                                        }
                                        handed_over = false;
                                        try {
                                            if (!this.informComplete(res)) break block78;
                                            handed_over = true;
                                            inputStream = res;
                                            Object var25_49 = null;
                                            if (handed_over) break block79;
                                        }
                                        catch (Throwable throwable) {
                                            Object var25_51 = null;
                                            if (handed_over) throw throwable;
                                            res.close();
                                            throw throwable;
                                        }
                                        res.close();
                                    }
                                    var27_46 = null;
                                    if (temp_file != null) {
                                        temp_file.delete();
                                    }
                                    Object var29_52 = null;
                                    if (!this.auth_supplied) return inputStream;
                                    SESecurityManager.setPasswordHandler(url, null);
                                    return inputStream;
                                }
                                Object var25_50 = null;
                                if (handed_over) throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                res.close();
                                throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                            }
                            catch (SSLException e) {
                                if (connect_loop != 0) throw e;
                                if (SESecurityManager.installServerCertificates(url) == null) throw e;
                                var27_46 = null;
                                if (temp_file == null) continue;
                                temp_file.delete();
                                continue;
                            }
                            catch (ZipException e) {
                                if (connect_loop == 0) {
                                    use_compression = false;
                                    var27_46 = null;
                                    if (temp_file == null) continue;
                                    temp_file.delete();
                                    continue;
                                }
                                var27_46 = null;
                                if (temp_file == null) continue;
                                temp_file.delete();
                                continue;
                            }
                            catch (IOException e) {
                                if (connect_loop != 0) throw e;
                                String msg = e.getMessage();
                                if (msg != null && (msg = msg.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("gzip") != -1) {
                                    use_compression = false;
                                    var27_46 = null;
                                    if (temp_file == null) continue;
                                    temp_file.delete();
                                    continue;
                                }
                                URL retry_url = UrlUtils.getIPV4Fallback(url);
                                if (retry_url == null) throw e;
                                url = retry_url;
                                var27_46 = null;
                                if (temp_file == null) continue;
                                temp_file.delete();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var27_46 = null;
                                if (temp_file == null) throw throwable;
                                temp_file.delete();
                                throw throwable;
                            }
                        }
                        ++redirect_loop;
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                catch (Throwable throwable) {
                    Object var29_53 = null;
                    if (!this.auth_supplied) throw throwable;
                    SESecurityManager.setPasswordHandler(url, null);
                    throw throwable;
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.trimForDisplay(this.original_url) + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
            } else {
                Debug.out(e);
                rde = new ResourceDownloaderException(this, "Unexpected error", e);
            }
            this.informFailed(rde);
            throw rde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                }
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.informFailed(new ResourceDownloaderCancelledException(this));
    }

    protected void setRequestProperties(URLConnection con, boolean use_compression) {
        Map properties = this.getLCKeyProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith("url_") || !(value instanceof String) || value.equals("skip") || key.equalsIgnoreCase("URL_HTTP_VERB") || (key = key.substring(4)).equals("accept-encoding") && !use_compression) continue;
            con.setRequestProperty(key, (String)value);
        }
    }

    protected void getRequestProperties(URLConnection con) {
        try {
            this.setProperty("ContentType", con.getContentType());
            this.setProperty("URL_URL", con.getURL());
            Map<String, List<String>> headers = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> val = entry.getValue();
                if (key == null) continue;
                this.setProperty("URL_" + key, val);
            }
            this.setPropertiesSet();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }

    private URLConnection openConnection(URL url) throws IOException {
        if (this.force_no_proxy) {
            return Java15Utils.openConnectionForceNoProxy(url);
        }
        return url.openConnection();
    }

    protected String trimForDisplay(URL url) {
        String str = url.toString();
        int pos = str.indexOf(63);
        if (pos != -1) {
            str = str.substring(0, pos);
        }
        return str;
    }
}

