/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.magnet;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.Debug;

public class MagnetConnection2
extends HttpURLConnection {
    private static final String NL = "\r\n";
    private OutputStream output_stream;
    private InputStream input_stream;
    private LinkedList<String> status_list = new LinkedList();

    protected MagnetConnection2(URL _url) {
        super(_url);
    }

    public void connect() throws IOException {
        String get = "/download/" + this.getURL().toString().substring(7) + " HTTP/1.0" + NL + NL;
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream();
        pis.connect(pos);
        this.input_stream = pis;
        this.output_stream = pos;
        MagnetURIHandler.getSingleton().process(get, new ByteArrayInputStream(new byte[0]), pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        int len;
        String line = "";
        byte[] buffer = new byte[1];
        byte[] line_bytes = new byte[2048];
        int line_bytes_pos = 0;
        while ((len = this.input_stream.read(buffer)) != -1) {
            line = line + (char)buffer[0];
            line_bytes[line_bytes_pos++] = buffer[0];
            if (!line.endsWith(NL)) continue;
            if ((line = line.trim()).length() == 0) break;
            if (line.startsWith("X-Report:")) {
                line = new String(line_bytes, 0, line_bytes_pos, "UTF-8");
                line = line.substring(9);
                line = line.trim();
                LinkedList<String> linkedList = this.status_list;
                synchronized (linkedList) {
                    String str = Character.toUpperCase(line.charAt(0)) + line.substring(1);
                    if (this.status_list.size() == 0) {
                        this.status_list.addLast(str);
                    } else if (!this.status_list.getLast().equals(str)) {
                        this.status_list.addLast(str);
                    }
                }
            }
            line = "";
            line_bytes_pos = 0;
        }
        return this.input_stream;
    }

    public int getResponseCode() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponseMessage() {
        LinkedList<String> linkedList = this.status_list;
        synchronized (linkedList) {
            if (this.status_list.size() == 0) {
                return "";
            }
            if (this.status_list.size() == 1) {
                return this.status_list.get(0);
            }
            return this.status_list.removeFirst();
        }
    }

    public boolean usingProxy() {
        return false;
    }

    public void disconnect() {
        try {
            this.output_stream.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        try {
            this.input_stream.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

