/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.dht.TRTrackerServerDHT;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServerProcessorFactory;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AsyncController;

public class TRTrackerServerFactoryImpl {
    protected static CopyOnWriteList servers = new CopyOnWriteList();
    protected static List listeners = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerServer create(String name, int protocol, int port, InetAddress bind_ip, boolean ssl, boolean apply_ip_filter, boolean main_tracker, boolean start_up_ready) throws TRTrackerServerException {
        try {
            TRTrackerServerImpl server;
            class_mon.enter();
            if (protocol == 1) {
                server = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking") && main_tracker && !ssl ? new TRNonBlockingServer(name, port, bind_ip, apply_ip_filter, start_up_ready, new TRNonBlockingServerProcessorFactory(){

                    public TRNonBlockingServerProcessor create(TRTrackerServerTCP _server, SocketChannel _socket) {
                        return new NonBlockingProcessor(_server, _socket);
                    }
                }) : new TRBlockingServer(name, port, bind_ip, ssl, apply_ip_filter, start_up_ready);
            } else if (protocol == 2) {
                if (ssl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                server = new TRTrackerServerUDP(name, port, start_up_ready);
            } else {
                server = new TRTrackerServerDHT(name, start_up_ready);
            }
            servers.add(server);
            for (int i = 0; i < listeners.size(); ++i) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(server);
            }
            TRTrackerServerImpl tRTrackerServerImpl = server;
            Object var11_11 = null;
            class_mon.exit();
            return tRTrackerServerImpl;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void close(TRTrackerServerImpl server) {
        try {
            class_mon.enter();
            server.closeSupport();
            if (servers.remove(server)) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ((TRTrackerServerFactoryListener)listeners.get(i)).serverDestroyed(server);
                }
            }
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.add(l);
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                l.serverCreated((TRTrackerServer)it.next());
            }
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.remove(l);
            Object var2_1 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("tracker.read.bytes.total");
        types.add("tracker.write.bytes.total");
        types.add("tracker.announce.count");
        types.add("tracker.announce.time");
        types.add("tracker.scrape.count");
        types.add("tracker.scrape.time");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            public void updateStats(Set types, Map values) {
                long read_bytes = 0L;
                long write_bytes = 0L;
                long announce_count = 0L;
                long announce_time = 0L;
                long scrape_count = 0L;
                long scrape_time = 0L;
                Iterator it = servers.iterator();
                while (it.hasNext()) {
                    TRTrackerServerStats stats2 = ((TRTrackerServer)it.next()).getStats();
                    read_bytes += stats2.getBytesIn();
                    write_bytes += stats2.getBytesOut();
                    announce_count += stats2.getAnnounceCount();
                    announce_time += stats2.getAnnounceTime();
                    scrape_count += stats2.getScrapeCount();
                    scrape_time += stats2.getScrapeTime();
                }
                if (types.contains("tracker.read.bytes.total")) {
                    values.put("tracker.read.bytes.total", new Long(read_bytes));
                }
                if (types.contains("tracker.write.bytes.total")) {
                    values.put("tracker.write.bytes.total", new Long(write_bytes));
                }
                if (types.contains("tracker.announce.count")) {
                    values.put("tracker.announce.count", new Long(announce_count));
                }
                if (types.contains("tracker.announce.time")) {
                    values.put("tracker.announce.time", new Long(announce_time));
                }
                if (types.contains("tracker.scrape.count")) {
                    values.put("tracker.scrape.count", new Long(scrape_count));
                }
                if (types.contains("tracker.scrape.time")) {
                    values.put("tracker.scrape.time", new Long(scrape_time));
                }
            }
        });
    }

    protected static class NonBlockingProcessor
    extends TRNonBlockingServerProcessor {
        protected NonBlockingProcessor(TRTrackerServerTCP _server, SocketChannel _socket) {
            super(_server, _socket);
        }

        protected ByteArrayOutputStream process(String input_header, String lowercase_input_header, String url_path, InetSocketAddress remote_address, boolean announce_and_scrape_only, InputStream is, AsyncController async) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
            InetSocketAddress local_address = null;
            this.processRequest(input_header, lowercase_input_header, url_path, local_address, remote_address, announce_and_scrape_only, false, is, os, async);
            return os;
        }
    }
}

