/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.impl;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.stats.StatsWriterPeriodic;
import org.gudy.azureus2.core3.stats.impl.StatsWriterImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class StatsWriterPeriodicImpl
implements StatsWriterPeriodic,
COConfigurationListener,
TimerEventPerformer {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static StatsWriterPeriodicImpl singleton;
    private boolean started;
    private long last_write_time = 0L;
    private AzureusCore core;
    private TimerEventPeriodic event;
    private boolean config_enabled;
    private int config_period;
    private String config_dir;
    private String config_file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StatsWriterPeriodic create(AzureusCore _core) {
        Class<StatsWriterPeriodicImpl> clazz = StatsWriterPeriodicImpl.class;
        synchronized (StatsWriterPeriodicImpl.class) {
            if (singleton == null) {
                singleton = new StatsWriterPeriodicImpl(_core);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    protected StatsWriterPeriodicImpl(AzureusCore _core) {
        this.core = _core;
    }

    public void perform(TimerEvent event2) {
        this.update();
    }

    protected void update() {
        try {
            this.writeStats();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected synchronized void readConfigValues() {
        this.config_enabled = COConfigurationManager.getBooleanParameter("Stats Enable");
        this.config_period = COConfigurationManager.getIntParameter("Stats Period");
        this.config_dir = COConfigurationManager.getStringParameter("Stats Dir");
        this.config_file = COConfigurationManager.getStringParameter("Stats File");
        if (this.config_enabled) {
            long targetFrequency = 1000 * (this.config_period < 30000 ? this.config_period : 30000);
            if (this.event != null && this.event.getFrequency() != targetFrequency) {
                this.event.cancel();
                this.event = null;
            }
            if (this.event == null) {
                this.event = SimpleTimer.addPeriodicEvent("StatsWriter", targetFrequency, this);
            }
        } else if (this.event != null) {
            this.event.cancel();
            this.event = null;
        }
    }

    protected void writeStats() {
        if (!this.config_enabled) {
            return;
        }
        int period = this.config_period;
        long now = SystemTime.getMonotonousTime() / 1000L;
        if (now - this.last_write_time < (long)(period - 1)) {
            return;
        }
        this.last_write_time = now;
        try {
            String file;
            String file_name;
            String dir = this.config_dir;
            dir = dir.trim();
            if (dir.length() == 0) {
                dir = File.separator;
            }
            if (!(file_name = dir).endsWith(File.separator)) {
                file_name = file_name + File.separator;
            }
            if ((file = this.config_file).trim().length() == 0) {
                file = "Azureus_Stats.xml";
            }
            file_name = file_name + file;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Stats Logged to '" + file_name + "'"));
            }
            new StatsWriterImpl(this.core).write(file_name);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats Logging fails", e));
        }
    }

    public void configurationSaved() {
        this.readConfigValues();
        this.writeStats();
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        COConfigurationManager.addListener(this);
        this.configurationSaved();
    }

    public void stop() {
        COConfigurationManager.removeListener(this);
        if (this.event != null) {
            this.event.cancel();
        }
    }
}

