/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class IntegratedResourceBundle
extends ResourceBundle {
    private static final boolean DEBUG = false;
    private static final Object NULL_OBJECT = new Object();
    private static final Map bundle_map = new WeakHashMap();
    private static TimerEventPeriodic compact_timer;
    private Locale locale;
    private Map messages;
    private Map used_messages;
    private List null_values;
    private boolean messages_dirty;
    private int clean_count = 0;
    private boolean one_off_discard_done;
    private File scratch_file_name;
    private InputStream scratch_file_is;
    private final int initCapacity;
    private Map<String, String> added_strings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void resetCompactTimer() {
        Map map = bundle_map;
        synchronized (map) {
            if (compact_timer == null && System.getProperty("transitory.startup", "0").equals("0")) {
                compact_timer = SimpleTimer.addPeriodicEvent("IRB:compactor", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        Map map = bundle_map;
                        synchronized (map) {
                            Iterator it = bundle_map.keySet().iterator();
                            boolean did_something = false;
                            while (it.hasNext()) {
                                IntegratedResourceBundle rb = (IntegratedResourceBundle)it.next();
                                if (!rb.compact()) continue;
                                did_something = true;
                            }
                            if (!did_something) {
                                compact_timer.cancel();
                                compact_timer = null;
                            }
                        }
                    }
                });
            }
        }
    }

    public IntegratedResourceBundle(ResourceBundle main, Map localizationPaths) {
        this(main, localizationPaths, null, 10);
    }

    public IntegratedResourceBundle(ResourceBundle main, Map localizationPaths, int initCapacity) {
        this(main, localizationPaths, null, initCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegratedResourceBundle(ResourceBundle main, Map localizationPaths, Collection resource_bundles, int initCapacity) {
        this.initCapacity = initCapacity;
        this.messages = new LightHashMap(initCapacity);
        this.locale = main.getLocale();
        this.addResourceMessages(main);
        Object object = localizationPaths;
        synchronized (object) {
            for (String localizationPath : localizationPaths.keySet()) {
                ClassLoader classLoader = (ClassLoader)localizationPaths.get(localizationPath);
                this.addPluginBundle(localizationPath, classLoader);
            }
        }
        if (resource_bundles != null) {
            object = resource_bundles;
            synchronized (object) {
                Iterator itr = resource_bundles.iterator();
                while (itr.hasNext()) {
                    this.addResourceMessages((ResourceBundle)itr.next());
                }
            }
        }
        this.used_messages = new LightHashMap(this.messages.size());
        object = bundle_map;
        synchronized (object) {
            bundle_map.put(this, NULL_OBJECT);
            IntegratedResourceBundle.resetCompactTimer();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    private Map getMessages() {
        return this.loadMessages();
    }

    public Enumeration getKeys() {
        new Exception("Don't call me, call getKeysLight").printStackTrace();
        Map m = this.loadMessages();
        return new Vector(m.keySet()).elements();
    }

    protected Iterator getKeysLight() {
        LightHashMap m = new LightHashMap(this.loadMessages());
        return m.keySet().iterator();
    }

    public String getString(String key, String def) {
        String s = (String)this.handleGetObject(key);
        if (s == null) {
            if (this.parent != null) {
                s = this.parent.getString(key);
            }
            if (s == null) {
                return def;
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleGetObject(String key) {
        int index;
        Object res;
        Map map = bundle_map;
        synchronized (map) {
            res = this.used_messages.get(key);
        }
        Integer keyHash = null;
        if (this.null_values != null && (index = Collections.binarySearch(this.null_values, keyHash = new Integer(key.hashCode()))) >= 0) {
            return null;
        }
        if (res == NULL_OBJECT) {
            return null;
        }
        if (res == null) {
            Map map2 = bundle_map;
            synchronized (map2) {
                this.loadMessages();
                if (this.messages != null) {
                    res = this.messages.get(key);
                }
                if (res == null && this.null_values != null) {
                    int index2 = Collections.binarySearch(this.null_values, keyHash);
                    if (index2 < 0) {
                        index2 = -1 * index2 - 1;
                    }
                    if (index2 > this.null_values.size()) {
                        index2 = this.null_values.size();
                    }
                    this.null_values.add(index2, keyHash);
                } else {
                    this.used_messages.put(key, res == null ? NULL_OBJECT : res);
                }
                this.clean_count = 0;
                IntegratedResourceBundle.resetCompactTimer();
            }
        }
        return res;
    }

    public void addPluginBundle(String localizationPath, ClassLoader classLoader) {
        ResourceBundle newResourceBundle = null;
        try {
            newResourceBundle = classLoader != null ? ResourceBundle.getBundle(localizationPath, this.locale, classLoader) : ResourceBundle.getBundle(localizationPath, this.locale, IntegratedResourceBundle.class.getClassLoader());
        }
        catch (Exception e) {
            try {
                newResourceBundle = classLoader != null ? ResourceBundle.getBundle(localizationPath, MessageText.LOCALE_DEFAULT, classLoader) : ResourceBundle.getBundle(localizationPath, MessageText.LOCALE_DEFAULT, IntegratedResourceBundle.class.getClassLoader());
            }
            catch (Exception e2) {
                System.out.println(localizationPath + ": no default resource bundle");
                return;
            }
        }
        this.addResourceMessages(newResourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceMessages(ResourceBundle bundle) {
        Map map = bundle_map;
        synchronized (map) {
            this.loadMessages();
            if (bundle != null) {
                this.messages_dirty = true;
                if (bundle instanceof IntegratedResourceBundle) {
                    this.messages.putAll(((IntegratedResourceBundle)bundle).getMessages());
                } else {
                    Enumeration<String> enumeration = bundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String key = enumeration.nextElement();
                        this.messages.put(key, bundle.getObject(key));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compact() {
        block17: {
            ++this.clean_count;
            if (this.clean_count == 1) {
                return true;
            }
            if (this.scratch_file_is == null || this.messages_dirty) {
                File temp_file = null;
                FileOutputStream fos = null;
                if (this.scratch_file_is != null) {
                    try {
                        try {
                            this.scratch_file_is.close();
                        }
                        catch (Throwable e) {
                            this.scratch_file_name = null;
                            Object var5_4 = null;
                            this.scratch_file_is = null;
                        }
                        Object var5_3 = null;
                        this.scratch_file_is = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.scratch_file_is = null;
                        throw throwable;
                    }
                }
                try {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)this.messages);
                    temp_file = this.scratch_file_name == null ? AETemporaryFileHandler.createTempFile() : this.scratch_file_name;
                    fos = new FileOutputStream(temp_file);
                    props.store(fos, "message cache");
                    fos.close();
                    fos = null;
                    this.scratch_file_name = temp_file;
                    this.scratch_file_is = new FileInputStream(temp_file);
                    this.messages_dirty = false;
                }
                catch (Throwable e) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                    }
                    if (temp_file == null) break block17;
                    temp_file.delete();
                }
            }
        }
        if (this.scratch_file_is != null) {
            if (this.clean_count >= 2) {
                this.messages = null;
            }
            if (this.clean_count == 5 && !this.one_off_discard_done) {
                this.one_off_discard_done = true;
                this.used_messages.clear();
            }
        }
        if (this.clean_count > 5) {
            LightHashMap compact_um = new LightHashMap(this.used_messages.size() + 16);
            compact_um.putAll(this.used_messages);
            this.used_messages = compact_um;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadMessages() {
        Map map = bundle_map;
        synchronized (map) {
            Map result;
            if (this.messages != null) {
                return this.messages;
            }
            if (this.scratch_file_is == null) {
                result = new LightHashMap();
            } else {
                Properties p = new Properties();
                InputStream fis = this.scratch_file_is;
                try {
                    p.load(fis);
                    fis.close();
                    this.scratch_file_is = new FileInputStream(this.scratch_file_name);
                    this.messages = new LightHashMap();
                    this.messages.putAll(p);
                    result = this.messages;
                }
                catch (Throwable e) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                    }
                    Debug.out("Failed to load message bundle scratch file", e);
                    this.scratch_file_name.delete();
                    this.scratch_file_is = null;
                    result = new LightHashMap();
                }
            }
            if (this.added_strings != null) {
                result.putAll(this.added_strings);
            }
            return result;
        }
    }

    protected String getString() {
        return this.locale + ": use=" + this.used_messages.size() + ",map=" + (this.messages == null ? "" : String.valueOf(this.messages.size())) + (this.null_values == null ? "" : ",null=" + this.null_values.size()) + ",added=" + (this.added_strings == null ? "" : Integer.valueOf(this.added_strings.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(String key, String value) {
        Map map = bundle_map;
        synchronized (map) {
            if (this.added_strings == null) {
                this.added_strings = new HashMap<String, String>();
            }
            this.added_strings.put(key, value);
            if (this.messages != null) {
                this.messages.put(key, value);
            }
        }
    }

    public boolean getUseNullList() {
        return this.null_values != null;
    }

    public void setUseNullList(boolean useNullList) {
        if (useNullList && this.null_values == null) {
            this.null_values = new ArrayList(0);
        } else if (!useNullList && this.null_values != null) {
            this.null_values = null;
        }
    }

    public void clearUsedMessagesMap(int initialCapacity) {
        this.used_messages = new LightHashMap(initialCapacity);
        if (this.null_values != null) {
            this.null_values = new ArrayList(0);
        }
    }
}

