/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.PriorityParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ConfigurationManager
implements AEDiagnosticsEvidenceGenerator {
    private static final boolean DEBUG_PARAMETER_LISTENERS = false;
    private static ConfigurationManager config_temp = null;
    private static ConfigurationManager config = null;
    private static AEMonitor class_mon = new AEMonitor("ConfigMan:class");
    private Map<String, Object> propertiesMap;
    private List transient_properties = new ArrayList();
    private List<COConfigurationListener> listenerz = new ArrayList<COConfigurationListener>();
    private Map<String, ParameterListener[]> parameterListenerz = new HashMap<String, ParameterListener[]>();
    private static FrequencyLimitedDispatcher dirty_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        public void runSupport() {
            COConfigurationManager.save();
        }
    }, 30000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance() {
        block5: {
            try {
                class_mon.enter();
                if (config != null) break block5;
                if (config_temp == null) {
                    config_temp = new ConfigurationManager();
                    config_temp.load();
                    config_temp.initialise();
                    config = config_temp;
                    break block5;
                }
                if (ConfigurationManager.config_temp.propertiesMap == null) {
                    config_temp.load();
                }
                ConfigurationManager configurationManager = config_temp;
                Object var2_2 = null;
                class_mon.exit();
                return configurationManager;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        ConfigurationManager configurationManager = config;
        Object var2_3 = null;
        class_mon.exit();
        return configurationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance(Map data) {
        try {
            class_mon.enter();
            if (config == null) {
                config = new ConfigurationManager(data);
            }
            ConfigurationManager configurationManager = config;
            Object var3_2 = null;
            class_mon.exit();
            return configurationManager;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    private ConfigurationManager() {
    }

    private ConfigurationManager(Map data) {
        if (data.get("Logger.DebugFiles.Enabled") == null) {
            data.put("Logger.DebugFiles.Enabled", new Long(0L));
        }
        this.propertiesMap = data;
    }

    protected void initialise() {
        ConfigurationChecker.checkConfiguration();
        ConfigurationChecker.setSystemProperties();
        AEDiagnostics.addEvidenceGenerator(this);
    }

    public void load(String filename) {
        Map data = FileUtil.readResilientConfigFile(filename, false);
        if (this.propertiesMap == null) {
            this.propertiesMap = data;
        }
    }

    public void load() {
        this.load("azureus.config");
        try {
            String[] keys;
            for (String key : keys = this.propertiesMap.keySet().toArray(new String[0])) {
                if (key == null || !key.startsWith("SideBar.Expanded.Category.")) continue;
                this.removeParameter(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String filename) {
        ArrayList<COConfigurationListener> listeners_copy;
        if (this.propertiesMap == null) {
            return;
        }
        TreeMap<String, Object> properties_clone = new TreeMap<String, Object>(this.propertiesMap);
        if (!this.transient_properties.isEmpty()) {
            properties_clone.keySet().removeAll(this.transient_properties);
        }
        FileUtil.writeResilientConfigFile(filename, properties_clone);
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            listeners_copy = new ArrayList<COConfigurationListener>(this.listenerz);
        }
        for (int i = 0; i < listeners_copy.size(); ++i) {
            COConfigurationListener l = (COConfigurationListener)listeners_copy.get(i);
            if (l != null) {
                try {
                    l.configurationSaved();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                continue;
            }
            Debug.out("COConfigurationListener is null");
        }
    }

    public void save() {
        this.save("azureus.config");
    }

    public void setDirty() {
        dirty_dispatcher.dispatch();
    }

    public boolean isNewInstall() {
        return ConfigurationChecker.isNewInstall();
    }

    public Set getDefinedParameters() {
        return this.propertiesMap.keySet();
    }

    public boolean getBooleanParameter(String parameter, boolean defaultValue) {
        int defaultInt = defaultValue ? 1 : 0;
        int result = this.getIntParameter(parameter, defaultInt);
        return result != 0;
    }

    public boolean getBooleanParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result != 0;
    }

    public boolean setParameter(String parameter, boolean value) {
        return this.setParameter(parameter, value ? 1 : 0);
    }

    private Long getLongParameterRaw(String parameter) {
        try {
            return (Long)this.propertiesMap.get(parameter);
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return null;
        }
    }

    public int getIntParameter(String parameter, int defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue.intValue() : defaultValue;
    }

    public int getIntParameter(String parameter) {
        int result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getIntParameter(parameter, def.getIntParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getIntParameter(parameter, 0);
        }
        return result;
    }

    public long getLongParameter(String parameter, long defaultValue) {
        Long tempValue = this.getLongParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    public long getLongParameter(String parameter) {
        long result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getLongParameter(parameter, def.getLongParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getLongParameter(parameter, 0L);
        }
        return result;
    }

    private byte[] getByteParameterRaw(String parameter) {
        return (byte[])this.propertiesMap.get(parameter);
    }

    public byte[] getByteParameter(String parameter) {
        byte[] result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getByteParameter(parameter, def.getByteParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getByteParameter(parameter, ConfigurationDefaults.def_bytes);
        }
        return result;
    }

    public byte[] getByteParameter(String parameter, byte[] defaultValue) {
        byte[] tempValue = this.getByteParameterRaw(parameter);
        return tempValue != null ? tempValue : defaultValue;
    }

    private String getStringParameter(String parameter, byte[] defaultValue) {
        byte[] bp = this.getByteParameter(parameter, defaultValue);
        if (bp == null) {
            bp = this.getByteParameter(parameter, null);
        }
        if (bp == null) {
            return null;
        }
        return ConfigurationManager.bytesToString(bp);
    }

    public String getStringParameter(String parameter, String defaultValue) {
        String tempValue = this.getStringParameter(parameter, (byte[])null);
        return tempValue != null ? tempValue : defaultValue;
    }

    public String getStringParameter(String parameter) {
        String result;
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            result = this.getStringParameter(parameter, def.getStringParameter(parameter));
        }
        catch (ConfigurationParameterNotFoundException e) {
            result = this.getStringParameter(parameter, "");
        }
        return result;
    }

    public StringList getStringListParameter(String parameter) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return new StringListImpl();
            }
            return new StringListImpl(rawList);
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return new StringListImpl();
        }
    }

    public boolean setParameter(String parameter, StringList value) {
        try {
            ArrayList<byte[]> encoded = new ArrayList<byte[]>();
            List l = ((StringListImpl)value).getList();
            for (int i = 0; i < l.size(); ++i) {
                encoded.add(ConfigurationManager.stringToBytes((String)l.get(i)));
            }
            this.propertiesMap.put(parameter, encoded);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public List getListParameter(String parameter, List def) {
        try {
            List rawList = (List)this.propertiesMap.get(parameter);
            if (rawList == null) {
                return def;
            }
            return rawList;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, List value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public Map getMapParameter(String parameter, Map def) {
        try {
            Map map = (Map)this.propertiesMap.get(parameter);
            if (map == null) {
                return def;
            }
            return map;
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
            return def;
        }
    }

    public boolean setParameter(String parameter, Map value) {
        try {
            this.propertiesMap.put(parameter, value);
            this.notifyParameterListeners(parameter);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return false;
        }
        return true;
    }

    public String getDirectoryParameter(String parameter) throws IOException {
        String dir = this.getStringParameter(parameter);
        if (dir.length() > 0) {
            File temp = new File(dir);
            if (!temp.exists()) {
                FileUtil.mkdirs(temp);
            }
            if (!temp.isDirectory()) {
                throw new IOException("Configuration error. This is not a directory: " + dir);
            }
        }
        return dir;
    }

    public float getFloatParameter(String parameter) {
        return this.getFloatParameter(parameter, 0.0f);
    }

    public float getFloatParameter(String parameter, float def_val) {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            Object o = this.propertiesMap.get(parameter);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            String s = this.getStringParameter(parameter);
            if (!s.equals("")) {
                return Float.parseFloat(s);
            }
        }
        catch (Exception e) {
            Debug.out("Parameter '" + parameter + "' has incorrect type", e);
        }
        try {
            return def.getFloatParameter(parameter);
        }
        catch (Exception e2) {
            return def_val;
        }
    }

    public boolean setParameter(String parameter, float defaultValue) {
        String newValue = String.valueOf(defaultValue);
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(newValue));
    }

    public boolean setParameter(String parameter, int defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = (Long)this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, long defaultValue) {
        Long newValue = new Long(defaultValue);
        try {
            Long oldValue = (Long)this.propertiesMap.put(parameter, newValue);
            return this.notifyParameterListenersIfChanged(parameter, newValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, byte[] defaultValue) {
        try {
            byte[] oldValue = (byte[])this.propertiesMap.put(parameter, defaultValue);
            return this.notifyParameterListenersIfChanged(parameter, defaultValue, oldValue);
        }
        catch (ClassCastException e) {
            this.notifyParameterListeners(parameter);
            return true;
        }
    }

    public boolean setParameter(String parameter, String defaultValue) {
        return this.setParameter(parameter, ConfigurationManager.stringToBytes(defaultValue));
    }

    public boolean hasParameter(String key, boolean explicit) {
        if (this.propertiesMap.containsKey(key)) {
            return true;
        }
        return !explicit && ConfigurationDefaults.getInstance().hasParameter(key);
    }

    public boolean verifyParameter(String parameter, String value) {
        List verifiers = ConfigurationDefaults.getInstance().getVerifiers(parameter);
        if (verifiers != null) {
            try {
                for (int i = 0; i < verifiers.size(); ++i) {
                    COConfigurationManager.ParameterVerifier verifier = (COConfigurationManager.ParameterVerifier)verifiers.get(i);
                    if (verifier == null) continue;
                    try {
                        if (verifier.verify(parameter, value)) continue;
                        return false;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return true;
    }

    public boolean setRGBParameter(String parameter, int red, int green, int blue) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.setParameter(parameter + ".red", red);
        bAnyChanged |= this.setParameter(parameter + ".green", green);
        if (bAnyChanged |= this.setParameter(parameter + ".blue", blue)) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean setRGBParameter(String parameter, int[] rgb, boolean override) {
        boolean changed = false;
        if (rgb == null) {
            changed |= this.removeParameter(parameter + ".override");
            changed |= this.removeParameter(parameter + ".red");
            changed |= this.removeParameter(parameter + ".green");
            changed |= this.removeParameter(parameter + ".blue");
        } else {
            changed |= this.setParameter(parameter + ".override", override);
            changed |= this.setRGBParameter(parameter, rgb[0], rgb[1], rgb[2]);
        }
        if (changed) {
            this.notifyParameterListeners(parameter);
        }
        return changed;
    }

    public boolean setParameter(String parameter) throws ConfigurationParameterNotFoundException {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        try {
            return this.setParameter(parameter, def.getIntParameter(parameter));
        }
        catch (Exception e) {
            return this.setParameter(parameter, def.getStringParameter(parameter));
        }
    }

    public Object getParameter(String name) {
        Object value = this.propertiesMap.get(name);
        if (value == null) {
            value = ConfigurationDefaults.getInstance().getParameter(name);
        }
        return value;
    }

    public void setParameterRawNoNotify(String parameter, Object value) {
        this.propertiesMap.put(parameter, value);
    }

    public void registerTransientParameter(String param) {
        this.transient_properties.add(param);
    }

    public boolean removeParameter(String parameter) {
        boolean removed;
        boolean bl = removed = this.propertiesMap.remove(parameter) != null;
        if (removed) {
            this.notifyParameterListeners(parameter);
        }
        return removed;
    }

    public boolean removeRGBParameter(String parameter) {
        boolean bAnyChanged = false;
        bAnyChanged |= this.removeParameter(parameter + ".red");
        bAnyChanged |= this.removeParameter(parameter + ".green");
        bAnyChanged |= this.removeParameter(parameter + ".blue");
        if (bAnyChanged |= this.removeParameter(parameter + ".override")) {
            this.notifyParameterListeners(parameter);
        }
        return bAnyChanged;
    }

    public boolean doesParameterNonDefaultExist(String parameter) {
        return this.propertiesMap.containsKey(parameter);
    }

    private boolean notifyParameterListenersIfChanged(String parameter, Long newValue, Long oldValue) {
        if (oldValue == null || 0 != newValue.compareTo(oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    private boolean notifyParameterListenersIfChanged(String parameter, byte[] newValue, byte[] oldValue) {
        if (oldValue == null || !Arrays.equals(newValue, oldValue)) {
            this.notifyParameterListeners(parameter);
            return true;
        }
        return false;
    }

    public void resetToDefaults() {
        ConfigurationDefaults def = ConfigurationDefaults.getInstance();
        ArrayList def_names = new ArrayList(def.getAllowedParameters());
        for (String s : def_names) {
            if (this.propertiesMap.remove(s) == null) continue;
            this.notifyParameterListeners(s);
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyParameterListeners(String parameter) {
        ParameterListener[] listeners;
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            listeners = this.parameterListenerz.get(parameter);
        }
        if (listeners == null) {
            return;
        }
        for (ParameterListener listener : listeners) {
            if (listener == null) continue;
            try {
                listener.parameterChanged(parameter);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterListener(String parameter, ParameterListener new_listener) {
        if (parameter == null || new_listener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] listeners = this.parameterListenerz.get(parameter);
            if (listeners == null) {
                this.parameterListenerz.put(parameter, new ParameterListener[]{new_listener});
            } else {
                int pos;
                ParameterListener[] new_listeners = new ParameterListener[listeners.length + 1];
                if (new_listener instanceof PriorityParameterListener) {
                    new_listeners[0] = new_listener;
                    pos = 1;
                } else {
                    new_listeners[listeners.length] = new_listener;
                    pos = 0;
                }
                for (int i = 0; i < listeners.length; ++i) {
                    ParameterListener existing_listener = listeners[i];
                    if (existing_listener == new_listener) {
                        return;
                    }
                    new_listeners[pos++] = existing_listener;
                }
                this.parameterListenerz.put(parameter, new_listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterListener(String parameter, ParameterListener listener) {
        if (parameter == null || listener == null) {
            return;
        }
        Map<String, ParameterListener[]> map = this.parameterListenerz;
        synchronized (map) {
            ParameterListener[] listeners = this.parameterListenerz.get(parameter);
            if (listeners == null) {
                return;
            }
            if (listeners.length == 1) {
                if (listeners[0] == listener) {
                    this.parameterListenerz.remove(parameter);
                }
            } else {
                ParameterListener[] new_listeners = new ParameterListener[listeners.length - 1];
                int pos = 0;
                for (int i = 0; i < listeners.length; ++i) {
                    ParameterListener existing_listener = listeners[i];
                    if (existing_listener == listener) continue;
                    if (pos == new_listeners.length) {
                        return;
                    }
                    new_listeners[pos++] = existing_listener;
                }
                this.parameterListenerz.put(parameter, new_listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(COConfigurationListener listener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(COConfigurationListener listener) {
        List<COConfigurationListener> list = this.listenerz;
        synchronized (list) {
            this.listenerz.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Configuration Details");
        try {
            writer.indent();
            writer.println("version=4.6.0.4, subver=");
            writer.println("System Properties");
            try {
                writer.indent();
                Properties props = System.getProperties();
                for (String string : new TreeSet<Object>(props.keySet())) {
                    writer.println(string + "=" + props.get(string));
                }
                Object var6_8 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                writer.exdent();
                throw throwable;
            }
            writer.println("Environment");
            try {
                writer.indent();
                Map<String, String> env = System.getenv();
                if (env == null) {
                    writer.println("Not supported");
                } else {
                    for (String string : new TreeSet<String>(env.keySet())) {
                        writer.println(string + "=" + env.get(string));
                    }
                }
                Object var8_12 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                writer.exdent();
                throw throwable;
            }
            writer.println("Azureus Config");
            ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
            try {
                writer.indent();
                TreeSet<String> keys = new TreeSet<String>(new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                });
                keys.addAll(this.propertiesMap.keySet());
                for (String key : keys) {
                    if (key.startsWith("core.crypto.")) continue;
                    Object value = this.propertiesMap.get(key);
                    boolean bParamExists = defaults.doesParameterDefaultExist(key.toString());
                    if (!bParamExists) {
                        key = "[NoDef] " + key;
                    } else {
                        Object def = defaults.getParameter(key);
                        if (def != null && value != null && !BEncoder.objectsAreIdentical(def, value)) {
                            key = "-> " + key;
                        }
                    }
                    if (value instanceof Long) {
                        writer.println(key + "=" + value);
                        continue;
                    }
                    if (value instanceof List) {
                        writer.println(key + "=" + BDecoder.decodeStrings((List)BEncoder.clone(value)) + "[list]");
                        continue;
                    }
                    if (value instanceof Map) {
                        writer.println(key + "=" + BDecoder.decodeStrings((Map)BEncoder.clone(value)) + "[map]");
                        continue;
                    }
                    if (value instanceof byte[]) {
                        byte[] b = (byte[])value;
                        boolean hex = false;
                        for (int i = 0; i < b.length; ++i) {
                            char c = (char)b[i];
                            if (Character.isLetterOrDigit(c) || "`\u00ef\u00bf\u00bd\"\u00ef\u00bf\u00bd$%^&*()-_=+[{]};:'@#~,<.>/?'".indexOf(c) != -1) continue;
                            hex = true;
                            break;
                        }
                        writer.println(key + "=" + (hex ? ByteFormatter.nicePrint(b) : ConfigurationManager.bytesToString((byte[])value)));
                        continue;
                    }
                    writer.println(key + "=" + value + "[unknown]");
                }
                Object var13_19 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                writer.exdent();
                throw throwable;
            }
            Object var15_22 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            writer.exdent();
            throw throwable;
        }
    }

    protected static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF8");
        }
        catch (Throwable e) {
            return new String(bytes);
        }
    }

    protected static byte[] stringToBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes("UTF8");
        }
        catch (Throwable e) {
            return str.getBytes();
        }
    }
}

