/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private int _length;

    DefiniteLengthInputStream(InputStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = length;
    }

    public int read() throws IOException {
        if (this._length > 0) {
            int b = this._in.read();
            if (b < 0) {
                throw new EOFException();
            }
            --this._length;
            return b;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._length > 0) {
            int toRead = Math.min(len, this._length);
            int numRead = this._in.read(buf, off, toRead);
            if (numRead < 0) {
                throw new EOFException();
            }
            this._length -= numRead;
            return numRead;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    byte[] toByteArray() throws IOException {
        byte[] bytes = new byte[this._length];
        if (this._length > 0) {
            int read;
            int pos = 0;
            do {
                if ((read = this._in.read(bytes, pos, this._length - pos)) >= 0) continue;
                throw new EOFException();
            } while ((pos += read) < this._length);
            this._length = 0;
        }
        this.setParentEofDetect(true);
        return bytes;
    }
}

